/*
  This file is part of Challenger
  Copyright (C) 2023 Taler Systems SA

  Challenger is free software; you can redistribute it and/or modify it under the
  terms of the GNU Lesser General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  Challenger is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  Challenger; see the file COPYING.GPL.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file challenger/challenger-httpd_main_css.c
 * @brief handler for /main.css
 * @author Christian Grothoff
 */
#include "platform.h"
#include "challenger-httpd_main_css.h"
#include <taler/taler_mhd_lib.h>


MHD_RESULT
CH_handler_main_css (struct CH_HandlerContext *hc,
                     const char *upload_data,
                     size_t *upload_data_size)
{
  static struct MHD_Response *reply;

  if (NULL == reply)
  {
    char *fn;
    struct stat sb;
    int fd;
    char *path;

    path = GNUNET_OS_installation_get_path (GNUNET_OS_IPK_DATADIR);
    if (NULL == path)
    {
      GNUNET_break (0);
      return MHD_NO;
    }
    GNUNET_asprintf (&fn,
                     "%s/templates/main.css",
                     path);
    GNUNET_free (path);
    fd = open (fn,
               O_RDONLY);
    if (-1 == fd)
    {
      GNUNET_log_strerror_file (GNUNET_ERROR_TYPE_ERROR,
                                "open",
                                fn);
      GNUNET_free (fn);
      return GNUNET_SYSERR;
    }
    if (0 !=
        fstat (fd,
               &sb))
    {
      GNUNET_log_strerror_file (GNUNET_ERROR_TYPE_ERROR,
                                "fstat",
                                fn);
      GNUNET_break (0 == close (fd));
      GNUNET_free (fn);
      return GNUNET_OK;
    }
    GNUNET_free (fn);
    reply = MHD_create_response_from_fd (sb.st_size,
                                         fd);
    TALER_MHD_add_global_headers (reply);
    GNUNET_break (MHD_NO !=
                  MHD_add_response_header (reply,
                                           MHD_HTTP_HEADER_CONTENT_TYPE,
                                           "text/css"));
  }
  if (NULL == reply)
  {
    GNUNET_break (0);
    return MHD_NO;
  }
  return MHD_queue_response (
    hc->connection,
    MHD_HTTP_OK,
    reply);
}


/* end of challenger-httpd_main_css.c */
