/* $Id: swheaderline.c,v 1.7 2000/03/23 23:12:05 jhl Exp jhl $

   swheaderline.c  --  Low-Level Routines to read the parser output.
   
   Copyright (C) 1998, 1999  Jim Lowe 
   All rights reserved.

   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "swuser_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "swheaderline.h"

#define NEWLINE_LEN 1

static
char *
get_value(char *output_line, int *value_len, int do_terminate)
{
	char *ret;
	int len;

	if (!output_line) return (char*)(NULL);
	if (!(ret = swheaderline_get_keyword(output_line)))
		return NULL;

	if (swheaderline_get_type(output_line) == SWPARSE_MD_TYPE_OBJ) {
		if (value_len) *value_len = 0;
		return ret + strlen(ret);
	}

	len=swheaderline_get_value_length(output_line);

	if (value_len) *value_len=len;
	
	if (do_terminate)
		*(ret + strlen(ret) + 1 +len) = '\0';
	return ret + strlen(ret) + 1;	/* pointer to  the value */
}

char * 
swheaderline_get_type_pointer(char *output_line)
{
	if (isdigit((int) (*output_line))) {
		return output_line + SWPARSE_MKUP_LEN_WIDTH + 1;
	} else {
		return output_line;
	}
}

int
swheaderline_write (char * line, int uxfio_fd)
{
	int len;
	char * keyword = swheaderline_get_keyword(line);
	char * value = 	swheaderline_get_value(line, &len);
        int type = (int)swheaderline_get_type(line);
	int level = swheaderline_get_level(line);
	len=-1;
	if (keyword)	
		return swdef_write_attribute(keyword, value,
					level, len, (int)type, uxfio_fd);
	else
		return 0;
}

int
swheaderline_get_level(char *outputline)
{
	char * typep;
	if (isdigit((int) (*outputline))) {
		typep = outputline  + SWPARSE_MKUP_LEN_WIDTH + 1;
	} else {
		typep = outputline;
	}
	typep += 2;
		/*
		* NOTE : MAX level is 9 since only the one's digit is scanned.
		*/
	return (int)((*typep) - 0x30);
}

char
swheaderline_get_type(char *output_line)
{
	char * p = swheaderline_get_type_pointer(output_line);
	if (p) return *p; else return (char)(0);
}

char *
swheaderline_get_keyword(char *output_line)
{
	char *t, *ret;

	if (!output_line) return (char*)(NULL);

	if (isdigit((int) (*output_line))) {
		t = output_line + SWPARSE_MKUP_LEN_WIDTH + 1;
	} else {
		t = output_line;
	}

	/* 
	* Find the keyword part of the parser output line and
	* put a NULL after it.  This means a NULL char will separate
	* the keyword and value.
	*/

	/* t now points to the <type><level> field */
	/* e.g. A01' ' */

	if (
		t[0] == SWPARSE_MD_TYPE_ATT || 
		t[0] == SWPARSE_MD_TYPE_OBJ ||
		t[0] == SWPARSE_MD_TYPE_EXT || 
		t[0] == SWPARSE_MD_TYPE_FILEREF || 
		0)  {
		;
		/* good */
	} else {
		/* bad */
		fprintf(stderr, "internal error in swheaderline_get_keyword\n");
		return NULL;
	}

	t+=3;
	/* the next char should be a space */

	while (*t && isspace((int)(*t))) t++;
	ret = t;
	while (*t && !isspace((int)(*t))) t++;
	*t = '\0';
	return ret;
}

int
swheaderline_get_value_length(char *output_line)
{
	int i;
	char  * t, *p;
	int n;
	int mytens[6] = {0, 1, 10, 100, 1000, 10000};

	if (!isdigit((int)(*output_line))) {
		fprintf(stderr, "bad parser output, value length not found\n"); 
		return -1;
	}

	/*
	* Unoptimized working code.
	* sscanf(output_line, "%d", &n);
	* return n;
	*/

	n = 0;
	t = output_line;
	p = output_line;
	while (*t && !isspace((int)(*t))) t++;
	for (i = (int)(t - output_line); i > 0; i--) {
		if (!isdigit(*p)) {
			fprintf(stderr,
		"internal error in swheaderline_get_value_length [%s]\n",
					output_line); 
		}
		n += ((int)((int)(*p) - 48)) * mytens[i];
		p++;
	}
	return n;
}

char *
swheaderline_strdup(char * outputline) {
	int value_length;
	char * value = swheaderline_get_value(outputline, &value_length);
	int len = (int)(value - outputline) + value_length + 1;
	char * dup = (char *)malloc(len);
	*(dup+len) = '\0';
	memcpy(dup, outputline, len);
	return dup;
}

char *
swheaderline_get_value_pointer(char *output_line, int *value_len)
{
	return get_value(output_line, value_len, 0);
}

char *
swheaderline_get_value(char *output_line, int *value_len)
{
	return get_value(output_line, value_len, 1);
}
