%{
/*
 * Copyright (C) 1999, 2000, Lorenzo Bettini, lorenzo.bettini@penteres.it
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "tags.h"

#include "optparser.h"

extern int line ;

#define PUSH(s) yy_push_state(s);
#define POP() yy_pop_state();

%}

%option prefix="opsc_"
%option noyywrap

ws [ ]+
tabs [\t]+

nl \n
cr \r
IDE [a-zA-Z_]([a-zA-Z0-9_])*

STRING \"[^\"\n]*\"

%option stack

%s COMMENT_STATE

%%

[ ] {}

\r {}

<INITIAL>"//" { PUSH(COMMENT_STATE); }
<COMMENT_STATE>[^\n] {}
<COMMENT_STATE>\n { ++line;  POP(); }

<INITIAL>"green" |
"red" |
"darkred" |
"blue" |
"brown" |
"pink" |
"yellow" |
"cyan" |
"purple" |
"orange" |
"brightorange" |
"darkgreen" |
"brightgreen" |
"black" |
"teal" |
"gray" |
"darkblue" { opsc_lval.string = new std::string(yytext) ; return COLOR ; }

<INITIAL>\#[a-fA-F0-9]{6} { opsc_lval.string = new std::string(yytext) ; return COLOR ; }

<INITIAL>"b" { opsc_lval.flag = BOLD ; return BOLD ; }
<INITIAL>"i" { opsc_lval.flag = ITALICS ; return ITALICS ; }
<INITIAL>"u" { opsc_lval.flag = UNDERLINE ; return UNDERLINE ; }

<INITIAL>"," { return ',' ; }
<INITIAL>";" { return ';' ; }

<INITIAL>{IDE} { opsc_lval.string = new std::string(yytext) ; return KEY ; }

\n { ++line ; }

<INITIAL>.  { return yytext[0] ; }

%%
