dnl ##
dnl ##  aclocal.m4 -- Pth Autoconf macros
dnl ##
dnl ##  Copyright (c) 1999 Ralf S. Engelschall <rse@engelschall.com>
dnl ##
dnl ##  This file is part of GNU Pth, a non-preemptive thread scheduling
dnl ##  library which can be found at http://www.gnu.org/software/pth/.
dnl ##
dnl ##  This library is free software; you can redistribute it and/or
dnl ##  modify it under the terms of the GNU Library General Public
dnl ##  License as published by the Free Software Foundation; either
dnl ##  version 2 of the License, or (at your option) any later version.
dnl ##
dnl ##  This library is distributed in the hope that it will be useful,
dnl ##  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl ##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
dnl ##  Library General Public License for more details.
dnl ##
dnl ##  You should have received a copy of the GNU Library General Public
dnl ##  License along with this library; if not, write to the Free Software
dnl ##  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
dnl ##  USA, or contact Ralf S. Engelschall <rse@engelschall.com>.
dnl ##
dnl
dnl #
dnl #   Libtool glue code
dnl #
define(AC_PROG_LIBTOOL,[dnl
AC_ARG_ENABLE(static,dnl
[  --enable-static         build static libraries (default=yes)],
enable_static="$enableval",
if test ".$enable_static" = .; then
    enable_static=yes
fi
)dnl
AC_ARG_ENABLE(shared,dnl
[  --enable-shared         build shared libraries (default=yes)],
enable_shared="$enableval",
if test ".$enable_shared" = .; then
    enable_shared=yes
fi
)dnl
libtool_flags=''
test "$enable_static"     = no  && libtool_flags="$libtool_flags --disable-static"
test "$enable_shared"     = no  && libtool_flags="$libtool_flags --disable-shared"
test "$ac_cv_prog_gcc"    = yes && libtool_flags="$libtool_flags --with-gcc"
test "$ac_cv_prog_gnu_ld" = yes && libtool_flags="$libtool_flags --with-gnu-ld"
CC="$CC" CFLAGS="$CFLAGS" CPPFLAGS="$CPPFLAGS" LD="$LD" \
${CONFIG_SHELL-/bin/sh} $srcdir/ltconfig --no-reexec \
$libtool_flags --srcdir=$srcdir --no-verify $srcdir/ltmain.sh $PLATFORM ||\
AC_MSG_ERROR([libtool configuration failed])
])dnl
dnl #
dnl #  Debugging support  
dnl #
define(AC_CHECK_DEBUGGING,[dnl
AC_MSG_CHECKING(for compilation debug mode)
AC_ARG_ENABLE(debug,dnl
[  --enable-debug          build for debugging (default=no)],
[dnl
if test ".$ac_cv_prog_gcc" = ".yes"; then
    case "$CFLAGS" in
        *-O2* ) ;;
            * ) CFLAGS="$CFLAGS -O2" ;;
    esac
    case "$CFLAGS" in
        *-g* ) ;;
           * ) CFLAGS="$CFLAGS -g" ;;
    esac
    case "$CFLAGS" in
        *-pipe* ) ;;
            * ) CFLAGS="$CFLAGS -pipe" ;;
    esac
    CFLAGS="$CFLAGS -ggdb3"
    CFLAGS="$CFLAGS -Wall -Wshadow -Wpointer-arith -Wcast-align"
    CFLAGS="$CFLAGS -Wmissing-prototypes -Wmissing-declarations -Wnested-externs -Winline"
else
    case "$CFLAGS" in
        *-g* ) ;;
           * ) CFLAGS="$CFLAGS -g" ;;
    esac
fi
msg="enabled"
AC_DEFINE(PTH_DEBUG)
],[
case "$CFLAGS" in
    *-g* ) CFLAGS=`echo "$CFLAGS" |\
                   sed -e 's/ -g //g' -e 's/ -g$//' -e 's/^-g //g' -e 's/^-g$//'` ;;
esac
msg=disabled
])dnl
AC_MSG_RESULT([$msg])
if test ".$msg" = .enabled; then
    enable_shared=no
fi
])
dnl #
dnl #  Profiling support  
dnl #
define(AC_CHECK_PROFILING,[dnl
AC_MSG_CHECKING(for compilation profile mode)
AC_ARG_ENABLE(profile,dnl
[  --enable-profile        build for profiling (default=no)],
[dnl
if test ".$ac_cv_prog_gcc" = ".no"; then
    AC_MSG_ERROR([profiling requires gcc and gprof])
fi
CFLAGS=`echo "$CFLAGS" | sed -e 's/-O2//g'`
CFLAGS="$CFLAGS -O0 -pg"
LDFLAGS="$LDFLAGS -pg"
msg="enabled"
],[
msg=disabled
])dnl
AC_MSG_RESULT([$msg])
if test ".$msg" = .enabled; then
    enable_shared=no
fi
])
dnl #
dnl #  Display support
dnl #
define(AC_CONFIGURE_PART,[dnl
AC_MSG_RESULT()
AC_MSG_RESULT(${T_MD}$1:${T_ME})
])dnl
dnl #
dnl #  Check for a pre-processor define
dnl #
define(AC_CHECK_DEFINE,[dnl
AC_MSG_CHECKING(for macro $1 in $2)
AC_CACHE_VAL(ac_cv_define_$1,
[AC_EGREP_CPP([YES_IS_DEFINED], [
#include <$2>
#ifdef $1
YES_IS_DEFINED
#endif
], ac_cv_define_$1=yes, ac_cv_define_$1=no)])dnl
AC_MSG_RESULT($ac_cv_define_$1)
if test $ac_cv_define_$1 = yes; then
    AC_DEFINE(HAVE_[]translit($1, [a-z], [A-Z]))
fi
])dnl
dnl #
dnl #  Check for an ANSI C typedef
dnl #
AC_DEFUN(AC_CHECK_TYPEDEF,[dnl
AC_REQUIRE([AC_HEADER_STDC])dnl
AC_MSG_CHECKING(for $1)
AC_CACHE_VAL(ac_cv_typedef_$1,
[AC_EGREP_CPP(dnl
changequote(<<,>>)dnl
<<(^|[^a-zA-Z_0-9])$1[^a-zA-Z_0-9]>>dnl
changequote([,]), [
#include <$2>
], ac_cv_typedef_$1=yes, ac_cv_typedef_$1=no)])dnl
AC_MSG_RESULT($ac_cv_typedef_$1)
if test $ac_cv_typedef_$1 = yes; then
    AC_DEFINE(HAVE_[]translit($1, [a-z], [A-Z]))
fi
])
dnl #
dnl #  Check for argument type of a function
dnl #
AC_DEFUN(AC_CHECK_ARGTYPE,[dnl
AC_REQUIRE_CPP()dnl
AC_MSG_CHECKING([for type of arg $3 in $2()])
AC_CACHE_VAL([ac_cv_argtype_$2$3],[
cat >conftest.$ac_ext <<EOF
[#]line __oline__ "configure"
#include "confdefs.h"
EOF
for ifile in $1; do
    echo "#include <$ifile>" >>conftest.$ac_ext
done
gpat=''
spat=''
i=1
changequote(, )dnl
while test $i -le $3; do
    gpat="$gpat[^,]*"
    if test $i -eq $3; then
        spat="$spat\\([^,]*\\)"
    else
        spat="$spat[^,]*"
    fi
    if test $i -lt $3; then
        gpat="$gpat,"
        spat="$spat,"
    fi
    i=`expr $i + 1`
done
(eval "$ac_cpp conftest.$ac_ext") 2>&AC_FD_CC |\
egrep "[^a-zA-Z0-9_]$2[ 	]*\($gpat\)" | head -1 |\
sed -e "s/.*[^a-zA-Z0-9_]$2[ 	]*($spat).*/\\1/" >conftest.output
changequote([, ])dnl
ac_cv_argtype_$2$3=`cat conftest.output | awk '{ printf("%s", [$]1); }'`
rm -f conftest*
dnl#
])
AC_MSG_RESULT([$ac_cv_argtype_$2$3])
type="$ac_cv_argtype_$2$3"
[$4]
])
dnl #
dnl #  Decision hierachy support
dnl #
define(AC_IFALLYES,[dnl
ac_rc=yes
for ac_spec in $1; do
    ac_type=`echo "$ac_spec" | sed -e 's/:.*$//'`
    ac_item=`echo "$ac_spec" | sed -e 's/^.*://'`
    case $ac_type in
        header [)]
            ac_item=`echo "$ac_item" | sed 'y%./+-%__p_%'`
            ac_var="ac_cv_header_$ac_item"
            ;;
        file [)]
            ac_item=`echo "$ac_item" | sed 'y%./+-%__p_%'`
            ac_var="ac_cv_file_$ac_item"
            ;;
        func   [)] ac_var="ac_cv_func_$ac_item"   ;;
        lib    [)] ac_var="ac_cv_lib_$ac_item"    ;;
        define [)] ac_var="ac_cv_define_$ac_item" ;;
        custom [)] ac_var="$ac_item" ;;
    esac
    eval "ac_val=\$$ac_var"
    if test ".$ac_val" != .yes; then
        ac_rc=no
        break
    fi
done
if test ".$ac_rc" = .yes; then
    :
    $2
else
    :
    $3
fi
])dnl
define(AC_BEGIN_DECISION,[dnl
ac_decision_item='$1'
ac_decision_msg='FAILED'
ac_decision=''
])dnl
define(AC_DECIDE,[dnl
ac_decision='$1'
ac_decision_msg='$2'
ac_decision_$1=yes
ac_decision_$1_msg='$2'
])dnl
define(AC_DECISION_OVERRIDE,[dnl
    ac_decision=''
    for ac_item in $1; do
         eval "ac_decision_this=\$ac_decision_${ac_item}"
         if test ".$ac_decision_this" = .yes; then
             ac_decision=$ac_item
             eval "ac_decision_msg=\$ac_decision_${ac_item}_msg"
         fi
    done
])dnl
define(AC_DECISION_FORCE,[dnl
ac_decision="$1"
eval "ac_decision_msg=\"\$ac_decision_${ac_decision}_msg\""
])dnl
define(AC_END_DECISION,[dnl
if test ".$ac_decision" = .; then
    echo "[$]0:Error: decision on $ac_decision_item failed" 1>&2
    exit 1
else
    if test ".$ac_decision_msg" = .; then
        ac_decision_msg="$ac_decision"
    fi
    AC_MSG_RESULT([decision on $ac_decision_item... $ac_decision_msg])
fi
])dnl
dnl #
dnl #  Check for existance of a file
dnl #
AC_DEFUN(AC_TEST_FILE,
[AC_REQUIRE([AC_PROG_CC])
ac_safe=`echo "$1" | sed 'y%./+-%__p_%'`
AC_MSG_CHECKING([for $1])
AC_CACHE_VAL(ac_cv_file_$ac_safe, [
  if test -r $1; then
    eval "ac_cv_file_$ac_safe=yes"
  else
    eval "ac_cv_file_$ac_safe=no"
  fi
])dnl
if eval "test \"`echo '$ac_cv_file_'$ac_safe`\" = yes"; then
  AC_MSG_RESULT(yes)
  ifelse([$2], , :, [$2])
else
  AC_MSG_RESULT(no)
ifelse([$3], , , [$3])
fi
])
dnl #
dnl #  Check in which direction a stack grows
dnl #
define(AC_CHECK_STACKGROW,[dnl
AC_MSG_CHECKING(in which direction stacks grow)
cross_compile=no
AC_TRY_RUN(
changequote(<<, >>)dnl
<<
#include <stdio.h>

static int growsdown(int *x)
{
    int y;
    return (x > &y);
}

int main(int argc, char *argv[])
{
    FILE *f;
    int x;
    if ((f = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(f, "%s\n", growsdown(&x) ? "down" : "up");;
    fclose(f);
    exit(0);
}
>>
changequote([, ])dnl
,[
msg=`cat conftestval`
],
msg=down
,
msg=down
)dnl
AC_MSG_RESULT([$msg])
if test ".$msg" = ".down"; then
    val=1
else
    val=0
fi
AC_DEFINE_UNQUOTED(PTH_STACKSGROWDOWN, $val)
])
dnl #
dnl #  Check how a POSIX sigsetjmp() can be achieved
dnl #
define(AC_CHECK_SIGSETJMP,[dnl
AC_MSG_CHECKING(for signal-mask aware setjmp)
msg=""
pth_sigsetjmp=""
pth_siglongjmp=""
pth_sigjmp_buf=""
cross_compile=no
for testdefine in SIGSETJMP SETJMP _SETJMP; do
OCFLAGS="$CFLAGS"
CFLAGS="$CFLAGS -DTEST_${testdefine}"
AC_TRY_RUN(
changequote(<<, >>)dnl
<<
#if defined(TEST_SIGSETJMP)
#define __JMP_BUF          sigjmp_buf
#define __SETJMP(buf)      sigsetjmp(buf,1)
#define __LONGJMP(buf,val) siglongjmp(buf,val)
#elif defined(TEST_SETJMP)
#define __JMP_BUF          jmp_buf
#define __SETJMP(buf)      setjmp(buf)
#define __LONGJMP(buf,val) longjmp(buf,val)
#elif defined(TEST__SETJMP)
#define __JMP_BUF          jmp_buf
#define __SETJMP(buf)      _setjmp(buf)
#define __LONGJMP(buf,val) _longjmp(buf,val)
#endif

#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <setjmp.h>
#include <unistd.h>

static __JMP_BUF jb;

static void sighandler(int sig)
{
    sigset_t sigs;
    
    /* get signal mask */
    sigprocmask(SIG_SETMASK, NULL, &sigs);

    /* make sure USR1 is still blocked */
    if (!sigismember(&sigs, SIGUSR1))
        exit(1);

    /* block USR2 for us */
    sigaddset(&sigs, SIGUSR2);
    sigprocmask(SIG_SETMASK, &sigs, NULL);

    /* jump back to main */
    __LONGJMP(jb, 1);
    exit(1);
}

int main(int argc, char *argv[]) 
{
    FILE *fp;
    sigset_t sigs;
    struct sigaction sa;
    
    /* the default is that it fails */
    if ((fp = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(fp, "failed\n");
    fclose(fp);

    /* block USR1 and unblock USR2 signal */
    sigprocmask(SIG_SETMASK, NULL, &sigs);
    sigaddset(&sigs, SIGUSR1);
    sigdelset(&sigs, SIGUSR2);
    sigprocmask(SIG_SETMASK, &sigs, NULL);

    /* set jump buffer */
    if (__SETJMP(jb) == 0) {

        /* install signal handler for USR1 */
        memset((void *)&sa, 0, sizeof(struct sigaction));
        sigemptyset(&sa.sa_mask);
        sa.sa_handler = sighandler;
        sa.sa_flags = 0;
        sigaction(SIGUSR1, &sa, NULL);

        /* send USR1 signal (which is still blocked) */
        kill(getpid(), SIGUSR1);
        
        /* unblock USR1 and wait for it */
        sigprocmask(SIG_SETMASK, NULL, &sigs);
        sigdelset(&sigs, SIGUSR1);
        sigsuspend(&sigs);
        exit(1);
    }

    /* get signal mask again */
    sigprocmask(SIG_SETMASK, NULL, &sigs);

    /* make sure USR2 is again unblocked */
    if (sigismember(&sigs, SIGUSR2))
        exit(1);

    /* Fine... */
    if ((fp = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(fp, "ok\n");
    fclose(fp);
    exit(0);
}
>>
changequote([, ])dnl
,[
rc=`cat conftestval`
],
rc=failed
,
rc=failed
)dnl
CFLAGS="$OCFLAGS"
case ".$rc" in
    .ok ) 
        case $testdefine in
            SIGSETJMP )
                pth_sigsetjmp=sigsetjmp1
                pth_siglongjmp=siglongjmp
                pth_sigjmp_buf=sigjmp_buf
                msg="sigjmp_buf+sigsetjmp/siglongjmp (POSIX)"
                ;;
            SETJMP )
                pth_sigsetjmp=setjmp
                pth_siglongjmp=longjmp
                pth_sigjmp_buf=jmp_buf
                msg="jmp_buf+setjmp/longjmp (BSD)"
                ;;
            _SETJMP )
                pth_sigsetjmp=_setjmp
                pth_siglongjmp=_longjmp
                pth_sigjmp_buf=jmp_buf
                msg="jmp_buf+_setjmp/_longjmp (esoteric)"
                ;;
        esac
        break
        ;;
esac
done
AC_DEFINE_UNQUOTED(pth_sigsetjmp, $pth_sigsetjmp)
AC_DEFINE_UNQUOTED(pth_siglongjmp, $pth_siglongjmp)
AC_DEFINE_UNQUOTED(pth_sigjmp_buf, $pth_sigjmp_buf)
if test ".$msg" = .; then
    pth_sigsetjmp=setjmp
    pth_siglongjmp=longjmp
    pth_sigjmp_buf=jmp_buf
    msg="jmp_buf+setjmp/longjmp+setprocmask (emulated)"
    AC_DEFINE(PTH_EMULATE_SIGSETJMP)
fi
AC_MSG_RESULT([$msg])
])dnl
dnl #
dnl #  Check for number of signals (NSIG)
dnl #
define(AC_CHECK_NSIG,[dnl
AC_MSG_CHECKING(for number of signals)
cross_compile=no
AC_TRY_RUN(
changequote(<<, >>)dnl
<<
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>

int main(int argc, char *argv[]) 
{
    FILE *fp;
    int nsig;

#if defined(NSIG)
    nsig = NSIG;
#elif defined(_NSIG)
    nsig = _NSIG;
#else
    nsig = (sizeof(sigset_t)*8);
    if (nsig < 32)
        nsig = 32;
#endif
    if ((fp = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(fp, "%d\n", sig);
    fclose(fp);
    exit(0);
}
>>
changequote([, ])dnl
,[
nsig=`cat conftestval`
],
nsig=32
,
nsig=32
)dnl
AC_MSG_RESULT([$nsig])
AC_DEFINE_UNQUOTED(PTH_NSIG, $nsig)
])dnl
dnl ##
dnl ##  check for an external/extension library
dnl ##  AC_CHECK_EXTLIB(Foo, foo, foo_init, foo.h, yes, no)
dnl ##
define(AC_CHECK_EXTLIB,[dnl
AC_ARG_WITH($2,dnl
[  --with-]substr([$2[[=DIR]]                 ], 0, 19)[build with $1 library (default=no)],
    if test ".$with_$2" = .yes; then
        #   via config script
        $2_version=`($2-config --version) 2>/dev/null`
        if test ".$$2_version" != .; then
            CPPFLAGS="$CPPFLAGS `$2-config --cflags`"
            CFLAGS="$CFLAGS `$2-config --cflags`"
            LDFLAGS="$LDFLAGS `$2-config --ldflags`"
        fi
    else
        if test -d "$with_$2"; then
            found=0
            #   via config script
            for dir in $with_$2/bin $with_$2; do
                if test -f "$dir/$2-config"; then
                    $2_version=`($2-config --version) 2>/dev/null`
                    if test ".$$2_version" != .; then
                        CPPFLAGS="$CPPFLAGS `$2-config --cflags`"
                        CFLAGS="$CFLAGS `$2-config --cflags`"
                        LDFLAGS="$LDFLAGS `$2-config --ldflags`"
                        found=1
                        break
                    fi
                fi
            done
            #   via standard paths
            if test ".$found" = .0; then
                for dir in $with_$2/include/$2 $with_$2/include $with_$2; do
                    if test -f "$dir/$4"; then
                        CPPFLAGS="$CPPFLAGS -I$dir"
                        CFLAGS="$CFLAGS -I$dir"
                        found=1
                        break
                    fi
                done
                for dir in $with_$2/lib/$2 $with_$2/lib $with_$2; do
                    if test -f "$dir/lib$2.a" -o -f "$dir/lib$2.so"; then
                        LDFLAGS="$LDFLAGS -L$dir"
                        found=1
                        break
                    fi
                done
            fi
            #   in any subarea
            if test ".$found" = .0; then
changequote(, )dnl
                for file in x `find $with_$2 -name "$4" -type f -print`; do
                    test .$file = .x && continue
                    dir=`echo $file | sed -e 's;[[^/]]*$;;' -e 's;\(.\)/$;\1;'`
                    CPPFLAGS="$CPPFLAGS -I$dir"
                    CFLAGS="$CFLAGS -I$dir"
                done
                for file in x `find $with_$2 -name "lib$2.[[aso]]" -type f -print`; do
                    test .$file = .x && continue
                    dir=`echo $file | sed -e 's;[[^/]]*$;;' -e 's;\(.\)/$;\1;'`
                    LDFLAGS="$LDFLAGS -L$dir"
                done
changequote([, ])dnl
            fi
        fi
    fi
    AC_HAVE_HEADERS($4)
    AC_CHECK_LIB($2, $3)
    AC_IFALLYES(header:$4 lib:$2_$3, with_$2=yes, with_$2=no)
    if test ".$with_$2" = .no; then
        AC_ERROR([Unable to find $1 library])
    fi
,
if test ".$with_$2" = .; then
    with_$2=no
fi
)dnl
AC_MSG_CHECKING(whether to build with $1 library)
if test ".$with_$2" = .yes; then
    ifelse([$5], , :, [$5])
else
    ifelse([$6], , :, [$6])
fi
AC_MSG_RESULT([$with_$2])
])dnl
