/* proxyknife.h - miscellaneous declarations 
 * Copyright (C) 2005, 2006, 2007 Jia Wang <skyroam@gmail.com>
 *
 *
 *
 * This file is part of GNU Proxyknife.
 * GNU Proxyknife is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 3 of the License, or (at your 
 * option) any later version.
 *
 * GNU Proxyknife is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
#ifndef HAVE_PROXYKNIFE_INCLUDE
#define HAVE_PROXYKNIFE_INCLUDE

/* for config.h */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

/* global include */
#include <stdlib.h>
#include <stdio.h>
/* #include <assert.h> */
#include <pthread.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
extern int h_errno;
#include <netinet/in.h>
#include <arpa/inet.h>
/* #include<sys/select.h> */
#include <sys/time.h>
#include <unistd.h>
/* gnulib: getopt,gettext */
#include <getopt.h>
#include <string.h>
#include <unistd.h>
#include "gettext.h"
#include "read-file.h"

/* for gettext */
#define _(String) gettext (String)

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif

/* protocol define */
#define HTTP 10
#define HTTPS 11
#define SOCKS5 12
#define SOCKS4 13
#define SOCKS4a 14
#define TELNET 15
#define FTP 16

/* The queue checked in the loop.
 * Tt is local struct,used in loop.c. 
 * */
struct testqueue
{
  char *testproxy;		/* As part of request to myproxy(http),thread */

  /* if connection to testproxy directly or type of myproxy is socks5  */
  /*
     char *testhost; 
     char *testport; */
  struct sockaddr_in proxyaddr;

  /* store the output protocol string */
  char *proto_out;
  /* the type of protocol */
  int proto;
};

/* Request method. */
#define HTTP_GET 0
#define HTTP_CONNECT 1

#define SOCKS5_CONNECT 2
#define SOCKS5_UDP 3
#define SOCKS5_BIND 4

#define SOCKS4_CONNECT 5
#define SOCSK4_BIND 6

#define SOCKS4A_CONNECT 7
#define SOCKS4A_BIND 8

#define HTTP_CONNECT_AUTH  11
#define SOCKS5_CONNECT_AUTH 12


/* Mode of input interface */
#define IN_FILE 0
#define IN_HTTP 1


/* Reserved */
struct dict
{
  char *key;
  int value;
} dict;

/* The struct include test attribute of testproxy. */
struct test
{
/*now only  HTTP_GET ,HTTP_CONNECT,SOCKS5_CONNECT,SOCKS4_CONNECT is supported*/
  int httptestmethod, socks5testmethod, socks4testmethod;
/* Size of buffer used to receive reply after sending CONNECT req to testproxy */
#define TESTCONREPLYSIZE 256
  int testconreplysize;		/* Including trailing '\0' */
/* The size of buffer used to store data from the target. */
/* Key was searched in it */
#define TESTTAGREPLYSIZE 65535
int testtagreplysize;		/* Including trailing '\0' */
};
struct test test;

#define DIRECT 21
/* The myproxy struct. */
/* now only HTTP_CONNECT,HTTP_CONNECT_AUTH is permitted for mytype */
struct my
{
  int mytype;
  char *myhost;			/* read data from conf ,nouse after gethostbyname */
  int myport;
/* Size of buffer used to receive reply after sending CONNECT req to myproxy */
#define MYCONREPLYSIZE 256
int myconreplysize;
#define BASIC "Proxy-Authorization: Basic "
  unsigned char *header_auth;	/* auth header for myproxy,global if have */
  char *myuserpass;		/* nouse after header_auth is constructed */
  struct in_addr myip;
  struct sockaddr_in myaddr;
  /* for socks5 */
  char *myuser;
  char *mypass;
  char *socks5authreq;
  char *buffer;			/* reply  or request via myproxy */
};
struct my my;

/* The target struct.
 * Target is a webserver used to validate testproxy. 
 * */
struct target
{
/* part of HTTP GET request to testproxy,global if need */
#define CHECKSITE "http://www.google.com:80/webhp?hl=en"
  char *target;
/* part of  HTTP CONNECT request to testproxy,global if need */
  char *targethost, *targetport, *targetpath, *protocol;
  struct sockaddr_in targetaddr;
#define KEY "2006 Google"
  char *key;			/* global */
  char *checkreqin, *req;	/* Request sent to target server. */
  char *req_get_via_http_proxy;	/* PROXYGET sent to HTTP testproxy. 
				   2(CON+GET/FTP/RSYNC...) in 1.
				   After this request,testproxy connect to target. then interact with target 
				   according to protocol in the request and return the result from the target 
				   server to user. */

  char *con_via_http_proxy;	/* PROXYCON Request sent to testproxy. After this,
				   interact with target(checksite) server directly. */
};
struct target target;

#define USER_AGENT "User-Agent: MSIE 6.0"
char *user_agent;		/* global */
#define NOCACHE "Pragma: no-cache"
#define CONNECT_SUCCESS0 "HTTP/1.0 200 Connection established"
#define CONNECT_SUCCESS1 "HTTP/1.1 200 Connection established"

/* Sending and receiving timeouts */
/* receiving timeout, in second, 0 to disable */
#define RCVTIMEO 10
/* sending timeout, in second, 0 to disable */
#define SNDTIMEO 5
int rcvtimeo, sndtimeo;
#define THREADS  50
/* The number of threads */
int threads;
/* return value for wrapper functions */
#define PROXYKNIFE_THREAD_EXIT -3

/* debug */
int debug;
/* log filename */
#define LOGFILENAME "proxyknife.log"
char *logfilename;
#define LOGSTDERR "."
#define PROXYKNIFE_IN "proxylist"
#define PROXYKNIFE_OUT "proxyout"
#define PROXYKNIFE_CONF "proxyknife.conf"
#define PROXYKNIFE_DEFAULT_LISTSITE "proxylist.kmip.net/list.html"
/* The proxylist file and result file */
FILE *out, *in;
/* Store the mode of input */
int proxyknife_in_type;
/* The proxylist file or url, output file*/
char *proxyknife_in, *proxyknife_out;
/* The buffer used to store document downloaded from the web. */
char *proxyknife_in_buffer, *proxyknife_in_buffer_cur;
/* log file */
int logfd;

#define time_sub(a,b) (((a).tv_usec-(b).tv_usec\
			+((a).tv_sec-(b).tv_sec)*1e6)*(double)(1e-6))

/* The name of this progname */
char *progname;			/* argv[1] here */

/* Thread specific data struct. I will define a 
 * thread_mem struct in every thread. */
struct thread_mem
{
  char *line;
  struct testqueue queue;
  char *request;
  char *reply;
};
/* The mutex used to lock read on  proxylist file */
pthread_mutex_t counter_mutex_in;
/* The mutex used to lock write on proxyout file */
pthread_mutex_t counter_mutex_out;
/* The mutex used to lock the operation - create thread .No use now. */
pthread_mutex_t counter_mutex_create;
/* The mutex used to lock free , malloc or realloc */
pthread_mutex_t counter_mutex_malloc;

/* proxyknife.c */
void INIT (int argc, char **args);
void THREAD ();
void END ();


/* readconf.c */
int readint (char *line, char *flagstring, int *i, int *num);
int readstr (char *line, char *flagstring, char **s, int *num);
void optstr (char *value, char **s, int *num);
void optint (char *value, int *i, int *num);
void * xstrdup(char *s);
void READCONF (int argc, char **args);

/* mem.c */
void mem_init (void);
void xexit (int status);
void *xmalloc (size_t size);
void xfree (void **p);
void *xrealloc (void *ptr, size_t size);
void *pmalloc (size_t size, struct thread_mem *thread_mem);
void *prealloc (void *ptr, size_t size, struct thread_mem *thread_mem);
void thread_mem_init (struct thread_mem *thread_mem);
void x_pthread_exit (void *retval, struct thread_mem *thread_mem);
void pxfree (void **p);

/* base64en.c */
int base64en (unsigned char *dst, int dst_max, unsigned char *src,
	      int src_size);
/* getaline.c */
int getaline (unsigned char **line, int *size, FILE * f);
int getaline_r (char **line, int *size, FILE * f,
		struct thread_mem *thread_mem);

/* checkaline.c */
int checkaline (struct thread_mem *thread_mem);

/* http.c */
void http_build_auth (void);
void http_build_get (void);
void build_req_get_via_http_proxy ();
void build_con_via_http_proxy ();
int CONVIAHTTP_MAIN (int sockfd, char *host, char *port);
int CONVIAHTTP (int sockfd, struct timeval *start,
		struct timeval *end, struct thread_mem *thread_mem);
int PGET (int sockfd, struct timeval *send, struct thread_mem *thread_mem);
int PCONGET (int sockfd, struct timeval *start, struct timeval *end,
	     struct timeval *req, struct thread_mem *thread_mem);
int GET (int sockfd, struct timeval *req, struct thread_mem *thread_mem);

/* socks5.c */
void s5_build_auth (void);
int s5_nego_free (int sockfd);
int s5_nego_auth (int sockfd);
int s5con (int sockfd, struct sockaddr *serv);
int CONVIASOCKS5_MAIN (int sockfd, struct sockaddr *addr);
int CONVIASOCKS5 (int sockfd, struct timeval *start,
		  struct timeval *end, struct thread_mem *thread_mem);
int S5PCONGET (int sockfd, struct timeval *start_CON, struct timeval *end_CON,
	       struct timeval *start_GET, struct thread_mem *thread_mem);


/* socks4.c */
int s4con (int sockfd, struct sockaddr *serv);
int S4PCONGET (int sockfd, struct timeval *start_CON, struct timeval *end_CON,
	       struct timeval *start_GET, struct thread_mem *thread_mem);

/* myproxy.c */
void MY_CONNECT (int sockfd, char *host, char *port);

/* fetchproxylist.c */
char *td (char *q, char **data);
void fetchproxylist (char *proxyknife_in);
char *sgetaline (char *s, struct thread_mem *thread_mem);


/* loop.c */
void x_update_string_thread (char **dst, char *value,
			     struct thread_mem *thread_mem);
void *update_string_thread (char **dst, char *value,
			    struct thread_mem *thread_mem);
int READAPROXY (struct thread_mem *thread_mem);
int VERIFY (int sockfd, struct timeval *finddata,
	    struct timeval *findkey, struct thread_mem *thread_mem);
void *loop (void *arg);

#endif /* HAVE_PROXYKNIFE_INCLUDE */
