/* initialization routines for Quizzer
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/*
 * quizzer.init.c
 * Guy Albertelli II 1996
 */
#include <stdio.h>
#include <sys/file.h>
#include <tk.h>
#include <stdlib.h>
#include <pProj/capaCommon.h>
#include <signal.h>
#include <quizzer.h>
#include <common.h>

Tcl_Interp * gInterp;

int Quizzer_Init(Tcl_Interp *interp)
{
  char buf[BUFFER_SIZE],*argv;

  signal(SIGSEGV,signalHandler);
  signal(SIGILL,signalHandler);
  signal(SIGFPE,signalHandler);
  signal(SIGBUS,signalHandler);

  gInterp=interp;
  Tcl_CreateCommand( interp, "enscriptParse", capaTclParse, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "texParse", capaTclParse, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "webParse", capaTclParse, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "capaGetStudent", capaGetStudent, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "dateUpdate", capaDateUpdate, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "runLatex", capaRunLatex, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "getParseErrors", capaGetParseErrors, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "getHeaderInfo", capaGetHeaderInfo, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "updateHeader", capaUpdateHeader, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "checkHeader", capaCheckHeader, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "getExistingSections", capaGetExistingSections,
		     (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "getStudentNumbers", capaGetStudentNumbers,
		     (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "stopParser", capaStopParser,
		     (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL); 

  Tcl_LinkVar(interp,"gFasterParsing",(char *)&gFasterParsing,TCL_LINK_INT);

  sprintf(buf,"%s.%s",MAJORVER,QUIZZERMINORVER);
  Tcl_SetVar(interp,"gVer",buf,TCL_GLOBAL_ONLY);
  sprintf(buf,"Compiled on %s",COMPILE_DATE);
  Tcl_SetVar(interp,"gCompileDate",buf,TCL_GLOBAL_ONLY);

  argv=Tcl_GetVar(interp,"argv", TCL_GLOBAL_ONLY);
  if (argv!=NULL && strlen(argv) > 9 && 
      argv[0]=='-' && 
      argv[1]=='c' && 
      argv[2]=='o' && 
      argv[3]=='p' && 
      argv[4]=='y' && 
      argv[5]=='r' && 
      argv[6]=='i' && 
      argv[7]=='g' && 
      argv[8]=='h' && 
      argv[9]=='t' ) message();

  return TCL_OK;
}

int Quizzer_InitStandAlone(Tcl_Interp *interp)
{
  return Quizzer_Init(interp);
}

int Quizzer_SafeInit(Tcl_Interp *interp)
{
  return Quizzer_Init(interp);
}

