/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef _WRAPPERS_H

#define _WRAPPERS_H 1

#include <stdlib.h>

enum motti_errors {
  ERR_NONAME,		/* A map file wasn't found.  */
  ERR_INVNAME,		/* Invalid map file.  */
  ERR_NOX,		/* Can't open display.  */
  ERR_NOFONT,		/* Can't load font.  */
  /* TODO: failed malloc shouldn't be fatal?  On the other hand, motti
     uses so little memory, that this might not be a problem at all.
  */
  ERR_MALLOC,		/* Can't alloc memory.  */
  ERR_COLOR_FIND,	/* Can't find a color value.  */
  ERR_COLOR_ALLOC,	/* Can't allocate a color value.  */
  ERR_MOUSE		/* Invalid mouse action specified.  */
};

extern void die (char *);
extern char *alloc_err_str (enum motti_errors, const char *);
extern void *my_malloc (size_t);
extern void *my_calloc (size_t, size_t);

#endif /* wrappers.h  */
