/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.kawa.functions.ParseFormat;
import gnu.lists.FString;
import gnu.mapping.CharArrayOutPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.Values;
import gnu.text.ReportFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.MessageFormat;

public class Format
extends ProcedureN {
    public static final Format format = new Format();

    public static void format(Writer dst, Object[] args, int arg_offset) {
        Object format = args[arg_offset++];
        Object[] vals = new Object[args.length - arg_offset];
        System.arraycopy(args, arg_offset, vals, 0, vals.length);
        Format.formatToWriter(dst, format, vals);
    }

    public static void formatToWriter(Writer dst, Object format, Object ... vals) {
        if (dst == null) {
            dst = OutPort.outDefault();
        }
        try {
            if (format instanceof MessageFormat) {
                String out = ((MessageFormat)format).format(vals);
                dst.write(out);
            } else {
                if (!(format instanceof ReportFormat)) {
                    format = ParseFormat.parseFormat.apply1(format);
                }
                ((ReportFormat)format).format(vals, 0, dst, (FieldPosition)null);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error in format: " + ex);
        }
    }

    public static void formatToOutputStream(OutputStream dst, Object format, Object ... vals) {
        OutPort port = new OutPort(dst);
        Format.format(port, format, vals);
        port.closeThis();
    }

    public static String formatToString(int arg_offset, Object ... args) {
        CharArrayOutPort port = new CharArrayOutPort();
        Format.format(port, args, arg_offset);
        String str = port.toString();
        port.close();
        return str;
    }

    public static FString formatToFString(char style, Object fmt, Object[] args) {
        ReportFormat rfmt = ParseFormat.asFormat(fmt, style);
        CharArrayOutPort port = new CharArrayOutPort();
        try {
            rfmt.format(args, 0, (Writer)port, (FieldPosition)null);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error in format: " + ex);
        }
        char[] chars = port.toCharArray();
        port.close();
        return new FString(chars);
    }

    public Object applyN(Object[] args) {
        return Format.format(args);
    }

    public static Object format(Object ... args) {
        Object port_arg = args[0];
        if (port_arg == Boolean.TRUE) {
            Format.format(OutPort.outDefault(), args, 1);
            return Values.empty;
        }
        if (port_arg == Boolean.FALSE) {
            return Format.formatToString(1, args);
        }
        if (port_arg instanceof MessageFormat || port_arg instanceof CharSequence || port_arg instanceof ReportFormat) {
            return Format.formatToString(0, args);
        }
        if (port_arg instanceof Writer) {
            Format.format((Writer)port_arg, args, 1);
            return Values.empty;
        }
        if (port_arg instanceof OutputStream) {
            Format.formatToOutputStream((OutputStream)port_arg, args[1], Format.drop2(args));
            return Values.empty;
        }
        throw new RuntimeException("bad first argument to format");
    }

    static Object[] drop2(Object[] vals) {
        int xlen = vals.length - 2;
        Object[] xvals = new Object[xlen];
        System.arraycopy(vals, 2, xvals, 0, xlen);
        return xvals;
    }

    static {
        format.setName("format");
        format.setProperty(Procedure.validateApplyKey, "gnu.kawa.functions.CompileMisc:validateApplyFormat");
    }
}

