/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- 
 * $Id: OP.java,v 1.1 2000/02/11 22:08:18 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998 -- 2000 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel;

public abstract class OP {
  /** References the next OP in the list */
  protected OP next=null;

  /** References the previous OP in the list */
  protected OP prev=null;
  
  /** Holds type ID of the result of this OP */
  protected int resID;
  
  /** Holds type of the result of this OP */
  protected Class resType;

  /**
   * Called to generate the code implementing this OP.
   * @param cf class file to write the code into.
   */
  protected abstract void compile(ClassFile cf);
  
};


