/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionLoader;
import gnu.jel.debug.Tester;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class ExpressionImage {
    public static final int BI_PL = 0;
    public static final int BI_MI = 1;
    public static final int BI_MU = 2;
    public static final int BI_DI = 3;
    public static final int BI_RE = 4;
    public static final int BI_AN = 5;
    public static final int BI_OR = 6;
    public static final int BI_XO = 7;
    public static final String[] binaryNames = new String[]{"add", "substract", "multiply", "divide", "remainder", "bitwise and", "bitwise or", "bitwise xor"};
    public static final String[] unaryNames = new String[]{"negate"};
    public static final int UN_NE = 0;
    private static final byte[] prologue;
    private int poolEntries = 1;
    private static final byte[] cp_middle;
    private static final byte[] intermezzo1;
    private byte thetype = (byte)99;
    private static final byte[] intermezzo2;
    short nameIdx = (short)9999;
    short signIdx = (short)9999;
    private static final byte[] intermezzo3;
    int max_stack = 2;
    int max_locals = 4;
    private static final byte[] konetc;
    public static final Class[] primitiveTypes;
    private static final char[] primitiveCodes;
    public static final String[] primitiveTypeNames;
    private static final byte[] returns;
    private static final byte[] cvt_wide;
    private static final int[][] cvt1;
    private static final int[][] cvt2;
    private static final byte[] stkoccup;
    private static final int[][] cvts;
    private static final int[][] ops;
    private static final int[] norm;
    private static final int[][] una;
    private static final byte[] stor;
    private static final byte[] load;
    private static final byte[] sladdr;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;
    private ByteArrayOutputStream constPool;
    private DataOutputStream constPoolData;
    private Hashtable Classes = new Hashtable();
    private Hashtable Methods = new Hashtable();
    private Hashtable Longs = new Hashtable();
    private Hashtable Doubles = new Hashtable();
    private Hashtable UTFs = new Hashtable();
    private Hashtable Strings = new Hashtable();
    private Hashtable Integers = new Hashtable();
    private Hashtable Floats = new Hashtable();
    private ByteArrayOutputStream methodText;
    private DataOutputStream methodTextData;
    private static final String classNamePrefix = "gnu.jel.generated.E_";
    private static volatile long numberGen;
    private String className;
    private boolean classFinished = false;
    private int currSSW;
    private Vector objectPool = new Vector();
    private Stack typesStk = new Stack();
    private Stack functionParams = new Stack();
    private Stack functionINTS = new Stack();
    private Stack functionRet = new Stack();

    public ExpressionImage() {
        this.constPool = new ByteArrayOutputStream();
        this.constPoolData = new DataOutputStream(this.constPool);
        this.methodText = new ByteArrayOutputStream();
        this.methodTextData = new DataOutputStream(this.methodText);
        this.className = classNamePrefix + Long.toString(numberGen++);
        int n = this.getUTFIndex(ExpressionImage.toHistoricalForm(this.className));
        try {
            this.constPoolData.write(cp_middle);
            this.poolEntries += 18;
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private final void checkAlter() {
    }

    private int getUTFIndex(String string) {
        Integer n = (Integer)this.UTFs.get(string);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.constPoolData.write(1);
                this.constPoolData.writeUTF(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.UTFs.put(string, n);
        }
        return n;
    }

    private int getLongIndex(Long l) {
        Integer n = (Integer)this.Longs.get(l);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.constPoolData.write(5);
                this.constPoolData.writeLong(l);
                ++this.poolEntries;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Longs.put(l, n);
        }
        return n;
    }

    private int getIntIndex(Integer n) {
        Integer n2 = (Integer)this.Integers.get(n);
        if (n2 == null) {
            n2 = new Integer(this.poolEntries++);
            try {
                this.constPoolData.write(3);
                this.constPoolData.writeInt(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Integers.put(n, n2);
        }
        return n2;
    }

    private int getFloatIndex(Float f) {
        Integer n = (Integer)this.Floats.get(f);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.constPoolData.write(4);
                this.constPoolData.writeFloat(f.floatValue());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Floats.put(f, n);
        }
        return n;
    }

    private int getDoubleIndex(Double d) {
        Integer n = (Integer)this.Doubles.get(d);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.constPoolData.write(6);
                this.constPoolData.writeDouble(d);
                ++this.poolEntries;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Doubles.put(d, n);
        }
        return n;
    }

    private int getStringIndex(String string) {
        Integer n = (Integer)this.Strings.get(string);
        if (n == null) {
            int n2 = this.getUTFIndex(string);
            n = new Integer(this.poolEntries++);
            try {
                this.constPoolData.write(8);
                this.constPoolData.writeShort(n2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Strings.put(string, n);
        }
        return n;
    }

    private int getClassIndex(Class clazz) {
        Integer n = (Integer)this.Classes.get(clazz);
        if (n == null) {
            String string = clazz.getName();
            String string2 = ExpressionImage.toHistoricalForm(string);
            int n2 = this.getUTFIndex(string2);
            n = new Integer(this.poolEntries++);
            this.writeClassInfo(n2);
            this.Classes.put(clazz, n);
        }
        return n;
    }

    private void writeClassInfo(int n) {
        try {
            this.constPoolData.write(7);
            this.constPoolData.writeShort(n);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private int getMethodIndex(Method method) {
        Integer n = (Integer)this.Methods.get(method);
        if (n == null) {
            int n2 = this.getUTFIndex(method.getName());
            int n3 = this.getUTFIndex(ExpressionImage.getSignature(method));
            Class<?> clazz = method.getDeclaringClass();
            int n4 = this.getClassIndex(clazz);
            int n5 = this.poolEntries++;
            try {
                this.constPoolData.write(12);
                this.constPoolData.writeShort(n2);
                this.constPoolData.writeShort(n3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            n = new Integer(this.poolEntries++);
            int n6 = 10;
            if (clazz.isInterface()) {
                n6 = 11;
            }
            try {
                this.constPoolData.write(n6);
                this.constPoolData.writeShort(n4);
                this.constPoolData.writeShort(n5);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Methods.put(method, n);
        }
        return n;
    }

    public static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ExpressionImage.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer.append(ExpressionImage.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    public static String getSignature(Class clazz) {
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz.isArray()) {
            return String.valueOf('[') + ExpressionImage.getSignature(clazz.getComponentType());
        }
        return String.valueOf('L') + ExpressionImage.toHistoricalForm(clazz.getName()) + ';';
    }

    private static String toHistoricalForm(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        int n2 = string.indexOf(46);
        while (n2 > 0 && n2 < n) {
            stringBuffer.setCharAt(n2, '/');
            n2 = string.indexOf(46, n2 + 1);
        }
        return stringBuffer.toString();
    }

    byte[] getImage() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.write(prologue);
            dataOutputStream.writeShort(this.poolEntries);
            this.constPool.writeTo(dataOutputStream);
            dataOutputStream.write(intermezzo1);
            dataOutputStream.write(this.thetype);
            dataOutputStream.write(intermezzo2);
            dataOutputStream.writeShort(this.nameIdx);
            dataOutputStream.writeShort(this.signIdx);
            dataOutputStream.write(intermezzo3);
            int n = this.methodText.size();
            dataOutputStream.writeInt(n + 12);
            dataOutputStream.writeShort(this.max_stack);
            dataOutputStream.writeShort(this.max_locals);
            dataOutputStream.writeInt(n);
            this.methodText.writeTo(dataOutputStream);
            dataOutputStream.write(konetc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public CompiledExpression getExpression() {
        byte[] byArray = this.getImage();
        try {
            ExpressionLoader expressionLoader = new ExpressionLoader(this.className, byArray);
            Class<?> clazz = expressionLoader.loadClass(this.className);
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Object[][] objectArray = new Object[1][this.objectPool.size()];
            if (this.objectPool.size() > 0) {
                this.objectPool.copyInto(objectArray[0]);
            }
            return (CompiledExpression)constructorArray[0].newInstance((Object[])objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final void ensureStack() {
        if (this.currSSW > this.max_stack) {
            this.max_stack = this.currSSW;
        }
    }

    private final void codeOP(int n) {
        try {
            this.methodTextData.write(n);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private final void codeINDEX(int n) {
        try {
            this.methodTextData.writeShort(n);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static final int primitiveID(Class clazz) {
        int n = 0;
        while (n < primitiveTypes.length && primitiveTypes[n] != clazz) {
            ++n;
        }
        return n;
    }

    private static final int stackSpace(Class clazz) {
        if (clazz.isPrimitive()) {
            return stkoccup[ExpressionImage.primitiveID(clazz)];
        }
        return 1;
    }

    public void asm_load_object(Object object) {
        if (object == null) {
            this.typesStk.push(null);
            this.codeOP(1);
            ++this.currSSW;
            if (this.currSSW > this.max_stack) {
                this.max_stack = this.currSSW;
                return;
            }
        } else {
            int n;
            int n2 = this.objectPool.indexOf(object);
            if (n2 == -1) {
                this.objectPool.addElement(object);
                n2 = this.objectPool.size() - 1;
            }
            this.typesStk.push(object.getClass());
            this.currSSW += 2;
            if (this.currSSW > this.max_stack) {
                this.max_stack = this.currSSW;
            }
            this.codeOP(42);
            this.codeOP(180);
            this.codeINDEX(15);
            if (n2 < 255) {
                this.codeOP(16);
                this.codeOP(n2);
            } else {
                n = this.getIntIndex(new Integer(n2));
                this.codeOP(19);
                this.codeINDEX(n);
            }
            this.codeOP(50);
            n = this.getClassIndex(object.getClass());
            this.codeOP(192);
            this.codeINDEX(n);
            --this.currSSW;
        }
    }

    public void asm_load_primitive(Object object) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        Class<Constable> clazz = null;
        Class<Comparable<Byte>> clazz2 = null;
        boolean bl = false;
        if (object instanceof Double) {
            n3 = 2;
            n = 20;
            n2 = this.getDoubleIndex((Double)object);
            clazz = Double.TYPE;
        } else if (object instanceof Long) {
            n3 = 2;
            n = 20;
            n2 = this.getLongIndex((Long)object);
            clazz = Long.TYPE;
        } else if (object instanceof Float) {
            n3 = 1;
            n = 19;
            n2 = this.getFloatIndex((Float)object);
            clazz = Float.TYPE;
            bl = true;
        } else if (object instanceof Integer) {
            n3 = 1;
            n = 19;
            n2 = this.getIntIndex((Integer)object);
            clazz = Integer.TYPE;
            bl = true;
        } else if (object instanceof Byte) {
            n3 = 1;
            n = 19;
            n2 = this.getIntIndex(new Integer(((Byte)object).intValue()));
            clazz = Integer.TYPE;
            clazz2 = Byte.TYPE;
            bl = true;
        } else if (object instanceof Short) {
            n3 = 1;
            n = 19;
            n2 = this.getIntIndex(new Integer(((Short)object).intValue()));
            clazz = Integer.TYPE;
            clazz2 = Short.TYPE;
            bl = true;
        } else if (object instanceof Character) {
            n3 = 1;
            n = 19;
            n2 = this.getIntIndex(new Integer(((Character)object).charValue()));
            clazz = Integer.TYPE;
            clazz2 = Character.TYPE;
            bl = true;
        } else if (object instanceof Boolean) {
            n3 = 1;
            n = 19;
            int n4 = 0;
            if (((Boolean)object).booleanValue()) {
                n4 = 1;
            }
            n2 = this.getIntIndex(new Integer(n4));
            clazz = Boolean.TYPE;
            bl = true;
        }
        if (clazz != null) {
            if (bl && n2 < 255) {
                this.codeOP(n - 1);
                this.codeOP(n2);
            } else {
                this.codeOP(n);
                this.codeINDEX(n2);
            }
            this.currSSW += n3;
            if (this.currSSW > this.max_stack) {
                this.max_stack = this.currSSW;
            }
            this.typesStk.push(clazz);
            if (clazz2 != null) {
                this.asm_convert(clazz2);
            }
        }
    }

    public static boolean canConvert(Class clazz, Class clazz2) {
        boolean bl = clazz.isPrimitive();
        boolean bl2 = clazz2.isPrimitive();
        if (bl2 && bl) {
            int n = ExpressionImage.primitiveID(clazz);
            int n2 = ExpressionImage.primitiveID(clazz2);
            return cvt1[n2][n] != 255;
        }
        if (bl2 ^ bl) {
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean canConvertByWidening(Class clazz, Class clazz2) {
        boolean bl = clazz.isPrimitive();
        boolean bl2 = clazz2.isPrimitive();
        if (bl2 && bl) {
            int n = ExpressionImage.primitiveID(clazz);
            int n2 = ExpressionImage.primitiveID(clazz2);
            return (cvt_wide[n2] & 128 >> n) > 0;
        }
        if (bl2 ^ bl) {
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public boolean asm_convert(Class clazz) {
        Class clazz2 = (Class)this.typesStk.peek();
        if (clazz == clazz2) {
            return true;
        }
        boolean bl = clazz2.isPrimitive();
        boolean bl2 = clazz.isPrimitive();
        if (bl && bl2) {
            int n = ExpressionImage.primitiveID(clazz2);
            int n2 = ExpressionImage.primitiveID(clazz);
            int n3 = cvt1[n2][n];
            int n4 = cvt2[n2][n];
            if (n3 == 255) {
                return false;
            }
            this.currSSW = this.currSSW + stkoccup[n2] - stkoccup[n];
            if (this.currSSW > this.max_stack) {
                this.max_stack = this.currSSW;
            }
            if (n3 != 0) {
                this.codeOP(n3);
            }
            if (n4 != 0) {
                this.codeOP(n4);
            }
            this.typesStk.pop();
            this.typesStk.push(clazz);
            return true;
        }
        if (bl ^ bl2) {
            return false;
        }
        this.typesStk.pop();
        this.typesStk.push(clazz);
        return true;
    }

    public static Class getMostGeneralType(Class clazz, Class clazz2) {
        int n;
        int n2 = ExpressionImage.primitiveID(clazz);
        int n3 = cvts[n2][n = ExpressionImage.primitiveID(clazz2)];
        if (n3 == 255) {
            return null;
        }
        return primitiveTypes[n3];
    }

    public static boolean canGenerateUnary(int n, Class clazz) {
        if (!clazz.isPrimitive()) {
            return false;
        }
        return una[n][ExpressionImage.primitiveID(clazz)] != 255;
    }

    public boolean asm_unary(int n) {
        Class clazz = (Class)this.typesStk.peek();
        if (!clazz.isPrimitive()) {
            return false;
        }
        int n2 = ExpressionImage.primitiveID(clazz);
        int n3 = una[n][n2];
        if (n3 == 255) {
            return false;
        }
        this.codeOP(n3);
        return true;
    }

    public static boolean canGenerateBinary(int n, Class clazz) {
        if (!clazz.isPrimitive()) {
            return false;
        }
        return ops[n][ExpressionImage.primitiveID(clazz)] != 255;
    }

    public static boolean canGenerateBinary(int n, Class clazz, Class clazz2) {
        if (!clazz.isPrimitive() || !clazz2.isPrimitive()) {
            return false;
        }
        Class clazz3 = ExpressionImage.getMostGeneralType(clazz, clazz2);
        if (clazz3 == null) {
            return false;
        }
        if (!clazz3.isPrimitive()) {
            return false;
        }
        return ops[n][ExpressionImage.primitiveID(clazz3)] != 255;
    }

    public boolean asm_binary(int n) {
        int n2;
        Class clazz = (Class)this.typesStk.peek();
        Object e = this.typesStk.pop();
        Class clazz2 = (Class)this.typesStk.peek();
        this.typesStk.push(e);
        if (!clazz2.isPrimitive() || !clazz.isPrimitive()) {
            return false;
        }
        int n3 = ExpressionImage.primitiveID(clazz2);
        if (n3 != (n2 = ExpressionImage.primitiveID(clazz))) {
            return false;
        }
        int n4 = ops[n][n3];
        if (n4 == 255) {
            return false;
        }
        this.codeOP(n4);
        this.typesStk.pop();
        this.currSSW -= stkoccup[n3];
        return true;
    }

    public void asm_func_start(Method method, int n) {
        Class<?>[] classArray = method.getParameterTypes();
        this.functionParams.push(classArray);
        boolean bl = Modifier.isStatic(method.getModifiers());
        int[] nArray = new int[5];
        nArray[0] = this.getMethodIndex(method);
        nArray[1] = bl ? 1 : 0;
        nArray[2] = classArray.length;
        nArray[4] = this.currSSW;
        int[] nArray2 = nArray;
        this.functionINTS.push(nArray2);
        this.functionRet.push(method.getReturnType());
        if (!bl) {
            int n2;
            this.currSSW += 2;
            if (this.currSSW > this.max_stack) {
                this.max_stack = this.currSSW;
            }
            this.codeOP(43);
            if (n < 255) {
                this.codeOP(16);
                this.codeOP(n);
            } else {
                n2 = this.getIntIndex(new Integer(n));
                this.codeOP(19);
                this.codeINDEX(n2);
            }
            this.codeOP(50);
            n2 = this.getClassIndex(method.getDeclaringClass());
            this.codeOP(192);
            this.codeINDEX(n2);
            nArray2[4] = --this.currSSW;
        }
    }

    public boolean asm_func_param() {
        int[] nArray;
        int n;
        Class[] classArray = (Class[])this.functionParams.peek();
        boolean bl = this.asm_convert(classArray[n = (nArray = (int[])this.functionINTS.peek())[3]]);
        if (!bl) {
            return false;
        }
        nArray[4] = this.currSSW;
        nArray[3] = nArray[3] + 1;
        return true;
    }

    public boolean asm_func_call() {
        int n;
        Class[] classArray = (Class[])this.functionParams.pop();
        int[] nArray = (int[])this.functionINTS.pop();
        Class clazz = (Class)this.functionRet.pop();
        int n2 = nArray[3];
        if (n2 != nArray[2]) {
            return false;
        }
        boolean bl = nArray[1] == 1;
        int n3 = n = bl ? 0 : 1;
        if (bl) {
            this.codeOP(184);
        } else {
            this.codeOP(182);
        }
        this.codeINDEX(nArray[0]);
        int n4 = 0;
        while (n4 < classArray.length) {
            Class clazz2 = classArray[n4];
            n += clazz2.isPrimitive() ? stkoccup[ExpressionImage.primitiveID(clazz2)] : 1;
            this.typesStk.pop();
            ++n4;
        }
        this.currSSW -= n;
        this.typesStk.push(clazz);
        this.currSSW += clazz.isPrimitive() ? stkoccup[ExpressionImage.primitiveID(clazz)] : 1;
        if (this.currSSW > this.max_stack) {
            this.max_stack = this.currSSW;
        }
        return true;
    }

    public void asm_return() {
        Class clazz = null;
        boolean bl = false;
        try {
            clazz = (Class)this.typesStk.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.asm_load_object(null);
            bl = true;
        }
        int n = primitiveTypes.length;
        int n2 = -80;
        if (!bl) {
            ++n;
            if (clazz != null && clazz.isPrimitive()) {
                n = ExpressionImage.primitiveID(clazz);
                n2 = returns[n];
            }
        }
        StringBuffer stringBuffer = new StringBuffer("evaluate");
        StringBuffer stringBuffer2 = new StringBuffer("([Ljava/lang/Object;)");
        if (n < primitiveTypes.length) {
            stringBuffer.append('_');
            stringBuffer.append(primitiveTypeNames[n]);
            stringBuffer2.append(primitiveCodes[n]);
        } else {
            stringBuffer2.append("Ljava/lang/Object;");
        }
        this.nameIdx = (short)this.getUTFIndex(stringBuffer.toString());
        this.signIdx = (short)this.getUTFIndex(stringBuffer2.toString());
        this.thetype = (byte)n;
        this.typesStk.pop();
        this.codeOP(n2);
        this.classFinished = true;
    }

    public void asm_ThrowReturn() {
        Class clazz = null;
        try {
            clazz = (Class)this.typesStk.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        this.codeOP(191);
        this.classFinished = true;
    }

    public static void main(String[] stringArray) {
        Tester tester = new Tester(System.out);
        tester.summarize();
    }

    static void dumpImage(ExpressionImage expressionImage) {
    }

    private static boolean transmitPrimitive(Object object, Object object2) throws Throwable {
        return true;
    }

    public static void test(Tester tester) {
    }

    static {
        byte[] byArray = new byte[8];
        byArray[0] = -54;
        byArray[1] = -2;
        byArray[2] = -70;
        byArray[3] = -66;
        byArray[5] = 3;
        byArray[7] = 45;
        prologue = byArray;
        byte[] byArray2 = new byte[182];
        byArray2[0] = 7;
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[5] = 26;
        byArray2[6] = 103;
        byArray2[7] = 110;
        byArray2[8] = 117;
        byArray2[9] = 47;
        byArray2[10] = 106;
        byArray2[11] = 101;
        byArray2[12] = 108;
        byArray2[13] = 47;
        byArray2[14] = 67;
        byArray2[15] = 111;
        byArray2[16] = 109;
        byArray2[17] = 112;
        byArray2[18] = 105;
        byArray2[19] = 108;
        byArray2[20] = 101;
        byArray2[21] = 100;
        byArray2[22] = 69;
        byArray2[23] = 120;
        byArray2[24] = 112;
        byArray2[25] = 114;
        byArray2[26] = 101;
        byArray2[27] = 115;
        byArray2[28] = 115;
        byArray2[29] = 105;
        byArray2[30] = 111;
        byArray2[31] = 110;
        byArray2[32] = 7;
        byArray2[34] = 3;
        byArray2[35] = 1;
        byArray2[37] = 1;
        byArray2[38] = 101;
        byArray2[39] = 1;
        byArray2[41] = 19;
        byArray2[42] = 91;
        byArray2[43] = 76;
        byArray2[44] = 106;
        byArray2[45] = 97;
        byArray2[46] = 118;
        byArray2[47] = 97;
        byArray2[48] = 47;
        byArray2[49] = 108;
        byArray2[50] = 97;
        byArray2[51] = 110;
        byArray2[52] = 103;
        byArray2[53] = 47;
        byArray2[54] = 79;
        byArray2[55] = 98;
        byArray2[56] = 106;
        byArray2[57] = 101;
        byArray2[58] = 99;
        byArray2[59] = 116;
        byArray2[60] = 59;
        byArray2[61] = 1;
        byArray2[63] = 6;
        byArray2[64] = 60;
        byArray2[65] = 105;
        byArray2[66] = 110;
        byArray2[67] = 105;
        byArray2[68] = 116;
        byArray2[69] = 62;
        byArray2[70] = 1;
        byArray2[72] = 22;
        byArray2[73] = 40;
        byArray2[74] = 91;
        byArray2[75] = 76;
        byArray2[76] = 106;
        byArray2[77] = 97;
        byArray2[78] = 118;
        byArray2[79] = 97;
        byArray2[80] = 47;
        byArray2[81] = 108;
        byArray2[82] = 97;
        byArray2[83] = 110;
        byArray2[84] = 103;
        byArray2[85] = 47;
        byArray2[86] = 79;
        byArray2[87] = 98;
        byArray2[88] = 106;
        byArray2[89] = 101;
        byArray2[90] = 99;
        byArray2[91] = 116;
        byArray2[92] = 59;
        byArray2[93] = 41;
        byArray2[94] = 86;
        byArray2[95] = 1;
        byArray2[97] = 10;
        byArray2[98] = 69;
        byArray2[99] = 120;
        byArray2[100] = 99;
        byArray2[101] = 101;
        byArray2[102] = 112;
        byArray2[103] = 116;
        byArray2[104] = 105;
        byArray2[105] = 111;
        byArray2[106] = 110;
        byArray2[107] = 115;
        byArray2[108] = 1;
        byArray2[110] = 4;
        byArray2[111] = 67;
        byArray2[112] = 111;
        byArray2[113] = 100;
        byArray2[114] = 101;
        byArray2[115] = 1;
        byArray2[117] = 3;
        byArray2[118] = 40;
        byArray2[119] = 41;
        byArray2[120] = 86;
        byArray2[121] = 12;
        byArray2[123] = 7;
        byArray2[125] = 11;
        byArray2[126] = 10;
        byArray2[128] = 4;
        byArray2[130] = 12;
        byArray2[131] = 12;
        byArray2[133] = 5;
        byArray2[135] = 6;
        byArray2[136] = 9;
        byArray2[138] = 2;
        byArray2[140] = 14;
        byArray2[141] = 1;
        byArray2[143] = 7;
        byArray2[144] = 103;
        byArray2[145] = 101;
        byArray2[146] = 116;
        byArray2[147] = 84;
        byArray2[148] = 121;
        byArray2[149] = 112;
        byArray2[150] = 101;
        byArray2[151] = 1;
        byArray2[153] = 3;
        byArray2[154] = 40;
        byArray2[155] = 41;
        byArray2[156] = 73;
        byArray2[157] = 1;
        byArray2[159] = 19;
        byArray2[160] = 106;
        byArray2[161] = 97;
        byArray2[162] = 118;
        byArray2[163] = 97;
        byArray2[164] = 47;
        byArray2[165] = 108;
        byArray2[166] = 97;
        byArray2[167] = 110;
        byArray2[168] = 103;
        byArray2[169] = 47;
        byArray2[170] = 84;
        byArray2[171] = 104;
        byArray2[172] = 114;
        byArray2[173] = 111;
        byArray2[174] = 119;
        byArray2[175] = 97;
        byArray2[176] = 98;
        byArray2[177] = 108;
        byArray2[178] = 101;
        byArray2[179] = 7;
        byArray2[181] = 18;
        cp_middle = byArray2;
        byte[] byArray3 = new byte[95];
        byArray3[1] = 33;
        byArray3[3] = 2;
        byArray3[5] = 4;
        byArray3[9] = 1;
        byArray3[11] = 2;
        byArray3[13] = 5;
        byArray3[15] = 6;
        byArray3[19] = 3;
        byArray3[21] = 1;
        byArray3[23] = 7;
        byArray3[25] = 8;
        byArray3[27] = 2;
        byArray3[29] = 9;
        byArray3[33] = 2;
        byArray3[37] = 10;
        byArray3[41] = 22;
        byArray3[43] = 2;
        byArray3[45] = 2;
        byArray3[49] = 10;
        byArray3[50] = 42;
        byArray3[51] = -73;
        byArray3[53] = 13;
        byArray3[54] = 42;
        byArray3[55] = 43;
        byArray3[56] = -75;
        byArray3[58] = 15;
        byArray3[59] = -79;
        byArray3[65] = 1;
        byArray3[67] = 16;
        byArray3[69] = 17;
        byArray3[71] = 2;
        byArray3[73] = 9;
        byArray3[77] = 2;
        byArray3[81] = 10;
        byArray3[85] = 15;
        byArray3[87] = 1;
        byArray3[89] = 1;
        byArray3[93] = 3;
        byArray3[94] = 16;
        intermezzo1 = byArray3;
        byte[] byArray4 = new byte[7];
        byArray4[0] = -84;
        byArray4[6] = 1;
        intermezzo2 = byArray4;
        byte[] byArray5 = new byte[14];
        byArray5[1] = 2;
        byArray5[3] = 9;
        byArray5[7] = 4;
        byArray5[9] = 1;
        byArray5[11] = 19;
        byArray5[13] = 10;
        intermezzo3 = byArray5;
        konetc = new byte[6];
        primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
        primitiveCodes = new char[]{'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D', 'V'};
        primitiveTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
        returns = new byte[]{-84, -84, -84, -84, -84, -83, -82, -81};
        cvt_wide = new byte[]{-128, 64, 96, 80, 88, 92, 94, 95};
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[8];
        nArray[1] = 255;
        nArray[2] = 255;
        nArray[3] = 255;
        nArray[4] = 255;
        nArray[5] = 255;
        nArray[6] = 255;
        nArray[7] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 145;
        nArray2[2] = 145;
        nArray2[3] = 145;
        nArray2[4] = 145;
        nArray2[5] = 136;
        nArray2[6] = 139;
        nArray2[7] = 142;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[0] = 146;
        nArray3[1] = 146;
        nArray3[3] = 146;
        nArray3[4] = 146;
        nArray3[5] = 136;
        nArray3[6] = 139;
        nArray3[7] = 142;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 147;
        nArray4[1] = 147;
        nArray4[2] = 147;
        nArray4[4] = 147;
        nArray4[5] = 136;
        nArray4[6] = 139;
        nArray4[7] = 142;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[8];
        nArray5[5] = 136;
        nArray5[6] = 139;
        nArray5[7] = 142;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[8];
        nArray6[0] = 133;
        nArray6[1] = 133;
        nArray6[2] = 133;
        nArray6[3] = 133;
        nArray6[4] = 133;
        nArray6[6] = 140;
        nArray6[7] = 143;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[0] = 134;
        nArray7[1] = 134;
        nArray7[2] = 134;
        nArray7[3] = 134;
        nArray7[4] = 134;
        nArray7[5] = 137;
        nArray7[7] = 144;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[8];
        nArray8[0] = 135;
        nArray8[1] = 135;
        nArray8[2] = 135;
        nArray8[3] = 135;
        nArray8[4] = 135;
        nArray8[5] = 138;
        nArray8[6] = 141;
        nArrayArray[7] = nArray8;
        cvt1 = nArrayArray;
        int[][] nArrayArray2 = new int[8][];
        nArrayArray2[0] = new int[8];
        int[] nArray9 = new int[8];
        nArray9[5] = 145;
        nArray9[6] = 145;
        nArray9[7] = 145;
        nArrayArray2[1] = nArray9;
        int[] nArray10 = new int[8];
        nArray10[5] = 146;
        nArray10[6] = 146;
        nArray10[7] = 146;
        nArrayArray2[2] = nArray10;
        int[] nArray11 = new int[8];
        nArray11[5] = 147;
        nArray11[6] = 147;
        nArray11[7] = 147;
        nArrayArray2[3] = nArray11;
        nArrayArray2[4] = new int[8];
        nArrayArray2[5] = new int[8];
        nArrayArray2[6] = new int[8];
        nArrayArray2[7] = new int[8];
        cvt2 = nArrayArray2;
        stkoccup = new byte[]{1, 1, 1, 1, 1, 2, 1, 2};
        int[][] nArrayArray3 = new int[8][];
        int[] nArray12 = new int[8];
        nArray12[1] = 255;
        nArray12[2] = 255;
        nArray12[3] = 255;
        nArray12[4] = 255;
        nArray12[5] = 255;
        nArray12[6] = 255;
        nArray12[7] = 255;
        nArrayArray3[0] = nArray12;
        nArrayArray3[1] = new int[]{255, 1, 255, 3, 4, 5, 6, 7};
        nArrayArray3[2] = new int[]{255, 255, 2, 255, 255, 255, 255, 255};
        nArrayArray3[3] = new int[]{255, 3, 255, 3, 4, 5, 6, 7};
        nArrayArray3[4] = new int[]{255, 4, 255, 4, 4, 5, 6, 7};
        nArrayArray3[5] = new int[]{255, 5, 255, 5, 5, 5, 6, 7};
        nArrayArray3[6] = new int[]{255, 6, 255, 6, 6, 6, 6, 7};
        nArrayArray3[7] = new int[]{255, 7, 255, 7, 7, 7, 7, 7};
        cvts = nArrayArray3;
        ops = new int[][]{{255, 96, 255, 96, 96, 97, 98, 99}, {255, 100, 255, 100, 100, 101, 102, 103}, {255, 104, 255, 104, 104, 105, 106, 107}, {255, 108, 255, 108, 108, 109, 110, 111}, {255, 112, 255, 112, 112, 113, 114, 115}, {126, 126, 255, 126, 126, 127, 255, 255}, {128, 128, 255, 128, 128, 129, 255, 255}, {130, 130, 255, 130, 130, 131, 255, 255}};
        int[] nArray13 = new int[8];
        nArray13[1] = 145;
        nArray13[2] = 146;
        nArray13[3] = 147;
        norm = nArray13;
        una = new int[][]{{116, 116, 255, 116, 116, 117, 118, 119}};
        stor = new byte[]{54, 54, 54, 54, 54, 55, 56, 57, 58};
        load = new byte[]{21, 21, 21, 21, 21, 22, 23, 24, 25};
        sladdr = new byte[]{4, 4, 4, 4, 4, 5, 7, 8, 10};
    }
}

