/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright( C) 2000, 2001 Edgar Denny( e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 * ( at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <limits.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include <gnome.h>
#include <ctype.h>

#include "text_util.h"

/* Converts floating point number to a string with three numbers after
 * the decimal point. */
char * 
ftoa( float number)
{
	static char string[15];
	g_snprintf( string, 15, "%.3f", number);
	return string;
}

/* converts an integer to a string. */
char *
itoa( int number)
{
	static char string[10];
	g_snprintf( string, 10, "%d", number);
	return string;
}

/* test that all chars in a string are digits. */
int
all_digits( char *text)
{
	int i, count=0, len;

	len = strlen( text);

	if ( len == 0) return 0;

	for ( i=0; i<len; i++) if ( isdigit( text[i]) ||
			( text[i] == '.') ) count++;

	if ( count == len) return 1;
	return 0;
}

/* returns 1 if the text is of zero length. */
int
empty_text( char *text)
{
	int len = strlen( text);
	if ( len == 0) return 1;
	return 0;
}


/* See if the directory exits. If not, try to create it. */
void
gnutr_dir_test( char *pathname)
{
	struct stat buf;
	char *dir;
	int len, i;

	len = strlen( pathname);

	for ( i=1; i<=len; i++) {
		if ( pathname[i] == '/' || pathname[i] == '\0') {
			dir = g_strndup( pathname, i);

			/* get directory status, if it fails, try to create 
			 * the directory. */
			if ( stat( dir, &buf) != 0) {
				int new_dir;
				new_dir = mkdir( dir, S_IRUSR | S_IWUSR | 
					S_IXUSR);
				if ( new_dir == -1) {
					g_warning( "Error: gnutr_dir_test.");
					return;
				}
			}
			g_free( dir);
		}
	}
}
