/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright( C) 2000, 2001 Edgar Denny( e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 * ( at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <ctype.h>

#include "text_util.h"
#include "food.h"
#include "recipe.h"
#include "load_data.h"
#include "support.h"
#include "food_srch_dlg.h"
#include "food_srch_res.h"
#include "recipe_srch_dlg.h"
#include "recipe_srch_res.h"
#include "plan_add_dlg.h"
#include "wrap_mysql.h"

static GladeXML *xml = NULL;

static void load_xml( void);
static void gnutr_initialize_plan_add_dlg( void);
static void connect_signals( void);

/* callbacks. */
static void on_search_button_released( GtkButton *, gpointer);
static void on_cancel_button_released( GtkButton *, gpointer);

/* connect the signals. */
static void
connect_signals()
{
	gtk_signal_connect( GTK_OBJECT( 
		glade_xml_get_widget( xml, "cancel_button")),
		"released", GTK_SIGNAL_FUNC( on_cancel_button_released), NULL);
	gtk_signal_connect( GTK_OBJECT( 
		glade_xml_get_widget( xml, "search_button")),
		"released", GTK_SIGNAL_FUNC( on_search_button_released), NULL);
}

/* load the glade xml if not already loaded. */
static void
load_xml()
{
	static gboolean loaded_xml = FALSE;

	/* load the glade interface. */
	if ( !loaded_xml) {
		xml = glade_xml_new( GNUTRITION_GLADEDIR "/plan_add_dlg.glade",
			NULL);
		loaded_xml = TRUE;

		if ( xml) {
			connect_signals();
		} else {
			g_log( "Gnutrition", G_LOG_LEVEL_ERROR,
				"cannot load file: plan_add_dlg.glade\n");
			return;
		}
	}
}

/* initialize dialog data. */
static void
gnutr_initialize_plan_add_dlg()
{
	if ( !xml) load_xml();
}

/* show the meal food add dialog. */
void
gnutr_show_plan_add_dlg()
{
	GtkWidget *parent1;
	GtkWidget *parent2;
	GtkWidget *parent3;
	GtkWidget *child1;
	GtkWidget *child2;
	GtkWidget *child3;
		
	gnutr_initialize_plan_add_dlg();

	/* get widgets from the food search dialog and change parents
	 * to notebook pages in here. */
	parent1 = glade_xml_get_widget( xml, "food_by_txt_srch_container");
	parent2 = glade_xml_get_widget( xml, "food_by_nut_srch_container");
	parent3 = glade_xml_get_widget( xml, "recipe_srch_container");

	child3 = gnutr_get_recipe_srch_table();
	child1 = gnutr_get_food_text_srch_table();
	child2 = gnutr_get_food_nutr_srch_table();

	gtk_widget_reparent( child2, parent2);
	gtk_box_set_child_packing( GTK_BOX( parent2), child2,
			FALSE, FALSE, 0, GTK_PACK_START);
	gtk_widget_show( parent2);

	gtk_widget_reparent( child1, parent1);
	gtk_box_set_child_packing( GTK_BOX( parent1), child1,
			FALSE, FALSE, 0, GTK_PACK_START);
	gtk_widget_show( parent1);

	gtk_widget_reparent( child3, parent3);
	gtk_box_set_child_packing( GTK_BOX( parent3), child3,
			FALSE, FALSE, 0, GTK_PACK_START);
	gtk_widget_show( parent3);


	gtk_widget_show( glade_xml_get_widget( xml, "plan_add_dlg"));
}

/* the "Cancel" button is released. */
static void
on_cancel_button_released( GtkButton *button,
                           gpointer    data)
{
	gnutr_hide_plan_add_dlg();

	/* close the food search result dialog if it is visible. */
	gnutr_hide_srch_result_dialog();
}

/* the "Search" button is released. */
static void
on_search_button_released( GtkButton *button,
                           gpointer    data)
{
	GtkWidget *notebook = glade_xml_get_widget( xml, "notebook");
	gint num;
	enum { PLAN_VIEW, RECIPE_VIEW, FOOD_VIEW};

	num = gtk_notebook_get_current_page( GTK_NOTEBOOK( notebook));

	if ( num == 0) {           /* recipe search. */
		GList *list = gnutr_recipe_srch();
		/* FIXME: I need a no recipe/food found message. */
		if ( !list) return;
		gnutr_show_recipe_res_dlg( list, PLAN_VIEW);
	} else if ( num == 1) {    /* food by name search. */
		GList *list = gnutr_search_food_by_text();
		if ( !list) return;
		gnutr_show_food_srch_res_dlg( list, PLAN_VIEW);
	} else {                  /* food by nutrient search. */
		GList *list = gnutr_search_food_by_nutrient();
		if ( !list) return;
		gnutr_show_food_srch_res_dlg( list, PLAN_VIEW);
	}
}

/* Hide the dialog if it is visible. */
void
gnutr_hide_plan_add_dlg()
{
	/* reparent children to their original parents. */
	GtkWidget *parent1 = gnutr_get_food_text_srch_container();
	GtkWidget *parent2 = gnutr_get_food_nutr_srch_container();
	GtkWidget *parent3 = gnutr_get_recipe_srch_container();

	GtkWidget *child1 = gnutr_get_food_text_srch_table();
	GtkWidget *child2 = gnutr_get_food_nutr_srch_table();
	GtkWidget *child3 = gnutr_get_recipe_srch_table();

	gtk_widget_reparent( child1, parent1);
	gtk_box_set_child_packing( GTK_BOX( parent1), child1,
			FALSE, FALSE, 0, GTK_PACK_START);

	gtk_widget_reparent( child2, parent2);
	gtk_box_set_child_packing( GTK_BOX( parent2), child2,
			FALSE, FALSE, 0, GTK_PACK_START);

	gtk_widget_reparent( child3, parent3);
	gtk_box_set_child_packing( GTK_BOX( parent3), child3,
			FALSE, FALSE, 0, GTK_PACK_START);

	if ( xml) {   /* check that the interface has been loaded. */
		GtkWidget *dlg = glade_xml_get_widget( xml, "plan_add_dlg");
		if ( GTK_WIDGET_VISIBLE( dlg)) gtk_widget_hide( dlg);
	}
}
