/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.term;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.term.TermCloneContext;
import gnu.prolog.vm.TermConstants;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundTerm
extends Term {
    private static final long serialVersionUID = -8207470525318790957L;
    public final CompoundTermTag tag;
    public final Term[] args;

    public static boolean isListPair(Term term) {
        if (term instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            return ct.tag == TermConstants.listTag;
        }
        return false;
    }

    public static CompoundTerm getList(Term head, Term tail) {
        return new CompoundTerm(TermConstants.listTag, head, tail);
    }

    public static Term getList(Term[] list) {
        Term tlist = TermConstants.emptyListAtom;
        int i = list.length - 1;
        while (i >= 0) {
            tlist = CompoundTerm.getList(list[i], tlist);
            --i;
        }
        return tlist;
    }

    public static Term getList(List<Term> list) {
        Term tlist = TermConstants.emptyListAtom;
        int i = list.size() - 1;
        while (i >= 0) {
            tlist = CompoundTerm.getList(list.get(i), tlist);
            --i;
        }
        return tlist;
    }

    public static boolean toCollection(Term term, Collection<Term> col) {
        if ((term = term.dereference()) instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            int i = ct.tag.arity - 1;
            while (i >= 0) {
                if (!CompoundTerm.toCollection(ct.args[i], col)) {
                    return false;
                }
                --i;
            }
        } else if (!TermConstants.emptyListAtom.equals(term)) {
            col.add(term);
        }
        return true;
    }

    public static CompoundTerm getConjunction(Term head, Term tail) {
        return new CompoundTerm(TermConstants.conjunctionTag, head, tail);
    }

    public static CompoundTerm getDisjunction(Term head, Term tail) {
        return new CompoundTerm(TermConstants.disjunctionTag, head, tail);
    }

    public CompoundTerm(CompoundTermTag tg, Term arg1) {
        this(tg, new Term[]{arg1});
    }

    public CompoundTerm(CompoundTermTag tg, Term arg1, Term arg2) {
        this(tg, new Term[]{arg1, arg2});
    }

    public CompoundTerm(CompoundTermTag tg, Term arg1, Term arg2, Term arg3) {
        this(tg, new Term[]{arg1, arg2, arg3});
    }

    public CompoundTerm(String functor, int arity) {
        this(AtomTerm.get(functor), arity);
    }

    public CompoundTerm(AtomTerm functor, int arity) {
        this(CompoundTermTag.get(functor, arity));
    }

    public CompoundTerm(AtomTerm functor, Term[] args) {
        this(CompoundTermTag.get(functor, args.length), args);
    }

    public CompoundTerm(String functor, Term[] args) {
        this(CompoundTermTag.get(functor, args.length), args);
    }

    public CompoundTerm(CompoundTermTag tag) {
        this.tag = tag;
        this.args = new Term[tag.arity];
    }

    public CompoundTerm(CompoundTermTag tag, Term[] args) {
        this.tag = tag;
        this.args = (Term[])args.clone();
    }

    @Override
    public Term clone(TermCloneContext context) {
        CompoundTerm term = (CompoundTerm)context.getTerm(this);
        if (term == null) {
            term = new CompoundTerm(this.tag);
            context.putTerm(this, term);
            int i = 0;
            while (i < this.args.length) {
                if (this.args[i] != null) {
                    term.args[i] = this.args[i].clone(context);
                }
                ++i;
            }
        }
        return term;
    }

    @Override
    public int getTermType() {
        return 6;
    }
}

