/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gnunet.construct.DoubleValue;
import org.gnunet.construct.FillWith;
import org.gnunet.construct.FixedSizeArray;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.FrameSize;
import org.gnunet.construct.Int16;
import org.gnunet.construct.Int32;
import org.gnunet.construct.Int64;
import org.gnunet.construct.Int8;
import org.gnunet.construct.IntegerFill;
import org.gnunet.construct.Message;
import org.gnunet.construct.NestedMessage;
import org.gnunet.construct.ProtocolViolationException;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.UInt16;
import org.gnunet.construct.UInt32;
import org.gnunet.construct.UInt64;
import org.gnunet.construct.UInt8;
import org.gnunet.construct.Union;
import org.gnunet.construct.VariableSizeArray;
import org.gnunet.construct.VariableSizeIntegerArray;
import org.gnunet.construct.VariableSizeString;
import org.gnunet.construct.ZeroTerminatedString;
import org.gnunet.construct.parsers.DoubleParser;
import org.gnunet.construct.parsers.FillParser;
import org.gnunet.construct.parsers.FixedSizeArrayParser;
import org.gnunet.construct.parsers.FixedSizeIntegerArrayParser;
import org.gnunet.construct.parsers.IntegerFillParser;
import org.gnunet.construct.parsers.IntegerParser;
import org.gnunet.construct.parsers.NestedParser;
import org.gnunet.construct.parsers.Parser;
import org.gnunet.construct.parsers.SequenceParser;
import org.gnunet.construct.parsers.StringParser;
import org.gnunet.construct.parsers.UnionParser;
import org.gnunet.construct.parsers.VariableSizeArrayParser;
import org.gnunet.construct.parsers.VariableSizeIntegerArrayParser;
import org.gnunet.construct.parsers.VariableSizeStringParser;
import org.grothoff.Runabout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Construct {
    private static final Logger logger = LoggerFactory.getLogger(Construct.class);
    private static Map<Class<? extends Message>, Parser> parserCache = new HashMap<Class<? extends Message>, Parser>(100);

    private Construct() {
    }

    public static <T extends Message> T parseAs(ByteBuffer srcBuf, Class<T> c) {
        try {
            Message m = (Message)ReflectUtil.justInstantiate(c);
            try {
                Construct.getParser(c).parse(srcBuf, 0, m, m, null);
            }
            catch (ProtocolViolationException e) {
                e.augmentPath("on " + c);
            }
            return (T)m;
        }
        catch (Error e) {
            System.err.println(String.format("Exception while parsing message for class '%s':", c.getCanonicalName()));
            throw e;
        }
    }

    public static <T extends Message> T parseAs(byte[] srcBuf, Class<T> c) {
        return Construct.parseAs(ByteBuffer.wrap(srcBuf), c);
    }

    public static Parser getParser(Class<? extends Message> c) {
        if (parserCache.containsKey(c)) {
            return parserCache.get(c);
        }
        Parser p = Construct.getParser(c, new ParserGenerator());
        parserCache.put(c, p);
        return p;
    }

    private static List<Field> getMessageFields(Class c) {
        LinkedList<Field> fields = new LinkedList<Field>(Arrays.asList(c.getDeclaredFields()));
        while ((c = c.getSuperclass()) != null && Message.class.isAssignableFrom(c)) {
            fields.addAll(0, Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    private static Parser getParser(Class<? extends Message> c, ParserGenerator pg) {
        Preconditions.checkNotNull(c);
        SequenceParser parser = new SequenceParser();
        if (!Modifier.isPublic(c.getModifiers())) {
            throw new AssertionError((Object)String.format("Construct Message %s not declared public", c));
        }
        for (Field f : Construct.getMessageFields(c)) {
            pg.c = c;
            Annotation[] as = f.getAnnotations();
            if (as.length == 0 || f.isSynthetic() || Modifier.isStatic(f.getModifiers())) continue;
            if (!Modifier.isPublic(f.getModifiers())) {
                throw new AssertionError((Object)String.format("Field %s of Message %s not declared public", f, c));
            }
            pg.field = f;
            pg.annotations = as;
            pg.annotationsIdx = 0;
            pg.visitAppropriate(as[0]);
            parser.add(pg.parser);
        }
        parser.setFrameSizePath(pg.frameSizePath);
        return parser;
    }

    public static int write(ByteBuffer dstBuf, Message msg) {
        Parser p = Construct.getParser(msg.getClass());
        return p.write(dstBuf, msg);
    }

    public static int getSize(Message m) {
        if (m == null) {
            return 0;
        }
        Parser p = Construct.getParser(m.getClass());
        return p.getSize(m);
    }

    public static byte[] toBinary(Message m) {
        byte[] a = new byte[Construct.getSize(m)];
        ByteBuffer buf = ByteBuffer.wrap(a);
        Construct.write(buf, m);
        return a;
    }

    public static void patch(Message m) {
        Parser p = Construct.getParser(m.getClass());
        p.patch(m, p.getSize(m), null, m);
    }

    public static int getStaticSize(Message m) {
        Parser p = Construct.getParser(m.getClass());
        return p.getStaticSize();
    }

    private static class FillWithParserRunabout
    extends Runabout {
        public Parser p;
        private Field f;

        public FillWithParserRunabout(Field f) {
            this.f = f;
        }

        public void visit(Int8 x) {
            this.p = new IntegerFillParser(this.f, true, 1);
        }

        public void visit(Int16 x) {
            this.p = new IntegerFillParser(this.f, true, 2);
        }

        public void visit(Int32 x) {
            this.p = new IntegerFillParser(this.f, true, 4);
        }

        public void visit(UInt8 x) {
            this.p = new IntegerFillParser(this.f, false, 1);
        }

        public void visit(UInt16 x) {
            this.p = new IntegerFillParser(this.f, false, 2);
        }

        public void visit(UInt32 x) {
            this.p = new IntegerFillParser(this.f, false, 4);
        }

        public void visit(NestedMessage n) {
            Parser componentParser = Construct.getParser(this.f.getType().getComponentType());
            this.p = new FillParser(componentParser, this.f);
        }
    }

    static class ParserGenerator
    extends Runabout {
        Field field;
        Annotation[] annotations;
        int annotationsIdx;
        Class c;
        Parser parser;
        List<Field> path = new LinkedList<Field>();
        List<Field> frameSizePath;

        private ParserGenerator() {
        }

        public void visit(Union u) {
            this.parser = new UnionParser(u.optional(), this.field.getType(), ReflectUtil.getFieldPathFromString(u.tag(), this.c), this.field);
        }

        public void visit(FrameSize ts) {
            this.frameSizePath = new LinkedList<Field>(this.path);
            this.frameSizePath.add(this.field);
            if (this.annotationsIdx != 0) {
                throw new AssertionError((Object)"FrameSize must be the first annotation on a Field");
            }
            ++this.annotationsIdx;
            if (this.annotationsIdx >= this.annotations.length) {
                throw new AssertionError((Object)"FrameSize must be followed by an numeric parser");
            }
            this.visitAppropriate(this.annotations[this.annotationsIdx]);
        }

        public void visit(UInt8 i) {
            this.parser = new IntegerParser(1, false, this.field);
        }

        public void visit(UInt16 i) {
            this.parser = new IntegerParser(2, false, this.field);
        }

        public void visit(UInt32 i) {
            this.parser = new IntegerParser(4, false, this.field);
        }

        public void visit(UInt64 i) {
            this.parser = new IntegerParser(8, false, this.field);
        }

        public void visit(Int8 i) {
            this.parser = new IntegerParser(1, true, this.field);
        }

        public void visit(Int16 i) {
            this.parser = new IntegerParser(2, true, this.field);
        }

        public void visit(Int32 i) {
            this.parser = new IntegerParser(4, true, this.field);
        }

        public void visit(Int64 i) {
            this.parser = new IntegerParser(8, true, this.field);
        }

        public void visit(ZeroTerminatedString zts) {
            this.parser = new StringParser(zts.charset(), zts.optional(), this.field);
        }

        public void visit(IntegerFill i) {
            this.parser = new IntegerFillParser(this.field, i.signed(), i.bitSize() / 8);
        }

        public void visit(NestedMessage n) {
            if (!Message.class.isAssignableFrom(this.field.getType())) {
                throw new AssertionError((Object)("@NestedMessage only works on messages, " + this.field.getType() + " is not a message (origin: " + this.c + ")"));
            }
            Field nestedField = this.field;
            if (n.newFrame()) {
                Parser p = Construct.getParser(nestedField.getType());
                this.parser = new NestedParser(p, n.optional(), nestedField, true);
            } else {
                Field oldField = this.field;
                ArrayList<Field> oldPath = new ArrayList<Field>(this.path);
                Class oldClass = this.c;
                this.path.add(this.field);
                Parser p = Construct.getParser(nestedField.getType(), this);
                this.path = oldPath;
                this.c = oldClass;
                this.parser = new NestedParser(p, n.optional(), oldField, false);
            }
        }

        public void visit(FixedSizeArray fsa) {
            Field f = this.field;
            int elemNumber = fsa.length();
            Construct.getParser(this.field.getType().getComponentType(), this);
            this.parser = new FixedSizeArrayParser(elemNumber, this.parser, f);
        }

        public void visit(FixedSizeIntegerArray fsa) {
            Field f = this.field;
            int elemNumber = fsa.length();
            this.parser = new FixedSizeIntegerArrayParser(elemNumber, fsa.signed(), fsa.bitSize() / 8, f);
        }

        public void visit(DoubleValue d) {
            if (!this.field.getType().equals(Double.TYPE)) {
                throw new AssertionError((Object)"@DoubleValue target must be a primitive 'double' field");
            }
            this.parser = new DoubleParser(this.field);
        }

        public void visit(FillWith fw) {
            ++this.annotationsIdx;
            if (this.annotationsIdx >= this.annotations.length) {
                Parser p = Construct.getParser(this.field.getType().getComponentType());
                this.parser = new FillParser(p, this.field);
            } else {
                FillWithParserRunabout r = new FillWithParserRunabout(this.field);
                r.visitAppropriate(this.annotations[this.annotationsIdx]);
                if (r.p == null) {
                    throw new AssertionError();
                }
                this.parser = r.p;
            }
        }

        public void visit(VariableSizeArray vsa) {
            Parser p = Construct.getParser(this.field.getType().getComponentType());
            if (!Message.class.isAssignableFrom(this.field.getType().getComponentType())) {
                throw new AssertionError((Object)"VariableSizeArray only valid on arrays of messages.");
            }
            try {
                this.parser = new VariableSizeArrayParser(p, this.c.getField(vsa.lengthField()), this.field);
            }
            catch (SecurityException e) {
                throw new AssertionError((Object)String.format("VariableSizeArray: length field '%s' not declared public", vsa.lengthField()));
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)String.format("VariableSizeArray: length field '%s' does not exist in class %s", vsa.lengthField(), this.c));
            }
        }

        public void visit(VariableSizeString vss) {
            try {
                this.parser = new VariableSizeStringParser(vss.terminationType(), this.c.getField(vss.lengthField()), this.field);
            }
            catch (SecurityException e) {
                throw new AssertionError((Object)String.format("VariableSizeString: length field '%s' not declared public", vss.lengthField()));
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)String.format("VariableSizeString: length field '%s' does not exist in class %s", vss.lengthField(), this.c));
            }
        }

        public void visit(VariableSizeIntegerArray a) {
            try {
                this.parser = new VariableSizeIntegerArrayParser(this.c.getField(a.lengthField()), this.field, a.signed(), a.bitSize() / 8);
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)String.format("VariableSizeIntegerArray: length field '%s' does not exist in class %s", a.lengthField(), this.c));
            }
        }

        @Override
        public void visitDefault(Object obj) {
            if (obj instanceof Annotation) {
                Annotation ann = (Annotation)obj;
                throw new AssertionError((Object)("invalid Construct annotation: " + ann.annotationType().getName()));
            }
            throw new AssertionError();
        }
    }
}

