.\" Copyright (c) 2000 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH gnatsd 8 "November 2002" "GNATS @VERSION@" "GNATS Admininstration Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
gnatsd \- GNATS network server
.SH SYNOPSIS
.hy 0
.na
.TP
.B gnatsd
[\fB\-\-database\fR\ \fIdatabase\fR\ |\ \fB\-d\fR\ \fIdatabase\fR]
[\fB\-\-not\-inetd\fR\ |\ \fB\-n\fR]
[\fB\-\-max-access-level\fR\ \fIlevel\fR\ |\ \fB\-m\fR\ \fIlevel\fR]
[\fB\-\-version\fR\ |\ \fB\-V\fR]
[\fB\-\-help\fR\ |\ \fB\-h\fR]
.ad b
.hy 1
.SH DESCRIPTION
\fBgnatsd\fR is used to service remote GNATS requests such as querying
\fIPR\fRs, \fIPR\fR creation, deletion, and editing, and miscellaneous
database queries.  It uses a simple ASCII-based command protocol
(similar to SMTP or POP3) for communicating with remote clients. 
.P
It also provides a security model based either on IP-based
authentication (generally a \fBterrible\fR idea) or
username/passwords.  Passwords may be encrypted using UNIX crypt() or
MD5 (for operating systems that support it).  Plaintext passwords are
also supported but strongly discouraged.
.P
All of the GNATS clients are capable of communicating via the GNATS
remote protocol to perform their functions.
.P
\fBgnatsd\fR should be run by the GNATS user (by default \fBgnats\fR),
and it is usually started from \fIinetd\fR(8).
.SH OPTIONS
.TP 0.5i
.B \-V\fR,\fB \-\-version
Prints the program version to stdout and exits.
.TP 0.5i
.B \-h\fR,\fB \-\-help
Prints a short help text to stdout and exits.
.TP 0.5i
.B \-d\fR,\fB \-\-database
Specifies the default database which is to be serviced by this
invocation of \fBgnatsd\fR.  (The selected database may be changed via
the \fBCHDB\fR command; this is simply the default if no \fBCHDB\fR
command is issued.)  If no database is specified, the database named
\fIdefault\fR is assumed.  This option overrides the database
specified in the \fBGNATSDB\fR environment variable.
.TP 0.5i
\fB\-\-not\-inetd\fR,\ \fB\-n\fR
As its name suggests, indicates that \fBgnatsd\fR is not being invoked
from \fIinetd\fR.  This can be used when testing \fBgnatsd\fR, or if
it being run via \fIssh\fR or some other mechanism.
.P
.RS 0.5i
This has the effect of using the local hostname where \fBgnatsd\fR is
being invoked for authentication purposes, rather than the remote
address of the connecting client.
.RE
.TP 0.5i
\fB\-\-max-access-level\fR,\ \fB\-m\fR
Specifies the maximum access level that the connecting client can
authenticate to. Authentication is as normal but if the user or host
authenticates at a higher level, access level is set to this level.
.SH COMMAND PROTOCOL
Commands are issued to \fBgnatsd\fR as one or more words followed by a
carriage-return/linefeed pair.  For example, the \fBCHDB\fR (change
databases) command is sent as
.RS
CHDB \fIdatabase\fR<CR><LF>
.RE
[the CRLF will not be explicitly written for future examples]
.P
Replies from \fBgnatsd\fR are returned as one or more \fIresponse line\fRs
containing a 3-digit numeric code followed by a human-readable string;
the line is terminated with a <CR><LF> pair.  For example, one possible
response to the \fBCHDB\fR command above would be:
.RS
210 Now accessing GNATS database 'database'.
.RE
.P
The three-digit code is normally followed by a single ASCII space
(character 0x20).  However, if additional response lines are to be
returned from the server, there will be a single dash (`-') instead of
the space character after the three-digit code.
.P
Response code values are divided into ranges.  The first digit
reflects the general type of response (such as "successful" or
"error"), and the subsequent digits identify the specific type of
response.
.TP
Codes 200-299
Positive response indicating that the command was successful.  No
subsequent data will be transmitted with the response.  [In
particular, code 210 (\fBCODE_OK\fR) is used as the positive result
code for most simple commands.]
.RS
.P
Commands that expect additional data from the client (such as
\fBSUBM\fR or \fBVFLD\fR) use a two-step mechanism for sending the
data.  The server will respond to the initial command with either a
211 (\fBCODE_SEND_PR\fR) or 212 (\fBCODE_SEND_TEXT\fR) response line,
or an error code if an error occurred with the initial command.  The
client is then expected to send the remaining data using the same
quoting mechanism as described for server responses in the 300-349
range.  The server will then send a final response line to the
command.
.RE
.TP
Codes 300-399
Positive response indicating that the query request was successful,
and that a \fIPR\fR or other data will follow.  Codes 300-349 are used
when transmitting \fIPR\fRs, and 350-399 are used for other responses.
.P
.RS
Codes in the 300-349 range are followed by a series of CRLF-terminated
lines containing the command response, usually a \fIPR\fR.  The final
line of the result is a single period (`.').  Result lines that begin
with a period have an extra period prepended to them.
.P
Codes in the 350-399 range use a different scheme for sending their
responses.  The three-digit numeric code will be followed by either a
dash (`-') or a single space.  If the code is followed by a dash, that
indicates that another response line will follow.  The final line of
the response has a single space after the three-digit code.
.P
In previous versions of the protocol the first line of a
CODE_INFORMATION (310) response was to be ignored.  This is no longer
the case.  Instead, any lines marked with code CODE_INFORMATION_FILLER
(351) are to be ignored.  This allows the server to transmit
additional headers or other human-readable text that can be safely
ignored by the clients.
.RE
.TP
Codes 400-599 
An error occurred, usually because of invalid command parameters or
invalid input from the client, missing arguments to the comamand, or a
command was issued out of sequence.  The human-readable message
associated with the response line describes the general problem
encountered with the command.
.P
.RS
Multiple error messages may be returned from a command; in this case
the `-' continuation character is used on all but the last response
line.
.RE
.TP
Codes 600-799
An internal error occurred on the server, a timeout occurred reading
data from the client, or a network failure occurred.  These errors are
of the "this should not occur" nature, and retrying the operation may
resolve the problem.  Fortunately, most GNATS transactions are
idempotent; unfortunately, locking the database or a \fIPR\fR are not
repeatable actions (we cannot determine if an existing lock is the one
we originally requested, or someone else's).
.SH COMMANDS
Note that the set of GNATS commands and their responses is somewhat
inconsistent and is very much in flux.  At present the GNATS clients
are rather simple-minded and not very strict about processing
responses.  For example, if the server were to issue a code 300
(\fBCODE_PR_READY\fR) response to a \fBCHDB\fR command, the client
would happily expect to see a PR appear (and would print it out if one
was sent).
.P
It is thus suggested that any clients that use the GNATS protocol be
equally flexible about the way received responses are handled; in
particular, only the first digit of the response code should be
assumed to be meaningful, although subsequent digits are needed in
some cases (codes 300-399). \fBNo attempt should be made to parse the
message strings on error response lines; they are only intended to be
read by humans, and will be changed on a regular basis.\fR
.P
Almost every command may result in the response 440 (\fBCODE_CMD_ERROR\fR).
This indicates that there was a problem with the command arguments,
usually because of insufficient or too many arguments being specified.
.TP 0.5i
\fBUSER\fR [<\fIuserid\fR> [<\fIpassword\fR>]]
Specifies the userid and password for database access.  Both a
username and a password may be given, only a username may be given, or
both may be omitted; if both are omitted, the current access level is
returned.
.RS 0.5i
.P
The possible server responses are:
.TP
350 (\fBCODE_INFORMATION\fR)
The current access level is specified.
.TP
422 (\fBCODE_NO_ACCESS\fR)
A matching username and password could not be found.
.TP
200 (\fBCODE_OK\fR)
A matching username and password was found, and the login was
successful.
.RE
.TP 0.5i
\fBQUIT\fR
Requests that the connection be closed.  Possible responses:
.RS 0.5i
.TP
201 (\fBCODE_CLOSING\fR)
Normal exit.
.P
The quit command has the dubious distinction of being the only command
that cannot fail.
.RE
.TP 0.5i
\fBLIST\fR <\fIlist\ type\fR>
Describes various aspects of the database.  The lists are returned as
a list of records, one per line.  Each line may contain a number of
colon-separated fields.
.P
.RS 0.5i
Possible values for \fIlist type\fR include
.RS 0.25i
.TP
\fBCategories\fR
Describes the legal categories for the database.
.TP
\fBSubmitters\fR
Describes the set of submitters for the database.
.TP
\fBResponsible\fR
Lists the names in the responsible administrative file, including their
full names and email addresses.
.TP
\fBStates\fR
Lists the states listed in the state administrative file, including
the state type (usually blank for most states; the closed state has a
special type).
.TP
\fBFieldNames\fR
Lists the entire set of PR fields.
.TP
\fBInitialInputFields\fR
Lists the fields that should be present when a PR is initially entered.
.TP
\fBInitialRequiredFields\fR
Lists fields that have to be present and nonempty when a PR is
initially entered (fields containing only blank characters such as
spaces or newlines are considered empty.)
.TP
\fBDatabases\fR
Lists the set of databases.
.RE
.P
The possible responses are:
.TP
301 (\fBCODE_TEXT_READY\fR)
Normal response, followed by the records making up the list as described
above.
.TP
416 (\fBCODE_INVALID_LIST\fR)
The requested list does not exist.
.RE
.TP 0.5i
\fBFTYP\fR <\fIfield\fR> [<\fIfield\fR> ...]
Describes the type of data held in the field(s) specified with the
command.  The currently-defined data types are:
.RS 0.5i
.TP
Text
A plain text field, containing exactly one line.
.TP
MultiText
A text field possibly containing multiple lines of text.
.TP
Enum
An enumerated data field; the value is restricted to one entry out of
a list of values associated with the field.
.TP
MultiEnum
The field contains one or more enumerated values.  Values are separated
with spaces or colons (\fB:\fR).
.TP
Integer
The field contains an integer value, possibly signed.
.TP
Date
The field contains a date.
.TP
TextWithRegex
The value in the field must match one or more regular expressions associated
with the field.
.P
The possible responses are:
.TP
350 (\fBCODE_INFORMATION\fR)
The normal response; the supplied text is the data type.
.TP
410 (\fBCODE_INVALID_FIELD_NAME\fR)
The specified field does not exist.
.P
If multiple field names were given, multiple response lines will be sent,
one for each field, using the standard continuation protocol; each response
except the last will have a dash (`-') immedately after the response
code.
.RE
.TP
\fBFTYPINFO\fR <\fIfield\fR> <\fIproperty\fR>
Provides field-type-related information.  Currently, only the property
`separators' for MultiEnum fields is supported.  When `separators' is
specified, the possible return codes are:
.RS 0.5i
.TP
350 (\fBCODE_INFORMATION\fR)
A proper MultiEnum field was specified and the returned text is the
string of separators specified for the field in the dbconfig file,
quoted within ''.
.TP
435 (\fBCODE_INVALID_FTYPE_PROPERTY\fR)
The `separators' property is not defined for this field, i.e. the
specified field is not of type MultiEnum.
.P
Currently, specifying a different property than `separators' results
in return code 435 as above.
.RE
.TP
\fBFDSC\fR <\fIfield\fR> [<\fIfield\fR> ... ]
Returns a human-readable description of the listed field(s).  The possible
responses are:
.RS 0.5i
.TP
350 (\fBCODE_INFORMATION\fR)
The normal response; the supplied text is the field description.
.TP
410 (\fBCODE_INVALID_FIELD_NAME\fR)
The specified field does not exist.
.P
Like the \fBFVLD\fR command, the standard continuation protocol will
be used if multiple fields were specified with the command.
.RE
.TP
\fBFIELDFLAGS\fR <\fIfield\fR> [<\fIfield\fR> ... ]
Returns a set of flags describing the specified field(s).  The possible
responses are either 410\ (\fBCODE_INVALID_FIELD_NAME\fR), meaning that
the specified field is invalid or nonexistent, or 350\ (\fBCODE_INFORMATION\fR)
which contains the set of flags for the field.  The flags may be blank,
which indicate that no special flags have been set for this field.
.RS 0.5i
.P
Like the \fBFDSC\fR and \fBFTYP\fR commands, multiple field names may be
listed with the command, and a response line will be returned for
each one in the order that the fields appear on the command line.
.P
The flags include:
.TP
\fItextsearch\fR
The field will be searched when a text field search is requested.
.TP
\fIallowAnyValue\fR
For fields that contain enumerated values, any legal value may be used in 
the field, not just ones that appear in the enumerated list.
.TP
\fIrequireChangeReason\fR
If the field is edited, a reason for the change must be supplied in
the new \fIPR\fR text describing the reason for the change.  The
reason must be supplied as a multitext \fIPR\fR field in the new
\fIPR\fR whose name is \fIfield\fR-Changed-Why (where \fIfield\fR is
the name of the field being edited).
.TP
\fIreadonly\fR
The field is read-only, and cannot be edited.
.RE
.TP
\fBFVLD\fR <\fIfield\fR>
Returns one or more regular expressions or strings that describe the
valid types of data that can be placed in \fIfield\fR.  Exactly what is
returned is dependent on the type of data that can be stored in the field.
For most fields a regular expression is returned; for enumerated fields, the
returned values are the list of legal strings that can be held in the
field.
.P
.RS 0.5i
The possible responses are:
.TP
301 (\fBCODE_TEXT_READY\fR)
The normal response, which is followed by the list of regexps or strings.
.TP
410 (\fBCODE_INVALID_FIELD_NAME\fR)
The specified field does not exist.
.RE
.TP 0.5i
\fBVFLD\fR <\fIfield\fR>
\fBVFLD\fR can be used to validate a given value for a field in the
database.  The client issues the \fBVFLD\fR command with the name of
the field to validate as an argument.  The server will either respond
with 212 (\fBCODE_SEND_TEXT\fR), or 410
(\fBCODE_INVALID_FIELD_NAME\fR) if the specified field does not exist.
.P
.RS 0.5i
Once the 212 response is received from the server, the client should
then send the line(s) of text to be validated, using the normal quoting
mechanism described for \fIPR\fRs.  The final line of text is followed
by a line containing a single period, again as when sending \fIPR\fR
text.
.P
The server will then either respond with 210 (\fBCODE_OK\fR), indicating that
the text is acceptable, or one or more error codes describing the problems
with the field contents.
.RE
.TP 0.5i
\fBINPUTDEFAULT\fR <\fIfield\fR> [<\fIfield\fR> ... ]
Returns the suggested default value for a field when a \fIPR\fR is
initially created.  The possible responses are either 410\
(\fBCODE_INVALID_FIELD_NAME\fR), meaning that the specified field is
invalid or nonexistent, or 350\ (\fBCODE_INFORMATION\fR) which
contains the default value for the field.
.RS 0.5i
.P
Like the \fBFDSC\fR and \fBFTYP\fR commands, multiple field names may be
listed with the command, and a response line will be returned for
each one in the order that the fields appear on the command line.
.RE
.TP 0.5i
\fBRSET\fR
Used to reset the internal server state.  The current query expression is
cleared, and the index of PRs may be reread if it has been updated since the
start of the session.
.RS 0.5i
The possible responses are:
.TP
200 (\fBCODE_OK\fR)
The state has been reset.
.TP
440 (\fBCODE_CMD_ERROR\fR)
One or more arguments were supplied to the command.
.TP
6xx (\fIinternal error\fR)
There were problems resetting the state (usually because the index
could not be reread).  The session will be immediately terminated.
.RE
.TP
\fBLKDB\fR
Locks the main GNATS database.  No subsequent database locks will
succeed until the lock is removed.  Sessions that attempt to write to
the database will fail.
.RS 0.5i
The possible responses are:
.TP
200 (\fBCODE_OK\fR)
The lock has been established.
.TP
440 (\fBCODE_CMD_ERROR\fR)
One or more arguments were supplied to the command.
.TP
431 (\fBCODE_GNATS_LOCKED\fR)
The database is already locked, and the lock could not be obtained after
10 seconds.
.TP
6xx (\fIinternal error\fR)
An internal error occurred, usually because of permission or other
filesystem-related problems.  The lock may or may not have been
established.
.RE
.TP
\fBUNDB\fR
Unlocks the database.  Any session may steal a database lock; no
checking of any sort is done.
.RS 0.5i
The possible responses are:
.TP
200 (\fBCODE_OK\fR)
The lock has been removed.
.TP
432 (\fBCODE_GNATS_NOT_LOCKED\fR)
The database was not locked.
.TP
440 (\fBCODE_CMD_ERROR\fR)
One or more arguments were supplied to the command.
.TP
6xx (\fIinternal error\fR)
The database lock could not be removed, usually because of permissions or
other filesystem-related issues.
.RE
.TP
\fBLOCK\fR <\fIPR\fR> <\fIuser\fR> [<\fIpid\fR>]
Locks the specified \fIPR\fR, marking the lock with the name
\fIuser\fR and the optional \fIpid\fR.  (No checking is done that the
\fIuser\fR or \fIpid\fR arguments are valid or meaningful; they are
simply treated as strings.)
.RS 0.5i
.P
The \fBEDIT\fR command requires that the \fIPR\fR be locked before it
may be successfully executed.  However, it does not require that the
lock is owned by the editing session, so the usefulness of the lock is
simply as an advisory measure.
.P
The \fBAPPN\fR and \fBREPL\fR commands lock the \fIPR\fR as part of
the editing process, and they do not require that the \fIPR\fR be
locked \fIbefore\fR they are invoked.
.P
The possible responses are:
.TP
440 (\fBCODE_CMD_ERROR\fR)
Insufficient or too many arguments were specified to the command.
.TP
300 (\fBCODE_PR_READY\fR)
The lock was successfully obtained; the text of the \fIPR\fR (using
the standard quoting mechanism for \fIPR\fRs) follows.
.TP
400 (\fBCODE_NONEXISTENT_PR\fR)
The \fIPR\fR specified does not exist.
.TP
430 (\fBCODE_LOCKED_PR\fR)
The \fIPR\fR is already locked by another session.
.TP
6xx (\fIinternal error\fR)
The \fIPR\fR lock could not be created, usually because of permissions or
other filesystem-related issues.
.RE
.TP
\fBUNLK\fR <\fIPR\fR>
Unlocks \fIPR\fR.  Any user may unlock a \fIPR\fR, as no checking is done
to determine if the requesting session owns the lock.
.RS 0.5i
.P
The possible responses are:
.TP
440 (\fBCODE_CMD_ERROR\fR)
Insufficient or too many arguments were specified to the command.
.TP
200 (\fBCODE_OK\fR)
The \fIPR\fR was successfully unlocked.
.TP
433 (\fBCODE_PR_NOT_LOCKED\fR)
The \fIPR\fR was not locked.
.TP
6xx (\fIinternal error\fR)
The \fIPR\fR could not be unlocked, usually because of permission or
other filesystem-related problems.
.RE
.TP
\fBDELETE\fR <\fIPR\fR>
Deletes the specified \fIPR\fR.  The user making the request must have
\fIadmin\fR privileges.  If successful, the \fIPR\fR is removed from the
filesystem and the index file; a gap will be left in the numbering sequence
for \fIPR\fRs.  No checks are made that the \fIPR\fR is closed.
.RS 0.5i
.P
The possible responses are:
.TP
200 (\fBCODE_OK\fR)
The \fIPR\fR was successfully deleted.
.TP
422 (\fBCODE_NO_ACCESS\fR)
The user requesting the delete does not have \fIadmin\fR privileges.
.TP
430 (\fBCODE_LOCKED_PR\fR)
The \fIPR\fR is locked by another session.
.TP
431 (\fBCODE_GNATS_LOCKED\fR)
The database has been locked, and no \fIPR\fRs may be updated until the
lock is cleared.
.TP
6xx (\fIinternal error\fR)
The \fIPR\fR could not be successfully deleted, usually because of
permission or other filesystem-related problems.
.RE
.TP
\fBCHEK\fR [initial]
Used to check the text of an entire \fIPR\fR for errors.  Unlike the
\fBVFLD\fR command, it accepts an entire \fIPR\fR at once instead of
the contents of an individual field.
.RS 0.5i
.P
The \fIinitial\fR argument indicates that the PR text to be checked is
for a \fIPR\fR that will be newly created, rather than an edit or 
replacement of an existing PR.
.P
After the \fBCHEK\fR command is issued, the server will respond with either a
440 (\fBCODE_CMD_ERROR\fR) response indicating that the command
arguments were incorrect, or a 211 (\fBCODE_SEND_PR\fR) response code will
be sent.
.P
Once the 211 response is received from the server, the client should send
the \fIPR\fR using the normal \fIPR\fR quoting mechanism; the final line of
the \fIPR\fR is then followed by a line containing a single period, as usual.
.P
The server will then respond with either a 200 (\fBCODE_OK\fR)
response, indicating there were no problems with the supplied text, or
one or more error codes listing the problems with the \fIPR\fR.
.RE
.TP
\fBEDIT\fR <\fIPR\fR>
Verifies the replacement text for \fIPR\fR.  If the command is successful, the
contents of \fIPR\fR are completely replaced with the supplied text.
\fIPR\fR must previously have been locked with the \fBLOCK\fR command.
.RS 0.5i
.P
The possible responses are:
.TP
431 (\fBCODE_GNATS_LOCKED\fR)
The database has been locked, and no \fIPR\fRs may be updated until the
lock is cleared.
.TP
433 (\fBCODE_PR_NOT_LOCKED\fR)
The \fIPR\fR was not previously locked with the \fBLOCK\fR command.
.TP
400 (\fBCODE_NONEXISTENT_PR\fR)
The specified \fIPR\fR does not currently exist.  The \fBSUBM\fR command
should be used to create new \fIPR\fRs.
.TP
211 (\fBCODE_SEND_PR\fR)
The client should now transmit the replacement \fIPR\fR text using the
normal \fIPR\fR quoting mechanism.  After the \fIPR\fR has been sent,
the server will respond with either a 200 (\fBCODE_OK\fR) response
indicating the edit was successful, or one or more error codes
listing problems with either with the replacement \fIPR\fR text, or
errors encountered while updating the \fIPR\fR file or index.
.RE
.TP
\fBAPPN\fR <\fIPR\fR> <\fIfield\fR>
.TP
\fBREPL\fR <\fIPR\fR> <\fIfield\fR>
Appends to or replaces the contents of \fIfield\fR in \fIPR\fR with
the supplied text.  The command returns a 201\ (\fBCODE_SEND_TEXT\fR)
response; the client should then transmit the new field contents using
the standard \fIPR\fR quoting mechanism.  After the server has read
the new contents, it then attempts to make the requested change to the
\fIPR\fR.
.RS 0.5i
.P
The possible responses are:
.TP
200 (\fBCODE_OK\fR)
The \fIPR\fR field was successfully changed.
.TP
400 (\fBCODE_NONEXISTENT_PR\fR)
The \fIPR\fR specified does not exist.
.TP
410 (\fBCODE_INVALID_FIELD_NAME\fR)
The specified field does not exist.
.TP
402 (\fBCODE_UNREADABLE_PR\fR)
The \fIPR\fR could not be read.
.TP
431 (\fBCODE_GNATS_LOCKED\fR)
The database has been locked, and no \fIPR\fRs may be updated until the
lock is cleared.
.TP
430 (\fBCODE_LOCKED_PR\fR)
The \fIPR\fR is locked, and may not be altered until the lock is cleared.
.TP
413 (\fBCODE_INVALID_FIELD_CONTENTS\fR)
The supplied (or resulting) field contents are not valid for the field.
.TP
6xx (\fIinternal error\fR)
An internal error occurred, usually because of permission or other
filesystem-related problems.  The \fIPR\fR may or may not have been
altered.
.RE
.P
\fBSUBM\fR
Submits a new \fIPR\fR into the database.  The supplied text is verified for
correctness, and if no problems are found a new \fIPR\fR is created.
.RS 0.5i
.P
The possible responses are:
.TP
431 (\fBCODE_GNATS_LOCKED\fR)
The database has been locked, and no \fIPR\fRs may be submitted until the
lock is cleared.
.TP
211 (\fBCODE_SEND_PR\fR)
The client should now transmit the new \fIPR\fR text using the normal
quoting mechanism.  After the \fIPR\fR has been sent, the server will
respond with either a 200 (\fBCODE_OK\fR) response indicating that the
new PR has been created (and mail sent to the appropriate persons), or
one or more error codes listing problems with the new \fIPR\fR text.
.RE
.TP
\fBCHDB\fR <\fIdatabase\fR> [<\fIuserid\fR> [<\fIpassword\fR>]]
Switches the current database to the name specified in the command.
An optional username or an optional username and password may be
given.
.RS 0.5i
.P
The possible responses are:
.TP
422 (\fBCODE_NO_ACCESS\fR)
The user does not have permission to access the requested database.
.TP
417 (\fBCODE_INVALID_DATABASE\fR)
The database specified does not exist, or one or more configuration errors
in the database were encountered.
.TP
210 (\fBCODE_OK\fR)
The current database is now \fIdatabase\fR.  Any operations performed
will now be applied to that database.  The user access level for the
new database is also returned.
.RE
.TP
\fBDBLS\fR
Lists the known set of databases.
.RS 0.5i
.P
The possible responses are:
.TP
6xx (\fIinternal error\fR)
An internal error was encountered while trying to obtain the list of
available databases, usually due to lack of permissions or other
filesystem-related problems, or the list of databases is empty.
.TP
301 (\fBCODE_TEXT_READY\fR)
The list of databases follows, one per line, using the standard quoting
mechanism.  Only the database names are sent.
.RE
.TP
\fBDBDESC\fR <\fIdatabasename\fR>
Returns a human-readable description of the specified database.  Responses
include:
.RS 0.5i
.TP
6xx (\fIinternal error\fR)
An internal error was encountered while trying to read the list of
available databases, usually due to lack of permissions or other
filesystem-related problems, or the list of databases is empty.
.TP
350 (\fBCODE_INFORMATION\fR)
The normal response; the supplied text is the database description.
.TP
417 (\fBCODE_INVALID_DATABASE\fR)
The specified database name does not have an entry.
.RE
.TP
\fBEXPR\fR <\fIquery expression\fR>
Specifies a query expression used to limit which \fIPR\fRs are returned
from the \fBQUER\fR command.  The expression uses the normal query
expression syntax, as described in the manual entry for query-pr(1).
.RS 0.5i
.P
Multiple \fBEXPR\fR commands may be issued; the expressions are
boolean \fIAND\fRed together.
.P
Expressions are cleared by the RSET command.
.P
Possible responses include:
.TP
415 (\fBCODE_INVALID_EXPR\fR)
The specified expression is invalid, and could not be parsed.
.TP
200 (\fBCODE_OK\fR)
The expression has been accepted, and will be used to limit the results
returned from \fBQUER\fR.
.RE
.TP 0.5i
\fBQFMT\fR <\fIquery format\fR>
Use the specified query format to format the output of the \fBQUER\fR command.
The query format may be either the name of a query format known to the
server, or an actual query format.
.RS 0.5i
The possible responses are:
.TP
200 (\fBCODE_OK\fR)
The normal response, which indicates that the query format is acceptable.
.TP
440 (\fBCODE_CMD_ERROR\fR)
No query format was supplied.
.TP
418 (\fBCODE_INVALID_QUERY_FORMAT\fR)
The specified query format does not exist, or could not be parsed.
.RE
.TP
\fBQUER\fR [\fIPR\fR] [\fIPR\fR] [...]
Searches the contents of the database for \fIPR\fRs that match the
(optional) specified expressions with the \fBEXPR\fR command.  If no
expressions were specified with \fBEXPR\fR, the entire set of \fIPR\fRs
is returned.
.RS 0.5i
.P
If one or more \fIPR\fRs are specified on the commandline, only those
\fIPR\fRs will be searched and/or output.
.P
The format of the output from the command is determined by the query
format selected with the \fBQFMT\fR command.
.P
The possible responses are:
.TP
418 (\fBCODE_INVALID_QUERY_FORMAT\fR)
A valid format was not specified with the \fBQFMT\fR command prior to
invoking \fBQUER\fR.
.TP
300 (\fBCODE_PR_READY\fR)
One or more \fIPR\fRs will be output using the requested query format.
The \fIPR\fR text is quoted using the normal quoting mechanisms for
\fIPR\fRs.
.TP
220 (\fBCODE_NO_PRS_MATCHED\fR)
No \fIPR\fRs met the specified criteria.
.RE
.TP
\fBADMV\fR <\fIfield\fR> <\fIkey\fR> [<\fIsubfield\fR>]
Returns an entry from an adm file associated with \fIfield\fR.
\fIkey\fR is used to look up the entry in the data file.  If
\fIsubfield\fR is specified, only the value of that subfield is
returned; otherwise, all of the fields in the adm data file are
returned, separated by colons (`:').
.RS 0.5i
.P
The responses are:
.TP
410 (\fBCODE_INVALID_FIELD_NAME\fR)
The specified field does not exist.
.TP
221 (\fBCODE_NO_ADM_ENTRY\fR)
An adm entry matching the key was not found, or the field does not have
an adm file associated with it.
.TP
350 (\fBCODE_INFORMATION\fR)
The normal response; the supplied text is the requested field(s).
.RE
.SH ENVIRONMENT VARIABLES
The \fBGNATSDB\fR environment variable is used to determine which
database to use.  For a local database, it contains the name of the
database to access.  \fBgnatsd\fR cannot service remote databases (tho
it might be interesting if it could) so the database is always assumed
to be local.
.P
If \fBGNATSDB\fR is not set and the --database option is not supplied,
it is assumed that the database is local and that its name is \fIdefault\fR.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
.LP
.BR databases (5),
.BR dbconfig (5),
.BR delete-pr (8),
.BR edit-pr (1)
.BR file-pr (8),
.BR gen-index (8),
.BR gnats (7),
.BR gnatsd (8),
.BR mkcat (8),
.BR mkdb (8),
.BR pr-edit (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR send-pr (1).
.SH COPYING
Copyright (c) 2000 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
