/*
  File autogenerated by gengetopt version 2.18
  generated with the following command:
  /home/bettini/usr/local/bin/gengetopt --input cmdline.ggo --no-handle-version --no-handle-help 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "This program, given a skeleton source file with some\nparts to be replaced, generates a program that generates that source,\nand substitutes those parts as specified.";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTIONS]...";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                Print help and exit",
  "  -V, --version             Print version and exit",
  "  -i, --input=file          input file (default std input)",
  "  -F, --file-name=name      name used for generating file (default stdout)",
  "  -f, --gen-name=STRING     prefix for generated code  (default=`gengen')",
  "      --output-format=lang  target language (cpp, c)  (default=`cpp')",
  "      --separate-files      output to separate files (header, source). require \n                              --file-name",
  "      --expand-tabs         strings containing newlines are indented according \n                              to the current indentation level",
  "      --no-gen-version      do not put gengen version in the generated file",
  "      --test-mode           even with errors exit with 0 (this is only for \n                              testing purposes)",
  "      --force               force regeneration of output code",
    0
};

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->file_name_given = 0 ;
  args_info->gen_name_given = 0 ;
  args_info->output_format_given = 0 ;
  args_info->separate_files_given = 0 ;
  args_info->expand_tabs_given = 0 ;
  args_info->no_gen_version_given = 0 ;
  args_info->test_mode_given = 0 ;
  args_info->force_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->input_arg = NULL;
  args_info->input_orig = NULL;
  args_info->file_name_arg = NULL;
  args_info->file_name_orig = NULL;
  args_info->gen_name_arg = gengetopt_strdup ("gengen");
  args_info->gen_name_orig = NULL;
  args_info->output_format_arg = gengetopt_strdup ("cpp");
  args_info->output_format_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{
  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->input_help = gengetopt_args_info_help[2] ;
  args_info->file_name_help = gengetopt_args_info_help[3] ;
  args_info->gen_name_help = gengetopt_args_info_help[4] ;
  args_info->output_format_help = gengetopt_args_info_help[5] ;
  args_info->separate_files_help = gengetopt_args_info_help[6] ;
  args_info->expand_tabs_help = gengetopt_args_info_help[7] ;
  args_info->no_gen_version_help = gengetopt_args_info_help[8] ;
  args_info->test_mode_help = gengetopt_args_info_help[9] ;
  args_info->force_help = gengetopt_args_info_help[10] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  printf("\n%s\n\n", gengetopt_args_info_usage);
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  if (args_info->input_arg)
    {
      free (args_info->input_arg); /* free previous argument */
      args_info->input_arg = 0;
    }
  if (args_info->input_orig)
    {
      free (args_info->input_orig); /* free previous argument */
      args_info->input_orig = 0;
    }
  if (args_info->file_name_arg)
    {
      free (args_info->file_name_arg); /* free previous argument */
      args_info->file_name_arg = 0;
    }
  if (args_info->file_name_orig)
    {
      free (args_info->file_name_orig); /* free previous argument */
      args_info->file_name_orig = 0;
    }
  if (args_info->gen_name_arg)
    {
      free (args_info->gen_name_arg); /* free previous argument */
      args_info->gen_name_arg = 0;
    }
  if (args_info->gen_name_orig)
    {
      free (args_info->gen_name_orig); /* free previous argument */
      args_info->gen_name_orig = 0;
    }
  if (args_info->output_format_arg)
    {
      free (args_info->output_format_arg); /* free previous argument */
      args_info->output_format_arg = 0;
    }
  if (args_info->output_format_orig)
    {
      free (args_info->output_format_orig); /* free previous argument */
      args_info->output_format_orig = 0;
    }
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->input_given) {
    if (args_info->input_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "input", args_info->input_orig);
    } else {
      fprintf(outfile, "%s\n", "input");
    }
  }
  if (args_info->file_name_given) {
    if (args_info->file_name_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "file-name", args_info->file_name_orig);
    } else {
      fprintf(outfile, "%s\n", "file-name");
    }
  }
  if (args_info->gen_name_given) {
    if (args_info->gen_name_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "gen-name", args_info->gen_name_orig);
    } else {
      fprintf(outfile, "%s\n", "gen-name");
    }
  }
  if (args_info->output_format_given) {
    if (args_info->output_format_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "output-format", args_info->output_format_orig);
    } else {
      fprintf(outfile, "%s\n", "output-format");
    }
  }
  if (args_info->separate_files_given) {
    fprintf(outfile, "%s\n", "separate-files");
  }
  if (args_info->expand_tabs_given) {
    fprintf(outfile, "%s\n", "expand-tabs");
  }
  if (args_info->no_gen_version_given) {
    fprintf(outfile, "%s\n", "no-gen-version");
  }
  if (args_info->test_mode_given) {
    fprintf(outfile, "%s\n", "test-mode");
  }
  if (args_info->force_given) {
    fprintf(outfile, "%s\n", "force");
  }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'i' },
        { "file-name",	1, NULL, 'F' },
        { "gen-name",	1, NULL, 'f' },
        { "output-format",	1, NULL, 0 },
        { "separate-files",	0, NULL, 0 },
        { "expand-tabs",	0, NULL, 0 },
        { "no-gen-version",	0, NULL, 0 },
        { "test-mode",	0, NULL, 0 },
        { "force",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVi:F:f:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (local_args_info.help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->help_given && ! override)
            continue;
          local_args_info.help_given = 1;
          args_info->help_given = 1;
          cmdline_parser_free (&local_args_info);
          return 0;

        case 'V':	/* Print version and exit.  */
          if (local_args_info.version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->version_given && ! override)
            continue;
          local_args_info.version_given = 1;
          args_info->version_given = 1;
          cmdline_parser_free (&local_args_info);
          return 0;

        case 'i':	/* input file (default std input).  */
          if (local_args_info.input_given)
            {
              fprintf (stderr, "%s: `--input' (`-i') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->input_given && ! override)
            continue;
          local_args_info.input_given = 1;
          args_info->input_given = 1;
          if (args_info->input_arg)
            free (args_info->input_arg); /* free previous string */
          args_info->input_arg = gengetopt_strdup (optarg);
          if (args_info->input_orig)
            free (args_info->input_orig); /* free previous string */
          args_info->input_orig = gengetopt_strdup (optarg);
          break;

        case 'F':	/* name used for generating file (default stdout).  */
          if (local_args_info.file_name_given)
            {
              fprintf (stderr, "%s: `--file-name' (`-F') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->file_name_given && ! override)
            continue;
          local_args_info.file_name_given = 1;
          args_info->file_name_given = 1;
          if (args_info->file_name_arg)
            free (args_info->file_name_arg); /* free previous string */
          args_info->file_name_arg = gengetopt_strdup (optarg);
          if (args_info->file_name_orig)
            free (args_info->file_name_orig); /* free previous string */
          args_info->file_name_orig = gengetopt_strdup (optarg);
          break;

        case 'f':	/* prefix for generated code.  */
          if (local_args_info.gen_name_given)
            {
              fprintf (stderr, "%s: `--gen-name' (`-f') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->gen_name_given && ! override)
            continue;
          local_args_info.gen_name_given = 1;
          args_info->gen_name_given = 1;
          if (args_info->gen_name_arg)
            free (args_info->gen_name_arg); /* free previous string */
          args_info->gen_name_arg = gengetopt_strdup (optarg);
          if (args_info->gen_name_orig)
            free (args_info->gen_name_orig); /* free previous string */
          args_info->gen_name_orig = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
          /* target language (cpp, c).  */
          if (strcmp (long_options[option_index].name, "output-format") == 0)
          {
            if (local_args_info.output_format_given)
              {
                fprintf (stderr, "%s: `--output-format' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->output_format_given && ! override)
              continue;
            local_args_info.output_format_given = 1;
            args_info->output_format_given = 1;
            if (args_info->output_format_arg)
              free (args_info->output_format_arg); /* free previous string */
            args_info->output_format_arg = gengetopt_strdup (optarg);
            if (args_info->output_format_orig)
              free (args_info->output_format_orig); /* free previous string */
            args_info->output_format_orig = gengetopt_strdup (optarg);
          }
          /* output to separate files (header, source). require --file-name.  */
          else if (strcmp (long_options[option_index].name, "separate-files") == 0)
          {
            if (local_args_info.separate_files_given)
              {
                fprintf (stderr, "%s: `--separate-files' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->separate_files_given && ! override)
              continue;
            local_args_info.separate_files_given = 1;
            args_info->separate_files_given = 1;
            break;
          }
          /* strings containing newlines are indented according to the current indentation level.  */
          else if (strcmp (long_options[option_index].name, "expand-tabs") == 0)
          {
            if (local_args_info.expand_tabs_given)
              {
                fprintf (stderr, "%s: `--expand-tabs' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->expand_tabs_given && ! override)
              continue;
            local_args_info.expand_tabs_given = 1;
            args_info->expand_tabs_given = 1;
            break;
          }
          /* do not put gengen version in the generated file.  */
          else if (strcmp (long_options[option_index].name, "no-gen-version") == 0)
          {
            if (local_args_info.no_gen_version_given)
              {
                fprintf (stderr, "%s: `--no-gen-version' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->no_gen_version_given && ! override)
              continue;
            local_args_info.no_gen_version_given = 1;
            args_info->no_gen_version_given = 1;
            break;
          }
          /* even with errors exit with 0 (this is only for testing purposes).  */
          else if (strcmp (long_options[option_index].name, "test-mode") == 0)
          {
            if (local_args_info.test_mode_given)
              {
                fprintf (stderr, "%s: `--test-mode' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->test_mode_given && ! override)
              continue;
            local_args_info.test_mode_given = 1;
            args_info->test_mode_given = 1;
            break;
          }
          /* force regeneration of output code.  */
          else if (strcmp (long_options[option_index].name, "force") == 0)
          {
            if (local_args_info.force_given)
              {
                fprintf (stderr, "%s: `--force' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->force_given && ! override)
              continue;
            local_args_info.force_given = 1;
            args_info->force_given = 1;
            break;
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
