/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import java.math.BigInteger;
import java.util.Map;

public class Vec4SignExt<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public final Svex<N> width;
    public final Svex<N> x;

    private Vec4SignExt(Svex<N> width, Svex<N> x) {
        super(FUNCTION, width, x);
        this.width = width;
        this.x = x;
    }

    @Override
    public Svex.MatchExt<N> matchExt() {
        Vec4 wval;
        if (this.width instanceof SvexQuote && (wval = ((SvexQuote)this.width).val).isVec2() && ((Vec2)wval).getVal().signum() >= 0) {
            return new Svex.MatchExt(((Vec2)wval).getVal().intValueExact(), this.args[1], true);
        }
        return null;
    }

    @Override
    public Svex<N> lhsrewriteAux(SvexManager<N> sm, int shift, int w) {
        int wv;
        Vec4 wval;
        if (this.width instanceof SvexQuote && (wval = ((SvexQuote)this.width).val).isVec2() && (wv = ((Vec2)wval).getVal().intValueExact()) >= 0 && wv > shift && shift + w <= wv) {
            return this.x.lhsrewriteAux(sm, shift, w);
        }
        return super.lhsrewriteAux(sm, shift, w);
    }

    @Override
    public Svex<N> lhsPreproc(SvexManager<N> sm) {
        Svex<N> newWidth = this.width.lhsPreproc(sm);
        Svex<N> newX = this.x.lhsPreproc(sm);
        return sm.newCall(FUNCTION, newWidth, newX);
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_SIGNX, 2, "4vec-sign-ext");
        }

        public <N extends SvarName> Vec4SignExt<N> build(Svex<N>[] args) {
            return new Vec4SignExt<N>(args[0], args[1]);
        }

        @Override
        public <N extends SvarName> Svex<N> callStar(SvexManager<N> sm, Svex<N>[] args) {
            BigInteger wV;
            Vec4 wVal;
            assert (args.length == 2);
            Svex<N> width = args[0];
            if (width instanceof SvexQuote && (wVal = ((SvexQuote)width).val).isVec2() && (wV = ((Vec2)wVal).getVal()).signum() >= 0) {
                return args[1].signx(sm, wV.intValueExact());
            }
            return super.callStar(sm, args);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            int wval;
            Vec4 width = args[0];
            Vec4 x = args[1];
            if (width.isVec2() && (wval = ((Vec2)width).getVal().intValueExact()) > 0) {
                if (wval >= 0x1000000 && (x.getUpper().signum() < 0 || x.getLower().signum() < 0)) {
                    throw new IllegalArgumentException("very large integer");
                }
                BigInteger pow = BigInteger.ONE.shiftLeft(wval - 1);
                BigInteger mask = pow.subtract(BigInteger.ONE);
                if (x.isVec2()) {
                    BigInteger xv = ((Vec2)x).getVal();
                    BigInteger xm = xv.and(mask);
                    return Vec2.valueOf(xv.testBit(wval - 1) ? xm.subtract(pow) : xm);
                }
                BigInteger uv = x.getUpper();
                BigInteger lv = x.getLower();
                BigInteger um = uv.and(mask);
                BigInteger lm = lv.and(mask);
                return Vec4.valueOf(uv.testBit(wval - 1) ? um.subtract(pow) : um, lv.testBit(wval - 1) ? lm.subtract(pow) : lm);
            }
            return Vec4.X;
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            if (mask.signum() == 0) {
                return new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
            }
            Svex<N> width = args[0];
            Vec4 widthVal = width.xeval(xevalMemoize);
            if (!widthVal.isVec2()) {
                return new BigInteger[]{BigIntegerUtil.MINUS_ONE, this.maskForGenericSignx(mask)};
            }
            int widthV = ((Vec2)widthVal).getVal().intValueExact();
            if (widthV <= 0) {
                return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigInteger.ZERO};
            }
            BigInteger xMask = BigInteger.ONE.shiftLeft(widthV).subtract(BigInteger.ONE).and(mask);
            if (mask.signum() < 0 || mask.bitLength() >= widthV) {
                xMask = xMask.setBit(widthV - 1);
            }
            return new BigInteger[]{BigIntegerUtil.MINUS_ONE, xMask};
        }
    }
}

