/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.machine;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStar;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarRegionNode;
import com.sun.electric.tool.routing.experimentalAStar3.machine.AStarMachine;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.ObjectPool;
import com.sun.electric.tool.routing.experimentalAStar3.storage.AStarClosedListReferencing;
import com.sun.electric.tool.routing.experimentalAStar3.storage.AStarOpenListCheapList;
import java.util.List;

public class AStarRegionMachine
implements AStarMachine<AStarRegionNode>,
AStarMapVisitorBase<AStarRegionNode> {
    private ObjectPool<AStarRegionNode> nodePool;
    private AStarOpenListCheapList<AStarRegionNode> openList;
    private AStarClosedListReferencing<AStarRegionNode> closedList;
    private AStarMapBase<AStarRegionNode> map = null;
    private AStarGoalBase<AStarRegionNode> goal = null;

    public AStarRegionMachine(ObjectPool<AStarRegionNode> nodePool) {
        this.nodePool = nodePool;
        this.openList = new AStarOpenListCheapList();
        this.closedList = new AStarClosedListReferencing();
    }

    @Override
    public List<AStarRegionNode> findPath(int startX, int startY, int startZ, int goalX, int goalY, int goalZ) {
        if (this.map == null) {
            throw new IllegalStateException("The searched map must be specified before path search can be done.");
        }
        if (this.goal == null) {
            throw new IllegalStateException("The goal object must be specified before path search can be done.");
        }
        AStarRegionNode startRegion = this.map.nodeAt(startX, startY, startZ);
        AStarRegionNode goalRegion = this.map.nodeAt(goalX, goalY, goalZ);
        assert (startRegion != null);
        assert (goalRegion != null);
        this.goal.setGoalNode(goalRegion);
        int goalDistance = this.goal.distanceToGoal(startX, startY, startZ);
        goalRegion.initialize(null, goalDistance, 0, goalDistance, goalX, goalY, goalZ);
        startRegion.initialize(null, 0, goalDistance, goalDistance, startX, startY, startZ);
        this.openList.addNodeToOpenList(startRegion);
        return AStar.findPath(this.openList, this.closedList, this.map, this.goal, this.nodePool, this);
    }

    @Override
    public void setUpSearchSpace(AStarMapBase<AStarRegionNode> newMap, AStarGoalBase<AStarRegionNode> newGoal) {
        if (newMap == null) {
            throw new IllegalArgumentException("The map to search may not be null.");
        }
        if (newGoal == null) {
            throw new IllegalArgumentException("The goal object may not be null.");
        }
        this.map = newMap;
        this.openList.setMap(this.map);
        this.closedList.setMap(this.map);
        this.goal = newGoal;
        this.goal.setNodeStorage(this.openList);
    }

    @Override
    public void visitNeighbour(AStarRegionNode origin, int x, int y, int z) {
        if (origin.getX() == x && (!origin.isTerminalRegion() && origin.getVerticalCapacity() == 0 || !this.map.nodeAt(x, y, z).isTerminalRegion() && this.map.nodeAt(x, y, z).getVerticalCapacity() == 0)) {
            return;
        }
        if (origin.getY() == y && (!origin.isTerminalRegion() && origin.getHorizontalCapacity() == 0 || !this.map.nodeAt(x, y, z).isTerminalRegion() && this.map.nodeAt(x, y, z).getHorizontalCapacity() == 0)) {
            return;
        }
        int costFromStart = origin.getCostFromStart() + this.goal.getNodeCost(origin, x, y, z);
        int costToGoal = this.goal.distanceToGoal(x, y, z);
        int totalCost = costFromStart + costToGoal;
        AStarRegionNode foundNode = this.openList.findOpenNode(x, y, z);
        AStarNode portal = null;
        boolean foundCheaperPath = false;
        if (foundNode != null) {
            if (totalCost < foundNode.getTotalCost() && (portal = this.findPortal(origin, foundNode)) != null) {
                foundCheaperPath = true;
                this.openList.removeNodeFromOpenList(foundNode);
            }
        } else {
            foundNode = this.closedList.findClosedNode(x, y, z);
            if (foundNode != null) {
                if (totalCost < foundNode.getTotalCost() && (portal = this.findPortal(origin, foundNode)) != null) {
                    foundCheaperPath = true;
                    this.closedList.removeNodeFromClosedList(foundNode);
                }
            } else {
                foundNode = this.map.nodeAt(x, y, z);
                portal = this.findPortal(origin, foundNode);
                if (portal != null) {
                    foundCheaperPath = true;
                }
            }
        }
        if (foundCheaperPath) {
            foundNode.initialize(origin, costFromStart, costToGoal, totalCost, x, y, z);
            foundNode.setEntryPoint(portal);
            this.openList.addNodeToOpenList(foundNode);
        }
    }

    public AStarNode findPortal(AStarRegionNode originRegion, AStarRegionNode targetRegion) {
        AStarNode result;
        block19: {
            int fy;
            int oy;
            block21: {
                block20: {
                    int fx;
                    int ox;
                    block18: {
                        result = null;
                        int viaX = originRegion.getEntryPoint().getX();
                        int viaY = originRegion.getEntryPoint().getY();
                        if (originRegion.getZ() != targetRegion.getZ()) {
                            int count = 0;
                            while (viaY + count < originRegion.height || viaY - count >= 0 || viaX + count < originRegion.width || viaX - count >= 0) {
                                if (viaX + count < originRegion.width && !originRegion.isTileBlocked(viaX + count, viaY) && !targetRegion.isTileBlocked(viaX + count, viaY) && originRegion.routingMap.nodeAt(viaX + count, viaY, 0).getTerminalCount() == 0 && targetRegion.routingMap.nodeAt(viaX + count, viaY, 0).getTerminalCount() == 0) {
                                    return targetRegion.routingMap.nodeAt(viaX + count, viaY, 0);
                                }
                                if (viaX - count >= 0 && !originRegion.isTileBlocked(viaX - count, viaY) && !targetRegion.isTileBlocked(viaX - count, viaY) && originRegion.routingMap.nodeAt(viaX - count, viaY, 0).getTerminalCount() == 0 && targetRegion.routingMap.nodeAt(viaX - count, viaY, 0).getTerminalCount() == 0) {
                                    return targetRegion.routingMap.nodeAt(viaX - count, viaY, 0);
                                }
                                if (viaY + count < originRegion.height && !originRegion.isTileBlocked(viaX, viaY + count) && !targetRegion.isTileBlocked(viaX, viaY + count) && originRegion.routingMap.nodeAt(viaX, viaY + count, 0).getTerminalCount() == 0 && targetRegion.routingMap.nodeAt(viaX, viaY + count, 0).getTerminalCount() == 0) {
                                    return targetRegion.routingMap.nodeAt(viaX, viaY + count, 0);
                                }
                                if (viaY - count >= 0 && !originRegion.isTileBlocked(viaX, viaY - count) && !targetRegion.isTileBlocked(viaX, viaY - count) && originRegion.routingMap.nodeAt(viaX, viaY - count, 0).getTerminalCount() == 0 && targetRegion.routingMap.nodeAt(viaX, viaY - count, 0).getTerminalCount() == 0) {
                                    return targetRegion.routingMap.nodeAt(viaX, viaY - count, 0);
                                }
                                ++count;
                            }
                            return null;
                        }
                        ox = originRegion.getX();
                        fx = targetRegion.getX();
                        oy = originRegion.getY();
                        fy = targetRegion.getY();
                        if (ox != fx - 1) break block18;
                        int targetX = 0;
                        int originX = originRegion.width - 1;
                        int y = originRegion.getEntryPoint().getY();
                        int count = 0;
                        while (y + count < originRegion.height || y - count >= 0) {
                            if (y + count < originRegion.height && originRegion.isPortalWithPath(originX, y + count, false) && targetRegion.isPortalWithPath(targetX, y + count, false)) {
                                return targetRegion.getMap(false).nodeAt(targetX, y + count, 0);
                            }
                            if (y - count >= 0 && originRegion.isPortalWithPath(originX, y - count, false) && targetRegion.isPortalWithPath(targetX, y - count, false)) {
                                return targetRegion.getMap(false).nodeAt(targetX, y - count, 0);
                            }
                            ++count;
                        }
                        break block19;
                    }
                    if (ox != fx + 1) break block20;
                    int targetX = originRegion.width - 1;
                    int originX = 0;
                    int y = originRegion.getEntryPoint().getY();
                    int count = 0;
                    while (y + count < originRegion.height || y - count >= 0) {
                        if (y + count < originRegion.height && originRegion.isPortalWithPath(originX, y + count, false) && targetRegion.isPortalWithPath(targetX, y + count, false)) {
                            return targetRegion.getMap(false).nodeAt(targetX, y + count, 0);
                        }
                        if (y - count >= 0 && originRegion.isPortalWithPath(originX, y - count, false) && targetRegion.isPortalWithPath(targetX, y - count, false)) {
                            return targetRegion.getMap(false).nodeAt(targetX, y - count, 0);
                        }
                        ++count;
                    }
                    break block19;
                }
                if (oy != fy + 1) break block21;
                int targetY = originRegion.height - 1;
                int originY = 0;
                int x = originRegion.getEntryPoint().getX();
                int count = 0;
                while (x + count < originRegion.width || x - count >= 0) {
                    if (x + count < originRegion.width && originRegion.isPortalWithPath(x + count, originY, true) && targetRegion.isPortalWithPath(x + count, targetY, true)) {
                        return targetRegion.getMap(false).nodeAt(x + count, targetY, 0);
                    }
                    if (x - count >= 0 && originRegion.isPortalWithPath(x - count, originY, true) && targetRegion.isPortalWithPath(x - count, targetY, true)) {
                        return targetRegion.getMap(false).nodeAt(x - count, targetY, 0);
                    }
                    ++count;
                }
                break block19;
            }
            if (oy != fy - 1) break block19;
            int targetY = 0;
            int originY = originRegion.height - 1;
            int x = originRegion.getEntryPoint().getX();
            int count = 0;
            while (x + count < originRegion.width || x - count >= 0) {
                if (x + count < originRegion.width && originRegion.isPortalWithPath(x + count, originY, true) && targetRegion.isPortalWithPath(x + count, targetY, true)) {
                    return targetRegion.getMap(false).nodeAt(x + count, targetY, 0);
                }
                if (x - count >= 0 && originRegion.isPortalWithPath(x - count, originY, true) && targetRegion.isPortalWithPath(x - count, targetY, true)) {
                    return targetRegion.getMap(false).nodeAt(x - count, targetY, 0);
                }
                ++count;
            }
        }
        return result;
    }
}

