/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.cmosPLA;

import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;

public class IO {
    private int width;
    private int height;
    private int widthIn;
    private int heightIn;
    private LineNumberReader lnr;
    private String curLine;

    IO() {
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    int getWidthIn() {
        return this.widthIn;
    }

    int getHeightIn() {
        return this.heightIn;
    }

    boolean readHeader(String fileName) {
        URL url = TextUtils.makeURLToFile(fileName);
        try {
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            this.lnr = new LineNumberReader(is);
            String line = this.lnr.readLine();
            if (line == null) {
                return false;
            }
            line = line.trim();
            this.height = TextUtils.atoi(line);
            int sep = line.indexOf(32);
            if (sep < 0) {
                return false;
            }
            line = line.substring(sep).trim();
            this.width = TextUtils.atoi(line);
            System.out.println("PLA table height=" + this.height + ", width=" + this.width);
            this.widthIn = this.width;
            this.heightIn = this.height;
            this.height = ((this.height - 1) / 4 + 1) * 5 + 1;
            if (this.height > 500) {
                System.out.println("PLA height exceeded");
                return false;
            }
            this.width = ((this.width - 1) / 4 + 1) * 5 + 1;
            if (this.width > 500) {
                System.out.println("PLA width exceeded");
                return false;
            }
            this.curLine = "";
            return true;
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName);
            return false;
        }
    }

    int[] readRow() {
        int read = 0;
        int[] row = new int[this.width];
        for (int i = 0; i < this.width; ++i) {
            if (i % 5 == 0) {
                row[i] = -2;
                continue;
            }
            if (read < this.widthIn) {
                try {
                    row[i] = this.getNextInt();
                }
                catch (IOException e) {
                    return null;
                }
                ++read;
                continue;
            }
            row[i] = -1;
        }
        return row;
    }

    void done() {
        try {
            this.lnr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getNextInt() throws IOException {
        while (this.curLine.length() == 0) {
            this.curLine = this.lnr.readLine();
            this.curLine = this.curLine.trim();
            if (this.curLine.length() <= 0) continue;
        }
        int value = TextUtils.atoi(this.curLine);
        int sepPos = this.curLine.indexOf(32);
        this.curLine = sepPos < 0 ? "" : this.curLine.substring(sepPos).trim();
        return value;
    }
}

