/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ServerJobManager;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractUserInterface
extends Client
implements UserInterface {
    private static final int DEFAULT_CONNECTION_ID = 0;
    private TechId curTechId;
    private LibId curLibId;
    private Job.Key jobKey = new Job.Key(0, 0, false);
    private Job.Inform[] serverJobQueue = new Job.Inform[0];
    private final HashMap<Job.Key, EJob> processingEJobs = new HashMap();
    private final ArrayList<EJob> clientJobs = new ArrayList();
    private boolean goSleeping;
    private boolean waitChanging;
    private UIDispatcher uiDispatcher;

    protected AbstractUserInterface() {
        super(0);
    }

    void patchConnectionId(int connectionId) {
        this.connectionId = connectionId;
        this.jobKey = new Job.Key(connectionId, 0, false);
    }

    void startDispatcher() {
        this.uiDispatcher = new UIDispatcher(this.connectionId);
        this.uiDispatcher.start();
    }

    @Override
    public Job.Key getJobKey() {
        return this.jobKey;
    }

    @Override
    public EDatabase getDatabase() {
        return EDatabase.clientDatabase();
    }

    @Override
    public Technology getCurrentTechnology() {
        EDatabase database = this.getDatabase();
        Technology tech = null;
        if (this.curTechId != null) {
            tech = database.getTech(this.curTechId);
        }
        if (tech == null) {
            tech = database.getTechPool().findTechnology(User.getDefaultTechnology());
        }
        if (tech == null) {
            tech = database.getTechPool().findTechnology("mocmos");
        }
        return tech;
    }

    public TechId getCurrentTechId() {
        return this.curTechId;
    }

    public void setCurrentTechnology(Technology tech) {
        if (tech != null) {
            this.curTechId = tech.getId();
        }
    }

    @Override
    public Library getCurrentLibrary() {
        return this.curLibId != null ? this.getDatabase().getLib(this.curLibId) : null;
    }

    public LibId getCurrentLibraryId() {
        return this.curLibId;
    }

    public void setCurrentLibrary(Library lib) {
        this.curLibId = lib != null ? lib.getId() : null;
    }

    protected abstract void addEvent(Client.ServerEvent var1);

    public void finishInitialization() {
    }

    protected void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        if (!errors.isEmpty()) {
            System.out.println(errors.size() + " network errors in " + cell);
        }
    }

    protected void updateIncrementalDRCErrors(Cell cell, List<ErrorLogger.MessageLog> newErrors, List<ErrorLogger.MessageLog> delErrors) {
        if (!newErrors.isEmpty()) {
            System.out.println(newErrors.size() + " drc errors in " + cell);
        }
    }

    public int saveHighlights() {
        return 0;
    }

    public void restoreHighlights(int highlightsId) {
    }

    public void showUndoRedoStatus(boolean newUndoEnabled, boolean newRedoEnabled) {
    }

    protected abstract void showJobQueue(Job.Inform[] var1);

    void showJobQueue() {
        this.showJobQueue(this.getFullJobQueue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showServerJobQueue(Job.Inform[] jobQueue) {
        AbstractUserInterface abstractUserInterface = this;
        synchronized (abstractUserInterface) {
            this.serverJobQueue = jobQueue;
        }
        this.showJobQueue();
    }

    private synchronized Job.Inform[] getFullJobQueue() {
        if (this.clientJobs.isEmpty()) {
            return this.serverJobQueue;
        }
        Job.Inform[] sq = this.serverJobQueue;
        Job.Inform[] q = new Job.Inform[sq.length + this.clientJobs.size()];
        System.arraycopy(sq, 0, q, 0, sq.length);
        for (int i = 0; i < this.clientJobs.size(); ++i) {
            q[sq.length + i] = this.clientJobs.get(i).getInform();
        }
        return q;
    }

    protected void showSnapshot(Snapshot newSnapshot) {
    }

    protected abstract void terminateJob(Job.Key var1, String var2, Tool var3, Job.Type var4, byte[] var5, boolean var6, byte[] var7, Snapshot var8);

    @Override
    public void beep() {
    }

    protected void setClientThread() {
        assert (Job.clientThread == null);
        Job.clientThread = Thread.currentThread();
    }

    synchronized void putProcessingEJob(EJob ejob, boolean onMySnapshot) {
        Job.Key jobKey = ejob.jobKey;
        assert (!jobKey.startedByServer());
        assert (jobKey.clientId == this.connectionId);
        assert (ejob.clientJob != null);
        EJob oldEJob = this.processingEJobs.put(jobKey, ejob);
        assert (oldEJob == null);
        if (!ejob.jobKey.doItOnServer) {
            if (onMySnapshot) {
                this.clientJobs.add(0, ejob);
            } else {
                this.clientJobs.add(ejob);
            }
            this.showJobQueue();
            if (this.goSleeping) {
                this.uiDispatcher.interrupt();
            }
        }
    }

    protected synchronized EJob removeProcessingEJob(Job.Key jobKey) {
        EJob ejob = this.processingEJobs.remove(jobKey);
        if (ejob != null && !jobKey.doItOnServer) {
            this.showJobQueue();
        }
        return ejob;
    }

    private synchronized EJob getClientJob() {
        return this.clientJobs.isEmpty() ? null : this.clientJobs.remove(0);
    }

    private synchronized boolean hasClientJobs() {
        return !this.clientJobs.isEmpty();
    }

    synchronized List<Job> getAllJobs() {
        ArrayList<Job> list = new ArrayList<Job>();
        for (EJob ejob : this.processingEJobs.values()) {
            list.add(ejob.getJob());
        }
        return list;
    }

    synchronized void setGoSleeping(boolean b) {
        assert (this.goSleeping != b);
        this.goSleeping = b;
    }

    private synchronized void startChanging() {
        assert (!this.waitChanging);
        this.waitChanging = true;
    }

    protected synchronized void endChanging() {
        assert (this.waitChanging);
        this.waitChanging = false;
        this.notify();
    }

    private synchronized void waitChanging() {
        while (this.waitChanging) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class UIDispatcher
    extends Thread {
        private static final long STACK_SIZE_EVENT = 0L;
        private Client.ServerEvent lastEvent;

        private UIDispatcher(int connectionId) {
            super(null, null, "UIDispatcher-" + connectionId, 0L);
            this.lastEvent = Client.getQueueTail();
        }

        private void doSafe() {
            Client.ServerEvent event;
            EJob ejob = AbstractUserInterface.this.getClientJob();
            if (ejob != null) {
                this.doClientExamine(ejob);
                return;
            }
            while ((event = this.lastEvent.getNext()) != null) {
                this.lastEvent = event;
                if (event instanceof Client.EJobEvent || event instanceof Client.SnapshotEvent) break;
                AbstractUserInterface.this.addEvent(event);
            }
            if (event == null) {
                AbstractUserInterface.this.setGoSleeping(true);
                if (AbstractUserInterface.this.hasClientJobs()) {
                    AbstractUserInterface.this.setGoSleeping(false);
                    UIDispatcher.interrupted();
                    return;
                }
                try {
                    this.lastEvent = Client.getEvent(this.lastEvent);
                }
                catch (InterruptedException e) {
                    AbstractUserInterface.this.setGoSleeping(false);
                    UIDispatcher.interrupted();
                    return;
                }
                AbstractUserInterface.this.setGoSleeping(false);
                UIDispatcher.interrupted();
            }
            if (this.lastEvent instanceof Client.EJobEvent && !((Client.EJobEvent)this.lastEvent).jobType.isExamine() || this.lastEvent instanceof Client.SnapshotEvent) {
                AbstractUserInterface.this.startChanging();
                AbstractUserInterface.this.addEvent(this.lastEvent);
                AbstractUserInterface.this.waitChanging();
            } else {
                AbstractUserInterface.this.addEvent(this.lastEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doClientExamine(EJob ejob) {
            assert (ejob.jobType == Job.Type.CLIENT_EXAMINE);
            ejob.state = EJob.State.RUNNING;
            Job.currentUI.showJobQueue();
            ejob.changedFields = new ArrayList();
            EDatabase database = EDatabase.clientDatabase();
            Environment.setThreadEnvironment(database.getEnvironment());
            EditingPreferences.lowLevelSetThreadLocalEditingPreferences(ejob.editingPreferences);
            ServerJobManager.UserInterfaceRedirect userInterface = new ServerJobManager.UserInterfaceRedirect(ejob.jobKey, Job.currentUI);
            Job.setUserInterface(userInterface);
            database.lock(!ejob.isExamine());
            ejob.oldSnapshot = database.backup();
            try {
                userInterface.setCurrents(ejob.clientJob);
                if (!ejob.clientJob.doIt()) {
                    throw new JobException("Job '" + ejob.jobName + "' failed");
                }
                ejob.serializeResult(database);
                ejob.newSnapshot = database.backup();
            }
            catch (Throwable e) {
                e.getStackTrace();
                if (!(e instanceof JobException)) {
                    e.printStackTrace();
                }
                ejob.serializeExceptionResult(e, database);
            }
            finally {
                database.unlock();
                userInterface = null;
                Environment.setThreadEnvironment(null);
                EditingPreferences.lowLevelSetThreadLocalEditingPreferences(null);
            }
            Job.currentUI.addEvent(new Client.EJobEvent(ejob.jobKey, ejob.jobName, ejob.getJob().getTool(), ejob.jobType, ejob.serializedJob, ejob.doItOk, ejob.serializedResult, database.backup(), EJob.State.SERVER_DONE));
        }

        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        this.doSafe();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.lastEvent = null;
                }
            }
            catch (Throwable throwable) {
                this.lastEvent = null;
                throw throwable;
            }
        }
    }
}

