/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.utils;

import com.sun.electric.tool.util.concurrent.datastructures.BDEQueue;
import com.sun.electric.tool.util.concurrent.datastructures.FCQueue;
import com.sun.electric.tool.util.concurrent.datastructures.LockFreeQueue;
import com.sun.electric.tool.util.concurrent.datastructures.LockFreeStack;
import com.sun.electric.tool.util.concurrent.datastructures.UnboundedDEQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentCollectionFactory {
    private static final int LOG_CAPACITY = 4;

    protected ConcurrentCollectionFactory() {
    }

    public static <T> ArrayList<T> createArrayList() {
        return new ArrayList();
    }

    public static <T> HashSet<T> createHashSet() {
        return new HashSet();
    }

    public static <T> List<T> createConcurrentList() {
        return Collections.synchronizedList(ConcurrentCollectionFactory.createArrayList());
    }

    public static <T> ConcurrentLinkedQueue<T> createConcurrentLinkedQueue() {
        return new ConcurrentLinkedQueue();
    }

    public static <T, V> ConcurrentHashMap<T, V> createConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <T> Set<T> createConcurrentHashSet() {
        return Collections.synchronizedSet(ConcurrentCollectionFactory.createHashSet());
    }

    public static <T> Set<T> copySetToConcurrent(Set<T> source) {
        Set<T> result2 = ConcurrentCollectionFactory.createConcurrentHashSet();
        ConcurrentCollectionFactory.doCopyCollection(source, result2);
        return result2;
    }

    public static <T> LinkedList<T> createLinkedList() {
        return new LinkedList();
    }

    public static <T> LockFreeQueue<T> createLockFreeQueue() {
        return new LockFreeQueue();
    }

    public static <T> LockFreeStack<T> createLockFreeStack() {
        return new LockFreeStack();
    }

    public static <T> UnboundedDEQueue<T> createUnboundedDoubleEndedQueue() {
        return new UnboundedDEQueue(4);
    }

    public static <T> BDEQueue<T> createBoundedDoubleEndedQueue(int capacity) {
        return new BDEQueue(capacity);
    }

    public static <T> FCQueue<T> createFCQueue() {
        return new FCQueue();
    }

    protected static <T> void doCopyCollection(Collection<T> source, Collection<T> dest) {
        Iterator<T> it = source.iterator();
        while (it.hasNext()) {
            dest.add(it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T threadSafeListGet(int index, List<T> list) {
        List<T> list2 = list;
        synchronized (list2) {
            return list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T threadSafeListRemove(int index, List<T> list) {
        List<T> list2 = list;
        synchronized (list2) {
            return list.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void threadSafeListAdd(T item, List<T> list) {
        List<T> list2 = list;
        synchronized (list2) {
            list.add(item);
        }
    }
}

