/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.runtime;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import com.sun.electric.tool.util.concurrent.datastructures.MultipleQueuesStructure;
import com.sun.electric.tool.util.concurrent.datastructures.WorkStealingStructure;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;

public class Scheduler {
    public static IStructure<PTask> createScheduler(SchedulingStrategy strategy, int numOfThreads) throws UnknownSchedulerException {
        IStructure result2 = null;
        if (strategy.equals((Object)SchedulingStrategy.queue)) {
            result2 = ConcurrentCollectionFactory.createLockFreeQueue();
        } else if (strategy.equals((Object)SchedulingStrategy.stack)) {
            result2 = ConcurrentCollectionFactory.createLockFreeStack();
        } else if (strategy.equals((Object)SchedulingStrategy.workStealing)) {
            result2 = WorkStealingStructure.createForThreadPool(numOfThreads);
        } else if (strategy.equals((Object)SchedulingStrategy.multipleQueues)) {
            result2 = new MultipleQueuesStructure(numOfThreads);
        } else if (strategy.equals((Object)SchedulingStrategy.fcQueue)) {
            result2 = ConcurrentCollectionFactory.createFCQueue();
        } else {
            throw new UnknownSchedulerException();
        }
        return result2;
    }

    public static String getAvailableScheduler() {
        StringBuilder builder = new StringBuilder();
        for (SchedulingStrategy strategy : SchedulingStrategy.values()) {
            builder.append(strategy.toString());
            builder.append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    public static class UnknownSchedulerException
    extends Exception {
    }

    public static enum SchedulingStrategy {
        queue,
        stack,
        workStealing,
        multipleQueues,
        fcQueue;

    }
}

