/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.dialogs.TextAttributesPanel;
import com.sun.electric.tool.user.dialogs.TextInfoPanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Attributes
extends EModelessDialog
implements HighlightListener,
DatabaseChangeListener {
    private static Attributes theDialog = null;
    private DefaultListModel listModel;
    private JList list;
    private ElectricObject selectedObject;
    private Cell selectedCell;
    private NodeInst selectedNode;
    private ArcInst selectedArc;
    private Export selectedExport;
    private PortInst selectedPort;
    private Variable.Key selectedVarKey;
    private JRadioButton currentButton;
    private String initialName;
    private String initialValue;
    private boolean showParamsOnly = !Job.getDebug();
    private TextAttributesPanel attrPanel;
    private TextInfoPanel textPanel;
    private VariableCellRenderer cellRenderer;
    private boolean loading = false;
    private JCheckBox applyToInstances;
    private JPanel body;
    private JLabel cellName;
    private JButton copyButton;
    private JRadioButton currentArc;
    private JRadioButton currentCell;
    private JRadioButton currentExport;
    private JRadioButton currentNode;
    private JRadioButton currentPort;
    private JPanel debugSelect;
    private JButton deleteButton;
    private JButton done;
    private JButton editValue;
    private JLabel evalLabel;
    private JLabel evaluation;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JScrollPane listPane;
    private JLabel mainLabel;
    private JTextField name;
    private JButton newButton;
    private JButton renameButton;
    private JTextField value;
    private ButtonGroup which;

    public static void showDialog() {
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new Attributes(jf);
        }
        theDialog.loadAttributesInfo(false);
        if (!theDialog.isVisible()) {
            theDialog.pack();
            theDialog.ensureProperSize();
            theDialog.setVisible(true);
        }
        theDialog.toFront();
    }

    @Override
    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadAttributesInfo(false);
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadAttributesInfo(false);
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (e.objectChanged(this.selectedObject)) {
            this.loadAttributesInfo(true);
        }
    }

    private Attributes(Frame parent) {
        super(parent);
        this.initComponents();
        if (this.showParamsOnly) {
            this.getContentPane().remove(this.debugSelect);
            this.mainLabel.setText("Parameters:");
            this.setTitle("Edit Parameters");
            this.pack();
        } else {
            this.mainLabel.setText("Parameters and Variables (Debug Mode):");
            this.setTitle("Edit Parameters and Variables");
        }
        UserInterfaceMain.addDatabaseChangeListener(this);
        Highlighter.addHighlightListener(this);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.cellRenderer = new VariableCellRenderer();
        this.list.setCellRenderer(this.cellRenderer);
        this.listPane.setViewportView(this.list);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Attributes.this.listClick();
            }
        });
        this.currentCell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentArc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentPort.setEnabled(false);
        this.attrPanel = new TextAttributesPanel(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.attrPanel, gridBagConstraints);
        this.textPanel = new TextInfoPanel(true, this.showParamsOnly);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.textPanel, gridBagConstraints);
        this.pack();
        this.loadAttributesInfo(false);
        this.name.getDocument().addDocumentListener(new TextInfoDocumentListener(this));
        this.value.getDocument().addDocumentListener(new TextInfoDocumentListener(this));
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.done(null);
    }

    private void fieldChanged() {
        if (this.loading) {
            return;
        }
        Variable var = this.getSelectedVariable();
        if (var == null) {
            return;
        }
        String varValue = this.value.getText().trim();
        if (!varValue.equals(this.initialValue)) {
            new ChangeAttribute(var.getKey(), this.selectedObject, this.getVariableObject(varValue));
            this.initialValue = varValue;
        }
    }

    private void objectSelectorActionPerformed(ActionEvent evt) {
        this.currentButton = (JRadioButton)evt.getSource();
        if (this.currentButton == this.currentCell) {
            this.selectedObject = this.selectedCell;
        } else if (this.currentButton == this.currentNode) {
            this.selectedObject = this.selectedNode;
        } else if (this.currentButton == this.currentArc) {
            this.selectedObject = this.selectedArc;
        } else if (this.currentButton == this.currentExport) {
            this.selectedObject = this.selectedExport;
        } else if (this.currentButton == this.currentPort) {
            this.selectedObject = this.selectedPort;
        }
        this.updateList();
        this.checkName();
    }

    private void listClick() {
        this.showSelectedAttribute(null);
    }

    private void loadAttributesInfo(boolean keepObj) {
        this.loading = true;
        if (!keepObj) {
            this.selectedObject = null;
            this.selectedCell = null;
            this.selectedNode = null;
            this.selectedArc = null;
            this.selectedExport = null;
            this.selectedPort = null;
            this.selectedVarKey = null;
            this.currentButton = this.currentCell;
            EditWindow curWnd = EditWindow.getCurrent();
            this.selectedCell = WindowFrame.needCurCell();
            this.selectedObject = this.selectedCell;
            if (curWnd == null) {
                this.selectedCell = null;
            }
            if (this.selectedCell != null) {
                if (this.showParamsOnly) {
                    if (!this.selectedCell.isIcon() && !this.selectedCell.isSchematic()) {
                        this.selectedCell = null;
                    } else {
                        this.mainLabel.setText("Parameters on " + this.selectedCell.getName() + ":");
                    }
                } else if (curWnd.getHighlighter().getNumHighlights() == 1) {
                    Highlight high = curWnd.getHighlighter().getHighlights().iterator().next();
                    ElectricObject eobj = high.getElectricObject();
                    if (high.isHighlightEOBJ()) {
                        if (eobj instanceof ArcInst) {
                            this.selectedArc = (ArcInst)eobj;
                            this.selectedObject = this.selectedArc;
                            this.currentButton = this.currentArc;
                        } else if (eobj instanceof NodeInst) {
                            this.selectedNode = (NodeInst)eobj;
                            this.selectedObject = this.selectedNode;
                            this.currentButton = this.currentNode;
                        } else if (eobj instanceof PortInst) {
                            PortInst pi = (PortInst)eobj;
                            this.selectedNode = pi.getNodeInst();
                            this.selectedObject = this.selectedNode;
                            this.currentButton = this.currentNode;
                            this.selectedPort = pi;
                        }
                    } else if (high.isHighlightText()) {
                        this.selectedVarKey = high.getVarKey();
                        if (this.selectedVarKey != null) {
                            if (eobj instanceof NodeInst) {
                                this.selectedNode = (NodeInst)eobj;
                                this.selectedObject = this.selectedNode;
                                this.currentButton = this.currentNode;
                            } else if (eobj instanceof ArcInst) {
                                this.selectedArc = (ArcInst)eobj;
                                this.selectedObject = this.selectedArc;
                                this.currentButton = this.currentArc;
                            } else if (eobj instanceof PortInst) {
                                this.selectedPort = (PortInst)eobj;
                                this.selectedObject = this.selectedPort;
                                this.currentButton = this.currentPort;
                                this.selectedNode = this.selectedPort.getNodeInst();
                            } else if (eobj instanceof Export) {
                                this.selectedExport = (Export)eobj;
                                this.selectedObject = this.selectedExport;
                                this.currentButton = this.currentExport;
                            }
                        } else if (high.getVarKey() == NodeInst.NODE_NAME || high.getVarKey() == NodeInst.NODE_PROTO) {
                            this.selectedNode = (NodeInst)eobj;
                            this.selectedObject = this.selectedNode;
                            this.currentButton = this.currentNode;
                        } else if (high.getVarKey() == ArcInst.ARC_NAME) {
                            this.selectedArc = (ArcInst)eobj;
                            this.selectedObject = this.selectedArc;
                            this.currentButton = this.currentArc;
                        } else if (high.getVarKey() == Export.EXPORT_NAME) {
                            this.selectedExport = (Export)eobj;
                            this.selectedObject = this.selectedExport;
                            this.currentButton = this.currentExport;
                        }
                    }
                }
            }
        }
        if (this.selectedCell == null) {
            this.currentCell.setEnabled(false);
            this.cellName.setText("NO CURRENT CELL");
            this.currentNode.setEnabled(false);
            this.currentArc.setEnabled(false);
            this.currentExport.setEnabled(false);
            this.currentPort.setEnabled(false);
            this.list.clearSelection();
            this.listModel.clear();
            this.name.setText("");
            this.name.setEditable(false);
            this.value.setText("");
            this.value.setEditable(false);
            this.evaluation.setText("");
            this.deleteButton.setEnabled(false);
            this.newButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.textPanel.setTextDescriptor(null, null);
            this.attrPanel.setVariable(null, null);
            this.loading = false;
            return;
        }
        this.currentCell.setEnabled(true);
        this.currentNode.setEnabled(this.selectedNode != null);
        this.currentArc.setEnabled(this.selectedArc != null);
        this.currentExport.setEnabled(this.selectedExport != null);
        this.currentPort.setEnabled(this.selectedPort != null);
        this.currentButton.setSelected(true);
        this.cellName.setText(this.selectedCell.describe(false));
        this.name.setEditable(true);
        this.value.setEditable(true);
        this.updateList();
        if (this.selectedVarKey != null) {
            this.showSelectedAttribute(this.selectedVarKey);
        } else {
            this.checkName();
        }
        this.loading = false;
    }

    private void checkName() {
        Variable.Key varKey;
        String varName = this.name.getText().trim();
        if (varName.equals("")) {
            this.newButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.textPanel.setTextDescriptor(null, null);
            this.attrPanel.setVariable(null, null);
            return;
        }
        if (this.showParamsOnly) {
            varName = "ATTR_" + varName;
        }
        if (this.selectedObject.getParameterOrVariable(varKey = Variable.newKey(varName)) != null) {
            if (varKey != null) {
                this.list.setSelectedValue(varKey, true);
            }
        } else {
            this.newButton.setEnabled(true);
            this.renameButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.list.clearSelection();
            this.textPanel.setTextDescriptor(varKey, this.selectedObject);
            this.attrPanel.setVariable(varKey, this.selectedObject);
        }
    }

    private void updateList() {
        this.list.clearSelection();
        this.listModel.clear();
        HashSet<Variable.Key> seen = new HashSet<Variable.Key>();
        Iterator<Variable> it = null;
        if (this.selectedObject instanceof Cell) {
            Cell cell = (Cell)this.selectedObject;
            it = cell.getParameters();
        }
        if (this.selectedObject instanceof NodeInst) {
            NodeInst ni = (NodeInst)this.selectedObject;
            it = ni.getParameters();
        }
        if (it != null) {
            ArrayList<Variable.Key> params = new ArrayList<Variable.Key>();
            while (it.hasNext()) {
                Variable var = it.next();
                params.add(var.getKey());
            }
            if (params.size() > 0) {
                if (!this.showParamsOnly) {
                    this.listModel.addElement("------------ PARAMETERS ------------");
                }
                for (Variable.Key key : params) {
                    this.listModel.addElement(key);
                    seen.add(key);
                }
            }
        }
        if (!this.showParamsOnly) {
            ArrayList<Variable.Key> variables = new ArrayList<Variable.Key>();
            Iterator<Variable> vIt = this.selectedObject.getVariables();
            while (vIt.hasNext()) {
                Variable var = vIt.next();
                if (seen.contains(var.getKey())) continue;
                variables.add(var.getKey());
            }
            if (variables.size() > 0) {
                this.listModel.addElement("------------ VARIABLES ------------");
                for (Variable.Key key : variables) {
                    this.listModel.addElement(key);
                }
            }
        }
    }

    Variable getSelectedVariable() {
        int i = this.list.getSelectedIndex();
        if (i < 0) {
            return null;
        }
        Object selectedObj = this.list.getSelectedValue();
        if (selectedObj instanceof Variable.Key) {
            Variable.Key key = (Variable.Key)selectedObj;
            return this.selectedObject.getParameterOrVariable(key);
        }
        return null;
    }

    private Object getVariableObject(String text) {
        if (TextUtils.isANumber(text)) {
            double d;
            int i = TextUtils.atoi(text);
            if ((double)i == (d = TextUtils.atof(text))) {
                return new Integer(i);
            }
            return new Double(d);
        }
        return text;
    }

    void showSelectedAttribute(Variable.Key selectThisKey) {
        Variable var;
        if (selectThisKey != null) {
            this.list.setSelectedValue(selectThisKey, true);
        }
        if ((var = this.getSelectedVariable()) == null) {
            this.renameButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            return;
        }
        this.selectedVarKey = var.getKey();
        boolean oldLoading = this.loading;
        this.loading = true;
        String pt = this.initialName = this.getVariableText(var.getKey());
        this.name.setText(pt);
        this.initialValue = var.getPureValue(-1);
        String oldValue = this.value.getText();
        if (!oldValue.equals(this.initialValue)) {
            this.value.setText(this.initialValue);
        }
        if (var.getObject() instanceof Object[]) {
            this.value.setEditable(false);
        } else {
            this.value.setEditable(true);
        }
        this.loading = oldLoading;
        if (var.isCode()) {
            Object eval = VarContext.globalContext.evalVar(var);
            if (eval == null) {
                this.evaluation.setText("");
            } else {
                this.evaluation.setText(eval.toString());
            }
        } else {
            this.evaluation.setText("");
        }
        if (var.isDisplay()) {
            this.textPanel.setTextDescriptor(var.getKey(), this.selectedObject);
        } else {
            this.textPanel.setTextDescriptor(null, null);
        }
        this.attrPanel.setVariable(var.getKey(), this.selectedObject);
        this.newButton.setEnabled(false);
        this.renameButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
    }

    private String getVariableText(Variable.Key varKey) {
        String varName = varKey.getName();
        if (this.showParamsOnly && varName.startsWith("ATTR_")) {
            return varName.substring(5);
        }
        String betterName = Variable.betterVariableName(varName);
        if (betterName != null) {
            return betterName;
        }
        return varName;
    }

    private void initComponents() {
        this.which = new ButtonGroup();
        this.jSeparator1 = new JSeparator();
        this.debugSelect = new JPanel();
        this.currentCell = new JRadioButton();
        this.cellName = new JLabel();
        this.jLabel1 = new JLabel();
        this.currentNode = new JRadioButton();
        this.currentArc = new JRadioButton();
        this.currentPort = new JRadioButton();
        this.currentExport = new JRadioButton();
        this.body = new JPanel();
        this.mainLabel = new JLabel();
        this.listPane = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.name = new JTextField();
        this.jLabel11 = new JLabel();
        this.value = new JTextField();
        this.evaluation = new JLabel();
        this.evalLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.renameButton = new JButton();
        this.done = new JButton();
        this.applyToInstances = new JCheckBox();
        this.copyButton = new JButton();
        this.editValue = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Attributes");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Attributes.this.closeDialog(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.debugSelect.setLayout(new GridBagLayout());
        this.which.add(this.currentCell);
        this.currentCell.setText("On Current Cell:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.debugSelect.add((Component)this.currentCell, gridBagConstraints);
        this.cellName.setText("clock{sch}");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.debugSelect.add((Component)this.cellName, gridBagConstraints);
        this.jLabel1.setText("or Highlighted Object:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.debugSelect.add((Component)this.jLabel1, gridBagConstraints);
        this.which.add(this.currentNode);
        this.currentNode.setText(" Node");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.debugSelect.add((Component)this.currentNode, gridBagConstraints);
        this.which.add(this.currentArc);
        this.currentArc.setText(" Arc");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.debugSelect.add((Component)this.currentArc, gridBagConstraints);
        this.which.add(this.currentPort);
        this.currentPort.setText("Port on Node");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.debugSelect.add((Component)this.currentPort, gridBagConstraints);
        this.which.add(this.currentExport);
        this.currentExport.setText(" Export");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.debugSelect.add((Component)this.currentExport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.debugSelect, gridBagConstraints);
        this.body.setLayout(new GridBagLayout());
        this.mainLabel.setText("Parameters:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.body.add((Component)this.mainLabel, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(400, 100));
        this.listPane.setPreferredSize(new Dimension(400, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.body.add((Component)this.listPane, gridBagConstraints);
        this.jLabel2.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.jLabel2, gridBagConstraints);
        this.name.setText(" ");
        this.name.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Attributes.this.nameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.name, gridBagConstraints);
        this.jLabel11.setText("Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.jLabel11, gridBagConstraints);
        this.value.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.body.add((Component)this.evaluation, gridBagConstraints);
        this.evalLabel.setText("Evaluation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.evalLabel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.newButton.setText("Create New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.newButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.deleteButton, gridBagConstraints);
        this.renameButton.setText("Rename...");
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.renameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.renameButton, gridBagConstraints);
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.done(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.done, gridBagConstraints);
        this.applyToInstances.setText("Show new parameter on instances");
        this.applyToInstances.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.applyToInstances.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.applyToInstances, gridBagConstraints);
        this.copyButton.setText("Copy From Cell...");
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.copyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.copyButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.body.add((Component)this.jPanel1, gridBagConstraints);
        this.editValue.setText("Edit...");
        this.editValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Attributes.this.editValueActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.editValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.body, gridBagConstraints);
        this.pack();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        Variable var;
        CellBrowser dialog = new CellBrowser((Frame)TopLevel.getCurrentJFrame(), true, CellBrowser.DoAction.selectCellToCopy);
        dialog.setVisible(true);
        Cell cell = dialog.getSelectedCell();
        if (cell == null) {
            return;
        }
        HashSet<Variable.Key> seen = new HashSet<Variable.Key>();
        Iterator<Variable> it = cell.getParameters();
        while (it.hasNext()) {
            var = it.next();
            new CreateAttribute(var.getKey().getName(), var.getObject(), this.selectedObject, this, this.applyToInstances.isSelected(), var.getTextDescriptor(), UserInterfaceMain.getEditingPreferences());
            seen.add(var.getKey());
        }
        if (!this.showParamsOnly) {
            Iterator<Variable> vIt = cell.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (seen.contains(var.getKey())) continue;
                new CreateAttribute(var.getKey().getName(), var.getObject(), this.selectedObject, this, this.applyToInstances.isSelected(), var.getTextDescriptor(), UserInterfaceMain.getEditingPreferences());
            }
        }
    }

    private void editValueActionPerformed(ActionEvent evt) {
        String editedValue = JOptionPane.showInputDialog("New Value:", (Object)this.value.getText());
        if (editedValue == null) {
            return;
        }
        this.value.setText(editedValue);
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        Variable var;
        String newName = (String)JOptionPane.showInputDialog(this, "New name for " + this.name.getText(), "Rename Attribute", 3, null, null, this.name.getText());
        if (newName == null) {
            return;
        }
        if ((newName = newName.trim()).equals("")) {
            JOptionPane.showMessageDialog(this, "Attribute name must not be empty", "Invalid Input", 0);
            return;
        }
        if (newName.equals(this.name.getText())) {
            return;
        }
        if (this.showParamsOnly) {
            newName = "ATTR_" + newName;
        }
        if ((var = this.selectedObject.getParameterOrVariable(Variable.newKey(newName))) != null) {
            JOptionPane.showMessageDialog(this, "Attribute of that name already exists", "No Action Taken", 0);
            return;
        }
        Variable selVar = this.getSelectedVariable();
        if (selVar != null) {
            new RenameAttribute(selVar.getKey().getName(), newName, this.selectedObject);
        }
        if (this.showParamsOnly) {
            newName = newName.substring(5);
        }
        this.initialName = newName;
        this.name.setText(newName);
    }

    private void nameKeyReleased(KeyEvent evt) {
        this.checkName();
    }

    private void done(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        EditingPreferences ep = UserInterfaceMain.getEditingPreferences();
        String varName = this.name.getText().trim();
        if (varName.trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Attribute name must not be empty", "Invalid Input", 2);
            return;
        }
        if (this.showParamsOnly) {
            varName = "ATTR_" + varName;
        }
        if (this.selectedObject.getParameterOrVariable(Variable.newKey(varName)) != null) {
            JOptionPane.showMessageDialog(null, "Can't create new attribute " + varName + ", already exists", "Invalid Action", 2);
            return;
        }
        String val = this.value.getText().trim();
        new CreateAttribute(varName, this.getVariableObject(val), this.selectedObject, this, this.applyToInstances.isSelected(), null, ep);
        this.initialName = varName;
        this.initialValue = val;
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        Variable var = this.getSelectedVariable();
        if (var != null) {
            new DeleteAttribute(var, this.selectedObject);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    private class VariableCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private VariableCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Variable.Key) {
                this.setText(Attributes.this.getVariableText((Variable.Key)value));
            } else if (value instanceof Variable) {
                this.setText(Attributes.this.getVariableText(((Variable)value).getKey()));
            } else {
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private static class ChangeAttribute
    extends Job {
        private Variable.Key varKey;
        private ElectricObject owner;
        private Object newValue;

        protected ChangeAttribute(Variable.Key varKey, ElectricObject owner, Object newValue) {
            super("Change Attribute", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.varKey = varKey;
            this.owner = owner;
            this.newValue = newValue;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            Variable var = this.owner.getParameterOrVariable(this.varKey);
            if (var == null) {
                throw new JobException("Could not update Attribute " + this.varKey + ": it does not exist");
            }
            this.newValue = Variable.withCode(this.newValue, var.getCode());
            if (this.owner instanceof Cell && this.owner.isParam(this.varKey)) {
                Cell.CellGroup cg = ((Cell)this.owner).getCellGroup();
                cg.updateParam((Variable.AttrKey)this.varKey, this.newValue, var.getUnit());
            } else {
                var = this.owner.updateVar(this.varKey, this.newValue, ep);
                if (var == null) {
                    throw new JobException("Error updating Attribute " + this.varKey);
                }
            }
            return true;
        }
    }

    private static class RenameAttribute
    extends Job {
        private String varName;
        private String newVarName;
        private ElectricObject owner;

        protected RenameAttribute(String varName, String newVarName, ElectricObject owner) {
            super("Rename Attribute", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.varName = varName;
            this.newVarName = newVarName;
            this.owner = owner;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Variable.Key varKey = Variable.newKey(this.varName);
            if (this.owner.isParam(varKey)) {
                if (this.owner instanceof Cell) {
                    Variable.AttrKey newParamKey = (Variable.AttrKey)Variable.newKey(this.newVarName);
                    ((Cell)this.owner).getCellGroup().renameParam((Variable.AttrKey)varKey, newParamKey);
                } else if (this.owner instanceof NodeInst) {
                    System.out.println("Can't rename parameter on instance. Rename it on icon cell.");
                }
            } else {
                Variable var = this.owner.renameVar(this.varName, this.newVarName);
                if (var == null) {
                    System.out.println("Rename of variable failed");
                    return false;
                }
            }
            return true;
        }
    }

    private static class CreateAttribute
    extends Job {
        private ElectricObject owner;
        private Variable newVar;
        private boolean addToInstances;
        private transient Attributes dialog;

        private CreateAttribute(String newName, Object newValue, ElectricObject owner, Attributes dialog, boolean addToInstances, TextDescriptor useThis, EditingPreferences ep) {
            super("Create Attribute", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.owner = owner;
            this.dialog = dialog;
            this.addToInstances = addToInstances;
            TextDescriptor td = useThis;
            if (useThis == null) {
                if (owner instanceof Cell) {
                    td = ep.getCellTextDescriptor().withParam(true).withInherit(true);
                } else if (owner instanceof NodeInst) {
                    td = ep.getNodeTextDescriptor();
                } else if (owner instanceof ArcInst) {
                    td = ep.getArcTextDescriptor();
                } else if (owner instanceof Export) {
                    td = ep.getExportTextDescriptor();
                } else if (owner instanceof PortInst) {
                    td = ep.getPortInstTextDescriptor();
                } else {
                    return;
                }
                td = dialog.attrPanel.withPanelValues(td);
                td = dialog.textPanel.withPanelValues(td);
                if (owner instanceof Cell) {
                    Point2D offset = ((Cell)owner).newVarOffset();
                    td = td.withOff(offset.getX(), offset.getY());
                }
            }
            newValue = dialog.attrPanel.withPanelCode(newValue);
            this.newVar = Variable.newInstance(Variable.newKey(newName), newValue, td);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (this.owner.getParameterOrVariable(this.newVar.getKey()) != null) {
                throw new JobException("Can't create new attribute " + this.newVar + ", already exists");
            }
            if (this.owner instanceof Cell && this.newVar.getTextDescriptor().isParam()) {
                Cell c = (Cell)this.owner;
                if (c.isLayout()) {
                    System.out.println("Paramters are only valid for schematic/icon cells");
                    return false;
                }
                Cell.CellGroup group = c.getCellGroup();
                if (group != null) {
                    group.addParam(this.newVar);
                }
                this.owner.setTextDescriptor(this.newVar.getKey(), this.newVar.getTextDescriptor());
                if (this.addToInstances) {
                    for (Cell cell : ((Cell)this.owner).getCellsInGroup()) {
                        if (!cell.isIcon()) continue;
                        Iterator<NodeInst> nIt = cell.getInstancesOf();
                        while (nIt.hasNext()) {
                            NodeInst ni = nIt.next();
                            CircuitChangeJobs.inheritCellParameter(this.newVar, ni, ep);
                        }
                    }
                }
            } else if (this.owner instanceof NodeInst && ((NodeInst)this.owner).isParam(this.newVar.getKey())) {
                ((NodeInst)this.owner).addParameter(this.newVar.withParam(true));
            } else {
                this.owner.addVar(this.newVar);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            this.dialog.updateList();
            this.dialog.showSelectedAttribute(this.newVar.getKey());
        }
    }

    private static class DeleteAttribute
    extends Job {
        private Variable var;
        private ElectricObject owner;

        private DeleteAttribute(Variable var, ElectricObject owner) {
            super("Delete Attribute", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.var = var;
            this.owner = owner;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.var == null) {
                return false;
            }
            Variable.Key varKey = this.var.getKey();
            if (this.owner.isParam(varKey)) {
                if (this.owner instanceof Cell) {
                    Cell.CellGroup cg = ((Cell)this.owner).getCellGroup();
                    if (cg != null) {
                        cg.delParam((Variable.AttrKey)varKey);
                    }
                } else if (this.owner instanceof NodeInst) {
                    ((NodeInst)this.owner).delParameter(varKey);
                }
            } else {
                this.owner.delVar(varKey);
            }
            return true;
        }
    }

    private static class TextInfoDocumentListener
    implements DocumentListener {
        Attributes dialog;

        TextInfoDocumentListener(Attributes dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.dialog.fieldChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.dialog.fieldChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.dialog.fieldChanged();
        }
    }
}

