/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.interval;

import com.sun.electric.util.math.MutableInterval;
import java.util.LinkedList;

public class ExprEval {
    private LinkedList<Expr> el = new LinkedList();
    private boolean printDetailed = false;
    boolean hasBoth = false;

    public void printAll(boolean detailed) {
        this.printDetailed = detailed;
        for (Expr e : this.el) {
            System.out.println((e.name != null ? e.name : "_") + "." + e.id + " = " + e);
        }
        this.printDetailed = false;
    }

    public void calcAll() {
        for (Expr e : this.el) {
            e.calcVal();
        }
    }

    public boolean calcIntervalAll() {
        this.hasBoth = false;
        for (Expr e : this.el) {
            e.calcInterval();
        }
        return this.hasBoth;
    }

    public DoubleConstExpr newConst() {
        return new DoubleConstExpr(0.0);
    }

    public DoubleConstExpr newConst(double v) {
        return new DoubleConstExpr(v);
    }

    class BooleanCompExpr
    extends BooleanExpr {
        static final int BOP_LT = 1;
        static final int BOP_GT = 2;
        static final int BOP_LE = 3;
        static final int BOP_GE = 4;
        private DoubleExpr e1;
        private int bop;
        private DoubleExpr e2;

        BooleanCompExpr(DoubleExpr e1, int bop, DoubleExpr e2) {
            this.e1 = e1;
            this.bop = bop;
            this.e2 = e2;
            this.calcVal();
        }

        @Override
        String toString(int prio) {
            String s2 = null;
            switch (this.bop) {
                case 1: {
                    s2 = " < ";
                    break;
                }
                case 2: {
                    s2 = " > ";
                    break;
                }
                case 3: {
                    s2 = " <= ";
                    break;
                }
                case 4: {
                    s2 = " >= ";
                }
            }
            s2 = this.e1.refString(3) + s2 + this.e2.refString(3);
            if (prio > 2) {
                s2 = "( " + s2 + ") ";
            }
            return s2;
        }

        @Override
        void calcVal() {
            switch (this.bop) {
                case 1: {
                    this.setV(this.e1.v() < this.e2.v());
                    break;
                }
                case 2: {
                    this.setV(this.e1.v() > this.e2.v());
                    break;
                }
                case 3: {
                    this.setV(this.e1.v() <= this.e2.v());
                    break;
                }
                case 4: {
                    this.setV(this.e1.v() >= this.e2.v());
                }
            }
        }

        @Override
        void calcInterval() {
            boolean c = false;
            boolean p = false;
            MutableInterval l = this.e1.iv();
            MutableInterval r = this.e2.iv();
            switch (this.bop) {
                case 1: {
                    c = l.clt(r);
                    p = l.plt(r);
                    break;
                }
                case 2: {
                    c = l.cgt(r);
                    p = l.pgt(r);
                    break;
                }
                case 3: {
                    c = l.cle(r);
                    p = l.ple(r);
                    break;
                }
                case 4: {
                    c = l.cge(r);
                    p = l.pge(r);
                }
            }
            this.setIBoth(c != p);
            this.setV(c);
        }
    }

    class BooleanBinopExpr
    extends BooleanExpr {
        static final int BOP_AND = 1;
        static final int BOP_OR = 2;
        private BooleanExpr e1;
        private int bop;
        private BooleanExpr e2;

        BooleanBinopExpr(BooleanExpr e1, int bop, BooleanExpr e2) {
            this.e1 = e1;
            this.bop = bop;
            this.e2 = e2;
            this.calcVal();
        }

        @Override
        String toString(int prio) {
            String s2 = null;
            switch (this.bop) {
                case 1: {
                    s2 = " && ";
                    break;
                }
                case 2: {
                    s2 = " || ";
                }
            }
            s2 = this.e1.refString(2) + s2 + this.e2.refString(2);
            if (prio > 1) {
                s2 = "( " + s2 + ") ";
            }
            return s2;
        }

        @Override
        void calcVal() {
            switch (this.bop) {
                case 1: {
                    this.setV(this.e1.v() && this.e2.v());
                    break;
                }
                case 2: {
                    this.setV(this.e1.v() || this.e2.v());
                }
            }
        }

        @Override
        void calcInterval() {
            switch (this.bop) {
                case 1: {
                    if (this.e1.iboth() && this.e2.iboth() || this.e1.iboth() && this.e2.v() || this.e2.iboth() && this.e1.v()) {
                        this.setIBoth(true);
                        break;
                    }
                    this.setIBoth(false);
                    this.setV(this.e1.v() && this.e2.v());
                    break;
                }
                case 2: {
                    if (this.e1.iboth() && this.e2.iboth() || this.e1.iboth() && !this.e2.v() || this.e2.iboth() && !this.e1.v()) {
                        this.setIBoth(true);
                        break;
                    }
                    this.setIBoth(false);
                    this.setV(this.e1.v() || this.e2.v());
                }
            }
        }
    }

    public abstract class BooleanExpr
    extends Expr {
        private boolean v;
        private boolean iboth;

        final boolean v() {
            return this.v;
        }

        final void setV(boolean v) {
            this.v = v;
        }

        final boolean iboth() {
            return this.iboth;
        }

        final void setIBoth(boolean v) {
            this.iboth = v;
        }

        public DoubleExpr ite(DoubleExpr th, DoubleExpr el) {
            return new DoubleIteExpr(this, th, el);
        }

        BooleanExpr or(BooleanExpr be) {
            return new BooleanBinopExpr(this, 2, be);
        }

        BooleanBinopExpr and(BooleanExpr be) {
            return new BooleanBinopExpr(this, 1, be);
        }

        @Override
        String valString() {
            return "" + this.v();
        }

        @Override
        String intervalString() {
            return this.iboth() ? "both" : this.valString();
        }
    }

    class DoubleIteExpr
    extends DoubleExpr {
        private BooleanExpr cond;
        private DoubleExpr th;
        private DoubleExpr el;

        DoubleIteExpr(BooleanExpr cond, DoubleExpr th, DoubleExpr el) {
            this.cond = cond;
            this.th = th;
            this.el = el;
            this.calcVal();
        }

        @Override
        String toString(int prio) {
            String s2 = null;
            s2 = this.cond.refString(1) + " ? " + this.th.refString(1) + " : " + this.el.refString(0);
            if (prio > 0) {
                s2 = "( " + s2 + " )";
            }
            return s2;
        }

        @Override
        void calcVal() {
            this.setV(this.cond.v() ? this.th.v() : this.el.v());
        }

        @Override
        void calcInterval() {
            MutableInterval t = this.th.iv();
            MutableInterval e = this.el.iv();
            if (this.cond.iboth()) {
                this.iv.assign(t).interval_hull(e);
                ExprEval.this.hasBoth = true;
            } else if (this.cond.v()) {
                this.iv.assign(t);
            } else {
                this.iv.assign(e);
            }
        }
    }

    class DoubleFunExpr
    extends DoubleExpr {
        static final int FUN1_EXP = 1;
        static final int FUN1_LOG = 2;
        static final int FUN1_ABS = 3;
        private int fun;
        private DoubleExpr e1;

        DoubleFunExpr(int fun, DoubleExpr e1) {
            this.fun = fun;
            this.e1 = e1;
            this.calcVal();
        }

        @Override
        String toString(int prio) {
            String s2 = null;
            switch (this.fun) {
                case 1: {
                    s2 = "exp( ";
                    break;
                }
                case 2: {
                    s2 = "log( ";
                    break;
                }
                case 3: {
                    s2 = "abs( ";
                }
            }
            s2 = s2 + this.e1.refString(0) + " )";
            return s2;
        }

        @Override
        void calcVal() {
            switch (this.fun) {
                case 1: {
                    this.setV(Math.exp(this.e1.v()));
                    break;
                }
                case 2: {
                    this.setV(Math.log(this.e1.v()));
                    break;
                }
                case 3: {
                    this.setV(Math.abs(this.e1.v()));
                }
            }
        }

        @Override
        void calcInterval() {
            MutableInterval a = this.e1.iv();
            switch (this.fun) {
                case 1: {
                    this.iv.assign(a).exp();
                    break;
                }
                case 2: {
                    this.iv.assign(a).log();
                    break;
                }
                case 3: {
                    this.iv.assign(a).abs();
                }
            }
        }
    }

    class DoubleUnopExpr
    extends DoubleExpr {
        static final int UOP_NEG = 1;
        private int uop;
        private DoubleExpr e1;

        DoubleUnopExpr(int uop, DoubleExpr e1) {
            this.uop = uop;
            this.e1 = e1;
            this.calcVal();
        }

        @Override
        String toString(int prio) {
            String s2 = null;
            switch (this.uop) {
                case 1: {
                    s2 = "- ";
                }
            }
            s2 = s2 + this.e1.refString(4);
            if (prio > 3) {
                s2 = "( " + s2 + " )";
            }
            return s2;
        }

        @Override
        void calcVal() {
            switch (this.uop) {
                case 1: {
                    this.setV(-this.e1.v());
                }
            }
        }

        @Override
        void calcInterval() {
            switch (this.uop) {
                case 1: {
                    this.iv.assign(this.e1.iv()).negate();
                }
            }
        }
    }

    class DoubleBinopExpr
    extends DoubleExpr {
        static final int BOP_PLUS = 1;
        static final int BOP_MINUS = 2;
        static final int BOP_TIMES = 3;
        static final int BOP_SLASH = 4;
        private DoubleExpr e1;
        private int bop;
        private DoubleExpr e2;

        DoubleBinopExpr(DoubleExpr e1, int bop, DoubleExpr e2) {
            this.e1 = e1;
            this.bop = bop;
            this.e2 = e2;
            this.calcVal();
        }

        @Override
        String toString(int prio) {
            String s2 = null;
            int pr = 0;
            switch (this.bop) {
                case 1: {
                    s2 = " + ";
                    pr = 3;
                    break;
                }
                case 2: {
                    s2 = " - ";
                    pr = 3;
                    break;
                }
                case 3: {
                    s2 = " * ";
                    pr = 4;
                    break;
                }
                case 4: {
                    s2 = " / ";
                    pr = 4;
                }
            }
            s2 = this.e1.refString(pr) + s2 + this.e2.refString(pr + 1);
            if (prio > pr) {
                s2 = "( " + s2 + " )";
            }
            return s2;
        }

        @Override
        void calcVal() {
            switch (this.bop) {
                case 1: {
                    this.setV(this.e1.v() + this.e2.v());
                    break;
                }
                case 2: {
                    this.setV(this.e1.v() - this.e2.v());
                    break;
                }
                case 3: {
                    this.setV(this.e1.v() * this.e2.v());
                    break;
                }
                case 4: {
                    this.setV(this.e1.v() / this.e2.v());
                }
            }
        }

        @Override
        void calcInterval() {
            switch (this.bop) {
                case 1: {
                    this.iv.assign(this.e1.iv()).add(this.e2.iv());
                    break;
                }
                case 2: {
                    this.iv.assign(this.e1.iv()).sub(this.e2.iv());
                    break;
                }
                case 3: {
                    this.iv.assign(this.e1.iv()).mul(this.e2.iv());
                    break;
                }
                case 4: {
                    this.iv.assign(this.e1.iv()).div(this.e2.iv());
                }
            }
        }
    }

    public class DoubleConstExpr
    extends DoubleExpr {
        DoubleConstExpr(double v) {
            this.setV(v);
            this.iv.assign(v);
        }

        public void setInterval(double lo, double hi) {
            this.iv.assign(lo, hi);
        }

        @Override
        String toString(int prio) {
            return "" + this.v();
        }

        @Override
        void calcVal() {
        }

        @Override
        void calcInterval() {
        }
    }

    public abstract class DoubleExpr
    extends Expr {
        private double v;
        MutableInterval iv;

        DoubleExpr() {
            this.v = 0.0;
            this.iv = new MutableInterval();
        }

        public double v() {
            return this.v;
        }

        public void setV(double v) {
            this.v = v;
        }

        final MutableInterval iv() {
            return this.iv;
        }

        public double inf() {
            return this.iv.inf();
        }

        public double sup() {
            return this.iv.sup();
        }

        public DoubleExpr add(DoubleExpr augend) {
            return new DoubleBinopExpr(this, 1, augend);
        }

        public DoubleExpr subtract(DoubleExpr subtrahend) {
            return new DoubleBinopExpr(this, 2, subtrahend);
        }

        public DoubleExpr multiply(DoubleExpr multiplicand) {
            return new DoubleBinopExpr(this, 3, multiplicand);
        }

        public DoubleExpr divide(DoubleExpr divisor) {
            return new DoubleBinopExpr(this, 4, divisor);
        }

        public DoubleExpr negate() {
            return new DoubleUnopExpr(1, this);
        }

        public DoubleExpr exp() {
            return new DoubleFunExpr(1, this);
        }

        public DoubleExpr log() {
            return new DoubleFunExpr(2, this);
        }

        public DoubleExpr abs() {
            return new DoubleFunExpr(3, this);
        }

        public BooleanExpr lt(DoubleExpr e) {
            return new BooleanCompExpr(this, 1, e);
        }

        public BooleanExpr gt(DoubleExpr e) {
            return new BooleanCompExpr(this, 2, e);
        }

        public BooleanExpr le(DoubleExpr e) {
            return new BooleanCompExpr(this, 3, e);
        }

        public BooleanExpr ge(DoubleExpr e) {
            return new BooleanCompExpr(this, 4, e);
        }

        @Override
        String valString() {
            return "" + this.v();
        }

        @Override
        String intervalString() {
            return this.iv().toString();
        }
    }

    abstract class Expr {
        private String name;
        private int id;

        Expr() {
            this.id = ExprEval.this.el.size();
            ExprEval.this.el.add(this);
        }

        String name() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.toString(0);
        }

        abstract String toString(int var1);

        String refString(int prio) {
            return (this.name != null ? this.name : "_") + "." + this.id;
        }

        abstract void calcVal();

        abstract void calcInterval();

        abstract String valString();

        abstract String intervalString();
    }
}

