/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevisionJ;
import com.sun.electric.database.CellRevisionProvider;
import com.sun.electric.database.CellUsageInfo;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.UsageCollector;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.util.collections.ImmutableArrayList;
import com.sun.electric.util.collections.ImmutableList;
import com.sun.electric.util.memory.ObjSize;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class CellRevision {
    public static boolean ALLOW_SUBCELLS_IN_ICON = false;
    public static final CellRevision[] NULL_ARRAY = new CellRevision[0];
    public static final ImmutableArrayList<CellRevision> EMPTY_LIST = ImmutableArrayList.of(new Object[0]);
    protected static final BitSet EMPTY_BITSET = new BitSet();
    protected static final int[] NULL_INT_ARRAY = new int[0];
    static final CellUsageInfo[] NULL_CELL_USAGE_INFO_ARRAY = new CellUsageInfo[0];
    static int cellRevisionsCreated = 0;
    public final ImmutableCell d;
    public final ImmutableNodeInst.Iterable nodes;
    public final ImmutableArcInst.Iterable arcs;
    final int[] arcIndex;
    public final ImmutableExport.Iterable exports;
    int[] exportIndex;
    final BitSet techUsages;
    final CellUsageInfo[] cellUsages;
    final BitSet definedExports;
    final int definedExportsLength;
    final BitSet deletedExports;
    private static Field BitSet_words;

    CellRevision(ImmutableCell d, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        this.d = d;
        this.nodes = nodes;
        this.arcs = arcs;
        this.arcIndex = arcIndex;
        this.exports = exports;
        this.exportIndex = exportIndex;
        this.techUsages = techUsages;
        this.cellUsages = cellUsages;
        this.definedExports = definedExports;
        this.definedExportsLength = definedExportsLength;
        this.deletedExports = deletedExports;
        ++cellRevisionsCreated;
    }

    protected static BitSet makeTechUsages(TechId techId) {
        BitSet techUsages = new BitSet();
        techUsages.set(techId.techIndex);
        return techUsages;
    }

    public static CellRevisionProvider getProvider() {
        return CellRevisionProvider.INSTANCE;
    }

    public static CellRevision newInstance(ImmutableCell d) {
        return CellRevision.getProvider().createCellRevision(d);
    }

    abstract CellRevision lowLevelWith(ImmutableCell var1, ImmutableNodeInst.Iterable var2, ImmutableArcInst.Iterable var3, int[] var4, ImmutableExport.Iterable var5, int[] var6, BitSet var7, CellUsageInfo[] var8, BitSet var9, int var10, BitSet var11);

    public CellRevision withRevisionDate(long revisionDate) {
        if (this.d.revisionDate == revisionDate) {
            return this;
        }
        return this.lowLevelWith(this.d.withRevisionDate(revisionDate), this.nodes, this.arcs, this.arcIndex, this.exports, this.exportIndex, this.techUsages, this.cellUsages, this.definedExports, this.definedExportsLength, this.deletedExports);
    }

    public CellRevision with(ImmutableCell d, ImmutableNodeInst[] nodesArray, ImmutableArcInst[] arcsArray, ImmutableExport[] exportsArray) {
        ImmutableNodeInst.Iterable nodes = CellRevision.getProvider().createNodeList(nodesArray, this.nodes);
        ImmutableArcInst.Iterable arcs = CellRevision.getProvider().createArcList(arcsArray, this.arcs);
        ImmutableExport.Iterable exports = CellRevision.getProvider().createExportList(exportsArray, this.exports);
        if (this.d == d && this.nodes == nodes && this.arcs == arcs && this.exports == exports) {
            return this;
        }
        CellId cellId = d.cellId;
        boolean busNamesAllowed = d.busNamesAllowed();
        if (this.d != d && d.techId == null) {
            throw new NullPointerException("tech");
        }
        BitSet techUsages = this.techUsages;
        CellUsageInfo[] cellUsages = this.cellUsages;
        if (this.d.cellId != d.cellId || this.d.techId != d.techId || this.d.getVars() != d.getVars() || nodes != this.nodes || arcs != this.arcs || exports != this.exports) {
            UsageCollector uc = new UsageCollector(d, nodes, arcs, exports);
            techUsages = uc.getTechUsages(this.techUsages);
            cellUsages = uc.getCellUsages(this.cellUsages);
        }
        if (!ALLOW_SUBCELLS_IN_ICON && cellId.isIcon() && cellUsages.length != 0) {
            throw new IllegalArgumentException("Icon contains subcells");
        }
        if (nodes != this.nodes) {
            boolean hasCellCenter = false;
            for (ImmutableNodeInst n : nodes) {
                if (ImmutableNodeInst.isCellCenter(n.protoId)) {
                    if (hasCellCenter) {
                        throw new IllegalArgumentException("Duplicate cell center");
                    }
                    hasCellCenter = true;
                }
                if (busNamesAllowed || !n.name.isBus()) continue;
                throw new IllegalArgumentException("arrayedName " + n.name);
            }
        }
        int[] arcIndex = this.arcIndex;
        if (arcs != this.arcs) {
            boolean sameArcIdAndIndex = true;
            boolean sameArcIndex = arcs.size() == this.arcs.size();
            int arcIndexLength = 0;
            int arcInd = 0;
            Iterator<ImmutableArcInst> oldArcs = this.arcs.iterator();
            for (ImmutableArcInst a : arcs) {
                sameArcIdAndIndex = sameArcIdAndIndex && a.arcId == arcInd;
                sameArcIndex = sameArcIndex && a.arcId == oldArcs.next().arcId;
                arcIndexLength = Math.max(arcIndexLength, a.arcId + 1);
                if (!busNamesAllowed && a.name.isBus()) {
                    throw new IllegalArgumentException("arrayedName " + a.name);
                }
                ++arcInd;
            }
            if (sameArcIdAndIndex) {
                arcIndex = null;
            } else if (!sameArcIndex) {
                arcIndex = new int[arcIndexLength];
                Arrays.fill(arcIndex, -1);
                arcInd = 0;
                for (ImmutableArcInst a : arcs) {
                    int arcId = a.arcId;
                    if (arcIndex[arcId] >= 0) {
                        throw new IllegalArgumentException("arcChronIndex");
                    }
                    arcIndex[arcId] = arcInd++;
                }
                assert (!Arrays.equals(this.arcIndex, arcIndex));
            }
        }
        int[] exportIndex = this.exportIndex;
        BitSet definedExports = this.definedExports;
        int definedExportsLength = this.definedExportsLength;
        BitSet deletedExports = this.deletedExports;
        if (exports != this.exports) {
            int chronIndex;
            boolean sameExportIndex = exports.size() == this.exports.size();
            int exportIndexLength = 0;
            int exportInd = 0;
            Iterator<ImmutableExport> oldExports = this.exports.iterator();
            for (ImmutableExport e : exports) {
                if (e.exportId.parentId != cellId) {
                    throw new IllegalArgumentException("exportId");
                }
                if (!busNamesAllowed && e.name.isBus()) {
                    throw new IllegalArgumentException("arrayedName " + e.name);
                }
                chronIndex = e.exportId.chronIndex;
                sameExportIndex = sameExportIndex && chronIndex == oldExports.next().exportId.chronIndex;
                exportIndexLength = Math.max(exportIndexLength, chronIndex + 1);
                ++exportInd;
            }
            if (!sameExportIndex) {
                exportIndex = new int[exportIndexLength];
                Arrays.fill(exportIndex, -1);
                exportInd = 0;
                for (ImmutableExport e : exports) {
                    chronIndex = e.exportId.chronIndex;
                    if (exportIndex[chronIndex] >= 0) {
                        throw new IllegalArgumentException("exportChronIndex");
                    }
                    exportIndex[chronIndex] = exportInd++;
                }
                assert (!Arrays.equals(this.exportIndex, exportIndex));
                definedExports = new BitSet();
                for (int chronIndex2 = 0; chronIndex2 < exportIndex.length; ++chronIndex2) {
                    if (exportIndex[chronIndex2] < 0) continue;
                    definedExports.set(chronIndex2);
                }
                if ((definedExports = UsageCollector.bitSetWith(this.definedExports, definedExports)) != this.definedExports) {
                    definedExportsLength = definedExports.length();
                    deletedExports = new BitSet();
                    deletedExports.set(0, definedExportsLength);
                    deletedExports.andNot(definedExports);
                    deletedExports = UsageCollector.bitSetWith(this.deletedExports, deletedExports);
                }
            }
        }
        return this.lowLevelWith(d, nodes, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
    }

    CellRevision withRenamedIds(IdMapper idMapper, CellName newGroupName) {
        ImmutableCell d = this.d.withRenamedIds(idMapper).withGroupName(newGroupName);
        ImmutableNodeInst[] nodesArray = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            ImmutableNodeInst oldNode = this.nodes.get(i);
            ImmutableNodeInst newNode = oldNode.withRenamedIds(idMapper);
            if (newNode != oldNode && nodesArray == null) {
                nodesArray = new ImmutableNodeInst[this.nodes.size()];
                for (int j = 0; j < i; ++j) {
                    nodesArray[j] = this.nodes.get(j);
                }
            }
            if (nodesArray == null) continue;
            nodesArray[i] = newNode;
        }
        ImmutableArcInst[] arcsArray = null;
        for (int i = 0; i < this.arcs.size(); ++i) {
            ImmutableArcInst oldArc = this.arcs.get(i);
            ImmutableArcInst newArc = oldArc.withRenamedIds(idMapper);
            if (newArc != oldArc && arcsArray == null) {
                arcsArray = new ImmutableArcInst[this.arcs.size()];
                for (int j = 0; j < i; ++j) {
                    arcsArray[j] = this.arcs.get(j);
                }
            }
            if (arcsArray == null) continue;
            arcsArray[i] = newArc;
        }
        ImmutableExport[] exportsArray = null;
        for (int i = 0; i < this.exports.size(); ++i) {
            ImmutableExport oldExport = this.exports.get(i);
            ImmutableExport newExport = oldExport.withRenamedIds(idMapper);
            if (newExport != oldExport && exportsArray == null) {
                exportsArray = new ImmutableExport[this.exports.size()];
                for (int j = 0; j < i; ++j) {
                    exportsArray[j] = this.exports.get(j);
                }
            }
            if (exportsArray == null) continue;
            exportsArray[i] = newExport;
        }
        if (this.d == d && nodesArray == null && arcsArray == null && exportsArray == null) {
            return this;
        }
        CellRevision newRevision = this.with(d, nodesArray, arcsArray, exportsArray);
        return newRevision;
    }

    public ImmutableNodeInst getNodeById(int nodeId) {
        return this.nodes.getNodeById(nodeId);
    }

    public int getNodeIndexByNodeId(int nodeId) {
        return this.nodes.getNodeIndexByNodeId(nodeId);
    }

    public boolean hasNodeWithId(int nodeId) {
        return this.nodes.hasNodeWithId(nodeId);
    }

    public int getMaxNodeId() {
        return this.nodes.getMaxNodeId();
    }

    public ImmutableArcInst getArcById(int arcId) {
        if (this.arcIndex == null) {
            return arcId < this.arcs.size() ? this.arcs.get(arcId) : null;
        }
        if (arcId >= this.arcIndex.length) {
            return null;
        }
        int arcInd = this.arcIndex[arcId];
        return arcInd >= 0 ? this.arcs.get(arcInd) : null;
    }

    public int getArcIndexByArcId(int arcId) {
        int arcInd;
        int n = arcInd = this.arcIndex != null ? this.arcIndex[arcId] : arcId;
        assert (0 <= arcInd && arcInd < this.arcs.size());
        return arcInd;
    }

    public int getMaxArcId() {
        return (this.arcIndex != null ? this.arcIndex.length : this.arcs.size()) - 1;
    }

    public ImmutableExport getExport(ExportId exportId) {
        if (exportId.parentId != this.d.cellId) {
            throw new IllegalArgumentException();
        }
        int chronIndex = exportId.chronIndex;
        if (chronIndex >= this.exportIndex.length) {
            return null;
        }
        int portIndex = this.exportIndex[chronIndex];
        return portIndex >= 0 ? this.exports.get(portIndex) : null;
    }

    public int getExportIndexByExportId(ExportId exportId) {
        if (exportId.parentId != this.d.cellId) {
            throw new IllegalArgumentException();
        }
        int chronIndex = exportId.chronIndex;
        return chronIndex < this.exportIndex.length ? this.exportIndex[chronIndex] : -1;
    }

    public int getMaxExportChronIndex() {
        return this.exportIndex.length - 1;
    }

    public int[] getInstCounts() {
        int l;
        for (l = this.cellUsages.length; l > 0 && (this.cellUsages[l - 1] == null || this.cellUsages[l - 1].instCount == 0); --l) {
        }
        if (l == 0) {
            return NULL_INT_ARRAY;
        }
        int[] instCounts = new int[l];
        for (int indexInParent = 0; indexInParent < l; ++indexInParent) {
            if (this.cellUsages[indexInParent] == null) continue;
            instCounts[indexInParent] = this.cellUsages[indexInParent].instCount;
        }
        return instCounts;
    }

    public int getInstCount(CellUsage u) {
        if (u.parentId != this.d.cellId) {
            throw new IllegalArgumentException();
        }
        if (u.indexInParent >= this.cellUsages.length) {
            return 0;
        }
        CellUsageInfo cui = this.cellUsages[u.indexInParent];
        if (cui == null) {
            return 0;
        }
        return cui.instCount;
    }

    public Set<TechId> getTechUsages() {
        LinkedHashSet<TechId> techUsagesSet = new LinkedHashSet<TechId>();
        for (int techIndex = 0; techIndex < this.techUsages.length(); ++techIndex) {
            if (!this.techUsages.get(techIndex)) continue;
            techUsagesSet.add(this.d.cellId.idManager.getTechId(techIndex));
        }
        return techUsagesSet;
    }

    public abstract boolean hasConnectionsOnNode(ImmutableNodeInst var1);

    public abstract int getNumConnectionsOnNode(ImmutableNodeInst var1);

    public abstract List<ImmutableArcInst> getConnectionsOnNode(BitSet var1, ImmutableNodeInst var2);

    public abstract boolean hasConnectionsOnPort(ImmutableNodeInst var1, PortProtoId var2);

    public abstract int getNumConnectionsOnPort(ImmutableNodeInst var1, PortProtoId var2);

    public abstract List<ImmutableArcInst> getConnectionsOnPort(BitSet var1, ImmutableNodeInst var2, PortProtoId var3);

    public abstract boolean hasExportsOnNode(ImmutableNodeInst var1);

    public abstract int getNumExportsOnNode(ImmutableNodeInst var1);

    public abstract Iterator<ImmutableExport> getExportsOnNode(ImmutableNodeInst var1);

    public abstract boolean hasExportsOnPort(ImmutableNodeInst var1, PortProtoId var2);

    public abstract int getNumExportsOnPort(ImmutableNodeInst var1, PortProtoId var2);

    public abstract Iterator<ImmutableExport> getExportsOnPort(ImmutableNodeInst var1, PortProtoId var2);

    public abstract long getConnectivityMemorySize(ObjSize var1, boolean var2);

    public long getOldConnectivityMemorySize(ObjSize objSize) {
        return objSize.sizeOfArray(Integer.TYPE, 2 * this.arcs.size()) + objSize.sizeOfArray(ImmutableExport.class, this.exports.size());
    }

    public boolean pinUseCount(ImmutableNodeInst pin) {
        int numConnections = this.getNumConnectionsOnNode(pin);
        if (numConnections > 2) {
            return false;
        }
        if (this.hasExportsOnNode(pin)) {
            return true;
        }
        return numConnections != 0;
    }

    void write(IdWriter writer) throws IOException {
        this.d.write(writer);
        writer.writeInt(this.nodes.size());
        for (ImmutableNodeInst n : this.nodes) {
            n.write(writer);
        }
        writer.writeInt(this.arcs.size());
        for (ImmutableArcInst a : this.arcs) {
            a.write(writer);
        }
        writer.writeInt(this.exports.size());
        for (ImmutableExport e : this.exports) {
            e.write(writer);
        }
    }

    static CellRevision read(IdReader reader) throws IOException {
        ImmutableCell d = ImmutableCell.read(reader);
        CellRevision revision = CellRevision.newInstance(d.withoutVariables());
        int nodesLength = reader.readInt();
        ImmutableNodeInst[] nodes = new ImmutableNodeInst[nodesLength];
        for (int i = 0; i < nodesLength; ++i) {
            nodes[i] = ImmutableNodeInst.read(reader);
        }
        int arcsLength = reader.readInt();
        ImmutableArcInst[] arcs = new ImmutableArcInst[arcsLength];
        for (int i = 0; i < arcsLength; ++i) {
            arcs[i] = ImmutableArcInst.read(reader);
        }
        int exportsLength = reader.readInt();
        ImmutableExport[] exports = new ImmutableExport[exportsLength];
        for (int i = 0; i < exportsLength; ++i) {
            exports[i] = ImmutableExport.read(reader);
        }
        revision = revision.with(d, nodes, arcs, exports);
        return revision;
    }

    public void check() {
        this.d.check();
        CellId cellId = this.d.cellId;
        boolean busNamesAllowed = this.d.busNamesAllowed();
        BitSet checkTechUsages = new BitSet();
        checkTechUsages.set(this.d.techId.techIndex);
        int[] checkCellUsages = this.getInstCounts();
        this.nodes.check();
        boolean hasCellCenter = false;
        int nodeInd = 0;
        for (ImmutableNodeInst n : this.nodes) {
            if (ImmutableNodeInst.isCellCenter(n.protoId)) {
                assert (!hasCellCenter);
                hasCellCenter = true;
            }
            assert (busNamesAllowed || !n.name.isBus());
            if (n.protoId instanceof CellId) {
                CellId subCellId = (CellId)n.protoId;
                CellUsage u = cellId.getUsageIn(subCellId);
                int n2 = u.indexInParent;
                checkCellUsages[n2] = checkCellUsages[n2] - 1;
                CellUsageInfo cui = this.cellUsages[u.indexInParent];
                assert (cui != null);
                for (int j = 0; j < n.ports.length; ++j) {
                    ImmutablePortInst pid = n.ports[j];
                    if (pid == ImmutablePortInst.EMPTY) continue;
                    this.checkPortInst(n, subCellId.getPortId(j));
                }
                if (subCellId.isIcon()) {
                    for (Variable param2 : n.getDefinedParams()) {
                        assert (cui.usedAttributes.get((Variable.AttrKey)param2.getKey()) == param2.getUnit());
                    }
                    Iterator<Variable> it = n.getVariables();
                    while (it.hasNext()) {
                        Variable.Key varKey = it.next().getKey();
                        if (varKey.isAttribute()) assert (cui.usedAttributes.get(varKey) == null);
                    }
                }
            } else {
                TechId techId = ((PrimitiveNodeId)n.protoId).techId;
                checkTechUsages.set(techId.techIndex);
            }
            ++nodeInd;
        }
        for (int i = 0; i < checkCellUsages.length; ++i) {
            assert (checkCellUsages[i] == 0);
        }
        ImmutableArcInst.checkList(this.arcs);
        if (this.arcIndex != null && this.arcIndex.length > 0) {
            assert (this.arcIndex[this.arcIndex.length - 1] >= 0);
            for (int arcId = 0; arcId < this.arcIndex.length; ++arcId) {
                int arcInd = this.arcIndex[arcId];
                if (arcInd != -1) assert (this.arcs.get((int)arcInd).arcId == arcId);
            }
        }
        int arcInd = 0;
        for (ImmutableArcInst a : this.arcs) {
            assert (this.arcIndex == null ? a.arcId == arcInd : this.arcIndex[a.arcId] == arcInd);
            assert (this.getArcById(a.arcId) == a);
            assert (busNamesAllowed || !a.name.isBus());
            this.checkPortInst(this.getNodeById(a.tailNodeId), a.tailPortId);
            this.checkPortInst(this.getNodeById(a.headNodeId), a.headPortId);
            checkTechUsages.set(a.protoId.techId.techIndex);
            ++arcInd;
        }
        ImmutableExport.checkList(this.exports);
        if (this.exportIndex.length > 0) {
            assert (this.exportIndex[this.exportIndex.length - 1] >= 0);
            for (int chronIndex = 0; chronIndex < this.exportIndex.length; ++chronIndex) {
                int exportInd = this.exportIndex[chronIndex];
                if (exportInd != -1) assert (this.exports.get((int)exportInd).exportId.chronIndex == chronIndex);
            }
        }
        assert (this.exportIndex.length == this.definedExportsLength);
        assert (this.definedExports.length() == this.definedExportsLength);
        int exportInd = 0;
        for (ImmutableExport e : this.exports) {
            assert (e.exportId.parentId == cellId);
            assert (this.exportIndex[e.exportId.chronIndex] == exportInd);
            assert (busNamesAllowed || !e.name.isBus());
            this.checkPortInst(this.getNodeById(e.originalNodeId), e.originalPortId);
            ++exportInd;
        }
        int exportCount = 0;
        for (int chronIndex = 0; chronIndex < this.exportIndex.length; ++chronIndex) {
            int portIndex = this.exportIndex[chronIndex];
            if (portIndex == -1) {
                assert (!this.definedExports.get(chronIndex));
                continue;
            }
            assert (this.definedExports.get(chronIndex));
            ++exportCount;
            assert (this.exports.get((int)portIndex).exportId.chronIndex == chronIndex);
        }
        assert (this.exports.size() == exportCount);
        BitSet checkDeleted = new BitSet();
        checkDeleted.set(0, this.definedExportsLength);
        checkDeleted.andNot(this.definedExports);
        assert (this.deletedExports.equals(checkDeleted));
        if (this.definedExports.isEmpty()) assert (this.definedExports == EMPTY_BITSET);
        if (this.deletedExports.isEmpty()) assert (this.deletedExports == EMPTY_BITSET);
        assert (this.techUsages.equals(checkTechUsages));
        if (!ALLOW_SUBCELLS_IN_ICON && this.d.cellId.isIcon()) assert (this.cellUsages.length == 0);
        for (int i = 0; i < this.cellUsages.length; ++i) {
            CellUsageInfo cui = this.cellUsages[i];
            if (cui == null) continue;
            cui.check(this.d.cellId.getUsageIn(i));
        }
    }

    private void checkPortInst(ImmutableNodeInst node, PortProtoId portId) {
        assert (node != null);
        assert (portId.getParentId() == node.protoId);
        if (portId instanceof ExportId) {
            this.checkExportId((ExportId)portId);
        }
    }

    private void checkExportId(ExportId exportId) {
        CellUsage u = this.d.cellId.getUsageIn(exportId.getParentId());
        assert (this.cellUsages[u.indexInParent].usedExports.get(exportId.getChronIndex()));
    }

    public void checkConnectivity() {
        int hi;
        int ti;
        List tc;
        int[] maxConnectedPortInst = new int[this.getMaxNodeId() + 1];
        for (ImmutableArcInst a : this.arcs) {
            maxConnectedPortInst[a.tailNodeId] = Math.max(maxConnectedPortInst[a.tailNodeId], a.tailPortId.chronIndex + 1);
            maxConnectedPortInst[a.headNodeId] = Math.max(maxConnectedPortInst[a.headNodeId], a.headPortId.chronIndex + 1);
        }
        for (ImmutableExport e : this.exports) {
            maxConnectedPortInst[e.originalNodeId] = Math.max(maxConnectedPortInst[e.originalNodeId], e.originalPortId.chronIndex + 1);
        }
        ArrayList conns = new ArrayList();
        ArrayList exps = new ArrayList();
        for (int nodeId = 0; nodeId <= this.getMaxNodeId(); ++nodeId) {
            ArrayList conns1 = null;
            ArrayList exps1 = null;
            int m = maxConnectedPortInst[nodeId];
            if (m > 0) {
                conns1 = new ArrayList(m);
                exps1 = new ArrayList(m);
                for (int i = 0; i < m; ++i) {
                    conns1.add(ImmutableList.empty());
                    exps1.add(ImmutableList.empty());
                }
            }
            conns.add(conns1);
            exps.add(exps1);
        }
        if (this instanceof CellRevisionJ) {
            for (ImmutableArcInst a : this.arcs) {
                tc = (List)conns.get(a.tailNodeId);
                ti = a.tailPortId.chronIndex;
                tc.set(ti, ImmutableList.addFirst((ImmutableList)tc.get(ti), new Conn(a, false)));
                List hc = (List)conns.get(a.headNodeId);
                hi = a.headPortId.chronIndex;
                hc.set(hi, ImmutableList.addFirst((ImmutableList)hc.get(hi), new Conn(a, true)));
            }
        } else {
            for (int arcId = 0; arcId <= this.getMaxArcId(); ++arcId) {
                ImmutableArcInst a;
                a = this.getArcById(arcId);
                if (a == null) continue;
                tc = (List)conns.get(a.tailNodeId);
                ti = a.tailPortId.chronIndex;
                tc.set(ti, ImmutableList.addFirst((ImmutableList)tc.get(ti), new Conn(a, false)));
                List hc = (List)conns.get(a.headNodeId);
                hi = a.headPortId.chronIndex;
                hc.set(hi, ImmutableList.addFirst((ImmutableList)hc.get(hi), new Conn(a, true)));
            }
        }
        CellId cellId = this.d.cellId;
        for (int chronIndex = 0; chronIndex <= this.getMaxExportChronIndex(); ++chronIndex) {
            ImmutableExport e = this.getExport(cellId.getPortId(chronIndex));
            if (e == null) continue;
            List ec = (List)exps.get(e.originalNodeId);
            int ei = e.originalPortId.chronIndex;
            ec.set(ei, ImmutableList.addFirst((ImmutableList)ec.get(ei), e));
        }
        for (ImmutableNodeInst n : this.nodes) {
            int nodeId = n.nodeId;
            List cn = (List)conns.get(nodeId);
            List ex = (List)exps.get(nodeId);
            int maxChronIndex = cn != null ? cn.size() - 1 : -1;
            BitSet arcHeads = new BitSet();
            List<ImmutableArcInst> arcsOnNode = this.getConnectionsOnNode(arcHeads, n);
            assert (arcsOnNode.equals(this.getConnectionsOnNode(null, n)));
            assert (arcHeads.length() <= arcsOnNode.size());
            assert (this.getNumConnectionsOnNode(n) == arcsOnNode.size());
            assert (this.hasConnectionsOnNode(n) == !arcsOnNode.isEmpty());
            Iterator<ImmutableExport> exportsOnNode = this.getExportsOnNode(n);
            assert (this.hasExportsOnNode(n) == exportsOnNode.hasNext());
            assert (maxChronIndex == (ex != null ? ex.size() - 1 : -1));
            int ci = 0;
            int ei = 0;
            for (int chronIndex = 0; chronIndex <= maxChronIndex; ++chronIndex) {
                ImmutableList<ImmutableExport> t;
                PortProtoId portProtoId = n.protoId.getPortId(chronIndex);
                BitSet arcHeadsP = new BitSet();
                List<ImmutableArcInst> arcsOnPort = this.getConnectionsOnPort(arcHeadsP, n, portProtoId);
                assert (arcsOnPort.equals(this.getConnectionsOnPort(null, n, portProtoId)));
                assert (arcHeadsP.length() <= arcsOnPort.size());
                assert (this.getNumConnectionsOnPort(n, portProtoId) == arcsOnPort.size());
                assert (this.hasConnectionsOnPort(n, portProtoId) == !arcsOnPort.isEmpty());
                Iterator<ImmutableExport> exportsOnPort = this.getExportsOnPort(n, portProtoId);
                assert (this.hasExportsOnPort(n, portProtoId) == exportsOnPort.hasNext());
                int ciP = 0;
                int eiP = 0;
                ImmutableList<Conn> l = ImmutableList.reverse((ImmutableList)cn.get(chronIndex));
                if (l != null) {
                    for (Conn conn : l) {
                        ImmutableArcInst a = conn.a;
                        boolean end = conn.end;
                        assert (a == arcsOnNode.get(ci) && end == arcHeads.get(ci));
                        assert (a == arcsOnPort.get(ciP) && end == arcHeadsP.get(ciP));
                        ++ci;
                        ++ciP;
                    }
                }
                if ((t = ImmutableList.reverse((ImmutableList)ex.get(chronIndex))) != null) {
                    for (ImmutableExport e : t) {
                        assert (e == exportsOnNode.next());
                        assert (e == exportsOnPort.next());
                        ++ei;
                        ++eiP;
                    }
                }
                assert (ciP == arcsOnPort.size());
                assert (!exportsOnPort.hasNext());
                assert (this.getNumExportsOnPort(n, portProtoId) == eiP);
            }
            assert (ci == arcsOnNode.size());
            assert (!exportsOnNode.hasNext());
            assert (this.getNumExportsOnNode(n) == ei);
        }
    }

    static long sizeOfBitSet(ObjSize objSize, BitSet bs) {
        if (bs == null || bs == EMPTY_BITSET) {
            return 0L;
        }
        long size2 = objSize.sizeOf(bs);
        try {
            if (BitSet_words == null) {
                Class<?> clsBitSet = Class.forName("java.util.BitSet");
                BitSet_words = clsBitSet.getDeclaredField("words");
                BitSet_words.setAccessible(true);
            }
            size2 += objSize.sizeOf(BitSet_words.get(bs));
        }
        catch (Exception e) {
            size2 += (long)((bs.length() + 63) / 64 * 8);
        }
        return size2;
    }

    public boolean sameExports(CellRevision thatRevision) {
        if (thatRevision == this) {
            return true;
        }
        if (this.exports.size() != thatRevision.exports.size()) {
            return false;
        }
        for (int i = 0; i < this.exports.size(); ++i) {
            if (this.exports.get((int)i).exportId == thatRevision.exports.get((int)i).exportId) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.d.toString();
    }

    private static class Conn {
        private final ImmutableArcInst a;
        private final boolean end;

        private Conn(ImmutableArcInst a, boolean end) {
            this.a = a;
            this.end = end;
        }
    }
}

