/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Equipment;
import com.sun.electric.tool.simulation.test.Infrastructure;

public class HP80000
extends Equipment {
    public static int SYSTEM = 0;
    public static int SYSTEMCLOCK = 1;
    public static int DATAGEN1GHZ = 2;
    public static int DG1GHZ128K = 3;
    private int selectedInst;

    public HP80000(String name) {
        super(name);
        this.selectInstrument(SYSTEM);
    }

    public void reset() {
        this.write("*CLS");
        this.write("*RST");
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        this.write(":INST:SEL SYSTEMCLOCK");
        this.write(":TRIG:STAR");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.write(":INST:SEL SYSTEMCLOCK");
        this.write(":TRIG:STOP");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void pause() {
        this.write(":INST:SEL SYSTEMCLOCK");
        this.write(":TRIG:PAUS");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void cont() {
        this.write(":INST:SEL SYSTEMCLOCK");
        this.write(":TRIG:CONT");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void selectInstrument(int inst) {
        this.write(":INST:SEL " + this.instToString(inst));
        this.selectedInst = inst;
    }

    private String instToString(int inst) {
        switch (inst) {
            case 0: {
                return "System";
            }
            case 1: {
                return "SystemClock";
            }
            case 2: {
                return "DATAGEN1GHZ";
            }
            case 3: {
                return "DG1GHZ128K";
            }
        }
        return "Unknown";
    }

    public void setClockSource(boolean internal) {
        if (!this.isSelectedInstSystemClock()) {
            return;
        }
        if (internal) {
            this.write(":CLOC:SOUR INT");
        } else {
            this.write(":CLOC:SOUR EXT");
        }
    }

    public void setClockFrequency(double freq, String units) {
        if (!this.isSelectedInstSystemClock()) {
            return;
        }
        if (!units.toLowerCase().endsWith("hz")) {
            units = units + "HZ";
        }
        this.write(":CLOC:INT:FREQ " + freq + " " + units);
    }

    public void printGroups() {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        this.write(":DIG:GRO:CAT?");
        String s = this.read(200);
        System.out.println("Groups: " + s);
    }

    public void defineGroup(String groupName, String slotsAndChannels) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        this.write(":DIG:GRO:DEF " + groupName + ",(@" + slotsAndChannels + ")");
    }

    public void deleteGroup(String groupName) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        if (groupName.equals("ALL")) {
            this.write(":DIG:GRO:DEL:ALL");
        } else {
            this.write(":DIG:GRO:DEL " + groupName);
        }
    }

    public void selectGroup(String groupName) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        this.write(":DIG:GRO:SEL " + groupName);
    }

    public void setGroupPatternCycle(int startLength, int cycleLength, int cycleTimes) {
        String l;
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        String string2 = l = cycleTimes < 0 ? "INF" : String.valueOf(cycleTimes);
        if (startLength < 4 && startLength != 0) {
            System.out.println("Error: pattern cycle start value must be 0, or 4 or more");
            return;
        }
        if (cycleLength % 8 != 0) {
            System.out.println("Error: pattern cycle length value must be 0 or multiple of 8");
            return;
        }
        if (cycleTimes > 255) {
            System.out.println("Warning: pattern cycle loop value maximum is 255, dropping " + cycleTimes + " to 255");
            cycleTimes = 255;
        }
        this.write(":PATT:CYCL " + startLength + "," + cycleLength + "," + l);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public void setGroupData(String[] binData) {
        int i;
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        if (binData.length == 0) {
            return;
        }
        int numChannels = binData.length;
        int datalen = binData[0].length();
        for (i = 0; i < binData.length; ++i) {
            if (binData[i].length() == datalen) continue;
            System.out.println("Error: in setData, all arrays must be the same length");
            return;
        }
        for (i = 0; i < datalen; ++i) {
            StringBuffer cmd = new StringBuffer();
            cmd.append(":PATT:MOD ");
            cmd.append(i);
            cmd.append(",#B");
            for (int j = numChannels - 1; j >= 0; --j) {
                cmd.append(binData[j].charAt(i));
            }
            this.write(cmd.toString());
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.write(":PATT:UPD");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public void printGroupData(int start, int end, int numSignals) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        this.write(":FORM ASC," + numSignals);
        this.write(":PATT:MOD? " + start + "," + end);
        String s = this.read(400);
        System.out.println(s);
    }

    private void setPatternData(int signal, String dataPat) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        this.write(":FORM PACK,1");
        this.write(":PATT:DATA" + signal + " " + dataPat);
        this.write(":PATT:UPD");
    }

    private void printPatternData(int signal, int start, int end) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        this.write(":FORM HEX,8");
        this.write(":PATT:DATA" + signal + "? " + start + "," + end);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String s = this.read(600);
        System.out.println("Data for signal " + signal + " is: (len=" + s.length() + ")");
        System.out.println(s);
    }

    public void setSignalFormat(boolean NonReturntoZero) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        if (NonReturntoZero) {
            this.write(":SIGN:FORM NRZ");
        } else {
            this.write(":SIGN:FORM RZ");
        }
    }

    public void setGroupSignalPolarity(boolean normal) {
        this.setGroupSignalPolarity(-1, normal);
    }

    public void setGroupSignalPolarity(int signal, boolean normal) {
        String s;
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        String string2 = s = signal < 0 ? "" : String.valueOf(signal);
        if (normal) {
            this.write(":SIGN:POL" + s + " NORM");
        } else {
            this.write(":SIGN:POL" + s + " INV");
        }
    }

    public void setOutputState(boolean on) {
        this.setOutputState(-1, on);
    }

    public void setOutputState(int signal, boolean on) {
        String s;
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        String string2 = s = signal < 0 ? "" : String.valueOf(signal);
        if (on) {
            this.write(":OUTP" + s + " ON");
        } else {
            this.write(":OUTP" + s + " OFF");
        }
    }

    public void setOutputTermination(int state) {
        this.setOutputTermination(-1, state);
    }

    public void setOutputTermination(int signal, int state) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        String s = signal < 0 ? "" : String.valueOf(signal);
        switch (state) {
            case 0: {
                this.write(":OUTP" + s + ":TERM GRO");
                break;
            }
            case 1: {
                this.write(":OUTP" + s + ":TERM ECL");
                break;
            }
            case 2: {
                this.write(":OUTP" + s + ":TERM PECL");
                break;
            }
            case 3: {
                this.write(":OUTP" + s + ":TERM OPEN");
                break;
            }
            default: {
                System.out.println("State " + state + " is not a valid output termination state");
            }
        }
    }

    public void setGroupDelay(int ps) {
        this.setGroupDelay(-1, ps);
    }

    public void setGroupDelay(int signal, int ps) {
        String s;
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        String string2 = s = signal < 0 ? "" : String.valueOf(signal);
        if (ps < -2000 || ps > 2000) {
            System.out.println("Valid range for group delay is -2000ps to 2000ps: not " + ps);
            return;
        }
        this.write(":SOUR:PULS:DEL" + s + " " + ps + " PS");
    }

    public void setGroupHighVoltageLevel(double voltage) {
        this.setGroupHighVoltageLevel(-1, voltage);
    }

    public void setGroupHighVoltageLevel(int signal, double voltage) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        String s = signal < 0 ? "" : String.valueOf(signal);
        this.write(":SOUR:VOLT:LEV:IMM:HIGH" + s + " " + voltage + " V");
    }

    public void setGroupLowVoltageLevel(double voltage) {
        this.setGroupLowVoltageLevel(-1, voltage);
    }

    public void setGroupLowVoltageLevel(int signal, double voltage) {
        if (!this.isSelectedInstDataGen()) {
            return;
        }
        String s = signal < 0 ? "" : String.valueOf(signal);
        this.write(":SOUR:VOLT:LEV:IMM:LOW" + s + " " + voltage + " V");
    }

    private void printResponse() {
        String s = this.read(200);
        System.out.println(s);
    }

    private boolean isSelectedInstSystem() {
        if (this.selectedInst != SYSTEM) {
            System.out.println("Error, issuing SYSTEM related command when currently selected instrument is not SYSTEM");
            return false;
        }
        return true;
    }

    private boolean isSelectedInstSystemClock() {
        if (this.selectedInst != SYSTEMCLOCK) {
            System.out.println("Error, issuing SYSTEMCLOCK related command when currently selected instrument is not SYSTEMCLOCK");
            return false;
        }
        return true;
    }

    private boolean isSelectedInstDataGen() {
        if (this.selectedInst != DATAGEN1GHZ && this.selectedInst != DG1GHZ128K) {
            System.out.println("Error, issuing DATAGEN1GHZ/DG1GHZ128K related command when currently selected instrument is not DATAGEN1GHZ/DG1GHZ128K");
            return false;
        }
        return true;
    }

    private void printErrorQueue() {
        this.write(":SYST:ERR?");
        String s = this.read(200);
        System.out.println(s);
    }

    public static void main(String[] args) {
        Infrastructure.gpibControllers = new int[]{2};
        HP80000 datagen = new HP80000("HP80000");
        datagen.reset();
        datagen.selectInstrument(DG1GHZ128K);
        datagen.deleteGroup("ALL");
        datagen.defineGroup("foo", "0(2:3)");
        datagen.printGroups();
        datagen.selectGroup("foo");
        datagen.setGroupPatternCycle(4, 8, 1);
        String[] data2 = new String[]{"000100110111", "100011001000"};
        datagen.printGroupData(0, 12, 2);
        datagen.setGroupData(data2);
        datagen.deleteGroup("ALL");
        datagen.defineGroup("clk", "0(2)");
        datagen.printGroups();
        datagen.selectGroup("clk");
        datagen.setGroupPatternCycle(0, 16, -1);
        datagen.setGroupData(new String[]{"0000111111110000"});
        datagen.printGroupData(0, 15, 1);
        System.out.println("done");
    }
}

