/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.general;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.topology.SteinerTree;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.PlacementFrameElectric;
import com.sun.electric.tool.placement.general.BottomUpPartition;
import com.sun.electric.tool.placement.general.FindEmptyRects;
import com.sun.electric.tool.simulation.test.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class BottomUpPlace
extends PlacementFrameElectric {
    private static final boolean DEBUGPROGRESS = false;
    private static final int DEFAULTTRELLISSIZE = 20;
    private static final int COMPRESSIONTRELLISSIZE = 5;
    private static final int COMPRESSIONIMPROVEMENTTHRESHOLD = 7;
    private static final int GROUPPAIRSBYDENSITY = 0;
    private static final int GROUPPAIRSBYSIZE = 1;
    private static final int GROUPPAIRSFLAT = 2;
    private static int pairGrouping = 0;
    private static double boundWeight = 2.0;
    private static double aspectRatioWeight = 2.0;
    private static int trellisWidth = 20;
    private static List<List<BottomUpPartition.PNPair>> orderedPairGroups;
    private static Map<PlacementFrame.PlacementNode, List<SteinerTree.SteinerTreePortPair>> consOnNodes;
    protected PlacementFrame.PlacementParameter numThreadsParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("threads", "Number of threads:", 4);
    protected PlacementFrame.PlacementParameter maxRuntimeParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("runtime", "Runtime (in seconds, 0 for no limit):", 240);
    protected PlacementFrame.PlacementParameter canRotate = (PlacementFrame)this.new PlacementFrame.PlacementParameter("canRotate", "Allow node rotation", false);
    private static int proposedPlacementIndex;
    private static final int INDENTPOLY = 5;
    private static int showIndex;

    @Override
    public String getAlgorithmName() {
        return "Bottom-Up-Place";
    }

    public static void setWeights(double b, double ar, int tr) {
        boundWeight = b;
        aspectRatioWeight = ar;
        trellisWidth = tr;
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace, String cellName, Job job) {
        this.setParamterValues(this.numThreadsParam.getIntValue(), this.maxRuntimeParam.getIntValue());
        if (placementNodes.size() < 2) {
            return;
        }
        this.prepareClustering(placementNodes, allNetworks);
        ProposedPlacement initialProposal = new ProposedPlacement(placementNodes);
        ArrayList<ProposedPlacement> currentProposals = new ArrayList<ProposedPlacement>();
        currentProposals.add(initialProposal);
        HashSet<PlacementFrame.PlacementNode> macroNodes = new HashSet<PlacementFrame.PlacementNode>();
        Map<Double, List<BottomUpPartition.PNPair>> allDensities = BottomUpPartition.makeClusteredPairs(placementNodes, allNetworks, macroNodes);
        TreeMap<Double, ArrayList<PlacementFrame.PlacementNode>> instSizes = new TreeMap<Double, ArrayList<PlacementFrame.PlacementNode>>();
        for (PlacementFrame.PlacementNode pn : placementNodes) {
            Double size2 = new Double(pn.getWidth() * pn.getHeight());
            ArrayList<PlacementFrame.PlacementNode> nodes = (ArrayList<PlacementFrame.PlacementNode>)instSizes.get(size2);
            if (nodes == null) {
                nodes = new ArrayList<PlacementFrame.PlacementNode>();
                instSizes.put(size2, nodes);
            }
            nodes.add(pn);
        }
        int si = instSizes.size();
        double[] bigSizes = new double[si];
        for (Double size3 : instSizes.keySet()) {
            bigSizes[--si] = size3;
        }
        HashSet<PlacementFrame.PlacementNode> bigNodes = new HashSet<PlacementFrame.PlacementNode>();
        for (int i = 0; !(i >= bigSizes.length || i != 0 && bigSizes[i] <= bigSizes[i - 1] / 2.0); ++i) {
            List nodes = (List)instSizes.get(new Double(bigSizes[i]));
            for (PlacementFrame.PlacementNode pn : nodes) {
                bigNodes.add(pn);
            }
        }
        orderedPairGroups = new ArrayList<List<BottomUpPartition.PNPair>>();
        int di = allDensities.size();
        double[] clusteringDensities = new double[di];
        for (Double density : allDensities.keySet()) {
            clusteringDensities[--di] = density;
        }
        switch (pairGrouping) {
            case 2: {
                List<BottomUpPartition.PNPair> pairsAtLevel;
                ArrayList<BottomUpPartition.PNPair> thisPairSet = new ArrayList<BottomUpPartition.PNPair>();
                for (int i = 0; i < allDensities.size(); ++i) {
                    pairsAtLevel = allDensities.get(new Double(clusteringDensities[i]));
                    for (BottomUpPartition.PNPair pnp : pairsAtLevel) {
                        thisPairSet.add(pnp);
                    }
                }
                if (thisPairSet.size() <= 0) break;
                orderedPairGroups.add(thisPairSet);
                break;
            }
            case 1: {
                int i;
                List<BottomUpPartition.PNPair> pairsAtLevel;
                ArrayList<BottomUpPartition.PNPair> thisPairSet = new ArrayList();
                for (i = 0; i < allDensities.size(); ++i) {
                    pairsAtLevel = allDensities.get(new Double(clusteringDensities[i]));
                    for (BottomUpPartition.PNPair pnp : pairsAtLevel) {
                        if (!bigNodes.contains(pnp.n1) || !bigNodes.contains(pnp.n2)) continue;
                        thisPairSet.add(pnp);
                    }
                }
                if (thisPairSet.size() > 0) {
                    orderedPairGroups.add(thisPairSet);
                }
                thisPairSet = new ArrayList();
                for (i = 0; i < allDensities.size(); ++i) {
                    pairsAtLevel = allDensities.get(new Double(clusteringDensities[i]));
                    for (BottomUpPartition.PNPair pnp : pairsAtLevel) {
                        if (bigNodes.contains(pnp.n1) && bigNodes.contains(pnp.n2)) continue;
                        thisPairSet.add(pnp);
                    }
                }
                if (thisPairSet.size() <= 0) break;
                orderedPairGroups.add(thisPairSet);
                break;
            }
            case 0: {
                int i;
                List<BottomUpPartition.PNPair> pairsAtLevel;
                ArrayList<BottomUpPartition.PNPair> thisPairSet;
                for (i = 0; i < allDensities.size(); ++i) {
                    pairsAtLevel = allDensities.get(new Double(clusteringDensities[i]));
                    thisPairSet = new ArrayList();
                    for (BottomUpPartition.PNPair pnp : pairsAtLevel) {
                        if (!bigNodes.contains(pnp.n1) || !bigNodes.contains(pnp.n2)) continue;
                        thisPairSet.add(pnp);
                    }
                    if (thisPairSet.size() <= 0) continue;
                    orderedPairGroups.add(thisPairSet);
                }
                for (i = 0; i < allDensities.size(); ++i) {
                    pairsAtLevel = allDensities.get(new Double(clusteringDensities[i]));
                    thisPairSet = new ArrayList();
                    for (BottomUpPartition.PNPair pnp : pairsAtLevel) {
                        if (bigNodes.contains(pnp.n1) && bigNodes.contains(pnp.n2)) continue;
                        thisPairSet.add(pnp);
                    }
                    if (thisPairSet.size() <= 0) continue;
                    orderedPairGroups.add(thisPairSet);
                }
                break;
            }
        }
        System.out.println(bigNodes.size() + " out of " + placementNodes.size() + " nodes are 'big'");
        String groupingName = "";
        switch (pairGrouping) {
            case 2: {
                groupingName = "Flat";
                break;
            }
            case 1: {
                groupingName = "Size";
                break;
            }
            case 0: {
                groupingName = "Density";
            }
        }
        if (Job.getDebug()) {
            System.out.println("Group " + orderedPairGroups.size() + " pairs by: " + groupingName + " (bound-weight=" + TextUtils.formatDouble(boundWeight) + " aspect-ratio-weight=" + TextUtils.formatDouble(aspectRatioWeight) + " trellis-size=" + trellisWidth + ")");
        }
        long start = System.currentTimeMillis();
        while (true) {
            int time;
            if (this.maxRuntimeParam.getIntValue() > 0 && (time = (int)((System.currentTimeMillis() - start) / 1000L)) > this.maxRuntimeParam.getIntValue()) {
                System.out.println("Refinement exceeded time limit");
                break;
            }
            ArrayList<ProposedPlacement> newProposals = new ArrayList<ProposedPlacement>();
            for (ProposedPlacement curProp : currentProposals) {
                List nextProposals = curProp.clusteringPlacementStep(1);
                for (int i = 0; i < nextProposals.size(); ++i) {
                    ProposedPlacement pp = (ProposedPlacement)nextProposals.get(i);
                    pp.computeQuality(allNetworks);
                    newProposals.add(pp);
                }
            }
            if (newProposals.isEmpty()) break;
            Collections.sort(newProposals);
            while (newProposals.size() > trellisWidth) {
                newProposals.remove(newProposals.size() - 1);
            }
            int fewestClusters = Integer.MAX_VALUE;
            for (ProposedPlacement pp : currentProposals) {
                if (pp.allClusters.size() >= fewestClusters) continue;
                fewestClusters = pp.allClusters.size();
            }
            if (fewestClusters % 10 == 0) {
                System.out.println("Merging " + fewestClusters + " clusters");
            }
            if (newProposals.isEmpty()) break;
            currentProposals = newProposals;
        }
        if (currentProposals.size() == 0) {
            System.out.println("No best placement could be found");
            return;
        }
        ProposedPlacement bestPlacement = (ProposedPlacement)currentProposals.get(0);
        if (bestPlacement.allClusters.size() > 1) {
            System.out.println("Combining " + bestPlacement.allClusters.size() + " unmerged clusters");
            bestPlacement.combineClusters();
        }
        int maxPasses = placementNodes.size();
        boolean compacted = false;
        ArrayList<ProposedPlacement> compactionTrellis = new ArrayList<ProposedPlacement>();
        compactionTrellis.add(bestPlacement);
        Rectangle2D bestBound = bestPlacement.getBounds(placementNodes);
        double bestArea = bestBound.getWidth() * bestBound.getHeight();
        double bestHPWL = bestPlacement.hpwl;
        DecimalFormat formatter = new DecimalFormat("#,###");
        for (int pass = 0; pass <= maxPasses; ++pass) {
            double hpwlImprovement;
            ProposedPlacement bestSoFar;
            Rectangle2D thisBound;
            double thisArea;
            double areaImprovement;
            ArrayList<ProposedPlacement> nextTrellis = new ArrayList<ProposedPlacement>();
            for (ProposedPlacement pp : compactionTrellis) {
                List<ProposedPlacement> proposals = this.compact(placementNodes, pp, allNetworks);
                for (ProposedPlacement nextPP : proposals) {
                    nextTrellis.add(nextPP);
                }
            }
            Collections.sort(nextTrellis, new SortPlacementByHPWL());
            while (nextTrellis.size() > 5) {
                nextTrellis.remove(nextTrellis.size() - 1);
            }
            if (nextTrellis.size() == 0 || (areaImprovement = bestArea / (thisArea = (thisBound = (bestSoFar = (ProposedPlacement)compactionTrellis.get(0)).getBounds(placementNodes)).getWidth() * thisBound.getHeight()) * 100.0 - 100.0) > (hpwlImprovement = bestHPWL / bestSoFar.hpwl * 100.0 - 100.0) + 7.0) break;
            compactionTrellis = nextTrellis;
            bestArea = thisArea;
            bestHPWL = bestSoFar.hpwl;
            System.out.println("Compacted. HPWL now " + formatter.format(Math.round(bestSoFar.hpwl)) + " (improved by " + Math.round(hpwlImprovement) + "%), area now " + formatter.format(Math.round(bestArea)) + ", improved by " + Math.round(areaImprovement) + "%)");
            compacted = true;
        }
        System.out.println("Could not compact placement" + (compacted ? " further" : ""));
        bestPlacement = (ProposedPlacement)compactionTrellis.get(0);
        bestPlacement.applyProposal(placementNodes);
    }

    private List<ProposedPlacement> compact(List<PlacementFrame.PlacementNode> placementNodes, ProposedPlacement proposal, List<PlacementFrame.PlacementNetwork> allNetworks) {
        double hY;
        double lY;
        double hX;
        double lX;
        ProxyNode p;
        ArrayList<ProposedPlacement> possibileSteps = new ArrayList<ProposedPlacement>();
        Rectangle2D initialBound = proposal.getBounds(placementNodes);
        double initialArea = initialBound.getWidth() * initialBound.getHeight();
        ArrayList<CompactionEdge> edges = new ArrayList<CompactionEdge>();
        CompactionEdge leftEdge = new CompactionEdge("left", edges);
        CompactionEdge rightEdge = new CompactionEdge("right", edges);
        CompactionEdge topEdge = new CompactionEdge("top", edges);
        CompactionEdge bottomEdge = new CompactionEdge("bottom", edges);
        for (PlacementFrame.PlacementNode pn : placementNodes) {
            p = (ProxyNode)proposal.proxyMap.get(pn);
            lX = p.getX() - p.getWidth() / 2.0;
            hX = lX + p.getWidth();
            lY = p.getY() - p.getHeight() / 2.0;
            hY = lY + p.getHeight();
            if (DBMath.areEquals(lX, initialBound.getMinX()) && !leftEdge.moveSet.contains(pn)) {
                leftEdge.moveSet.add(pn);
                leftEdge.toMove.add(pn);
            }
            if (DBMath.areEquals(hX, initialBound.getMaxX()) && !rightEdge.moveSet.contains(pn)) {
                rightEdge.moveSet.add(pn);
                rightEdge.toMove.add(pn);
            }
            if (DBMath.areEquals(lY, initialBound.getMinY()) && !bottomEdge.moveSet.contains(pn)) {
                bottomEdge.moveSet.add(pn);
                bottomEdge.toMove.add(pn);
            }
            if (!DBMath.areEquals(hY, initialBound.getMaxY()) || topEdge.moveSet.contains(pn)) continue;
            topEdge.moveSet.add(pn);
            topEdge.toMove.add(pn);
        }
        for (PlacementFrame.PlacementNode pn : placementNodes) {
            p = (ProxyNode)proposal.proxyMap.get(pn);
            lX = p.getX() - p.getWidth() / 2.0;
            hX = lX + p.getWidth();
            lY = p.getY() - p.getHeight() / 2.0;
            hY = lY + p.getHeight();
            Rectangle2D.Double bound = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
            for (CompactionEdge edge : edges) {
                if (edge.moveSet.contains(pn)) continue;
                if (edge.bound == null) {
                    edge.bound = bound;
                    continue;
                }
                edge.bound = edge.bound.createUnion(bound);
            }
        }
        for (CompactionEdge edge : edges) {
            if (edge.bound == null) {
                edge.improvement = 0.0;
                continue;
            }
            edge.improvement = initialArea / (edge.bound.getWidth() * edge.bound.getHeight());
        }
        Collections.sort(edges);
        for (CompactionEdge edge : edges) {
            ProposedPlacement newProposal = new ProposedPlacement(proposal, true);
            ArrayList<ERectangle> rectangles = new ArrayList<ERectangle>();
            for (PlacementFrame.PlacementNode pn : placementNodes) {
                if (edge.moveSet.contains(pn)) continue;
                ProxyNode p2 = (ProxyNode)newProposal.proxyMap.get(pn);
                double lX2 = p2.getX() - p2.getWidth() / 2.0;
                double hX2 = lX2 + p2.getWidth();
                double lY2 = p2.getY() - p2.getHeight() / 2.0;
                double hY2 = lY2 + p2.getHeight();
                ERectangle rect = ERectangle.fromLambda(lX2, lY2, hX2 - lX2, hY2 - lY2);
                rectangles.add(rect);
            }
            if (rectangles.size() == 0) continue;
            ERectangle edgeBound = ERectangle.fromLambda(edge.bound);
            boolean failed = false;
            for (int i = 0; i < edge.toMove.size(); ++i) {
                PlacementFrame.PlacementNode pln = edge.toMove.get(i);
                ProxyNode pNode = (ProxyNode)newProposal.proxyMap.get(pln);
                FindEmptyRects fer = new FindEmptyRects();
                List<ERectangle> emptySpace = fer.findEmptySpace(rectangles, edgeBound);
                double bestQuality = Double.MAX_VALUE;
                double bestX = pNode.getX();
                double bestY = pNode.getY();
                for (ERectangle empty : emptySpace) {
                    double tryY;
                    double tryX;
                    if (pNode.getWidth() > empty.getWidth() || pNode.getHeight() > empty.getHeight()) continue;
                    if (empty.getMinX() > edge.bound.getMinX() && empty.getMinY() > edge.bound.getMinY()) {
                        tryX = empty.getMinX() + pNode.getWidth() / 2.0;
                        tryY = empty.getMinY() + pNode.getHeight() / 2.0;
                        pNode.setLocation(tryX, tryY);
                        newProposal.computeQuality(allNetworks);
                        if (newProposal.hpwl < bestQuality) {
                            bestQuality = newProposal.hpwl;
                            bestX = tryX;
                            bestY = tryY;
                        }
                    }
                    if (empty.getMinX() > edge.bound.getMinX() && empty.getMaxY() < edge.bound.getMaxY()) {
                        tryX = empty.getMinX() + pNode.getWidth() / 2.0;
                        tryY = empty.getMaxY() - pNode.getHeight() / 2.0;
                        pNode.setLocation(tryX, tryY);
                        newProposal.computeQuality(allNetworks);
                        if (newProposal.hpwl < bestQuality) {
                            bestQuality = newProposal.hpwl;
                            bestX = tryX;
                            bestY = tryY;
                        }
                    }
                    if (empty.getMaxX() < edge.bound.getMaxX() && empty.getMinY() > edge.bound.getMinY()) {
                        tryX = empty.getMaxX() - pNode.getWidth() / 2.0;
                        tryY = empty.getMinY() + pNode.getHeight() / 2.0;
                        pNode.setLocation(tryX, tryY);
                        newProposal.computeQuality(allNetworks);
                        if (newProposal.hpwl < bestQuality) {
                            bestQuality = newProposal.hpwl;
                            bestX = tryX;
                            bestY = tryY;
                        }
                    }
                    if (!(empty.getMaxX() < edge.bound.getMaxX()) || !(empty.getMaxY() < edge.bound.getMaxY())) continue;
                    tryX = empty.getMaxX() - pNode.getWidth() / 2.0;
                    tryY = empty.getMaxY() - pNode.getHeight() / 2.0;
                    pNode.setLocation(tryX, tryY);
                    newProposal.computeQuality(allNetworks);
                    if (!(newProposal.hpwl < bestQuality)) continue;
                    bestQuality = newProposal.hpwl;
                    bestX = tryX;
                    bestY = tryY;
                }
                if (bestQuality == Double.MAX_VALUE) {
                    failed = true;
                    break;
                }
                pNode.setLocation(bestX, bestY);
                double lX3 = pNode.getX() - pNode.getWidth() / 2.0;
                double hX3 = lX3 + pNode.getWidth();
                double lY3 = pNode.getY() - pNode.getHeight() / 2.0;
                double hY3 = lY3 + pNode.getHeight();
                ERectangle rect = ERectangle.fromLambda(lX3, lY3, hX3 - lX3, hY3 - lY3);
                rectangles.add(rect);
            }
            if (failed) continue;
            newProposal.computeQuality(allNetworks);
            possibileSteps.add(newProposal);
        }
        return possibileSteps;
    }

    private void prepareClustering(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks) {
        consOnNodes = new HashMap<PlacementFrame.PlacementNode, List<SteinerTree.SteinerTreePortPair>>();
        for (PlacementFrame.PlacementNetwork pNet : allNetworks) {
            List<SteinerTree.SteinerTreePortPair> cons = PlacementAdapter.getOptimalConnections(pNet);
            for (SteinerTree.SteinerTreePortPair con : cons) {
                List<SteinerTree.SteinerTreePortPair> consOnN2;
                PlacementFrame.PlacementPort p1 = (PlacementFrame.PlacementPort)con.getPort1();
                PlacementFrame.PlacementNode n1 = p1.getPlacementNode();
                PlacementFrame.PlacementPort p2 = (PlacementFrame.PlacementPort)con.getPort2();
                PlacementFrame.PlacementNode n2 = p2.getPlacementNode();
                List<SteinerTree.SteinerTreePortPair> consOnN1 = consOnNodes.get(n1);
                if (consOnN1 == null) {
                    consOnN1 = new ArrayList<SteinerTree.SteinerTreePortPair>();
                    consOnNodes.put(n1, consOnN1);
                }
                if ((consOnN2 = consOnNodes.get(n2)) == null) {
                    consOnN2 = new ArrayList<SteinerTree.SteinerTreePortPair>();
                    consOnNodes.put(n2, consOnN2);
                }
                consOnN1.add(con);
                if (n2 == n1) continue;
                consOnN2.add(con);
            }
        }
    }

    private EPoint pushCluster(ProxyCluster pcMoving, ProxyCluster pcFixed, double dX, double dY, int forceDir, ProposedPlacement debug) {
        RTNode<Object> root2 = RTNode.makeTopLevel();
        for (ProxyNode pnFixed : pcFixed.getNodesInCluster()) {
            root2 = RTNode.linkGeom(null, root2, pnFixed);
        }
        double bestLeftMotion = 0.0;
        double bestRightMotion = 0.0;
        double bestUpMotion = 0.0;
        double bestDownMotion = 0.0;
        boolean tryNegLeft = true;
        boolean tryNegRight = true;
        boolean tryNegUp = true;
        boolean tryNegDown = true;
        boolean intersects = true;
        block7: while (intersects) {
            intersects = false;
            for (ProxyNode pnMoving : pcMoving.getNodesInCluster()) {
                ERectangle boundMovingLeft = ERectangle.fromLambda(pnMoving.getX() + dX - bestLeftMotion - pnMoving.getWidth() / 2.0, pnMoving.getY() + dY - pnMoving.getHeight() / 2.0, pnMoving.getWidth(), pnMoving.getHeight());
                RTNode.Search sea = new RTNode.Search(boundMovingLeft, root2, true);
                while (sea.hasNext()) {
                    ERectangle boundFixed = ((ProxyNode)sea.next()).getBounds();
                    if (!(boundFixed.getMaxX() > boundMovingLeft.getMinX()) || !(boundFixed.getMinX() < boundMovingLeft.getMaxX()) || !(boundFixed.getMaxY() > boundMovingLeft.getMinY()) || !(boundFixed.getMinY() < boundMovingLeft.getMaxY())) continue;
                    bestLeftMotion += boundMovingLeft.getMaxX() - boundFixed.getMinX();
                    intersects = true;
                    tryNegLeft = false;
                    break;
                }
                if (bestLeftMotion <= 0.0 && tryNegLeft) {
                    bestLeftMotion -= pcMoving.getNodesInCluster().get(0).getWidth();
                    if (pcMoving.getBounds().getMinX() - bestLeftMotion >= pcFixed.getBounds().getMaxX()) {
                        bestLeftMotion = 0.0;
                        tryNegLeft = false;
                    }
                    intersects = true;
                }
                ERectangle boundMovingRight = ERectangle.fromLambda(pnMoving.getX() + dX + bestRightMotion - pnMoving.getWidth() / 2.0, pnMoving.getY() + dY - pnMoving.getHeight() / 2.0, pnMoving.getWidth(), pnMoving.getHeight());
                RTNode.Search sea2 = new RTNode.Search(boundMovingRight, root2, true);
                while (sea2.hasNext()) {
                    ERectangle boundFixed = ((ProxyNode)sea2.next()).getBounds();
                    if (!(boundFixed.getMaxX() > boundMovingRight.getMinX()) || !(boundFixed.getMinX() < boundMovingRight.getMaxX()) || !(boundFixed.getMaxY() > boundMovingRight.getMinY()) || !(boundFixed.getMinY() < boundMovingRight.getMaxY())) continue;
                    bestRightMotion += boundFixed.getMaxX() - boundMovingRight.getMinX();
                    intersects = true;
                    tryNegRight = false;
                    break;
                }
                if (bestRightMotion <= 0.0 && tryNegRight) {
                    bestRightMotion -= pcMoving.getNodesInCluster().get(0).getWidth();
                    if (pcMoving.getBounds().getMaxX() + bestRightMotion <= pcFixed.getBounds().getMinX()) {
                        bestRightMotion = 0.0;
                        tryNegRight = false;
                    }
                    intersects = true;
                }
                ERectangle boundMovingUp = ERectangle.fromLambda(pnMoving.getX() + dX - pnMoving.getWidth() / 2.0, pnMoving.getY() + dY + bestUpMotion - pnMoving.getHeight() / 2.0, pnMoving.getWidth(), pnMoving.getHeight());
                RTNode.Search sea3 = new RTNode.Search(boundMovingUp, root2, true);
                while (sea3.hasNext()) {
                    ERectangle boundFixed = ((ProxyNode)sea3.next()).getBounds();
                    if (!(boundFixed.getMaxX() > boundMovingUp.getMinX()) || !(boundFixed.getMinX() < boundMovingUp.getMaxX()) || !(boundFixed.getMaxY() > boundMovingUp.getMinY()) || !(boundFixed.getMinY() < boundMovingUp.getMaxY())) continue;
                    bestUpMotion += boundFixed.getMaxY() - boundMovingUp.getMinY();
                    intersects = true;
                    tryNegUp = false;
                    break;
                }
                if (bestUpMotion <= 0.0 && tryNegUp) {
                    bestUpMotion -= pcMoving.getNodesInCluster().get(0).getHeight();
                    if (pcMoving.getBounds().getMaxY() + bestUpMotion <= pcFixed.getBounds().getMinY()) {
                        bestUpMotion = 0.0;
                        tryNegUp = false;
                    }
                    intersects = true;
                }
                ERectangle boundMovingDown = ERectangle.fromLambda(pnMoving.getX() + dX - pnMoving.getWidth() / 2.0, pnMoving.getY() + dY - bestDownMotion - pnMoving.getHeight() / 2.0, pnMoving.getWidth(), pnMoving.getHeight());
                RTNode.Search sea4 = new RTNode.Search(boundMovingDown, root2, true);
                while (sea4.hasNext()) {
                    ProxyNode pnf = (ProxyNode)sea4.next();
                    ERectangle boundFixed = pnf.getBounds();
                    if (!(boundFixed.getMaxX() > boundMovingDown.getMinX()) || !(boundFixed.getMinX() < boundMovingDown.getMaxX()) || !(boundFixed.getMaxY() > boundMovingDown.getMinY()) || !(boundFixed.getMinY() < boundMovingDown.getMaxY())) continue;
                    bestDownMotion += boundMovingDown.getMaxY() - boundFixed.getMinY();
                    intersects = true;
                    tryNegDown = false;
                    break;
                }
                if (bestDownMotion <= 0.0 && tryNegDown) {
                    bestDownMotion -= pcMoving.getNodesInCluster().get(0).getHeight();
                    if (pcMoving.getBounds().getMinY() - bestDownMotion >= pcFixed.getBounds().getMaxY()) {
                        bestDownMotion = 0.0;
                        tryNegDown = false;
                    }
                    intersects = true;
                }
                if (!intersects) continue;
                continue block7;
            }
        }
        double moveX = 0.0;
        double moveY = 0.0;
        switch (forceDir) {
            case 0: {
                moveX = -bestLeftMotion;
                break;
            }
            case 1: {
                moveX = bestRightMotion;
                break;
            }
            case 2: {
                moveY = bestUpMotion;
                break;
            }
            case 3: {
                moveY = -bestDownMotion;
                break;
            }
            default: {
                moveX = bestLeftMotion < bestRightMotion ? -bestLeftMotion : bestRightMotion;
                moveY = bestDownMotion < bestUpMotion ? -bestDownMotion : bestUpMotion;
                if (Math.abs(moveX) > Math.abs(moveY)) {
                    moveX = 0.0;
                    break;
                }
                moveY = 0.0;
            }
        }
        return EPoint.fromLambda(moveX + dX, moveY + dY);
    }

    private void showProposal(ProposedPlacement pp) {
        TextDescriptor td;
        NodeInst newNI;
        Cell cell = Cell.newInstance(Library.getCurrent(), "DEBUG" + ++showIndex);
        Point2D fromPt = new Point2D.Double(0.0, 0.0);
        Point2D toPt = new Point2D.Double(0.0, 0.0);
        ProxyNode fromPN = (ProxyNode)pp.proxyMap.get(((ProposedPlacement)pp).movedPair.n1);
        ProxyNode toPN = (ProxyNode)pp.proxyMap.get(((ProposedPlacement)pp).movedPair.n2);
        for (ProxyNode pn : pp.nodesToPlace) {
            NodeInst ni = ((PlacementAdapter.PlacementNode)pn.original).getOriginal();
            double width = ni.getProto().getDefWidth(this.ep);
            double height = ni.getProto().getDefHeight(this.ep);
            double xPos = pn.getX();
            double yPos = pn.getY();
            if (ni.isCellInstance()) {
                Cell placementCell = (Cell)ni.getProto();
                ERectangle bounds = placementCell.getBounds();
                Point2D.Double centerOffset = new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY());
                pn.getOrientation().pureRotate().transform(centerOffset, centerOffset);
                xPos -= ((Point2D)centerOffset).getX();
                yPos -= ((Point2D)centerOffset).getY();
            }
            EPoint ctr = EPoint.fromLambda(xPos, yPos);
            if (pn == fromPN) {
                fromPt = ctr;
            }
            if (pn == toPN) {
                toPt = ctr;
            }
            newNI = NodeInst.makeInstance(ni.getProto(), this.ep, ctr, width, height, cell, pn.getOrientation(), ni.getName());
            TextDescriptor td2 = this.ep.getNodeTextDescriptor().withDisplay(true).withRelSize(20.0);
            newNI.setTextDescriptor(NodeInst.NODE_NAME, td2);
        }
        for (ProxyCluster cluster : pp.allClusters) {
            if (cluster.getNodesInCluster().size() <= 1) continue;
            PolyMerge merge = new PolyMerge();
            for (ProxyNode pn : cluster.getNodesInCluster()) {
                Poly poly = new Poly(pn.getBounds());
                merge.add(Artwork.tech().defaultLayer, poly);
            }
            List<PolyBase> polys = merge.getMergedPoints(Artwork.tech().defaultLayer, true);
            for (PolyBase pb : polys) {
                PolyBase.Point[] oldPts = pb.getPoints();
                EPoint[] newPts = new EPoint[oldPts.length];
                double cX = pb.getCenterX();
                double cY = pb.getCenterY();
                for (int i = 0; i < oldPts.length; ++i) {
                    double nX = ((Point2D)oldPts[i]).getX();
                    double nY = ((Point2D)oldPts[i]).getY();
                    if (nX < cX) {
                        nX += 5.0;
                    } else if (nX > cX) {
                        nX -= 5.0;
                    }
                    if (nY < cY) {
                        nY += 5.0;
                    } else if (nY > cY) {
                        nY -= 5.0;
                    }
                    newPts[i] = EPoint.fromLambda(nX, nY);
                }
                newNI = NodeInst.makeInstance(Artwork.tech().openedPolygonNode, this.ep, EPoint.fromLambda(cX, cY), pb.getBounds2D().getWidth() - 10.0, pb.getBounds2D().getHeight() - 10.0, cell);
                newNI.setTrace(newPts);
                newNI.newVar(Artwork.ART_COLOR, (Object)new Integer(10), this.ep);
            }
        }
        NodeInst arrowHead = NodeInst.makeInstance(Artwork.tech().pinNode, this.ep, fromPt, 0.0, 0.0, cell);
        NodeInst arrowTail = NodeInst.makeInstance(Artwork.tech().pinNode, this.ep, toPt, 0.0, 0.0, cell);
        ArcInst ai = ArcInst.makeInstance(Artwork.tech().thickerArc, this.ep, arrowHead.getOnlyPortInst(), arrowTail.getOnlyPortInst());
        ai.newVar(Artwork.ART_COLOR, (Object)new Integer(18), this.ep);
        int angle = DBMath.figureAngle(toPt, fromPt);
        int ang1 = (angle + 450) % 3600;
        int ang2 = (angle + 3150) % 3600;
        double cX = (fromPt.getX() + toPt.getX()) / 2.0;
        double cY = (fromPt.getY() + toPt.getY()) / 2.0;
        double len = DBMath.distBetweenPoints(fromPt, toPt) / 5.0;
        double x1 = cX + DBMath.cos(ang1) * len;
        double y1 = cY + DBMath.sin(ang1) * len;
        double x2 = cX + DBMath.cos(ang2) * len;
        double y2 = cY + DBMath.sin(ang2) * len;
        NodeInst arrowCtr = NodeInst.makeInstance(Artwork.tech().pinNode, this.ep, EPoint.fromLambda(cX, cY), 0.0, 0.0, cell);
        NodeInst arrowEnd1 = NodeInst.makeInstance(Artwork.tech().pinNode, this.ep, EPoint.fromLambda(x1, y1), 0.0, 0.0, cell);
        NodeInst arrowEnd2 = NodeInst.makeInstance(Artwork.tech().pinNode, this.ep, EPoint.fromLambda(x2, y2), 0.0, 0.0, cell);
        ai = ArcInst.makeInstance(Artwork.tech().thickerArc, this.ep, arrowCtr.getOnlyPortInst(), arrowEnd1.getOnlyPortInst());
        ai.newVar(Artwork.ART_COLOR, (Object)new Integer(18), this.ep);
        ai = ArcInst.makeInstance(Artwork.tech().thickerArc, this.ep, arrowCtr.getOnlyPortInst(), arrowEnd2.getOnlyPortInst());
        ai.newVar(Artwork.ART_COLOR, (Object)new Integer(18), this.ep);
        double x3 = cell.getBounds().getCenterX();
        double y = cell.getBounds().getMaxY() + 10.0;
        PrimitiveNode np = Generic.tech().invisiblePinNode;
        for (int i = pp.furtherExplanation.size() - 1; i >= 0; --i) {
            NodeInst ni = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(x3, y), 0.0, 0.0, cell);
            td = this.ep.getAnnotationTextDescriptor().withDisplay(true).withRelSize(10.0);
            ni.newVar(Artwork.ART_MESSAGE, pp.furtherExplanation.get(i), td);
            y += 10.0;
        }
        NodeInst ni = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(x3, y + 5.0), 0.0, 0.0, cell);
        String msg = "Proposal " + pp.proposalNumber + " from parent proposal " + pp.parentProposalNumber;
        td = this.ep.getAnnotationTextDescriptor().withDisplay(true).withRelSize(15.0);
        ni.newVar(Artwork.ART_MESSAGE, (Object)msg, td);
    }

    static /* synthetic */ int access$608() {
        return proposedPlacementIndex++;
    }

    static {
        proposedPlacementIndex = 1;
        showIndex = 0;
    }

    private class ProxyNode
    implements RTBounds {
        private double x;
        private double y;
        private Orientation orientation;
        private double width;
        private double height;
        private double xSave;
        private double ySave;
        private Orientation orientationSave;
        private double widthSave;
        private double heightSave;
        private ERectangle bounds;
        private PlacementFrame.PlacementNode original;

        public ProxyNode(PlacementFrame.PlacementNode node) {
            this.original = node;
            NodeInst ni = ((PlacementAdapter.PlacementNode)node).getOriginal();
            this.x = DBMath.round(ni.getTrueCenterX());
            this.y = DBMath.round(ni.getTrueCenterY());
            this.orientation = ni.getOrient();
            NodeProto np = ((PlacementAdapter.PlacementNode)node).getType();
            Rectangle2D spacing = null;
            if (np instanceof Cell) {
                spacing = ((Cell)np).findEssentialBounds();
            }
            if (spacing == null) {
                this.width = node.getWidth();
                this.height = node.getHeight();
            } else {
                this.width = spacing.getWidth();
                this.height = spacing.getHeight();
            }
            if (ni.getOrient().getAngle() == 900 || ni.getOrient().getAngle() == 2700) {
                double swap = this.width;
                this.width = this.height;
                this.height = swap;
            }
            this.computeBounds();
        }

        public ProxyNode(ProxyNode pn) {
            this.x = pn.x;
            this.y = pn.y;
            this.orientation = pn.orientation;
            this.width = pn.width;
            this.height = pn.height;
            this.original = pn.original;
            this.computeBounds();
        }

        public String toString() {
            NodeInst ni = ((PlacementAdapter.PlacementNode)this.original).getOriginal();
            return ni.describe(false);
        }

        public String getNodeName() {
            NodeInst ni = ((PlacementAdapter.PlacementNode)this.original).getOriginal();
            return ni.getName();
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x2, double y) {
            this.x = DBMath.round(x2);
            this.y = DBMath.round(y);
            this.computeBounds();
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public Orientation getOrientation() {
            return this.orientation;
        }

        public void changeOrientation(Orientation delta) {
            Orientation newOrientation = delta.concatenate(this.orientation);
            int deltaAng = Math.abs(this.orientation.getAngle() - newOrientation.getAngle());
            if (deltaAng == 900 || deltaAng == 2700) {
                double swap = this.width;
                this.width = this.height;
                this.height = swap;
                this.computeBounds();
            }
            this.orientation = newOrientation;
        }

        @Override
        public ERectangle getBounds() {
            return this.bounds;
        }

        private void computeBounds() {
            this.bounds = ERectangle.fromLambda(this.x - this.width / 2.0, this.y - this.height / 2.0, this.width, this.height);
        }

        public void saveValues() {
            this.xSave = this.x;
            this.ySave = this.y;
            this.orientationSave = this.orientation;
            this.widthSave = this.width;
            this.heightSave = this.height;
        }

        public void restoreValues() {
            this.x = this.xSave;
            this.y = this.ySave;
            this.orientation = this.orientationSave;
            this.width = this.widthSave;
            this.height = this.heightSave;
            this.computeBounds();
        }
    }

    private static class ProxyCluster
    implements RTBounds,
    Comparable<ProxyCluster> {
        private List<ProxyNode> nodesInCluster = new ArrayList<ProxyNode>();
        private ERectangle bound;
        private int clusterIndex;

        ProxyCluster() {
        }

        @Override
        public int compareTo(ProxyCluster pcO) {
            double sizeB;
            double sizeA = this.bound.getWidth() * this.bound.getHeight();
            if (sizeA > (sizeB = pcO.bound.getWidth() * pcO.bound.getHeight())) {
                return -1;
            }
            if (sizeA < sizeB) {
                return 1;
            }
            return 0;
        }

        @Override
        public ERectangle getBounds() {
            return this.bound;
        }

        public List<ProxyNode> getNodesInCluster() {
            return this.nodesInCluster;
        }

        public void computeBounds() {
            double lXAll = 0.0;
            double hXAll = 0.0;
            double lYAll = 0.0;
            double hYAll = 0.0;
            for (int i = 0; i < this.nodesInCluster.size(); ++i) {
                ProxyNode pn = this.nodesInCluster.get(i);
                double lX = pn.getX() - pn.getWidth() / 2.0;
                double hX = lX + pn.getWidth();
                double lY = pn.getY() - pn.getHeight() / 2.0;
                double hY = lY + pn.getHeight();
                if (i == 0) {
                    lXAll = lX;
                    hXAll = hX;
                    lYAll = lY;
                    hYAll = hY;
                    continue;
                }
                if (lX < lXAll) {
                    lXAll = lX;
                }
                if (hX > hXAll) {
                    hXAll = hX;
                }
                if (lY < lYAll) {
                    lYAll = lY;
                }
                if (!(hY > hYAll)) continue;
                hYAll = hY;
            }
            long l = (long)Math.ceil(lXAll * 400.0);
            if ((l & 1L) != 0L) {
                --l;
            }
            lXAll = (double)l / 400.0;
            l = (long)Math.ceil(hXAll * 400.0);
            if ((l & 1L) != 0L) {
                ++l;
            }
            hXAll = (double)l / 400.0;
            l = (long)Math.ceil(lYAll * 400.0);
            if ((l & 1L) != 0L) {
                --l;
            }
            lYAll = (double)l / 400.0;
            l = (long)Math.ceil(hYAll * 400.0);
            if ((l & 1L) != 0L) {
                ++l;
            }
            hYAll = (double)l / 400.0;
            this.bound = ERectangle.fromLambda(lXAll, lYAll, hXAll - lXAll, hYAll - lYAll);
        }

        public double getAreaWithOtherShiftedCluster(ProxyCluster other, EPoint delta) {
            double lXAll = this.bound.getMinX();
            double hXAll = this.bound.getMaxX();
            double lYAll = this.bound.getMinY();
            double hYAll = this.bound.getMaxY();
            for (int i = 0; i < other.getNodesInCluster().size(); ++i) {
                ProxyNode pn = other.getNodesInCluster().get(i);
                double lX = pn.getX() + delta.getX() - pn.getWidth() / 2.0;
                double hX = lX + pn.getWidth();
                double lY = pn.getY() + delta.getY() - pn.getHeight() / 2.0;
                double hY = lY + pn.getHeight();
                if (lX < lXAll) {
                    lXAll = lX;
                }
                if (hX > hXAll) {
                    hXAll = hX;
                }
                if (lY < lYAll) {
                    lYAll = lY;
                }
                if (!(hY > hYAll)) continue;
                hYAll = hY;
            }
            double area = (hXAll - lXAll) * (hYAll - lYAll);
            return area;
        }

        public void rotate(Orientation spin) {
            if (spin == Orientation.IDENT) {
                return;
            }
            for (ProxyNode pn : this.nodesInCluster) {
                double ox = pn.getX() - this.bound.getCenterX();
                double oy = pn.getY() - this.bound.getCenterY();
                Point2D newOff = spin.transformPoint(new Point2D.Double(ox, oy));
                pn.setLocation(newOff.getX() + this.bound.getCenterX(), newOff.getY() + this.bound.getCenterY());
                pn.changeOrientation(spin);
            }
            this.computeBounds();
        }

        public void add(ProxyNode pNode) {
            this.nodesInCluster.add(pNode);
            ERectangle b = ERectangle.fromLambda(pNode.getX() - pNode.getWidth() / 2.0, pNode.getY() - pNode.getHeight() / 2.0, pNode.getWidth(), pNode.getHeight());
            this.bound = this.nodesInCluster.size() == 1 ? b : (ERectangle)this.bound.createUnion(b);
        }

        public String toString() {
            String str = "CLUSTER";
            String sep = " ";
            for (ProxyNode pNode : this.nodesInCluster) {
                str = str + sep + pNode.getNodeName();
                sep = "/";
            }
            return str;
        }
    }

    private class ComputeForce {
        private double dX;
        private double dY;
        private int numMoved;
        private double[] dXQ;
        private double[] dYQ;
        private int[] numMovedQ;
        private ProxyNode px1;
        private ProxyNode px2;
        private List<EPoint> perfectAlignment;
        private List<EPoint> imperfectAlignment;

        public ComputeForce(ProposedPlacement pp, ProxyNode px1, ProxyNode px2) {
            this.px1 = px1;
            this.px2 = px2;
            this.dXQ = new double[8];
            this.dYQ = new double[8];
            this.numMovedQ = new int[8];
            this.perfectAlignment = new ArrayList<EPoint>();
            this.imperfectAlignment = new ArrayList<EPoint>();
        }

        public void accumulateForce(double addX, double addY, boolean isOnRail) {
            this.dX += addX;
            this.dY += addY;
            ++this.numMoved;
            int quadrant = -1;
            if (addX == 0.0) {
                if (addY > 0.0) {
                    quadrant = 2;
                } else if (addY < 0.0) {
                    quadrant = 6;
                }
            } else {
                quadrant = addX > 0.0 ? (addY == 0.0 ? 0 : (addY > 0.0 ? 1 : 7)) : (addY == 0.0 ? 4 : (addY > 0.0 ? 3 : 5));
            }
            if (quadrant >= 0) {
                int n = quadrant;
                this.dXQ[n] = this.dXQ[n] + addX;
                int n2 = quadrant;
                this.dYQ[n2] = this.dYQ[n2] + addY;
                int n3 = quadrant;
                this.numMovedQ[n3] = this.numMovedQ[n3] + 1;
            }
            boolean alignedPerfectly = false;
            double top1 = this.px1.getY() + this.px1.getHeight() / 2.0 + addY;
            double bot1 = this.px1.getY() - this.px1.getHeight() / 2.0 + addY;
            double right1 = this.px1.getX() + this.px1.getWidth() / 2.0 + addX;
            double left1 = this.px1.getX() - this.px1.getWidth() / 2.0 + addX;
            double top2 = this.px2.getY() + this.px2.getHeight() / 2.0;
            double bot2 = this.px2.getY() - this.px2.getHeight() / 2.0;
            double right2 = this.px2.getX() + this.px2.getWidth() / 2.0;
            double left2 = this.px2.getX() - this.px2.getWidth() / 2.0;
            if (DBMath.areEquals(top1, top2) && DBMath.areEquals(bot1, bot2)) {
                alignedPerfectly = true;
            }
            if (DBMath.areEquals(right1, right2) && DBMath.areEquals(left1, left2)) {
                alignedPerfectly = true;
            }
            if (isOnRail) {
                alignedPerfectly = true;
            }
            if (alignedPerfectly) {
                this.perfectAlignment.add(EPoint.fromLambda(addX, addY));
            }
        }

        public void normalizeForce() {
            if (this.numMoved != 0) {
                this.dX /= (double)this.numMoved;
                this.dY /= (double)this.numMoved;
            }
            if (this.numMoved > 1) {
                int biggestQuadrant = -1;
                int numInBiggestQuadrant = 0;
                for (int i = 0; i < 8; ++i) {
                    if (this.numMovedQ[i] > numInBiggestQuadrant) {
                        numInBiggestQuadrant = this.numMovedQ[i];
                        biggestQuadrant = i;
                    }
                    if (this.numMovedQ[i] <= 0) continue;
                    int n = i;
                    this.dXQ[n] = this.dXQ[n] / (double)this.numMovedQ[i];
                    int n2 = i;
                    this.dYQ[n2] = this.dYQ[n2] / (double)this.numMovedQ[i];
                }
                if (biggestQuadrant >= 0 && numInBiggestQuadrant * 2 > this.numMoved) {
                    this.dX = this.dXQ[biggestQuadrant];
                    this.dY = this.dYQ[biggestQuadrant];
                }
            }
            if (this.perfectAlignment.size() > 0 || this.imperfectAlignment.size() > 0) {
                double dist;
                double offY;
                double offX;
                double bestDist = Double.MAX_VALUE;
                EPoint bestMove = null;
                for (EPoint move : this.perfectAlignment) {
                    offX = this.dX - move.getX();
                    dist = Math.sqrt(offX * offX + (offY = this.dY - move.getY()) * offY);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                    bestMove = move;
                }
                if (this.perfectAlignment.isEmpty()) {
                    for (EPoint move : this.imperfectAlignment) {
                        offX = this.dX - move.getX();
                        dist = Math.sqrt(offX * offX + (offY = this.dY - move.getY()) * offY);
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                        bestMove = move;
                    }
                }
                if (bestMove != null) {
                    this.dX = bestMove.getX();
                    this.dY = bestMove.getY();
                }
            }
        }

        public double getForceX() {
            return DBMath.round(this.dX);
        }

        public double getForceY() {
            return DBMath.round(this.dY);
        }
    }

    private class RotationTest
    implements Comparable<RotationTest> {
        private double metric;
        private Point2D delta;
        private ERectangle overallBound;
        private Orientation spin;
        private ProxyNode beingMoved;
        ProxyCluster cluster1;
        ProxyCluster cluster2;

        public RotationTest(ProposedPlacement pp, ProxyNode pn1, ProxyNode pn2, Orientation spin, int forceDir) {
            this.beingMoved = pn1;
            this.spin = spin;
            this.delta = new Point2D.Double();
            this.cluster1 = (ProxyCluster)pp.clusterMap.get(pn1);
            this.cluster2 = (ProxyCluster)pp.clusterMap.get(pn2);
            this.metric = this.bringTogether(pp, pn1, pn2, this.delta, spin, forceDir);
        }

        public String toString() {
            String msg = "MOVE " + this.beingMoved + " R=" + this.spin.toString() + " TO (" + (this.beingMoved.getX() + this.delta.getX()) + "," + (this.beingMoved.getY() + this.delta.getY()) + ")";
            return msg;
        }

        @Override
        public int compareTo(RotationTest other) {
            double metricImprovement = (other.metric - this.metric) / Math.max(other.metric, this.metric);
            double thisArea = this.overallBound.getWidth() * this.overallBound.getHeight();
            double otherArea = other.overallBound.getWidth() * other.overallBound.getHeight();
            double boundImprovement = (otherArea - thisArea) / Math.max(thisArea, otherArea);
            double aspectRatioThis = this.overallBound.getWidth() > this.overallBound.getHeight() ? this.overallBound.getHeight() / this.overallBound.getWidth() : this.overallBound.getWidth() / this.overallBound.getHeight();
            double aspectRatioOther = other.overallBound.getWidth() > other.overallBound.getHeight() ? other.overallBound.getHeight() / other.overallBound.getWidth() : other.overallBound.getWidth() / other.overallBound.getHeight();
            double aspectRatioImprovement = (aspectRatioThis - aspectRatioOther) / Math.max(aspectRatioOther, aspectRatioThis);
            double totalImprovement = metricImprovement + (boundImprovement *= boundWeight) + (aspectRatioImprovement *= aspectRatioWeight);
            if (totalImprovement < 0.0) {
                return 1;
            }
            if (totalImprovement > 0.0) {
                return -1;
            }
            return 0;
        }

        public Point2D getDelta() {
            return this.delta;
        }

        public Orientation getOrientation() {
            return this.spin;
        }

        private double bringTogether(ProposedPlacement pp, ProxyNode px1, ProxyNode px2, Point2D delta, Orientation spin1, int forceDir) {
            PlacementFrame.PlacementPort pp2;
            PlacementFrame.PlacementPort pp1;
            ComputeForce cf = new ComputeForce(pp, px1, px2);
            for (ProxyNode pn : this.cluster1.nodesInCluster) {
                pn.saveValues();
            }
            this.cluster1.rotate(spin1);
            ArrayList<SteinerTree.SteinerTreePortPair> consOnC1 = new ArrayList<SteinerTree.SteinerTreePortPair>();
            for (ProxyNode pn : this.cluster1.nodesInCluster) {
                for (SteinerTree.SteinerTreePortPair pc : (List)consOnNodes.get(pn.original)) {
                    consOnC1.add(pc);
                }
            }
            HashSet<PlacementFrame.PlacementNode> nodesInC1 = new HashSet<PlacementFrame.PlacementNode>();
            for (ProxyNode pn : this.cluster1.nodesInCluster) {
                nodesInC1.add(pn.original);
            }
            HashSet<PlacementFrame.PlacementNode> nodesInC2 = new HashSet<PlacementFrame.PlacementNode>();
            for (ProxyNode pn : this.cluster2.nodesInCluster) {
                nodesInC2.add(pn.original);
            }
            ArrayList<SteinerTree.SteinerTreePortPair> validConnections = new ArrayList<SteinerTree.SteinerTreePortPair>();
            for (SteinerTree.SteinerTreePortPair con : consOnC1) {
                pp1 = (PlacementFrame.PlacementPort)con.getPort1();
                pp2 = (PlacementFrame.PlacementPort)con.getPort2();
                boolean linksTheNodes = false;
                if (nodesInC1.contains(pp1.getPlacementNode()) && nodesInC2.contains(pp2.getPlacementNode())) {
                    linksTheNodes = true;
                }
                if (nodesInC1.contains(pp2.getPlacementNode()) && nodesInC2.contains(pp1.getPlacementNode())) {
                    linksTheNodes = true;
                }
                if (!linksTheNodes) continue;
                validConnections.add(con);
            }
            for (SteinerTree.SteinerTreePortPair con : validConnections) {
                pp1 = (PlacementFrame.PlacementPort)con.getPort1();
                pp2 = (PlacementFrame.PlacementPort)con.getPort2();
                ProxyNode pxn1 = (ProxyNode)pp.proxyMap.get(pp1.getPlacementNode());
                Orientation o1 = pxn1.getOrientation();
                Point2D off1 = o1.transformPoint(new Point2D.Double(pp1.getOffX(), pp1.getOffY()));
                double x1 = pxn1.getX() + off1.getX();
                double y1 = pxn1.getY() + off1.getY();
                ProxyNode pxn2 = (ProxyNode)pp.proxyMap.get(pp2.getPlacementNode());
                Orientation o2 = pxn2.getOrientation();
                Point2D off2 = o2.transformPoint(new Point2D.Double(pp2.getOffX(), pp2.getOffY()));
                double x2 = pxn2.getX() + off2.getX();
                double y2 = pxn2.getY() + off2.getY();
                double dX = x2 - x1;
                double dY = y2 - y1;
                boolean isOnRail = pp1.getPlacementNetwork().isOnRail();
                if (pxn1 == px1) {
                    cf.accumulateForce(dX, dY, isOnRail);
                    continue;
                }
                if (pxn2 != px1) continue;
                cf.accumulateForce(-dX, -dY, isOnRail);
            }
            cf.normalizeForce();
            double dX = cf.getForceX();
            double dY = cf.getForceY();
            EPoint newDelta = BottomUpPlace.this.pushCluster(this.cluster1, this.cluster2, dX, dY, forceDir, null);
            dX = newDelta.getX();
            dY = newDelta.getY();
            delta.setLocation(newDelta);
            double totalLen = 0.0;
            for (SteinerTree.SteinerTreePortPair con : validConnections) {
                PlacementFrame.PlacementPort pp12 = (PlacementFrame.PlacementPort)con.getPort1();
                PlacementFrame.PlacementPort pp22 = (PlacementFrame.PlacementPort)con.getPort2();
                ProxyNode pxn1 = (ProxyNode)pp.proxyMap.get(pp12.getPlacementNode());
                ProxyNode pxn2 = (ProxyNode)pp.proxyMap.get(pp22.getPlacementNode());
                double x1 = pxn1.getX();
                double y1 = pxn1.getY();
                double x2 = pxn2.getX();
                double y2 = pxn2.getY();
                if (px1 == pxn1) {
                    x1 += dX;
                    y1 += dY;
                } else {
                    x2 += dX;
                    y2 += dY;
                }
                Orientation o1 = pxn1.getOrientation();
                Point2D off1 = o1.transformPoint(new Point2D.Double(pp12.getOffX(), pp12.getOffY()));
                Orientation o2 = pxn2.getOrientation();
                Point2D off2 = o2.transformPoint(new Point2D.Double(pp22.getOffX(), pp22.getOffY()));
                double dist = Math.sqrt(((x2 += off2.getX()) - (x1 += off1.getX())) * (x2 - x1) + ((y2 += off2.getY()) - (y1 += off1.getY())) * (y2 - y1));
                if (!pp12.getPlacementNetwork().isOnRail()) {
                    dist *= 2.0;
                }
                totalLen += dist;
            }
            double lXTot = this.cluster2.getBounds().getMinX();
            double hXTot = this.cluster2.getBounds().getMaxX();
            double lYTot = this.cluster2.getBounds().getMinY();
            double hYTot = this.cluster2.getBounds().getMaxY();
            for (ProxyNode pn : this.cluster1.nodesInCluster) {
                double lX = pn.getX() - pn.getWidth() / 2.0 + dX;
                double hX = lX + pn.getWidth();
                double lY = pn.getY() - pn.getHeight() / 2.0 + dY;
                double hY = lY + pn.getHeight();
                if (lX < lXTot) {
                    lXTot = lX;
                }
                if (hX > hXTot) {
                    hXTot = hX;
                }
                if (lY < lYTot) {
                    lYTot = lY;
                }
                if (!(hY > hYTot)) continue;
                hYTot = hY;
            }
            this.overallBound = ERectangle.fromLambda(lXTot, lYTot, hXTot - lXTot, hYTot - lYTot);
            for (ProxyNode pn : this.cluster1.nodesInCluster) {
                pn.restoreValues();
            }
            this.cluster1.computeBounds();
            return totalLen;
        }
    }

    private static class SortPlacementByHPWL
    implements Comparator<ProposedPlacement> {
        private SortPlacementByHPWL() {
        }

        @Override
        public int compare(ProposedPlacement pp1, ProposedPlacement pp2) {
            if (pp1.hpwl < pp2.hpwl) {
                return -1;
            }
            if (pp1.hpwl > pp2.hpwl) {
                return 1;
            }
            return 0;
        }
    }

    private class ProposedPlacement
    implements Comparable<ProposedPlacement> {
        private List<ProxyNode> nodesToPlace = new ArrayList<ProxyNode>();
        private Map<PlacementFrame.PlacementNode, ProxyNode> proxyMap = new HashMap<PlacementFrame.PlacementNode, ProxyNode>();
        private List<ProxyCluster> allClusters = new ArrayList<ProxyCluster>();
        private Map<ProxyNode, ProxyCluster> clusterMap = new HashMap<ProxyNode, ProxyCluster>();
        private int groupPosition;
        private double hpwl;
        private double quality;
        private int proposalNumber = BottomUpPlace.access$608();
        private int parentProposalNumber;
        private BottomUpPartition.PNPair movedPair;
        private List<String> furtherExplanation;

        ProposedPlacement() {
        }

        ProposedPlacement(List<PlacementFrame.PlacementNode> placementNodes) {
            this();
            this.groupPosition = 0;
            for (int i = 0; i < placementNodes.size(); ++i) {
                PlacementFrame.PlacementNode p = placementNodes.get(i);
                ProxyNode proxy = bottomUpPlace.new ProxyNode(p);
                this.nodesToPlace.add(proxy);
                this.proxyMap.put(p, proxy);
                ProxyCluster pCluster = new ProxyCluster();
                this.clusterMap.put(proxy, pCluster);
                pCluster.clusterIndex = i;
                this.allClusters.add(pCluster);
                pCluster.add(proxy);
            }
        }

        ProposedPlacement(ProposedPlacement copyIt, boolean duplicateProxys) {
            this();
            if (duplicateProxys) {
                for (PlacementFrame.PlacementNode placementNode : copyIt.proxyMap.keySet()) {
                    ProxyNode pNode = copyIt.proxyMap.get(placementNode);
                    ProxyNode copyPN = bottomUpPlace.new ProxyNode(pNode);
                    this.nodesToPlace.add(copyPN);
                    this.proxyMap.put(placementNode, copyPN);
                }
            } else {
                for (ProxyNode proxyNode : copyIt.nodesToPlace) {
                    this.nodesToPlace.add(proxyNode);
                }
                for (PlacementFrame.PlacementNode placementNode : copyIt.proxyMap.keySet()) {
                    this.proxyMap.put(placementNode, copyIt.proxyMap.get(placementNode));
                }
            }
            for (ProxyCluster proxyCluster : copyIt.allClusters) {
                this.allClusters.add(proxyCluster);
            }
            for (ProxyNode proxyNode : copyIt.clusterMap.keySet()) {
                this.clusterMap.put(proxyNode, copyIt.clusterMap.get(proxyNode));
            }
            this.groupPosition = copyIt.groupPosition;
            this.parentProposalNumber = copyIt.proposalNumber;
        }

        @Override
        public int compareTo(ProposedPlacement pp) {
            if (this.quality > pp.quality) {
                return 1;
            }
            if (this.quality < pp.quality) {
                return -1;
            }
            return 0;
        }

        public Rectangle2D getBounds(List<PlacementFrame.PlacementNode> placementNodes) {
            Rectangle2D initialBound = null;
            for (PlacementFrame.PlacementNode pn : placementNodes) {
                ProxyNode p = this.proxyMap.get(pn);
                double lX = p.getX() - p.getWidth() / 2.0;
                double hX = lX + p.getWidth();
                double lY = p.getY() - p.getHeight() / 2.0;
                double hY = lY + p.getHeight();
                Rectangle2D.Double bound = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                if (initialBound == null) {
                    initialBound = bound;
                    continue;
                }
                initialBound = ((Rectangle2D)initialBound).createUnion(bound);
            }
            return initialBound;
        }

        public double computeQuality(List<PlacementFrame.PlacementNetwork> allNetworks) {
            this.hpwl = 0.0;
            for (PlacementFrame.PlacementNetwork pNet : allNetworks) {
                double lXTot = Double.MAX_VALUE;
                double hXTot = -1.7976931348623157E308;
                double lYTot = Double.MAX_VALUE;
                double hYTot = -1.7976931348623157E308;
                for (PlacementFrame.PlacementPort pPort : pNet.getPortsOnNet()) {
                    ProxyNode pxn = this.proxyMap.get(pPort.getPlacementNode());
                    Orientation o = pxn.getOrientation();
                    Point2D off = o.transformPoint(new Point2D.Double(pPort.getOffX(), pPort.getOffY()));
                    double x2 = pxn.getX() + off.getX();
                    double y = pxn.getY() + off.getY();
                    if (x2 < lXTot) {
                        lXTot = x2;
                    }
                    if (x2 > hXTot) {
                        hXTot = x2;
                    }
                    if (y < lYTot) {
                        lYTot = y;
                    }
                    if (!(y > hYTot)) continue;
                    hYTot = y;
                }
                double h = (hXTot - lXTot + (hYTot - lYTot)) / 2.0;
                this.hpwl += h;
            }
            double aspectRatioFactor = 1.0;
            for (ProxyCluster cluster : this.allClusters) {
                if (cluster.getNodesInCluster().size() <= 1) continue;
                double aspectRatio = cluster.bound.getWidth() > cluster.bound.getHeight() ? cluster.bound.getHeight() / cluster.bound.getWidth() : cluster.bound.getWidth() / cluster.bound.getHeight();
                aspectRatioFactor *= aspectRatio;
            }
            this.quality = this.hpwl * aspectRatioFactor;
            return this.quality;
        }

        public ProxyCluster copyCluster(ProxyCluster cluster) {
            ProxyCluster newCluster = new ProxyCluster();
            newCluster.clusterIndex = cluster.clusterIndex;
            this.allClusters.set(cluster.clusterIndex, newCluster);
            newCluster.bound = ERectangle.fromLambda(cluster.bound.getX(), cluster.bound.getY(), cluster.bound.getWidth(), cluster.bound.getHeight());
            ArrayList<ProxyNode> newClusterList = new ArrayList<ProxyNode>();
            for (ProxyNode pn : cluster.getNodesInCluster()) {
                ProxyNode copyPN = new ProxyNode(pn);
                this.nodesToPlace.remove(pn);
                this.nodesToPlace.add(copyPN);
                this.proxyMap.put(pn.original, copyPN);
                newClusterList.add(copyPN);
                this.clusterMap.remove(pn);
                this.clusterMap.put(copyPN, newCluster);
            }
            newCluster.nodesInCluster = newClusterList;
            return newCluster;
        }

        private List<ProposedPlacement> clusteringPlacementStep(int clustersToMerge) {
            ArrayList<ProposedPlacement> choices = new ArrayList<ProposedPlacement>();
            while (choices.size() == 0 && this.groupPosition < orderedPairGroups.size()) {
                for (BottomUpPartition.PNPair pnp : (List)orderedPairGroups.get(this.groupPosition)) {
                    ProxyCluster cluster2;
                    ProxyNode pnp1 = this.proxyMap.get(pnp.n1);
                    ProxyNode pnp2 = this.proxyMap.get(pnp.n2);
                    ProxyCluster cluster1 = this.clusterMap.get(pnp1);
                    if (cluster1 == (cluster2 = this.clusterMap.get(pnp2))) continue;
                    String explanation = "MOVED NODE: " + pnp1.getNodeName() + " AT (" + pnp1.getX() + "," + pnp1.getY() + ") TO NODE " + pnp2.getNodeName() + " AT (" + pnp2.getX() + "," + pnp2.getY() + ")";
                    ArrayList<RotationTest> allTests = new ArrayList<RotationTest>();
                    for (int forceDir = 0; forceDir < 4; ++forceDir) {
                        RotationTest spinI = new RotationTest(this, pnp1, pnp2, Orientation.IDENT, forceDir);
                        allTests.add(spinI);
                        allTests.add(new RotationTest(this, pnp1, pnp2, Orientation.X, forceDir));
                        allTests.add(new RotationTest(this, pnp1, pnp2, Orientation.Y, forceDir));
                        allTests.add(new RotationTest(this, pnp1, pnp2, Orientation.RR, forceDir));
                        if (!BottomUpPlace.this.canRotate.getBooleanValue()) continue;
                        allTests.add(new RotationTest(this, pnp1, pnp2, Orientation.R, forceDir));
                        allTests.add(new RotationTest(this, pnp1, pnp2, Orientation.RRR, forceDir));
                        allTests.add(new RotationTest(this, pnp1, pnp2, Orientation.YR, forceDir));
                        allTests.add(new RotationTest(this, pnp1, pnp2, Orientation.YRRR, forceDir));
                    }
                    Collections.sort(allTests);
                    RotationTest bestTest = (RotationTest)allTests.get(0);
                    ProposedPlacement newPP = new ProposedPlacement(this, false);
                    if (newPP.furtherExplanation != null) {
                        newPP.furtherExplanation.add(explanation);
                    }
                    this.makeProposal(newPP, bestTest, pnp, cluster1, cluster2);
                    choices.add(newPP);
                    newPP.movedPair = pnp;
                }
                ++this.groupPosition;
            }
            return choices;
        }

        private void makeProposal(ProposedPlacement newPP, RotationTest bestTest, BottomUpPartition.PNPair pnp, ProxyCluster cluster1, ProxyCluster cluster2) {
            double dX = bestTest.getDelta().getX();
            double dY = bestTest.getDelta().getY();
            cluster1 = newPP.copyCluster(cluster1);
            cluster2 = newPP.copyCluster(cluster2);
            cluster1.rotate(bestTest.getOrientation());
            for (ProxyNode pNode : cluster1.getNodesInCluster()) {
                pNode.setLocation(pNode.getX() + dX, pNode.getY() + dY);
                if (newPP.furtherExplanation == null) continue;
                newPP.furtherExplanation.add("MOVE " + pNode.getNodeName() + " (" + dX + "," + dY + "), ROT=" + bestTest.getOrientation() + " TO (" + pNode.getX() + "," + pNode.getY() + ") ROTATED " + bestTest.getOrientation());
            }
            for (ProxyNode pNode : cluster2.getNodesInCluster()) {
                cluster1.add(pNode);
                newPP.clusterMap.put(pNode, cluster1);
            }
            cluster1.computeBounds();
            int lastIndex = newPP.allClusters.size() - 1;
            if (cluster2.clusterIndex < lastIndex) {
                ProxyCluster newLastCluster = newPP.copyCluster(newPP.allClusters.get(lastIndex));
                if (cluster1.clusterIndex == lastIndex) {
                    cluster1 = newLastCluster;
                }
                newLastCluster.clusterIndex = cluster2.clusterIndex;
                newPP.allClusters.set(newLastCluster.clusterIndex, newLastCluster);
            }
            newPP.allClusters.remove(lastIndex);
            RTNode<ProxyCluster> rTree = newPP.makeClusterRTree();
            int cluster1Index = cluster1.clusterIndex;
            rTree = newPP.plowCluster(cluster1Index, 0.0, 0.0, rTree, true, true, true, true);
            for (int i = 0; i < newPP.allClusters.size(); ++i) {
                if (i == cluster1Index) continue;
                rTree = newPP.plowCluster(i, 0.0, 0.0, rTree, true, true, true, true);
            }
        }

        public void applyProposal(List<PlacementFrame.PlacementNode> placementNodes) {
            for (PlacementFrame.PlacementNode pn : placementNodes) {
                ProxyNode p = this.proxyMap.get(pn);
                pn.setPlacement(p.getX(), p.getY());
                pn.setOrientation(p.getOrientation());
            }
        }

        private RTNode<ProxyCluster> makeClusterRTree() {
            RTNode<ProxyCluster> root2 = RTNode.makeTopLevel();
            for (ProxyCluster pCluster : this.allClusters) {
                root2 = RTNode.linkGeom(null, root2, pCluster);
            }
            return root2;
        }

        private RTNode<ProxyCluster> plowCluster(int clusterIndex, double dX, double dY, RTNode<ProxyCluster> rTree, boolean lDir, boolean rDir, boolean uDir, boolean dDir) {
            ProxyCluster pCluster = this.allClusters.get(clusterIndex);
            ERectangle oldBounds = pCluster.getBounds();
            double prevX = oldBounds.getCenterX();
            double prevY = oldBounds.getCenterY();
            if (this.furtherExplanation != null) {
                this.furtherExplanation.add("PLOWING " + pCluster + " BY (" + TextUtils.formatDouble(dX) + "," + TextUtils.formatDouble(dY) + ")");
            }
            if (dX != 0.0 || dY != 0.0) {
                rTree = RTNode.unLinkGeom(null, rTree, pCluster);
                pCluster = this.copyCluster(pCluster);
                for (ProxyNode pNode : pCluster.getNodesInCluster()) {
                    pNode.setLocation(pNode.getX() + dX, pNode.getY() + dY);
                }
                pCluster.computeBounds();
                if (this.furtherExplanation != null) {
                    this.furtherExplanation.add("CLUSTER BOUNDS NOW " + TextUtils.formatDouble(pCluster.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDouble(pCluster.getBounds().getMaxX()) + " AND " + TextUtils.formatDouble(pCluster.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDouble(pCluster.getBounds().getMaxY()));
                }
                rTree = RTNode.linkGeom(null, rTree, pCluster);
            }
            ERectangle pBound = pCluster.getBounds();
            ERectangle search = ERectangle.fromLambda(Math.min(prevX, prevX + dX) - oldBounds.getWidth() / 2.0, Math.min(prevY, prevY + dY) - oldBounds.getHeight() / 2.0, oldBounds.getWidth() + Math.abs(dX), oldBounds.getHeight() + Math.abs(dY));
            boolean blocked = true;
            block1: while (blocked) {
                blocked = false;
                pBound = pCluster.getBounds();
                RTNode.Search<ProxyCluster> sea = new RTNode.Search<ProxyCluster>(search, rTree, true);
                while (sea.hasNext()) {
                    double leastMotion;
                    ProxyCluster inArea = (ProxyCluster)sea.next();
                    if (inArea == pCluster) continue;
                    ERectangle sBound = inArea.getBounds();
                    if (pBound.getMinX() >= sBound.getMaxX() || pBound.getMaxX() <= sBound.getMinX() || pBound.getMinY() >= sBound.getMaxY() || pBound.getMaxY() <= sBound.getMinY()) continue;
                    double leftMotion = sBound.getMaxX() - pBound.getMinX();
                    double rightMotion = pBound.getMaxX() - sBound.getMinX();
                    double downMotion = sBound.getMaxY() - pBound.getMinY();
                    double upMotion = pBound.getMaxY() - sBound.getMinY();
                    if (!lDir) {
                        leftMotion = Double.MAX_VALUE;
                    }
                    if (!rDir) {
                        rightMotion = Double.MAX_VALUE;
                    }
                    if (!dDir) {
                        downMotion = Double.MAX_VALUE;
                    }
                    if (!uDir) {
                        upMotion = Double.MAX_VALUE;
                    }
                    if (this.furtherExplanation != null) {
                        String exp = "  INTERSECTS " + inArea + " LEFT=";
                        exp = leftMotion == Double.MAX_VALUE ? exp + "INFINITE" : exp + TextUtils.formatDouble(leftMotion);
                        exp = exp + " RIGHT=";
                        exp = rightMotion == Double.MAX_VALUE ? exp + "INFINITE" : exp + TextUtils.formatDouble(rightMotion);
                        exp = exp + " UP=";
                        exp = upMotion == Double.MAX_VALUE ? exp + "INFINITE" : exp + TextUtils.formatDouble(upMotion);
                        exp = exp + " DOWN=";
                        exp = downMotion == Double.MAX_VALUE ? exp + "INFINITE" : exp + TextUtils.formatDouble(downMotion);
                        this.furtherExplanation.add(exp);
                    }
                    if (leftMotion == (leastMotion = Math.min(Math.min(leftMotion, rightMotion), Math.min(upMotion, downMotion)))) {
                        if (this.furtherExplanation != null) {
                            this.furtherExplanation.add("  MOVE " + inArea + " " + TextUtils.formatDouble(leftMotion) + " LEFT (Because its right edge is " + TextUtils.formatDouble(sBound.getMaxX()) + " and " + pCluster + " left edge is " + TextUtils.formatDouble(pBound.getMinX()) + ")");
                        }
                        rTree = this.plowCluster(inArea.clusterIndex, -leftMotion, 0.0, rTree, lDir, false, false, false);
                    } else if (rightMotion == leastMotion) {
                        if (this.furtherExplanation != null) {
                            this.furtherExplanation.add("  MOVE " + inArea + " " + TextUtils.formatDouble(rightMotion) + " RIGHT (Because its left edge is " + TextUtils.formatDouble(sBound.getMinX()) + " and " + pCluster + " right edge is " + TextUtils.formatDouble(pBound.getMaxX()) + ")");
                        }
                        rTree = this.plowCluster(inArea.clusterIndex, rightMotion, 0.0, rTree, false, rDir, false, false);
                    } else if (upMotion == leastMotion) {
                        if (this.furtherExplanation != null) {
                            this.furtherExplanation.add("  MOVE " + inArea + " " + TextUtils.formatDouble(upMotion) + " UP (Because its bottom edge is " + TextUtils.formatDouble(sBound.getMinY()) + " and " + pCluster + " top edge is " + TextUtils.formatDouble(pBound.getMaxY()) + ")");
                        }
                        rTree = this.plowCluster(inArea.clusterIndex, 0.0, upMotion, rTree, false, false, uDir, false);
                    } else if (downMotion == leastMotion) {
                        if (this.furtherExplanation != null) {
                            this.furtherExplanation.add("  MOVE " + inArea + " " + TextUtils.formatDouble(downMotion) + " DOWN (Because its top edge is " + TextUtils.formatDouble(sBound.getMaxY()) + " and " + pCluster + " bottom edge is " + TextUtils.formatDouble(pBound.getMinY()) + ")");
                        }
                        rTree = this.plowCluster(inArea.clusterIndex, 0.0, -downMotion, rTree, false, false, false, dDir);
                    }
                    blocked = true;
                    continue block1;
                }
            }
            return rTree;
        }

        private void combineClusters() {
            Collections.sort(this.allClusters);
            ProxyCluster mainCluster = this.allClusters.get(0);
            TreeSet<Double> xCoords = new TreeSet<Double>();
            TreeSet<Double> yCoords = new TreeSet<Double>();
            for (ProxyNode pNode : mainCluster.getNodesInCluster()) {
                xCoords.add(new Double(pNode.getX() - pNode.getWidth() / 2.0));
                xCoords.add(new Double(pNode.getX() + pNode.getWidth() / 2.0));
                yCoords.add(new Double(pNode.getY() - pNode.getHeight() / 2.0));
                yCoords.add(new Double(pNode.getY() + pNode.getHeight() / 2.0));
            }
            int otherClusterIndex = 1;
            while (this.allClusters.size() > otherClusterIndex) {
                ProxyCluster otherCluster = this.allClusters.get(otherClusterIndex);
                double bestArea = -1.0;
                double bestDX = 0.0;
                double bestDY = 0.0;
                for (Double y : yCoords) {
                    for (int forceDir = 0; forceDir < 4; ++forceDir) {
                        double dX = mainCluster.bound.getCenterX() - otherCluster.bound.getCenterX();
                        double dY = y - otherCluster.bound.getMaxY();
                        EPoint newDelta = BottomUpPlace.this.pushCluster(otherCluster, mainCluster, dX, dY, forceDir, null);
                        double area = mainCluster.getAreaWithOtherShiftedCluster(otherCluster, newDelta);
                        if (!(bestArea < 0.0) && !(area < bestArea)) continue;
                        bestArea = area;
                        bestDX = newDelta.getX();
                        bestDY = newDelta.getY();
                    }
                }
                for (ProxyNode pNode : otherCluster.getNodesInCluster()) {
                    pNode.setLocation(pNode.getX() + bestDX, pNode.getY() + bestDY);
                    xCoords.add(new Double(pNode.getX() - pNode.getWidth() / 2.0));
                    xCoords.add(new Double(pNode.getX() + pNode.getWidth() / 2.0));
                    yCoords.add(new Double(pNode.getY() - pNode.getHeight() / 2.0));
                    yCoords.add(new Double(pNode.getY() + pNode.getHeight() / 2.0));
                }
                for (ProxyNode pNode : otherCluster.getNodesInCluster()) {
                    mainCluster.add(pNode);
                    this.clusterMap.put(pNode, mainCluster);
                }
                this.allClusters.remove(otherCluster);
                mainCluster.computeBounds();
            }
        }
    }

    private static class CompactionEdge
    implements Comparable {
        double improvement;
        Rectangle2D bound = null;
        Set<PlacementFrame.PlacementNode> moveSet = new HashSet<PlacementFrame.PlacementNode>();
        List<PlacementFrame.PlacementNode> toMove = new ArrayList<PlacementFrame.PlacementNode>();
        String side;

        public CompactionEdge(String side, List<CompactionEdge> edges) {
            this.side = side;
            if (edges != null) {
                edges.add(this);
            }
        }

        public int compareTo(Object o) {
            if (o instanceof CompactionEdge) {
                CompactionEdge other = (CompactionEdge)o;
                if (this.improvement < other.improvement) {
                    return 1;
                }
                if (this.improvement > other.improvement) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

