/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.basic.NccUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NodaNets {
    private Map<String, Nodable> nameToNoda = new HashMap<String, Nodable>();
    private Map<String, Network> nameToNet = new HashMap<String, Network>();
    private Map<Nodable, ArrayList<NodaPortInst>> nodeToPorts = new HashMap<Nodable, ArrayList<NodaPortInst>>();
    private Map<Network, ArrayList<NodaPortInst>> netToPorts = new HashMap<Network, ArrayList<NodaPortInst>>();

    public NodaNets(Cell c, Netlist.ShortResistors shortResistors) {
        Date start = new Date();
        Netlist nets = c.getNetlist(shortResistors);
        Iterator<Nodable> it = c.getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            Job.error(this.nameToNoda.containsKey(no.getName()), "Nodable name not unique: ");
            this.nameToNoda.put(no.getName(), no);
            NodeProto np = no.getProto();
            Iterator<PortProto> it2 = np.getPorts();
            while (it2.hasNext()) {
                PortProto pp = it2.next();
                Name key = pp.getNameKey();
                int numBits = key.busWidth();
                for (int busNdx = 0; busNdx < numBits; ++busNdx) {
                    Network net = nets.getNetwork(no, pp, busNdx);
                    if (net == null) continue;
                    Iterator<String> it3 = net.getNames();
                    while (it3.hasNext()) {
                        String netNm = it3.next();
                        Network exists2 = this.nameToNet.get(netNm);
                        if (exists2 != null) {
                            Job.error(exists2 != net, "Net name not unique");
                            continue;
                        }
                        this.nameToNet.put(netNm, net);
                    }
                    NodaPortInst npi = new NodaPortInst(no, pp, busNdx, net);
                    ArrayList<NodaPortInst> ports = this.nodeToPorts.get(no);
                    if (ports == null) {
                        ports = new ArrayList();
                        this.nodeToPorts.put(no, ports);
                    }
                    ports.add(npi);
                    ports = this.netToPorts.get(net);
                    if (ports == null) {
                        ports = new ArrayList();
                        this.netToPorts.put(net, ports);
                    }
                    ports.add(npi);
                }
            }
        }
        Date end = new Date();
        System.out.println("    RK Debug: Time to build NodaNets: " + NccUtils.hourMinSec(start, end));
    }

    public Collection<Network> getNets() {
        return Collections.unmodifiableCollection(this.nameToNet.values());
    }

    public Network getNet(String netNm) {
        return this.nameToNet.get(netNm);
    }

    public Collection<Nodable> getNodes() {
        return Collections.unmodifiableCollection(this.nameToNoda.values());
    }

    public Nodable getNoda(String nodaNm) {
        return this.nameToNoda.get(nodaNm);
    }

    public Collection<NodaPortInst> getPorts(Nodable noda) {
        Collection ports = this.nodeToPorts.get(noda);
        return Collections.unmodifiableCollection(ports);
    }

    public Collection<NodaPortInst> getPorts(Network net) {
        Collection ports = this.netToPorts.get(net);
        return Collections.unmodifiableCollection(ports);
    }

    public static class NodaPortInst {
        private final Nodable noda;
        private final PortProto port;
        private final int index;
        private final Network net;

        NodaPortInst(Nodable no, PortProto pp, int ndx, Network ne) {
            this.noda = no;
            this.port = pp;
            this.index = ndx;
            this.net = ne;
        }

        public Nodable getNodable() {
            return this.noda;
        }

        public PortProto getPortProto() {
            return this.port;
        }

        public int getIndex() {
            return this.index;
        }

        public Network getNet() {
            return this.net;
        }
    }
}

