/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TextUtils
extends com.sun.electric.util.TextUtils {
    public static final Comparator<Connection> CONNECTIONS_ORDER = new Comparator<Connection>(){

        @Override
        public int compare(Connection c1, Connection c2) {
            int i2;
            int i1 = c1.getPortInst().getPortProto().getPortIndex();
            int cmp = i1 - (i2 = c2.getPortInst().getPortProto().getPortIndex());
            if (cmp != 0) {
                return cmp;
            }
            cmp = c1.getArc().getArcId() - c2.getArc().getArcId();
            if (cmp != 0) {
                return cmp;
            }
            return c1.getEndIndex() - c2.getEndIndex();
        }
    };
    private static Set<String> missingComponentNames = new HashSet<String>();
    private static Set<String> missingPrivateComponentNames = new HashSet<String>();
    private static Set<String> missingTechnologyNames = new HashSet<String>();

    public static double atofDistance(String text2, Technology tech) {
        if (tech != null && tech.isLayout()) {
            return TextUtils.atof(text2, null, AbstractTextDescriptor.Unit.DISTANCE, tech);
        }
        return TextUtils.atof(text2);
    }

    public static double atofDistance(String text2) {
        return TextUtils.atof(text2, null, AbstractTextDescriptor.Unit.DISTANCE, Technology.getCurrent());
    }

    public static double atof(String text2, Double defaultVal, AbstractTextDescriptor.Unit unitType, Technology tech) {
        TextUtils.UnitScale us;
        String pf;
        if (unitType != null && text2.endsWith(pf = unitType.getPostfixChar())) {
            text2 = text2.substring(0, text2.length() - pf.length());
        }
        if (unitType == AbstractTextDescriptor.Unit.DISTANCE && (us = User.getDistanceUnits()) != null) {
            text2 = text2.replaceAll(",", "");
            double v = 0.0;
            try {
                v = TextUtils.parsePostFixNumber(text2, us).doubleValue();
            }
            catch (NumberFormatException ex) {
                v = TextUtils.atof(text2, defaultVal);
            }
            return v / Technology.getCurrent().getScale() / TextUtils.UnitScale.NANO.getMultiplier().doubleValue();
        }
        return TextUtils.atof(text2, defaultVal);
    }

    public static double getValueOfExpression(String expression) {
        if (TextUtils.isANumber(expression)) {
            double res = TextUtils.atof(expression);
            return res;
        }
        Object o = EvalJavaBsh.evalJavaBsh.doEvalLine(expression);
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return 0.0;
    }

    public static String formatDistance(double v, Technology tech) {
        if (tech != null && tech.isLayout()) {
            return TextUtils.displayedUnits(v, AbstractTextDescriptor.Unit.DISTANCE, User.getDistanceUnits(), tech);
        }
        return TextUtils.formatDouble(v);
    }

    public static String formatDistance(double v) {
        return TextUtils.displayedUnits(v, AbstractTextDescriptor.Unit.DISTANCE, User.getDistanceUnits(), Technology.getCurrent());
    }

    public static double convertDistance(double value2, Technology tech, TextUtils.UnitScale unitScale) {
        double scale = tech.getScale();
        double distanceScale = 1.0E-9 / unitScale.getMultiplier().doubleValue() * scale;
        return value2 * distanceScale;
    }

    public static double convertFromDistance(double value2, Technology tech, TextUtils.UnitScale unitScale) {
        double scale = tech != null ? tech.getScale() : 1.0;
        double distanceScale = 1.0E-9 / unitScale.getMultiplier().doubleValue() * scale;
        return value2 / distanceScale;
    }

    private static String displayedUnits(double value2, AbstractTextDescriptor.Unit unitType, TextUtils.UnitScale unitScale, Technology tech) {
        if (unitType == AbstractTextDescriptor.Unit.DISTANCE && unitScale != null) {
            value2 *= TextUtils.UnitScale.NANO.getMultiplier().doubleValue() * tech.getScale();
        }
        String postFix = "";
        if (unitScale != null) {
            value2 /= unitScale.getMultiplier().doubleValue();
            postFix = unitScale.getPostFix() + unitType.getPostfixChar();
        }
        return TextUtils.formatDouble(value2) + postFix;
    }

    public static String makeUnits(double value2, AbstractTextDescriptor.Unit units) {
        if (units == AbstractTextDescriptor.Unit.NONE) {
            return TextUtils.formatDouble(value2);
        }
        if (units == AbstractTextDescriptor.Unit.DISTANCE) {
            return TextUtils.displayedUnits(value2, units, User.getDistanceUnits(), Technology.getCurrent());
        }
        return TextUtils.formatDoublePostFix(value2);
    }

    public static void recordMissingComponent(String name) {
        missingComponentNames.add(name);
    }

    public static void recordMissingTechnology(String name) {
        missingTechnologyNames.add(name);
    }

    public static void recordMissingPrivateComponent(String name) {
        missingPrivateComponentNames.add(name);
    }

    public static Set<String> getMissingComponentNames() {
        if (missingTechnologyNames.size() > 0) {
            String techNames = null;
            for (String tech : missingTechnologyNames) {
                techNames = techNames == null ? "Technologies (" : techNames + ", ";
                techNames = techNames + tech;
            }
            techNames = techNames + ")";
            missingComponentNames.add(techNames);
        }
        return missingComponentNames;
    }

    public static Set<String> getMissingPrivateComponentNames() {
        return missingPrivateComponentNames;
    }

    public static String generateFileHeader(Cell cell, String startDelim, String endDelim, boolean includeDate, boolean includeVersion) {
        StringBuffer s = new StringBuffer(100);
        if (includeDate || includeVersion) {
            if (cell != null) {
                s.append(startDelim + " Cell created on " + TextUtils.formatDate(cell.getCreationDate()) + " " + endDelim + "\n");
                s.append(startDelim + " Cell last revised on " + TextUtils.formatDate(cell.getRevisionDate()) + " " + endDelim + "\n");
            }
            s.append(startDelim + " Written");
            if (includeDate) {
                s.append(" on " + TextUtils.formatDate(new Date()) + " " + endDelim + "\n" + startDelim);
            }
            s.append(" by Electric VLSI Design System");
            if (includeVersion) {
                s.append(", version " + Version.getVersion());
            }
            s.append(" " + endDelim + "\n");
        } else {
            s.append(startDelim + " Written by Electric VLSI Design System " + endDelim + "\n");
        }
        return s.toString();
    }

    public static enum WhatToSearch {
        ARC_NAME("Arc Name"),
        ARC_VAR("Arc Variable"),
        NODE_NAME("Node Name"),
        NODE_VAR("Node Variable"),
        EXPORT_NAME("Export Name"),
        EXPORT_VAR("Export Variable"),
        CELL_VAR("Cell Name"),
        TEMP_NAMES(null);

        private String descriptionOfObjectFound;

        private WhatToSearch(String descriptionOfObjectFound) {
            this.descriptionOfObjectFound = descriptionOfObjectFound;
        }

        public String toString() {
            return this.descriptionOfObjectFound;
        }
    }

    public static class NetworksByName
    implements Comparator<Network> {
        @Override
        public int compare(Network n1, Network n2) {
            String s1 = n1.describe(false);
            String s2 = n2.describe(false);
            return s1.compareToIgnoreCase(s2);
        }
    }

    public static class PrefsByName
    implements Comparator<Pref> {
        @Override
        public int compare(Pref p1, Pref p2) {
            String s1 = p1.getPrefName();
            String s2 = p2.getPrefName();
            return s1.compareToIgnoreCase(s2);
        }
    }

    public static class CellsByDate
    implements Comparator<Cell> {
        @Override
        public int compare(Cell c1, Cell c2) {
            Date r1 = c1.getRevisionDate();
            Date r2 = c2.getRevisionDate();
            return r1.compareTo(r2);
        }
    }

    public static class CellsByName
    implements Comparator<Cell> {
        @Override
        public int compare(Cell c1, Cell c2) {
            String r1 = c1.getName();
            String r2 = c2.getName();
            return r1.compareTo(r2);
        }
    }

    public static class CellsByVersion
    implements Comparator<Cell> {
        @Override
        public int compare(Cell c1, Cell c2) {
            return c2.getVersion() - c1.getVersion();
        }
    }

    public static class CellsByView
    implements Comparator<Cell> {
        @Override
        public int compare(Cell c1, Cell c2) {
            View v1 = c1.getView();
            View v2 = c2.getView();
            return v1.getOrder() - v2.getOrder();
        }
    }

    public static class ObjectsByToString
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }
}

