/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import com.sun.electric.util.math.ECoord;
import java.awt.geom.Dimension2D;
import java.io.Serializable;

public class EDimension
extends Dimension2D
implements Serializable {
    private final ECoord width;
    private final ECoord height;
    private final double lambdaWidth;
    private final double lambdaHeight;

    public EDimension(double width, double height) {
        this(ECoord.fromLambdaRoundSizeGrid(width), ECoord.fromLambdaRoundSizeGrid(height));
    }

    public EDimension(ECoord width, ECoord height) {
        if (!width.isExact(ECoord.SIZE_GRID) || !height.isExact(ECoord.SIZE_GRID)) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
        this.lambdaWidth = width.getLambda();
        this.lambdaHeight = height.getLambda();
    }

    @Override
    public double getWidth() {
        return this.lambdaWidth;
    }

    @Override
    public double getHeight() {
        return this.lambdaHeight;
    }

    public ECoord getCoordWidth() {
        return this.width;
    }

    public ECoord getCoordHeight() {
        return this.height;
    }

    public double getLambdaWidth() {
        return this.lambdaWidth;
    }

    public double getLambdaHeight() {
        return this.lambdaHeight;
    }

    public long getFixpWidth() {
        return this.width.getFixp();
    }

    public long getFixpHeight() {
        return this.height.getFixp();
    }

    public long getGridWidth() {
        return this.width.getGrid();
    }

    public long getGridHeight() {
        return this.height.getGrid();
    }

    @Override
    public void setSize(Dimension2D d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSize(double width, double height) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "(" + this.lambdaWidth + "," + this.lambdaHeight + ")";
    }
}

