/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.utils;

import com.sun.electric.tool.util.concurrent.utils.BlockedRange;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import com.sun.electric.tool.util.concurrent.utils.Range;
import java.util.ArrayList;
import java.util.List;

public class BlockedRange1D
extends BlockedRange<BlockedRange1D> {
    private Range range;
    private Integer current = null;

    public BlockedRange1D(int start, int end, int step) {
        this.range = new Range(start, end, step);
    }

    public int start() {
        return this.range.start();
    }

    public int end() {
        return this.range.end();
    }

    public int step() {
        return this.range.step();
    }

    @Override
    public List<BlockedRange1D> splitBlockedRange(int step) {
        if (this.current != null && this.current >= this.range.end()) {
            return null;
        }
        ArrayList<BlockedRange1D> result2 = ConcurrentCollectionFactory.createArrayList();
        for (int i = 0; i < step; ++i) {
            if (this.current == null) {
                this.current = this.range.start();
            }
            if (this.current >= this.range.end()) {
                return result2;
            }
            result2.add(new BlockedRange1D(this.current, Math.min(this.current + this.range.step(), this.range.end()), this.range.step()));
            this.current = this.current + this.range.step();
        }
        return result2;
    }

    @Override
    public BlockedRange1D createInstance(int number2, int total) {
        int size2 = this.range.end() - this.range.start();
        int split2 = size2 / total;
        BlockedRange1D result2 = new BlockedRange1D(number2 * split2, number2 + 1 == total ? this.range.end() : (number2 + 1) * split2, this.range.step());
        return result2;
    }
}

