/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore1;

import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore1.RoutingPart;
import com.sun.electric.tool.routing.experimentalLeeMoore1.ThreadBorders;
import com.sun.electric.tool.routing.experimentalLeeMoore1.WorkPartition;
import com.sun.electric.tool.routing.experimentalLeeMoore1.yana;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkPool {
    private static Logger logger = LoggerFactory.getLogger(WorkPool.class);
    private static ConcurrentLinkedQueue<RoutingFrame.RoutingSegment> inputList = new ConcurrentLinkedQueue();
    private static BlockingQueue<RoutingPart> globalRoutingQueue;
    private static ArrayList<WorkPartition> workPartitions;
    private static ConcurrentLinkedQueue<WorkPartition> workPartitionsList;
    private static int segmentCounter;
    private static int additionalSegments;
    private static int WorkDivideIn_X_Dir;
    private static int WorkDivideIn_Y_Dir;
    private static int minimumRegionBorderLength;
    private static int size_x;
    private static int size_y;
    private static int numPartitions;
    private static int[][] regionPartition;
    public static boolean output;

    public static void init(List<RoutingFrame.RoutingSegment> segmentsToRoute, int numPartitions, int size_x, int size_y, boolean output2) {
        output = output2;
        WorkPool.size_x = size_x;
        WorkPool.size_y = size_y;
        WorkPool.numPartitions = numPartitions;
        minimumRegionBorderLength = yana.minimumRegionBorderLength;
        additionalSegments = segmentCounter = segmentsToRoute.size();
        globalRoutingQueue = new ArrayBlockingQueue<RoutingPart>(segmentCounter);
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            inputList.add(rs);
        }
        workPartitions = new ArrayList(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            workPartitions.add(new WorkPartition(i));
        }
        WorkPool.createThreadBorders(yana.regionDivideMethod);
        WorkPool.createRegionArray();
    }

    private static void createThreadBorders(int method) {
        do {
            switch (method) {
                case 1: {
                    WorkPool.regions_OptimalDivisionFactor();
                    break;
                }
                case 2: {
                    WorkPool.regions_simpleStripes();
                    break;
                }
                case 3: {
                    WorkPool.regions_AdaptedRegions();
                    break;
                }
                default: {
                    WorkPool.regions_OneRegion();
                }
            }
            logger.debug("partitions: " + --numPartitions);
        } while (numPartitions > 0 && (size_x / WorkDivideIn_X_Dir < minimumRegionBorderLength || size_y / WorkDivideIn_Y_Dir < minimumRegionBorderLength));
        ++numPartitions;
        if (output) {
            System.out.println("size: " + size_x + "x" + size_y);
        }
        if (output) {
            System.out.println("region devision: " + WorkDivideIn_X_Dir + "x" + WorkDivideIn_Y_Dir + " for " + numPartitions + " regions");
        }
        for (int i = 0; i < numPartitions; ++i) {
            workPartitions.get(i).setThreadBorders(new ThreadBorders(WorkPool.getLowIndexIn_X(i), WorkPool.getHighIndexIn_X(i), WorkPool.getLowIndexIn_Y(i), WorkPool.getHighIndexIn_Y(i)));
        }
    }

    private static void regions_OptimalDivisionFactor() {
        int smallerFactor = (int)Math.sqrt(numPartitions);
        WorkPool.aproximateXYdirection(smallerFactor);
    }

    private static void regions_simpleStripes() {
        WorkPool.aproximateXYdirection(1);
    }

    private static void regions_AdaptedRegions() {
        int smallerSide;
        double r = 1.0 * (double)size_x / (double)size_y;
        if (Math.abs(1.0 - r) < 0.05) {
            WorkPool.regions_OptimalDivisionFactor();
            return;
        }
        if (r < 1.0) {
            r = 1.0 / r;
        }
        if ((smallerSide = (int)Math.round(Math.sqrt((double)numPartitions / r))) == 0) {
            WorkPool.regions_simpleStripes();
            return;
        }
        WorkPool.aproximateXYdirection(smallerSide);
    }

    private static void regions_OneRegion() {
        WorkDivideIn_X_Dir = 1;
        WorkDivideIn_Y_Dir = 1;
        numPartitions = 1;
    }

    private static void aproximateXYdirection(int smallerFactor) {
        if (smallerFactor <= 0) {
            WorkPool.regions_OneRegion();
            return;
        }
        while (numPartitions % smallerFactor != 0) {
            --smallerFactor;
        }
        if (size_x <= size_y) {
            WorkDivideIn_X_Dir = smallerFactor;
            WorkDivideIn_Y_Dir = numPartitions / smallerFactor;
        } else {
            WorkDivideIn_X_Dir = numPartitions / smallerFactor;
            WorkDivideIn_Y_Dir = smallerFactor;
        }
    }

    public static void prepare() {
        WorkPool.verify();
        if (output) {
            System.out.println("Preparing work partitions for real work...");
        }
        workPartitionsList = new ConcurrentLinkedQueue<WorkPartition>(workPartitions);
        workPartitions = null;
        yana.setProgressMax(WorkPool.getAdditionalSegments());
    }

    private static void verify() {
        int numParts = 0;
        for (WorkPartition wp : workPartitions) {
            numParts += wp.routingParts.size();
        }
        if (numParts != additionalSegments && output) {
            System.out.println("ERROR: RoutingParts are missing!");
        }
    }

    public static RoutingFrame.RoutingSegment getRoutingSegment() {
        return inputList.poll();
    }

    public static RoutingPart getPartFromGlobalRoutingQueue() {
        return (RoutingPart)globalRoutingQueue.poll();
    }

    public static void addPartToGlobalRoutingQueue(RoutingPart rp) {
        globalRoutingQueue.offer(rp);
    }

    public static synchronized int getSegmentCounter() {
        return segmentCounter;
    }

    public static synchronized void decreaseSegmentCounter() {
        --segmentCounter;
    }

    public static void addWorkToPartition(RoutingPart rp, int partition2) {
        workPartitions.get(partition2).addWork(rp);
    }

    public static WorkPartition getWorkFromPartition() {
        return workPartitionsList.poll();
    }

    public static int getGlobalRoutingQueueSize() {
        return globalRoutingQueue.size();
    }

    public static synchronized void increaseAdditionalSegments() {
        ++additionalSegments;
    }

    public static synchronized int getAdditionalSegments() {
        return additionalSegments;
    }

    private static int oneDimensionalGetHighIndex(int numberOfWork, int numWorkers, int rank) {
        ++rank;
        if (numWorkers > numberOfWork) {
            if (rank > numberOfWork) {
                return -1;
            }
            return rank - 1;
        }
        return (int)((double)rank * ((double)numberOfWork / (double)numWorkers)) - 1;
    }

    private static int oneDimensionalGetLowIndex(int numberOfWork, int numWorkers, int rank) {
        ++rank;
        if (numWorkers > numberOfWork) {
            if (rank > numberOfWork) {
                return 0;
            }
            return rank - 1;
        }
        return (int)((double)(rank - 1) * ((double)numberOfWork / (double)numWorkers)) + 1 - 1;
    }

    protected static int getHighIndexIn_X(int rank) {
        return WorkPool.oneDimensionalGetHighIndex(size_x, WorkDivideIn_X_Dir, rank % WorkDivideIn_X_Dir);
    }

    protected static int getHighIndexIn_Y(int rank) {
        return WorkPool.oneDimensionalGetHighIndex(size_y, WorkDivideIn_Y_Dir, rank / WorkDivideIn_X_Dir);
    }

    protected static int getLowIndexIn_X(int rank) {
        return WorkPool.oneDimensionalGetLowIndex(size_x, WorkDivideIn_X_Dir, rank % WorkDivideIn_X_Dir);
    }

    protected static int getLowIndexIn_Y(int rank) {
        return WorkPool.oneDimensionalGetLowIndex(size_y, WorkDivideIn_Y_Dir, rank / WorkDivideIn_X_Dir);
    }

    static void printPartitionBorders() {
        regionPartition = new int[size_x][size_y];
        for (int t = 0; t < numPartitions; ++t) {
            if (output) {
                System.out.println("Partition-" + t + ": " + WorkPool.getLowIndexIn_X(t) + "<x<" + WorkPool.getHighIndexIn_X(t) + ", " + WorkPool.getLowIndexIn_Y(t) + "<y<" + WorkPool.getHighIndexIn_Y(t));
            }
            for (int x2 = WorkPool.getLowIndexIn_X(t); x2 <= WorkPool.getHighIndexIn_X(t); ++x2) {
                for (int y = WorkPool.getLowIndexIn_Y(t); y <= WorkPool.getHighIndexIn_Y(t); ++y) {
                    WorkPool.regionPartition[x2][y] = t;
                }
            }
        }
    }

    static void createRegionArray() {
        regionPartition = new int[size_x][size_y];
        for (int t = 0; t < numPartitions; ++t) {
            for (int x2 = WorkPool.getLowIndexIn_X(t); x2 <= WorkPool.getHighIndexIn_X(t); ++x2) {
                for (int y = WorkPool.getLowIndexIn_Y(t); y <= WorkPool.getHighIndexIn_Y(t); ++y) {
                    WorkPool.regionPartition[x2][y] = t;
                }
            }
        }
    }

    public static int getResponsiblePartitionID_ForPoint(int posX, int posY) {
        return regionPartition[posX][posY];
    }

    static {
        output = false;
    }
}

