/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.spicenetlist;

import com.sun.electric.tool.io.input.spicenetlist.SpiceNetlistReader;
import com.sun.electric.tool.io.input.spicenetlist.SpiceSubckt;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class SpiceInstance {
    private char type;
    private String name;
    private List<String> nets;
    private SpiceSubckt subckt;
    private HashMap<String, String> params;

    public SpiceInstance(String typeAndName) {
        this.type = typeAndName.charAt(0);
        this.name = typeAndName.substring(1);
        this.nets = new ArrayList<String>();
        this.subckt = null;
        this.params = new LinkedHashMap<String, String>();
    }

    public SpiceInstance(SpiceSubckt subckt, String name) {
        this.type = (char)120;
        this.name = name;
        this.nets = new ArrayList<String>();
        this.subckt = subckt;
        this.params = new LinkedHashMap<String, String>();
        for (String key : subckt.getParams().keySet()) {
            this.params.put(key, subckt.getParams().get(key));
        }
    }

    public char getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getNets() {
        return this.nets;
    }

    public void addNet(String net) {
        this.nets.add(net);
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public SpiceSubckt getSubckt() {
        return this.subckt;
    }

    public void write(PrintStream out) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.type);
        buf.append(this.name);
        buf.append(" ");
        for (String net : this.nets) {
            buf.append(net);
            buf.append(" ");
        }
        if (this.subckt != null) {
            buf.append(this.subckt.getName());
            buf.append(" ");
        }
        for (String key : this.params.keySet()) {
            buf.append(key);
            String value2 = this.params.get(key);
            if (value2 != null) {
                buf.append("=");
                buf.append(value2);
            }
            buf.append(" ");
        }
        buf.append("\n");
        SpiceNetlistReader.multiLinePrint(out, false, buf.toString());
    }
}

