/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GDSMap
extends EDialog {
    private HashMap<String, JComboBox> assocCombos;
    private List<MapLine> drawingEntries;
    private List<MapLine> pinEntries;
    private Technology tech;

    public static void importMapFile() {
        String fileName = OpenFile.chooseInputFile(FileType.GDSMAP, "GDS Layer Map File");
        if (fileName == null) {
            return;
        }
        HashSet<String> allNames = new HashSet<String>();
        ArrayList<MapLine> drawingEntries = new ArrayList<MapLine>();
        ArrayList<MapLine> pinEntries = new ArrayList<MapLine>();
        URL url = TextUtils.makeURLToFile(fileName);
        try {
            String buf;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            while ((buf = lineReader.readLine()) != null) {
                int spaPos;
                if ((buf = buf.trim()).length() == 0 || buf.charAt(0) == '#' || (spaPos = buf.indexOf(32)) < 0) continue;
                String layerName = buf.substring(0, spaPos);
                if ((spaPos = (buf = buf.substring(spaPos + 1).trim()).indexOf(32)) < 0) continue;
                String layerPurpose = buf.substring(0, spaPos);
                if ((spaPos = (buf = buf.substring(spaPos + 1).trim()).indexOf(32)) < 0) continue;
                int gdsNumber = TextUtils.atoi(buf.substring(0, spaPos));
                buf = buf.substring(spaPos + 1).trim();
                int gdsType = TextUtils.atoi(buf);
                if (!layerPurpose.equalsIgnoreCase("drawing") && !layerPurpose.equalsIgnoreCase("pin")) continue;
                MapLine ml = new MapLine();
                ml.name = layerName;
                ml.layer = gdsNumber;
                ml.type = gdsType;
                if (layerPurpose.equalsIgnoreCase("drawing")) {
                    drawingEntries.add(ml);
                } else {
                    pinEntries.add(ml);
                }
                allNames.add(layerName);
            }
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName);
            return;
        }
        new GDSMap((Frame)TopLevel.getCurrentJFrame(), allNames, drawingEntries, pinEntries);
    }

    public GDSMap(Frame parent, HashSet<String> allNames, List<MapLine> drawingEntries, List<MapLine> pinEntries) {
        super(parent, true);
        JLabel lab;
        this.drawingEntries = drawingEntries;
        this.pinEntries = pinEntries;
        this.tech = Technology.getCurrent();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("GDS Layer Map Association");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GDSMap.this.closeDialog(evt);
            }
        });
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : allNames) {
            nameList.add(name);
        }
        Collections.sort(nameList, TextUtils.STRING_NUMBER_ORDER);
        this.assocCombos = new HashMap();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 1;
        for (String name : nameList) {
            lab = new JLabel(name);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = row;
            gbc.anchor = 17;
            panel.add((Component)lab, gbc);
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("<<IGNORE>>");
            Iterator<Layer> lIt = this.tech.getLayers();
            while (lIt.hasNext()) {
                comboBox.addItem(lIt.next().getName());
            }
            String savedAssoc = this.getSavedAssoc(name);
            if (savedAssoc.length() > 0) {
                comboBox.setSelectedItem(savedAssoc);
            }
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = row++;
            panel.add(comboBox, gbc);
            this.assocCombos.put(name, comboBox);
        }
        JScrollPane assocPane = new JScrollPane();
        assocPane.setViewportView(panel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)assocPane, gbc);
        lab = new JLabel("Mapping these layer names to the " + this.tech.getTechName() + " technology:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)lab, gbc);
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GDSMap.this.ok();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)ok, gbc);
        this.getRootPane().setDefaultButton(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GDSMap.this.closeDialog(null);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)cancel, gbc);
        this.pack();
        this.setVisible(true);
    }

    public void termDialog() {
        for (String name : this.assocCombos.keySet()) {
            JComboBox combo = this.assocCombos.get(name);
            String layerName = "";
            if (combo.getSelectedIndex() != 0) {
                layerName = (String)combo.getSelectedItem();
            }
            this.setSavedAssoc(name, layerName);
        }
        Foundry foundry = this.tech.getSelectedFoundry();
        if (foundry == null) {
            System.out.println("No foundry associated for the mapping");
            return;
        }
        Setting.SettingChangeBatch changeBatch = new Setting.SettingChangeBatch();
        Iterator<Layer> it = this.tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            changeBatch.add(foundry.getGDSLayerSetting(layer), "");
        }
        for (MapLine ml : this.drawingEntries) {
            Layer layer;
            String layerName = this.getSavedAssoc(ml.name);
            if (layerName.length() == 0 || (layer = this.tech.findLayer(layerName)) == null) continue;
            String layerInfo = "" + ml.layer;
            if (ml.type != 0) {
                layerInfo = layerInfo + "/" + ml.type;
            }
            for (MapLine pMl : this.pinEntries) {
                if (!pMl.name.equals(ml.name)) continue;
                if (pMl.layer == -1) break;
                layerInfo = layerInfo + "," + pMl.layer;
                if (pMl.type != 0) {
                    layerInfo = layerInfo + "/" + pMl.type;
                }
                layerInfo = layerInfo + "p";
                break;
            }
            changeBatch.add(foundry.getGDSLayerSetting(layer), layerInfo);
        }
        new OKUpdate(changeBatch).startJob();
    }

    private void ok() {
        this.termDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private String getSavedAssoc(String mapName) {
        Preferences preferences = Pref.getPrefRoot().node(IOTool.getIOTool().prefs.relativePath());
        return preferences.get("GDSMappingFor" + mapName, "");
    }

    private void setSavedAssoc(String mapName, String layerName) {
        Preferences preferences = Pref.getPrefRoot().node(IOTool.getIOTool().prefs.relativePath());
        preferences.put("GDSMappingFor" + mapName, layerName);
    }

    private static class OKUpdate
    extends Job {
        private Setting.SettingChangeBatch changeBatch;

        private OKUpdate(Setting.SettingChangeBatch changeBatch) {
            super("Update GDS Mapping", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.changeBatch = changeBatch;
        }

        @Override
        public boolean doIt() throws JobException {
            this.getDatabase().implementSettingChanges(this.changeBatch);
            return true;
        }

        @Override
        public void terminateOK() {
        }
    }

    private static class MapLine {
        String name;
        int layer;
        int type;

        private MapLine() {
        }
    }
}

