/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.prototype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public enum PortCharacteristic {
    UNKNOWN("U", "Unknown", "unknown"),
    CLK("C", "Clock", "clock"),
    C1("C1", "Clock Phase 1", "clock1"),
    C2("C2", "Clock Phase 2", "clock2"),
    C3("C3", "Clock Phase 3", "clock3"),
    C4("C4", "Clock Phase 4", "clock4"),
    C5("C5", "Clock Phase 5", "clock5"),
    C6("C6", "Clock Phase 6", "clock6"),
    IN("I", "Input", "input"),
    OUT("O", "Output", "output"),
    BIDIR("B", "Bidirectional", "bidirectional"),
    PWR("P", "Power", "power"),
    GND("G", "Ground", "ground"),
    REFOUT("RO", "Reference Output", "refout"),
    REFIN("RI", "Reference Input", "refin"),
    REFBASE("RB", "Reference Base", "refbase");

    private final String name;
    private final String shortName;
    private final String fullName;
    private final int bits;

    private PortCharacteristic(String shortName, String fullName, String name) {
        this.shortName = shortName;
        this.fullName = fullName;
        this.name = name;
        this.bits = this.ordinal() << 1;
    }

    public int getBits() {
        return this.bits;
    }

    public int getOrder() {
        return this.ordinal();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReference() {
        return this == REFIN || this == REFOUT || this == REFBASE;
    }

    public boolean isClock() {
        return this == CLK || this == C1 || this == C2 || this == C3 || this == C4 || this == C5 || this == C6;
    }

    public static PortCharacteristic findCharacteristic(int bits2) {
        if ((bits2 & 1) != 0) {
            return null;
        }
        int index = bits2 >>> 1;
        PortCharacteristic[] allCharacteristics = (PortCharacteristic[])PortCharacteristic.class.getEnumConstants();
        return index < allCharacteristics.length ? allCharacteristics[index] : null;
    }

    public static PortCharacteristic findCharacteristic(String wantName) {
        for (PortCharacteristic ch : (PortCharacteristic[])PortCharacteristic.class.getEnumConstants()) {
            if (!ch.name.equals(wantName)) continue;
            return ch;
        }
        return null;
    }

    public static PortCharacteristic findCharacteristicShort(String shortName) {
        for (PortCharacteristic ch : (PortCharacteristic[])PortCharacteristic.class.getEnumConstants()) {
            if (!ch.shortName.equals(shortName)) continue;
            return ch;
        }
        return null;
    }

    public static List<PortCharacteristic> getOrderedCharacteristics() {
        ArrayList<PortCharacteristic> orderedList = new ArrayList<PortCharacteristic>();
        for (PortCharacteristic ch : (PortCharacteristic[])PortCharacteristic.class.getEnumConstants()) {
            orderedList.add(ch);
        }
        Collections.sort(orderedList, new CharacteristicOrder());
        return orderedList;
    }

    public String toString() {
        return this.name;
    }

    static class CharacteristicOrder
    implements Comparator<PortCharacteristic> {
        CharacteristicOrder() {
        }

        @Override
        public int compare(PortCharacteristic c1, PortCharacteristic c2) {
            return c1.ordinal() - c2.ordinal();
        }
    }
}

