/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.bool;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.util.math.DBMath;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UnloadPolys {
    Polys polyPool;
    private static final int IN = 1;
    private static final int OUT = 0;
    private static final int B = 0;
    private static final int W = 1;
    Arc arcPool;
    private int[] inpA = new int[1];
    private int inpC;
    private int x;
    private Arc mainArc;
    private Arc top;
    private List<Arc> stack = new ArrayList<Arc>();
    private int v;
    private int nv;
    private boolean rotated;

    public Iterable<PolyBase.PolyBaseTree> loop(DataInputStream inpS, boolean rotated) throws IOException {
        this.rotated = rotated;
        this.mainArc = this.newArc();
        this.mainArc.y[1] = Integer.MIN_VALUE;
        this.mainArc.y[0] = Integer.MAX_VALUE;
        this.mainArc.t[1] = this.mainArc;
        this.mainArc.b[0] = this.mainArc;
        while (this.getLine(inpS)) {
            this.scanLine();
        }
        assert (this.mainArc.t[1] == this.mainArc && this.mainArc.b[0] == this.mainArc);
        List<PolyBase.PolyBaseTree> result2 = this.mainArc.sons != null ? Collections.unmodifiableCollection(this.mainArc.sons) : Collections.emptyList();
        this.dispArc(this.mainArc);
        return result2;
    }

    private boolean getLine(DataInputStream inpS) throws IOException {
        this.resetInp();
        boolean eof = inpS.readBoolean();
        if (!eof) {
            return false;
        }
        this.x = inpS.readInt();
        int count2 = inpS.readInt();
        while (count2 > this.inpA.length) {
            int[] newInpA = new int[this.inpA.length * 2];
            System.arraycopy(this.inpA, 0, newInpA, 0, this.inpA.length);
            this.inpA = newInpA;
        }
        while (this.inpC < count2) {
            this.inpA[this.inpC++] = inpS.readInt();
        }
        return true;
    }

    private void scanLine() {
        this.stack.clear();
        this.top = this.mainArc;
        this.v = 1;
        this.nv = 0;
        Arc al = this.top;
        int y = 0;
        int d = 0;
        int inpPos = 0;
        while (inpPos < this.inpC) {
            List<PolyBase.PolyBaseTreeImpl> sons;
            Polys pl;
            if (Math.abs(d) == 2) {
                d >>= 1;
            } else {
                int inpVal = this.inpA[inpPos++];
                y = inpVal >> 1;
                int n = d = (inpVal & 1) != 0 ? 1 : -1;
                while (inpPos < this.inpC && this.inpA[inpPos] >> 1 == y) {
                    if ((this.inpA[inpPos++] & 1) != 0) {
                        ++d;
                        continue;
                    }
                    --d;
                }
            }
            assert (d == 1 || d == -1);
            assert (this.v + this.nv == 1);
            while (y >= this.top.y[this.nv]) {
                al = this.top;
                this.POP();
            }
            assert (this.top.y[this.v] <= y && y < this.top.y[this.nv]);
            while (true) {
                if (al.t[this.v] != this.top && y >= al.t[this.v].y[this.v]) {
                    al = al.t[this.v];
                    continue;
                }
                if (al.t[this.v] == this.top || y < al.t[this.v].y[this.nv]) break;
                al = al.t[this.v];
                this.PUSH(al);
            }
            assert (this.top.y[this.v] <= y && y < this.top.y[this.nv]);
            Arc ar = al.t[this.v];
            if (y > al.y[this.v]) {
                pl = this.newPolys();
                pl.y = y;
                pl.next = pl;
                Arc at = this.newArc();
                at.y[this.nv] = at.y[this.v] = y;
                at.pol = pl;
                this.GLUE(al, at, this.v);
                this.GLUE(at, at, this.nv);
                this.GLUE(at, ar, this.v);
                al = at;
            }
            assert (y == al.y[this.v]);
            assert (ar == al.t[this.v]);
            assert (al == ar.b[this.nv]);
            int inpVal = this.inpA[inpPos++];
            y = inpVal >> 1;
            int n = d = (inpVal & 1) != 0 ? 1 : -1;
            while (inpPos < this.inpC && this.inpA[inpPos] >> 1 == y) {
                if ((this.inpA[inpPos++] & 1) != 0) {
                    ++d;
                    continue;
                }
                --d;
            }
            assert (d == 1 || d == -1 || d == 2 || d == -2);
            assert (y <= ar.y[this.nv]);
            if (y < ar.y[this.nv]) {
                al.y[this.v] = y;
                pl = this.newPolys();
                pl.y = y;
                pl.next = pl;
                al.pol = this.CAT(al.pol, this.v, pl);
                continue;
            }
            Arc aln = al.b[this.v];
            Arc arn = ar.t[this.nv];
            this.GLUE(aln, arn, this.nv);
            if (al == ar) {
                assert (al == this.top);
                this.top.pol.x = this.x;
                PolyBase.PolyBaseTreeImpl t = this.outTree(this.top.pol);
                if (this.top.sons != null) {
                    for (PolyBase.PolyBaseTreeImpl s : this.top.sons) {
                        t.addSonLowLevel(s);
                    }
                }
                this.dispArc(this.top);
                this.POP();
                this.top.addSon(t);
            } else if (al == this.top) {
                this.top.pol = this.CAT(this.top.pol, this.v, ar.pol);
                this.REPLACE(ar, this.top, this.v);
                arn = aln.t[this.nv];
                sons = ar.sons;
                this.dispArc(ar);
                this.POP();
                this.top.addSons(sons);
            } else if (ar == this.top) {
                this.top.pol = this.CAT(this.top.pol, this.nv, al.pol);
                this.REPLACE(al, this.top, this.nv);
                aln = arn.b[this.v];
                sons = al.sons;
                this.dispArc(al);
                this.POP();
                this.top.addSons(sons);
            } else {
                al.pol = this.CAT(al.pol, this.v, ar.pol);
                this.REPLACE(ar, al, this.v);
                arn = aln.t[this.nv];
                sons = ar.sons;
                this.dispArc(ar);
                al.addSons(sons);
                this.PUSH(al);
            }
            al = aln;
            ar = arn;
        }
    }

    private void out(Polys pl, int v) {
        Polys pg = pl;
        int n = 0;
        int lx = Integer.MAX_VALUE;
        int ly = Integer.MAX_VALUE;
        int hx = Integer.MIN_VALUE;
        int hy = Integer.MIN_VALUE;
        do {
            lx = Math.min(lx, pg.x);
            hx = Math.max(hx, pg.x);
            ly = Math.min(ly, pg.y);
            hy = Math.max(hy, pg.y);
            pg = pg.next;
            ++n;
        } while (pg != pl);
        if (v == 0 && n == 2 && (lx + hx & 1) == 0) {
            System.out.println("WIRE " + this.prCoord(false, (lx + hx) / 2) + " " + this.prCoord(true, ly) + " w=" + DBMath.gridToLambda(hx - lx) + " " + this.prCoord(true, hy));
            return;
        }
        if (v == 0) {
            Polys top = pl;
            while (top.y != hy) {
                top = top.next;
            }
            ArrayList<Polys> left = new ArrayList<Polys>();
            Polys bottom = top;
            while (bottom.next.y < bottom.y) {
                left.add(bottom);
                bottom = bottom.next;
            }
            left.add(bottom);
            ArrayList<Polys> right = new ArrayList<Polys>();
            Polys p = bottom;
            while (p.next.y > p.y) {
                right.add(p);
                p = p.next;
            }
            right.add(p);
            if (p == top) {
                int mx = (lx + hx) / 2;
                System.out.print("WIRE " + this.prCoord(false, mx) + " " + this.prCoord(true, ly));
                int leftI = left.size() - 1;
                int rightI = 0;
                while (true) {
                    int leftW = mx - ((Polys)left.get((int)(leftI - 1))).x;
                    int rightW = ((Polys)right.get((int)rightI)).x - mx;
                    System.out.print(" w=");
                    if (leftW == rightW) {
                        System.out.print(DBMath.gridToLambda(leftW + rightW));
                    } else {
                        System.out.print(DBMath.gridToLambda(leftW) + "+" + DBMath.gridToLambda(rightW));
                    }
                    int nextY = Math.min(((Polys)left.get((int)(leftI - 1))).y, ((Polys)right.get((int)(rightI + 1))).y);
                    System.out.print(" " + this.prCoord(true, nextY));
                    if (nextY == hy) {
                        assert (leftI == 1 && rightI == right.size() - 2);
                        break;
                    }
                    if (nextY == ((Polys)left.get((int)(leftI - 1))).y) {
                        --leftI;
                    }
                    if (nextY != ((Polys)right.get((int)(rightI + 1))).y) continue;
                    ++rightI;
                }
                System.out.println();
                return;
            }
        }
        if (v == 0) {
            System.out.print("POLY");
        } else {
            System.out.print("NEGATIVE POLY");
        }
        do {
            System.out.print(" " + this.prPoint(pg.x, pg.y));
            System.out.print(" " + this.prPoint(pg.x, pg.next.y));
        } while ((pg = pg.next) != pl);
        System.out.println();
    }

    PolyBase.PolyBaseTreeImpl outTree(Polys pl) {
        int k;
        Polys pg = pl;
        int n = 0;
        do {
            pg = pg.next;
            ++n;
        } while (pg != pl);
        PolyBase.Point[] pts = new PolyBase.Point[n * 2];
        if (this.rotated) {
            k = pts.length;
            do {
                pts[--k] = PolyBase.fromGrid(pg.y, pg.x);
                pts[--k] = PolyBase.fromGrid(pg.next.y, pg.x);
            } while ((pg = pg.next) != pl);
            assert (k == 0);
        } else {
            k = 0;
            do {
                pts[k++] = PolyBase.fromGrid(pg.x, pg.y);
                pts[k++] = PolyBase.fromGrid(pg.x, pg.next.y);
            } while ((pg = pg.next) != pl);
            assert (k == pts.length);
        }
        PolyBase p = new PolyBase(pts);
        return new PolyBase.PolyBaseTreeImpl(p);
    }

    private String prPoint(int x2, int y) {
        return this.rotated ? this.prCoord(y) + "," + this.prCoord(x2) : this.prCoord(x2) + "," + this.prCoord(y);
    }

    private String prCoord(boolean isY, int v) {
        return (isY ^ this.rotated ? "y=" : "x=") + this.prCoord(v);
    }

    private String prCoord(int v) {
        double period = 57600.0;
        int n = (int)Math.floor((double)v / period);
        return n + "#" + DBMath.gridToLambda((double)v - (double)n * period);
    }

    private void GLUE(Arc al, Arc ar, int v) {
        al.t[v] = ar;
        ar.b[1 - v] = al;
    }

    private void REPLACE(Arc so, Arc sn, int v) {
        int nv = 1 - v;
        sn.y[v] = so.y[v];
        so.b[v].t[nv] = sn;
        so.t[v].b[nv] = sn;
        sn.b[v] = so.b[v];
        sn.t[v] = so.t[v];
    }

    private void PUSH(Arc a) {
        this.stack.add(this.top);
        this.top = a;
        this.nv = this.v;
        this.v = 1 - this.v;
    }

    private void POP() {
        this.nv = this.v;
        this.v = 1 - this.v;
        this.top = this.stack.remove(this.stack.size() - 1);
    }

    private Polys CAT(Polys pl, int v, Polys pg) {
        (v == 1 ? pg : pl).x = this.x;
        Polys pt = pl.next;
        pl.next = pg.next;
        pg.next = pt;
        return v == 1 ? pl : pg;
    }

    private void printInp() throws IOException {
        System.out.print("x=" + DBMath.gridToLambda(this.x));
        for (int i = 0; i < this.inpC; ++i) {
            int inpVal = this.inpA[i];
            int y = inpVal >> 1;
            boolean df = (inpVal & 1) != 0;
            System.out.print(" " + DBMath.gridToLambda(y) + (df ? "^" : "_"));
        }
        System.out.println();
    }

    private void resetInp() {
        this.inpC = 0;
    }

    private void putPointInp(int y, int val) {
        if (this.inpC >= this.inpA.length) {
            int[] newInpA = new int[this.inpA.length * 2];
            System.arraycopy(this.inpA, 0, newInpA, 0, this.inpA.length);
            this.inpA = newInpA;
        }
        this.inpA[this.inpC++] = y << 1 | (val > 0 ? 1 : 0);
    }

    private Polys newPolys() {
        Polys result2;
        if (this.polyPool == null) {
            result2 = new Polys();
        } else {
            result2 = this.polyPool;
            this.polyPool = this.polyPool.next;
        }
        return result2;
    }

    private void dispPolys(Polys p) {
        p.next = this.polyPool;
        this.polyPool = p;
    }

    private Arc newArc() {
        Arc result2;
        if (this.arcPool == null) {
            result2 = new Arc();
        } else {
            result2 = this.arcPool;
            this.arcPool = this.arcPool.next;
        }
        return result2;
    }

    private void dispArc(Arc p) {
        p.next = this.arcPool;
        this.arcPool = p;
        p.sons = null;
    }

    private static class Arc {
        Arc next;
        int[] y = new int[2];
        Arc[] b = new Arc[2];
        Arc[] t = new Arc[2];
        List<PolyBase.PolyBaseTreeImpl> sons;
        Polys pol;

        private Arc() {
        }

        private void addSon(PolyBase.PolyBaseTreeImpl son) {
            if (this.sons == null) {
                this.sons = new ArrayList<PolyBase.PolyBaseTreeImpl>();
            }
            this.sons.add(son);
        }

        private void addSons(List<PolyBase.PolyBaseTreeImpl> newSons) {
            if (newSons == null || newSons.isEmpty()) {
                return;
            }
            if (this.sons == null) {
                this.sons = new ArrayList<PolyBase.PolyBaseTreeImpl>();
            }
            this.sons.addAll(newSons);
        }
    }

    private static class Polys {
        Polys next;
        int x;
        int y;

        private Polys() {
        }
    }
}

