/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sandbox;

import com.sun.electric.tool.sandbox.EClassLoader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public abstract class ESandBox
extends EClassLoader {
    private static final PrintStream stdOut = System.out;
    private static final OutputStream redirectedStdOut = new OutputStream(){

        public void write(int b) {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        public void write(byte[] b, int off, int len) {
            ESandBox.writeStdOut(b, off, len);
        }
    };
    private static final RunnableTask task;
    private static ESandBox theSandBox;
    private static String command;
    private static final Object lock;
    private static byte[] serializedResultOrException;
    private static boolean isException;
    private final Constructor UniversalJob_constructor = this.getDeclaredConstructor(this.defineClass("com.sun.electric.tool.UniversalJob"), String.class, Runnable.class);
    private static final char MIN_LENGTH_CHAR = ' ';
    private static final char HEADER_CHAR = '\u007f';
    private static final int STRLEN_WIDTH;
    private static final int HEADER_LEN;
    private static final int TRAILER_LEN = 3;

    protected ESandBox(URL electricJar) throws IOException, IllegalAccessException, ClassNotFoundException {
        super(electricJar);
    }

    public static void redirectStdOut(String args) {
        System.setOut(new PrintStream(redirectedStdOut, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop(InputStream commandStream) throws InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        Object object = lock;
        synchronized (object) {
            if (theSandBox != null) {
                throw new IllegalStateException("SandBox already instantiated");
            }
            theSandBox = this;
        }
        command = "redirectStdOut";
        new ServerManagerThread().start();
        BufferedReader commandReader = new BufferedReader(new InputStreamReader(commandStream));
        boolean i = false;
        while (true) {
            Object object2 = lock;
            synchronized (object2) {
                try {
                    while (serializedResultOrException == null) {
                        lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            Object result = null;
            if (serializedResultOrException.length != 0) {
                try {
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serializedResultOrException));
                    result = in.readObject();
                    in.close();
                }
                catch (Throwable e) {
                    result = new Exception(e);
                }
            }
            ESandBox.writeStdOut(serializedResultOrException, isException);
            serializedResultOrException = null;
            command = commandReader.readLine();
            if (command == null) {
                System.exit(0);
            }
            Object job = this.createJob(command);
            this.Job_startJob.invoke(job, new Object[0]);
        }
    }

    private Object createJob(String jobName) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.UniversalJob_constructor.newInstance(jobName, task);
    }

    private static synchronized void writeStdOut(byte[] b, int off, int len) {
        while (len > 0 && (b[off] == 10 || b[off] == 13)) {
            stdOut.write(b[off]);
            ++off;
            --len;
        }
        while (len > 0) {
            int l = Math.min(len, 95);
            stdOut.write(32 + l - 1);
            stdOut.write(b, off, l);
            off += l;
            len -= l;
        }
    }

    private static synchronized void writeStdOut(byte[] b, boolean isException) {
        stdOut.write(127);
        stdOut.write(10);
        stdOut.write(isException ? 69 : 82);
        String s = Integer.toString(b.length);
        while (s.length() < STRLEN_WIDTH) {
            s = '0' + s;
        }
        for (int i = 0; i < s.length(); ++i) {
            stdOut.write(s.charAt(i));
        }
        stdOut.write(10);
        stdOut.write(b, 0, b.length);
        stdOut.write(10);
        stdOut.write(33);
        stdOut.write(10);
    }

    static /* synthetic */ byte[] access$602(byte[] x0) {
        serializedResultOrException = x0;
        return x0;
    }

    static {
        System.setOut(new PrintStream(redirectedStdOut, false));
        task = new RunnableTask();
        lock = new Object();
        STRLEN_WIDTH = Integer.toString(Integer.MAX_VALUE).length();
        HEADER_LEN = 3 + STRLEN_WIDTH + 1;
    }

    private static class RunnableTask
    implements Runnable,
    Serializable {
        private RunnableTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String args;
            String cmd;
            int i = command.indexOf(32);
            if (i >= 0) {
                cmd = command.substring(0, i);
                args = command.substring(i);
            } else {
                cmd = command;
                args = "";
            }
            while (args.startsWith(" ")) {
                args = args.substring(1);
            }
            Object result = null;
            Exception exception = null;
            try {
                if (cmd.length() > 0) {
                    Method method = theSandBox.getClass().getMethod(cmd, String.class);
                    result = method.invoke((Object)theSandBox, args);
                }
            }
            catch (Exception e) {
                exception = e;
            }
            catch (Throwable e) {
                exception = new Exception("Error", e);
                exception.fillInStackTrace();
            }
            byte[] serialized = null;
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteStream);
                out.writeObject(exception != null ? exception : result);
                out.flush();
                serialized = byteStream.toByteArray();
            }
            catch (Throwable e) {
                exception = new Exception("Serialization Error", e);
                exception.fillInStackTrace();
                try {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(byteStream);
                    out.writeObject(exception);
                    out.flush();
                    serialized = byteStream.toByteArray();
                }
                catch (Throwable e2) {
                    serialized = new byte[]{};
                }
            }
            Object object = lock;
            synchronized (object) {
                try {
                    while (serializedResultOrException != null) {
                        lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("Interrupted");
                    Thread.currentThread().interrupt();
                }
                isException = exception != null;
                ESandBox.access$602(serialized);
                lock.notify();
            }
        }
    }

    private class ServerManagerThread
    extends Thread {
        ServerManagerThread() {
            super("ServerManager");
        }

        public void run() {
            try {
                if (ESandBox.this.Job_initJobManager1 != null || ESandBox.this.Job_initJobManager2 != null || ESandBox.this.Job_initJobManager3 != null) {
                    Object ui = ESandBox.this.MainUserInterfaceDummy_constructor.newInstance(new Object[0]);
                    Object jobMode = ESandBox.this.JobMode_SERVER.get(null);
                    if (ESandBox.this.Job_setThreadMode1 != null) {
                        ESandBox.this.Job_setThreadMode1.invoke(null, jobMode, ui);
                    } else if (ESandBox.this.Job_setThreadMode2 != null) {
                        ESandBox.this.Job_setThreadMode2.invoke(null, jobMode, ui);
                    }
                    Object job = ESandBox.this.createJob("SandBox");
                    if (ESandBox.this.Job_initJobManager1 != null) {
                        ESandBox.this.Job_initJobManager1.invoke(null, 1, job, null, null);
                    } else if (ESandBox.this.Job_initJobManager2 != null) {
                        ESandBox.this.Job_initJobManager2.invoke(null, 1, job, null);
                    } else if (ESandBox.this.Job_initJobManager3 != null) {
                        ESandBox.this.Job_initJobManager3.invoke(null, 1, job);
                    }
                } else {
                    Object job = ESandBox.this.createJob("SandBox");
                    ESandBox.this.Job_startJob.invoke(job, new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

