/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.xml.Xml807;
import com.sun.electric.tool.user.User;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveNode
implements NodeProto,
Comparable<PrimitiveNode>,
Serializable {
    public static final int NORMAL = 0;
    public static final int SERPTRANS = 1;
    public static final int POLYGONAL = 2;
    public static final int LOWVTBIT = 8;
    public static final int HIGHVTBIT = 16;
    public static final int NATIVEBIT = 32;
    public static final int OD18BIT = 64;
    public static final int OD25BIT = 128;
    public static final int OD33BIT = 256;
    private static final int NODESHRINK = 1;
    private static final int ARCSWIPE = 512;
    private static final int NSQUARE = 1024;
    private static final int HOLDSTRACE = 2048;
    private static final int CANBEZEROSIZE = 4096;
    private static final int WIPEON1OR2 = 8192;
    private static final int LOCKEDPRIM = 16384;
    private static final int NEDGESELECT = 32768;
    private static final int ARCSHRINK = 65536;
    private static final int NINVISIBLE = 131072;
    private static final int SKIPSIZEINPALETTE = 262144;
    private static final int NNOTUSED = 524288;
    private final PrimitiveNodeId protoId;
    private final Technology tech;
    private Function function;
    private Technology.NodeLayer[] layers;
    private Technology.NodeLayer[] electricalLayers;
    private PrimitivePort[] primPorts = new PrimitivePort[0];
    private PrimitivePort[] portsByChronIndex = new PrimitivePort[0];
    private int userBits;
    private int globalPrimNodeIndex;
    private int techPrimNodeIndex = -1;
    private int specialType;
    private double[] specialValues;
    private int numMultiCuts;
    private NodeSizeRule minNodeSize;
    private final EPoint[] sizeCorrectors = new EPoint[]{EPoint.ORIGIN, EPoint.ORIGIN};
    private SizeOffset offset;
    private ERectangle baseRectangle;
    private ERectangle fullRectangle;
    private Dimension2D autoGrowth;
    private String spiceTemplate;
    private static int primNodeNumber = 0;
    private static Map<PrimitiveNode, Pref> defaultExtendXPrefs = new HashMap<PrimitiveNode, Pref>();
    private static Map<PrimitiveNode, Pref> defaultExtendYPrefs = new HashMap<PrimitiveNode, Pref>();
    private static Map<PrimitiveNode, Boolean> cacheVisibilityNodes = new HashMap<PrimitiveNode, Boolean>();
    private static final String[] nodeBits = new String[]{"NODESHRINK", null, null, "LOWVTBIT", "HIGHVTBIT", "NATIVEBIT", "OD18BIT", "OD25BIT", "OD33BIT", "ARCSWIPE", "NSQUARE", "HOLDSTRACE", "CANBEZEROSIZE", "WIPEON1OR2", "LOCKEDPRIM", "NEDGESELECT", "ARCSHRINK", "NINVISIBLE", "SKIPSIZEINPALETTE", "NNOTUSED", null};

    protected PrimitiveNode(String protoName, Technology tech, EPoint sizeCorrector1, EPoint sizeCorrector2, String minSizeRule, double defWidth, double defHeight, ERectangle fullRectangle, ERectangle baseRectangle, Technology.NodeLayer[] layers) {
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("PrimitiveNode name " + protoName + " is not safe to write in the JELIB");
        }
        this.protoId = tech.getId().newPrimitiveNodeId(protoName);
        this.function = Function.UNKNOWN;
        this.tech = tech;
        this.layers = layers;
        this.electricalLayers = null;
        this.userBits = 0;
        this.specialType = 0;
        this.sizeCorrectors[0] = sizeCorrector1;
        this.sizeCorrectors[1] = sizeCorrector2;
        this.fullRectangle = fullRectangle;
        this.baseRectangle = baseRectangle;
        if (minSizeRule != null) {
            if (minSizeRule.length() == 0) {
                minSizeRule = this.getName() + " Min. Size";
            }
            this.minNodeSize = new NodeSizeRule(minSizeRule);
        }
        this.setFactoryDefSize(defWidth, defHeight);
        double lx = baseRectangle.getLambdaMinX() - fullRectangle.getLambdaMinX();
        double hx = fullRectangle.getLambdaMaxX() - baseRectangle.getLambdaMaxX();
        double ly = baseRectangle.getLambdaMinY() - fullRectangle.getLambdaMinY();
        double hy = fullRectangle.getLambdaMaxY() - baseRectangle.getLambdaMaxY();
        this.offset = new SizeOffset(lx, hx, ly, hy);
        this.autoGrowth = null;
        this.globalPrimNodeIndex = primNodeNumber++;
        int numMultiCuts = 0;
        for (Technology.NodeLayer nodeLayer : layers) {
            if (nodeLayer.getRepresentation() != 3) continue;
            ++numMultiCuts;
        }
        this.numMultiCuts = numMultiCuts;
        tech.addNodeProto(this);
        this.check();
    }

    protected Object writeReplace() {
        return new PrimitiveNodeKey(this);
    }

    public static PrimitiveNode newInstance(String protoName, Technology tech, double width, double height, String minSizeRule, SizeOffset offset, Technology.NodeLayer[] layers) {
        EPoint sizeCorrector = EPoint.fromLambda(0.5 * width, 0.5 * height);
        if (offset == null) {
            offset = new SizeOffset(0.0, 0.0, 0.0, 0.0);
        }
        long lx = -sizeCorrector.getGridX() + offset.getLowXGridOffset();
        long hx = sizeCorrector.getGridX() - offset.getHighXGridOffset();
        long ly = -sizeCorrector.getGridY() + offset.getLowYGridOffset();
        long hy = sizeCorrector.getGridY() - offset.getHighYGridOffset();
        ERectangle fullRectangle = ERectangle.fromGrid(-sizeCorrector.getGridX(), -sizeCorrector.getGridY(), 2L * sizeCorrector.getGridX(), 2L * sizeCorrector.getGridY());
        ERectangle baseRectangle = ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
        EPoint sizeCorrector2 = EPoint.fromGrid(baseRectangle.getGridWidth() >> 1, baseRectangle.getGridHeight() >> 1);
        return PrimitiveNode.newInstance(protoName, tech, sizeCorrector, sizeCorrector2, minSizeRule, width, height, fullRectangle, baseRectangle, layers);
    }

    public static PrimitiveNode newInstance(String protoName, Technology tech, double width, double height, SizeOffset offset, Technology.NodeLayer[] layers) {
        return PrimitiveNode.newInstance(protoName, tech, width, height, null, offset, layers);
    }

    public static PrimitiveNode newInstance0(String protoName, Technology tech, double width, double height, Technology.NodeLayer[] layers) {
        return PrimitiveNode.newInstance(protoName, tech, EPoint.ORIGIN, EPoint.ORIGIN, null, width, height, ERectangle.ORIGIN, ERectangle.ORIGIN, layers);
    }

    static PrimitiveNode newInstance(String protoName, Technology tech, EPoint sizeCorrector1, EPoint sizeCorrector2, String minSizeRule, double width, double height, ERectangle fullRectangle, ERectangle baseRectangle, Technology.NodeLayer[] layers) {
        if (tech.findNodeProto(protoName) != null) {
            System.out.println("Error: technology " + tech.getTechName() + " has multiple nodes named " + protoName);
            return null;
        }
        if (width < 0.0 || height < 0.0) {
            System.out.println("Error: technology " + tech.getTechName() + " node " + protoName + " has negative size");
            return null;
        }
        PrimitiveNode pn = new PrimitiveNode(protoName, tech, sizeCorrector1, sizeCorrector2, minSizeRule, width, height, fullRectangle, baseRectangle, layers);
        return pn;
    }

    static PrimitiveNode makeArcPin(ArcProto ap, String pinName, String portName, double elibSize0, double elibSize1, ArcProto ... extraArcs) {
        Technology tech = ap.getTechnology();
        Technology.NodeLayer[] nodeLayers = new Technology.NodeLayer[ap.getNumArcLayers()];
        for (int i = 0; i < ap.getNumArcLayers(); ++i) {
            Layer layer = ap.getLayer(i);
            if (layer.getPseudoLayer() == null) {
                layer.makePseudo();
            }
            layer = layer.getPseudoLayer();
            nodeLayers[i] = new Technology.NodeLayer(layer, 0, Poly.Type.CROSSED, 1, null);
        }
        EPoint sizeCorrector1 = EPoint.fromLambda(elibSize0, elibSize0);
        EPoint sizeCorrector2 = EPoint.fromLambda(elibSize1, elibSize1);
        PrimitiveNode arcPin = PrimitiveNode.newInstance(pinName, tech, sizeCorrector1, sizeCorrector2, null, 0.0, 0.0, ERectangle.ORIGIN, ERectangle.ORIGIN, nodeLayers);
        ArcProto[] connections = new ArcProto[1 + extraArcs.length];
        connections[0] = ap;
        System.arraycopy(extraArcs, 0, connections, 1, extraArcs.length);
        arcPin.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(tech, arcPin, connections, portName, 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(0.0), EdgeV.fromBottom(0.0), EdgeH.fromRight(0.0), EdgeV.fromTop(0.0))});
        arcPin.setFunction(Function.PIN);
        arcPin.setArcsWipe();
        arcPin.setArcsShrink();
        if (ap.isSkipSizeInPalette() || ap.isSpecialArc()) {
            arcPin.setSkipSizeInPalette();
        }
        arcPin.resizeArcPin();
        return arcPin;
    }

    void resizeArcPin() {
        assert (this.function == Function.PIN);
        assert (this.getNumPorts() == 1);
        PrimitivePort port = this.getPort(0);
        ArcProto ap = port.getConnections()[0];
        long fullExtend = ap.getMaxLayerGridExtend();
        this.fullRectangle = ERectangle.fromGrid(-fullExtend, -fullExtend, 2L * fullExtend, 2L * fullExtend);
        long baseExtend = ap.getGridBaseExtend();
        this.baseRectangle = ERectangle.fromGrid(-baseExtend, -baseExtend, 2L * baseExtend, 2L * baseExtend);
        double sizeOffset = DBMath.gridToLambda(fullExtend - baseExtend);
        this.offset = new SizeOffset(sizeOffset, sizeOffset, sizeOffset, sizeOffset);
        assert (ap.getNumArcLayers() == this.layers.length);
        for (int arcLayerIndex = 0; arcLayerIndex < this.layers.length; ++arcLayerIndex) {
            Technology.NodeLayer nl = this.layers[arcLayerIndex];
            double indent = DBMath.gridToLambda(fullExtend - (long)ap.getLayerGridExtend(arcLayerIndex));
            nl.setPoints(Technology.TechPoint.makeIndented(indent));
        }
        port.getLeft().setAdder(-this.fullRectangle.getLambdaMinX());
        port.getRight().setAdder(-this.fullRectangle.getLambdaMaxX());
        port.getBottom().setAdder(-this.fullRectangle.getLambdaMinY());
        port.getTop().setAdder(-this.fullRectangle.getLambdaMaxY());
    }

    @Override
    public PrimitiveNodeId getId() {
        return this.protoId;
    }

    @Override
    public String getName() {
        return this.protoId.name;
    }

    public String getFullName() {
        return this.protoId.fullName;
    }

    public void setFunction(Function function) {
        this.checkChanging();
        this.function = function;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    public Function getGroupFunction() {
        if (this.function == Function.TRANMOS || this.function == Function.TRA4NMOS || this.function == Function.TRAPMOS || this.function == Function.TRA4PMOS || this.function == Function.TRADMOS || this.function == Function.TRA4DMOS || this.function == Function.TRANPN || this.function == Function.TRA4NPN || this.function == Function.TRAPNP || this.function == Function.TRA4PNP || this.function == Function.TRANJFET || this.function == Function.TRA4NJFET || this.function == Function.TRAPJFET || this.function == Function.TRA4PJFET || this.function == Function.TRADMES || this.function == Function.TRA4DMES || this.function == Function.TRAEMES || this.function == Function.TRA4EMES || this.function == Function.TRANS4) {
            return Function.TRANS;
        }
        if (this.function.isResistor() || this.function.isCapacitor() || this.function == Function.DIODE || this.function == Function.DIODEZ || this.function == Function.INDUCT) {
            return Function.INDUCT;
        }
        if (this.function == Function.CCVS || this.function == Function.CCCS || this.function == Function.VCVS || this.function == Function.VCCS || this.function == Function.TLINE) {
            return Function.TLINE;
        }
        if (this.function == Function.BASE || this.function == Function.EMIT || this.function == Function.COLLECT) {
            return Function.COLLECT;
        }
        if (this.function == Function.BUFFER || this.function == Function.GATEAND || this.function == Function.GATEOR || this.function == Function.MUX || this.function == Function.GATEXOR) {
            return Function.GATEXOR;
        }
        if (this.function == Function.CONPOWER || this.function == Function.CONGROUND) {
            return Function.CONGROUND;
        }
        if (this.function == Function.METER || this.function == Function.SOURCE) {
            return Function.SOURCE;
        }
        if (this.function == Function.SUBSTRATE || this.function == Function.WELL) {
            return Function.WELL;
        }
        return this.function;
    }

    public Technology.NodeLayer[] getLayers() {
        return this.layers;
    }

    public void setLayers(Technology.NodeLayer[] layers) {
        this.layers = layers;
        PrimitiveNode.resetAllVisibility();
    }

    public Iterator<Layer> getLayerIterator() {
        return new NodeLayerIterator(this.layers);
    }

    public Technology.NodeLayer[] getElectricalLayers() {
        return this.electricalLayers;
    }

    public void setElectricalLayers(Technology.NodeLayer[] electricalLayers) {
        this.electricalLayers = electricalLayers;
    }

    public Technology.NodeLayer findNodeLayer(Layer layer, boolean electrical) {
        Technology.NodeLayer[] nodes;
        Technology.NodeLayer[] nodeLayerArray = nodes = electrical ? this.electricalLayers : this.layers;
        if (nodes != null) {
            for (int j = 0; j < nodes.length; ++j) {
                Technology.NodeLayer oneLayer = nodes[j];
                if (oneLayer.getLayer() != layer) continue;
                return oneLayer;
            }
        }
        return null;
    }

    public boolean hasMultiCuts() {
        return this.numMultiCuts > 0;
    }

    public Technology.NodeLayer findMulticut() {
        for (Technology.NodeLayer nl : this.layers) {
            if (nl.getRepresentation() != 3) continue;
            return nl;
        }
        return null;
    }

    public boolean isMulticut() {
        return this.numMultiCuts == 1;
    }

    public int getDefPlacementAngle() {
        int defAngle = User.getNewNodeRotation();
        return defAngle;
    }

    private Pref getNodeProtoExtendXPref(double factoryExtendX) {
        Pref pref = defaultExtendXPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultExtendXFor" + this.getName() + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factoryExtendX);
            defaultExtendXPrefs.put(this, pref);
        }
        return pref;
    }

    private Pref getNodeProtoExtendYPref(double factoryExtendY) {
        Pref pref = defaultExtendYPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultExtendYFor" + this.getName() + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factoryExtendY);
            defaultExtendYPrefs.put(this, pref);
        }
        return pref;
    }

    protected void setFactoryDefSize(double defWidth, double defHeight) {
        this.getNodeProtoExtendXPref(DBMath.round(0.5 * (defWidth - this.fullRectangle.getLambdaWidth())));
        this.getNodeProtoExtendYPref(DBMath.round(0.5 * (defHeight - this.fullRectangle.getLambdaHeight())));
    }

    public void setDefSize(double defWidth, double defHeight) {
        this.getNodeProtoExtendXPref(0.0).setDouble(DBMath.round(0.5 * (defWidth - this.fullRectangle.getLambdaWidth())));
        this.getNodeProtoExtendYPref(0.0).setDouble(DBMath.round(0.5 * (defHeight - this.fullRectangle.getLambdaHeight())));
    }

    @Override
    public double getDefWidth() {
        return DBMath.gridToLambda(this.fullRectangle.getGridWidth() + 2L * this.getDefaultGridExtendX());
    }

    @Override
    public double getDefHeight() {
        return DBMath.gridToLambda(this.fullRectangle.getGridHeight() + 2L * this.getDefaultGridExtendY());
    }

    public double getDefaultLambdaBaseWidth() {
        return DBMath.gridToLambda(this.getDefaultGridBaseWidth());
    }

    public double getDefaultLambdaBaseHeight() {
        return DBMath.gridToLambda(this.getDefaultGridBaseHeight());
    }

    public long getDefaultGridBaseWidth() {
        return this.baseRectangle.getGridWidth() + 2L * this.getDefaultGridExtendX();
    }

    public long getDefaultGridBaseHeight() {
        return this.baseRectangle.getGridHeight() + 2L * this.getDefaultGridExtendY();
    }

    public double getDefaultLambdaExtendX() {
        return DBMath.gridToLambda(this.getDefaultGridExtendX());
    }

    public double getDefaultLambdaExtendY() {
        return DBMath.gridToLambda(this.getDefaultGridExtendY());
    }

    public long getDefaultGridExtendX() {
        return DBMath.lambdaToGrid(this.getNodeProtoExtendXPref(0.0).getDouble());
    }

    public long getDefaultGridExtendY() {
        return DBMath.lambdaToGrid(this.getNodeProtoExtendYPref(0.0).getDouble());
    }

    @Override
    public SizeOffset getProtoSizeOffset() {
        return this.offset;
    }

    public ERectangle getBaseRectangle() {
        return this.baseRectangle;
    }

    public ERectangle getFullRectangle() {
        return this.fullRectangle;
    }

    EPoint getSizeCorrector(int version) {
        return this.sizeCorrectors[version];
    }

    public NodeSizeRule getMinSizeRule() {
        return this.minNodeSize;
    }

    public void setMinSize(double minWidth, double minHeight, String minSizeRule) {
        this.setSizeCorrector(minWidth, minHeight);
        if (minSizeRule == null || minSizeRule.equals("")) {
            minSizeRule = this.getName() + " Min. Size";
        }
        this.minNodeSize = new NodeSizeRule(minSizeRule);
        this.check();
    }

    private void setSizeCorrector(double refWidth, double refHeight) {
        long extendX = DBMath.lambdaToGrid(0.5 * refWidth);
        long extendY = DBMath.lambdaToGrid(0.5 * refHeight);
        this.sizeCorrectors[0] = EPoint.fromGrid(extendX, extendY);
        this.fullRectangle = ERectangle.fromGrid(-extendX, -extendY, 2L * extendX, 2L * extendY);
        long lx = this.fullRectangle.getGridMinX() + this.offset.getLowXGridOffset();
        long hx = this.fullRectangle.getGridMaxX() - this.offset.getHighXGridOffset();
        long ly = this.fullRectangle.getGridMinY() + this.offset.getLowYGridOffset();
        long hy = this.fullRectangle.getGridMaxY() - this.offset.getHighYGridOffset();
        this.baseRectangle = ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
        this.sizeCorrectors[1] = EPoint.fromGrid(this.baseRectangle.getGridWidth() >> 1, this.baseRectangle.getGridHeight() >> 1);
        this.check();
    }

    public void setSizeOffset(SizeOffset offset) {
        this.offset = offset;
        long lx = this.fullRectangle.getGridMinX() + offset.getLowXGridOffset();
        long hx = this.fullRectangle.getGridMaxX() - offset.getHighXGridOffset();
        long ly = this.fullRectangle.getGridMinY() + offset.getLowYGridOffset();
        long hy = this.fullRectangle.getGridMaxY() - offset.getHighYGridOffset();
        this.baseRectangle = ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
        this.sizeCorrectors[1] = EPoint.fromGrid(this.baseRectangle.getGridWidth() >> 1, this.baseRectangle.getGridHeight() >> 1);
        this.check();
    }

    public void resize(Technology.DistanceContext context) {
        for (Technology.NodeLayer nl : this.layers) {
            nl.resize(context);
        }
        if (this.electricalLayers != null) {
            for (Technology.NodeLayer nl : this.electricalLayers) {
                nl.resize(context);
            }
        }
    }

    public void setAutoGrowth(double dX, double dY) {
        this.autoGrowth = new Dimension2D.Double(dX, dY);
    }

    public Dimension2D getAutoGrowth() {
        return this.autoGrowth;
    }

    public void setSpiceTemplate(String st) {
        this.spiceTemplate = st;
    }

    public String getSpiceTemplate() {
        return this.spiceTemplate;
    }

    @Override
    public Technology getTechnology() {
        return this.tech;
    }

    public void addPrimitivePorts(PrimitivePort[] ports) {
        assert (ports.length == this.primPorts.length);
        for (int i = 0; i < this.primPorts.length; ++i) {
            assert (this.primPorts[i] == ports[i]);
            assert (this.primPorts[i].getPortIndex() == i);
        }
        if (this.primPorts.length == 1) {
            PrimitivePort thePort = this.primPorts[0];
            PrimitivePortId newPortId = thePort.setEmptyId();
            this.portsByChronIndex = new PrimitivePort[newPortId.chronIndex + 1];
            this.portsByChronIndex[newPortId.chronIndex] = thePort;
        }
    }

    void addPrimitivePort(PrimitivePort pp) {
        assert (pp.getParent() == this);
        assert (pp.getPortIndex() == this.primPorts.length);
        PrimitivePort[] newPrimPorts = new PrimitivePort[this.primPorts.length + 1];
        System.arraycopy(this.primPorts, 0, newPrimPorts, 0, this.primPorts.length);
        newPrimPorts[pp.getPortIndex()] = pp;
        this.primPorts = newPrimPorts;
        PrimitivePortId primitivePortId = pp.getId();
        if (primitivePortId.chronIndex >= this.portsByChronIndex.length) {
            PrimitivePort[] newPortsByChronIndex = new PrimitivePort[primitivePortId.chronIndex + 1];
            System.arraycopy(this.portsByChronIndex, 0, newPortsByChronIndex, 0, this.portsByChronIndex.length);
            this.portsByChronIndex = newPortsByChronIndex;
        }
        this.portsByChronIndex[primitivePortId.chronIndex] = pp;
    }

    @Override
    public PortProto findPortProto(String name) {
        if (name == null) {
            return null;
        }
        return this.findPortProto(Name.findName(name));
    }

    @Override
    public PortProto findPortProto(Name name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.primPorts.length; ++i) {
            PrimitivePort pp = this.primPorts[i];
            if (pp.getNameKey() != name) continue;
            return pp;
        }
        return null;
    }

    PrimitivePort getPrimitivePortByChronIndex(int chronIndex) {
        return chronIndex < this.portsByChronIndex.length ? this.portsByChronIndex[chronIndex] : null;
    }

    @Override
    public Iterator<PortProto> getPorts() {
        return ArrayIterator.iterator((PortProto[])this.primPorts);
    }

    public Iterator<PrimitivePort> getPrimitivePorts() {
        return ArrayIterator.iterator(this.primPorts);
    }

    @Override
    public int getNumPorts() {
        return this.primPorts.length;
    }

    @Override
    public final PrimitivePort getPort(int portIndex) {
        return this.primPorts[portIndex];
    }

    @Override
    public PrimitivePort getPort(PortProtoId portProtoId) {
        if (portProtoId.getParentId() != this.protoId) {
            throw new IllegalArgumentException();
        }
        return this.portsByChronIndex[portProtoId.getChronIndex()];
    }

    public PrimitivePort connectsTo(ArcProto arc) {
        for (int i = 0; i < this.primPorts.length; ++i) {
            PrimitivePort pp = this.primPorts[i];
            if (!pp.connectsTo(arc)) continue;
            return pp;
        }
        return null;
    }

    public int getSpecialType() {
        return this.specialType;
    }

    public void setSpecialType(int specialType) {
        this.specialType = specialType;
    }

    public static String getSpecialTypeName(int t) {
        if (t == 0) {
            return "normal";
        }
        if (t == 1) {
            return "serp-trans";
        }
        if (t == 2) {
            return "outline";
        }
        return "?";
    }

    public double[] getSpecialValues() {
        return this.specialValues;
    }

    public EPoint getMulticut2Size() {
        Technology.NodeLayer cutLayer = this.findMulticut();
        assert (cutLayer.getLeftEdge().getMultiplier() == -0.5);
        assert (cutLayer.getBottomEdge().getMultiplier() == -0.5);
        assert (cutLayer.getRightEdge().getMultiplier() == 0.5);
        assert (cutLayer.getTopEdge().getMultiplier() == 0.5);
        double x = cutLayer.getMulticutSizeX() + cutLayer.getMulticutSep2D() + cutLayer.getLeftEdge().getAdder() - cutLayer.getRightEdge().getAdder();
        double y = cutLayer.getMulticutSizeY() + cutLayer.getMulticutSep2D() + cutLayer.getBottomEdge().getAdder() - cutLayer.getTopEdge().getAdder();
        return EPoint.fromLambda(x, y);
    }

    public void setSpecialValues(double[] specialValues) {
        if (specialValues.length != 6) {
            throw new IndexOutOfBoundsException("Invalid number of values in setSpecialValues");
        }
        this.specialValues = specialValues;
    }

    public boolean isPin() {
        return this.getFunction() == Function.PIN;
    }

    @Override
    public String describe(boolean withQuotes) {
        String name = "";
        if (this.tech != Technology.getCurrent()) {
            name = name + this.tech.getTechName() + ":";
        }
        name = name + this.getName();
        return withQuotes ? "'" + name + "'" : name;
    }

    public boolean isNodeBitOn(int bit) {
        assert (bit == 8 || bit == 16 || bit == 32 || bit == 64 || bit == 128 || bit == 256);
        return (this.userBits & bit) != 0;
    }

    public void setNodeBit(int bit) {
        this.checkChanging();
        this.userBits |= bit;
    }

    public void setSkipSizeInPalette() {
        this.checkChanging();
        this.userBits |= 0x40000;
    }

    public boolean isSkipSizeInPalette() {
        return (this.userBits & 0x40000) != 0;
    }

    public void setCanShrink() {
        this.checkChanging();
        this.userBits |= 1;
    }

    public void clearCanShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFFFFFE;
    }

    public boolean canShrink() {
        return (this.userBits & 1) != 0;
    }

    public void setArcsWipe() {
        this.checkChanging();
        this.userBits |= 0x200;
    }

    public void clearArcsWipe() {
        this.checkChanging();
        this.userBits &= 0xFFFFFDFF;
    }

    public boolean isArcsWipe() {
        return (this.userBits & 0x200) != 0;
    }

    public void setSquare() {
        this.checkChanging();
        this.userBits |= 0x400;
    }

    public void clearSquare() {
        this.checkChanging();
        this.userBits &= 0xFFFFFBFF;
    }

    public boolean isSquare() {
        return (this.userBits & 0x400) != 0;
    }

    public void setHoldsOutline() {
        this.checkChanging();
        this.userBits |= 0x800;
    }

    public void clearHoldsOutline() {
        this.checkChanging();
        this.userBits &= 0xFFFFF7FF;
    }

    public boolean isHoldsOutline() {
        return (this.userBits & 0x800) != 0;
    }

    public void setCanBeZeroSize() {
        this.checkChanging();
        this.userBits |= 0x1000;
    }

    public void clearCanBeZeroSize() {
        this.checkChanging();
        this.userBits &= 0xFFFFEFFF;
    }

    public boolean isCanBeZeroSize() {
        return (this.userBits & 0x1000) != 0;
    }

    public void setWipeOn1or2() {
        this.checkChanging();
        this.userBits |= 0x2000;
    }

    public void clearWipeOn1or2() {
        this.checkChanging();
        this.userBits &= 0xFFFFDFFF;
    }

    public boolean isWipeOn1or2() {
        return (this.userBits & 0x2000) != 0;
    }

    public void setLockedPrim() {
        this.checkChanging();
        this.userBits |= 0x4000;
    }

    public void clearLockedPrim() {
        this.checkChanging();
        this.userBits &= 0xFFFFBFFF;
    }

    public boolean isLockedPrim() {
        return (this.userBits & 0x4000) != 0;
    }

    public void setEdgeSelect() {
        this.checkChanging();
        this.userBits |= 0x8000;
    }

    public void clearEdgeSelect() {
        this.checkChanging();
        this.userBits &= 0xFFFF7FFF;
    }

    public boolean isEdgeSelect() {
        return (this.userBits & 0x8000) != 0;
    }

    public void setArcsShrink() {
        this.checkChanging();
        this.userBits |= 0x10000;
    }

    public void clearArcsShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFEFFFF;
    }

    public boolean isArcsShrink() {
        return (this.userBits & 0x10000) != 0;
    }

    public void setNodeInvisible(boolean invisible) {
        this.userBits = invisible ? (this.userBits |= 0x20000) : (this.userBits &= 0xFFFDFFFF);
    }

    public boolean isNodeInvisible() {
        return (this.userBits & 0x20000) != 0;
    }

    public void setNotUsed(boolean set) {
        this.checkChanging();
        this.userBits = set ? (this.userBits |= 0x80000) : (this.userBits &= 0xFFF7FFFF);
    }

    public static void resetAllVisibility() {
        cacheVisibilityNodes.clear();
    }

    public boolean isVisible() {
        Boolean b = cacheVisibilityNodes.get(this);
        if (b == null) {
            boolean visible = false;
            Iterator<Layer> it2 = this.getLayerIterator();
            while (it2.hasNext()) {
                Layer lay = it2.next();
                if (!lay.isVisible()) continue;
                visible = true;
                break;
            }
            b = new Boolean(visible);
            cacheVisibilityNodes.put(this, b);
        }
        return b;
    }

    public boolean isNotUsed() {
        return (this.userBits & 0x80000) != 0;
    }

    public boolean isPureWellNode() {
        if (this.function != Function.NODE) {
            return false;
        }
        if (this.layers.length != 1) {
            return false;
        }
        Layer layer = this.layers[0].getLayer();
        return layer.getFunction().isWell();
    }

    public boolean isPureSubstrateNode() {
        if (this.function != Function.NODE) {
            return false;
        }
        if (this.layers.length != 1) {
            return false;
        }
        Layer layer = this.layers[0].getLayer();
        return layer.getFunction().isSubstrate();
    }

    public final int getPrimNodeIndexInTech() {
        return this.techPrimNodeIndex;
    }

    public void setPrimNodeIndexInTech(int index) {
        this.techPrimNodeIndex = index;
        assert (this.techPrimNodeIndex == this.protoId.chronIndex);
    }

    @Override
    public int compareTo(PrimitiveNode that) {
        int cmp;
        if (this.tech != that.tech && (cmp = this.tech.compareTo(that.tech)) != 0) {
            return cmp;
        }
        return this.globalPrimNodeIndex - that.globalPrimNodeIndex;
    }

    public String toString() {
        return "node " + this.describe(true);
    }

    void dump(PrintWriter out) {
        out.print("PrimitiveNode " + this.getName() + " " + (Object)((Object)this.getFunction()));
        if (this.isNotUsed()) {
            out.println(" NOTUSED");
            return;
        }
        Technology.printlnBits(out, nodeBits, this.userBits);
        out.print("\tspecialType=" + this.specialType + " numMultiCuts=" + this.numMultiCuts);
        if (this.specialValues != null) {
            for (double v : this.specialValues) {
                out.print(" " + v);
            }
        }
        out.println();
        if (this.offset != null) {
            out.println("\t" + this.offset);
        }
        out.println("\tfullRectangle=" + this.fullRectangle);
        out.println("\tbaseRectangle=" + this.baseRectangle);
        if (this.minNodeSize != null) {
            out.println("\tminNodeSize w=" + this.minNodeSize.getWidth() + " h=" + this.minNodeSize.getHeight() + " rule=" + this.minNodeSize.getRuleName());
        }
        if (this.autoGrowth != null) {
            out.println("\tautoGrowth " + this.autoGrowth);
        }
        Technology.printlnPref(out, 1, defaultExtendXPrefs.get(this));
        Technology.printlnPref(out, 1, defaultExtendYPrefs.get(this));
        for (int techVersion = 0; techVersion < 2; ++techVersion) {
            EPoint sizeCorrector = this.getSizeCorrector(techVersion);
            String diskOffset = "diskOffset" + (techVersion + 1);
            double x = sizeCorrector.getLambdaX();
            double y = sizeCorrector.getLambdaY();
            out.println("\t" + diskOffset + "=" + x + "," + y);
        }
        out.println("\tlayers:");
        boolean isSerp = this.specialType == 1;
        this.dumpNodeLayers(out, this.layers, isSerp);
        if (this.electricalLayers != null) {
            out.println("\telectricalLayers:");
            this.dumpNodeLayers(out, this.electricalLayers, isSerp);
        }
        for (PrimitivePort pp : this.primPorts) {
            pp.dump(out);
        }
    }

    private void dumpNodeLayers(PrintWriter out, Technology.NodeLayer[] layers, boolean isSerp) {
        for (Technology.NodeLayer nl : layers) {
            nl.dump(out, isSerp);
        }
    }

    Xml.PrimitiveNode makeXml() {
        List<Technology.NodeLayer> nodeLayers;
        EPoint p2;
        Xml.PrimitiveNode n = new Xml.PrimitiveNode();
        n.name = this.getName();
        for (Map.Entry<String, PrimitiveNode> e : this.tech.getOldNodeNames().entrySet()) {
            if (e.getValue() != this) continue;
            assert (n.oldName == null);
            n.oldName = e.getKey();
        }
        n.function = this.getFunction();
        n.shrinkArcs = this.isArcsShrink();
        n.square = this.isSquare();
        n.canBeZeroSize = this.isCanBeZeroSize();
        n.wipes = this.isWipeOn1or2();
        n.lockable = this.isLockedPrim();
        n.edgeSelect = this.isEdgeSelect();
        n.skipSizeInPalette = this.isSkipSizeInPalette();
        n.notUsed = this.isNotUsed();
        n.lowVt = this.isNodeBitOn(8);
        n.highVt = this.isNodeBitOn(16);
        n.nativeBit = this.isNodeBitOn(32);
        n.od18 = this.isNodeBitOn(64);
        n.od25 = this.isNodeBitOn(128);
        n.od33 = this.isNodeBitOn(256);
        NodeSizeRule nodeSizeRule = this.getMinSizeRule();
        EPoint minFullSize = EPoint.fromGrid((this.fullRectangle.getGridWidth() + 1L) / 2L, (this.fullRectangle.getGridHeight() + 1L) / 2L);
        SizeOffset so = this.getProtoSizeOffset();
        if (so.getLowXOffset() == 0.0 && so.getHighXOffset() == 0.0 && so.getLowYOffset() == 0.0 && so.getHighYOffset() == 0.0) {
            so = null;
        }
        n.sizeOffset = so;
        EPoint p1 = this.getSizeCorrector(0);
        if (!p1.equals(p2 = this.getSizeCorrector(1))) {
            n.diskOffset.put(1, p1);
        }
        if (!p2.equals(EPoint.ORIGIN)) {
            n.diskOffset.put(2, p2);
        }
        n.defaultWidth.addLambda(DBMath.round(this.getDefWidth() - 2.0 * minFullSize.getLambdaX()));
        n.defaultHeight.addLambda(DBMath.round(this.getDefHeight() - 2.0 * minFullSize.getLambdaY()));
        List<Technology.NodeLayer> electricalNodeLayers = nodeLayers = Arrays.asList(this.getLayers());
        if (this.getElectricalLayers() != null) {
            electricalNodeLayers = Arrays.asList(this.getElectricalLayers());
        }
        boolean isSerp = this.getSpecialType() == 1;
        int m = 0;
        for (Technology.NodeLayer nld : electricalNodeLayers) {
            int j = nodeLayers.indexOf(nld);
            if (j < 0) {
                n.nodeLayers.add(nld.makeXml(isSerp, minFullSize, false, true));
                continue;
            }
            while (m < j) {
                n.nodeLayers.add(nodeLayers.get(m++).makeXml(isSerp, minFullSize, true, false));
            }
            n.nodeLayers.add(nodeLayers.get(m++).makeXml(isSerp, minFullSize, true, true));
        }
        while (m < nodeLayers.size()) {
            n.nodeLayers.add(nodeLayers.get(m++).makeXml(isSerp, minFullSize, true, false));
        }
        Iterator<PrimitivePort> pit = this.getPrimitivePorts();
        while (pit.hasNext()) {
            PrimitivePort pp = pit.next();
            n.ports.add(pp.makeXml(minFullSize));
        }
        n.specialType = this.getSpecialType();
        if (this.getSpecialValues() != null) {
            n.specialValues = (double[])this.getSpecialValues().clone();
        }
        if (nodeSizeRule != null) {
            n.nodeSizeRule = new Xml.NodeSizeRule();
            n.nodeSizeRule.width = nodeSizeRule.getWidth();
            n.nodeSizeRule.height = nodeSizeRule.getHeight();
            n.nodeSizeRule.rule = nodeSizeRule.getRuleName();
        }
        n.spiceTemplate = this.getSpiceTemplate();
        return n;
    }

    Xml807.PrimitiveNode makeXml807() {
        List<Technology.NodeLayer> nodeLayers;
        SizeOffset so;
        EPoint minFullSize;
        Xml807.PrimitiveNode n = new Xml807.PrimitiveNode();
        n.name = this.getName();
        for (Map.Entry<String, PrimitiveNode> e : this.tech.getOldNodeNames().entrySet()) {
            if (e.getValue() != this) continue;
            assert (n.oldName == null);
            n.oldName = e.getKey();
        }
        n.function = this.getFunction();
        n.shrinkArcs = this.isArcsShrink();
        n.square = this.isSquare();
        n.canBeZeroSize = this.isCanBeZeroSize();
        n.wipes = this.isWipeOn1or2();
        n.lockable = this.isLockedPrim();
        n.edgeSelect = this.isEdgeSelect();
        n.skipSizeInPalette = this.isSkipSizeInPalette();
        n.notUsed = this.isNotUsed();
        n.lowVt = this.isNodeBitOn(8);
        n.highVt = this.isNodeBitOn(16);
        n.nativeBit = this.isNodeBitOn(32);
        n.od18 = this.isNodeBitOn(64);
        n.od25 = this.isNodeBitOn(128);
        n.od33 = this.isNodeBitOn(256);
        NodeSizeRule nodeSizeRule = this.getMinSizeRule();
        EPoint ePoint = minFullSize = nodeSizeRule != null ? EPoint.fromLambda(0.5 * nodeSizeRule.getWidth(), 0.5 * nodeSizeRule.getHeight()) : EPoint.fromLambda(0.5 * this.getDefWidth(), 0.5 * this.getDefHeight());
        if (this.getFunction() == Function.PIN && this.isArcsShrink()) {
            assert (this.getNumPorts() == 1);
            PrimitivePort pp = this.getPort(0);
            assert (pp.getLeft().getMultiplier() == -0.5 && pp.getRight().getMultiplier() == 0.5 && pp.getBottom().getMultiplier() == -0.5 && pp.getTop().getMultiplier() == 0.5);
            assert (pp.getLeft().getAdder() == -pp.getRight().getAdder() && pp.getBottom().getAdder() == -pp.getTop().getAdder());
            minFullSize = EPoint.fromLambda(pp.getLeft().getAdder(), pp.getBottom().getAdder());
        }
        if ((so = this.getProtoSizeOffset()).getLowXOffset() == 0.0 && so.getHighXOffset() == 0.0 && so.getLowYOffset() == 0.0 && so.getHighYOffset() == 0.0) {
            so = null;
        }
        if (!minFullSize.equals(EPoint.ORIGIN)) {
            n.diskOffset = minFullSize;
        }
        n.defaultWidth.addLambda(DBMath.round(this.getDefWidth() - 2.0 * minFullSize.getLambdaX()));
        n.defaultHeight.addLambda(DBMath.round(this.getDefHeight() - 2.0 * minFullSize.getLambdaY()));
        n.nodeBase = this.baseRectangle;
        List<Technology.NodeLayer> electricalNodeLayers = nodeLayers = Arrays.asList(this.getLayers());
        if (this.getElectricalLayers() != null) {
            electricalNodeLayers = Arrays.asList(this.getElectricalLayers());
        }
        boolean isSerp = this.getSpecialType() == 1;
        int m = 0;
        for (Technology.NodeLayer nld : electricalNodeLayers) {
            int j = nodeLayers.indexOf(nld);
            if (j < 0) {
                n.nodeLayers.add(nld.makeXml807(isSerp, minFullSize, false, true));
                continue;
            }
            while (m < j) {
                n.nodeLayers.add(nodeLayers.get(m++).makeXml807(isSerp, minFullSize, true, false));
            }
            n.nodeLayers.add(nodeLayers.get(m++).makeXml807(isSerp, minFullSize, true, true));
        }
        while (m < nodeLayers.size()) {
            n.nodeLayers.add(nodeLayers.get(m++).makeXml807(isSerp, minFullSize, true, false));
        }
        Iterator<PrimitivePort> pit = this.getPrimitivePorts();
        while (pit.hasNext()) {
            PrimitivePort pp = pit.next();
            n.ports.add(pp.makeXml807(minFullSize));
        }
        n.specialType = this.getSpecialType();
        if (this.getSpecialValues() != null) {
            n.specialValues = (double[])this.getSpecialValues().clone();
        }
        if (nodeSizeRule != null) {
            n.nodeSizeRule = new Xml807.NodeSizeRule();
            n.nodeSizeRule.width = nodeSizeRule.getWidth();
            n.nodeSizeRule.height = nodeSizeRule.getHeight();
            n.nodeSizeRule.rule = nodeSizeRule.getRuleName();
        }
        n.spiceTemplate = this.getSpiceTemplate();
        return n;
    }

    public void getZValues(double[] array) {
        for (int j = 0; j < this.layers.length; ++j) {
            Layer layer = this.layers[j].getLayer();
            if (layer.getTechnology() instanceof Generic) continue;
            double distance = layer.getDistance();
            double thickness = layer.getThickness();
            double z = distance + thickness;
            array[0] = array[0] > distance ? distance : array[0];
            array[1] = array[1] < z ? z : array[1];
        }
    }

    private void checkChanging() {
    }

    private void check() {
        assert (this.fullRectangle.getGridMinX() == this.baseRectangle.getGridMinX() - this.offset.getLowXGridOffset());
        assert (this.fullRectangle.getGridMaxX() == this.baseRectangle.getGridMaxX() + this.offset.getHighXGridOffset());
        assert (this.fullRectangle.getGridMinY() == this.baseRectangle.getGridMinY() - this.offset.getLowYGridOffset());
        assert (this.fullRectangle.getGridMaxY() == this.baseRectangle.getGridMaxY() + this.offset.getHighYGridOffset());
    }

    public class NodeSizeRule {
        private final String rule;

        private NodeSizeRule(String rule) {
            this.rule = rule;
        }

        public String getRuleName() {
            return this.rule;
        }

        public double getWidth() {
            return PrimitiveNode.this.fullRectangle.getLambdaWidth();
        }

        public double getHeight() {
            return PrimitiveNode.this.fullRectangle.getLambdaHeight();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeLayerIterator
    implements Iterator<Layer> {
        Technology.NodeLayer[] array;
        int pos;

        public NodeLayerIterator(Technology.NodeLayer[] a) {
            this.array = a;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        @Override
        public Layer next() throws NoSuchElementException {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.pos++].getLayer();
        }

        @Override
        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimitiveNodeKey
    extends EObjectInputStream.Key<PrimitiveNode> {
        public PrimitiveNodeKey() {
        }

        private PrimitiveNodeKey(PrimitiveNode pn) {
            super(pn);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, PrimitiveNode pn) throws IOException {
            out.writeObject(pn.getTechnology());
            out.writeInt(pn.getId().chronIndex);
        }

        @Override
        public PrimitiveNode readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int chronIndex;
            Technology tech = (Technology)in.readObject();
            PrimitiveNode pn = tech.getPrimitiveNodeByChronIndex(chronIndex = in.readInt());
            if (pn == null) {
                throw new InvalidObjectException("primitive node not found");
            }
            return pn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Function {
        UNKNOWN("unknown", "node"),
        PIN("pin", "pin"),
        CONTACT("contact", "contact"),
        NODE("pure-layer-node", "plnode"),
        CONNECT("connection", "conn"),
        TRANMOS("nMOS-transistor", "nmos"),
        TRADMOS("DMOS-transistor", "dmos"),
        TRAPMOS("pMOS-transistor", "pmos"),
        TRANPN("NPN-transistor", "npn"),
        TRAPNP("PNP-transistor", "pnp"),
        TRANJFET("n-type-JFET-transistor", "njfet"),
        TRAPJFET("p-type-JFET-transistor", "pjfet"),
        TRADMES("depletion-mesfet", "dmes"),
        TRAEMES("enhancement-mesfet", "emes"),
        TRANSREF("prototype-defined-transistor", "tref"),
        TRANS("transistor", "trans"),
        TRA4NMOS("4-port-nMOS-transistor", "nmos4p"),
        TRA4DMOS("4-port-DMOS-transistor", "dmos4p"),
        TRA4PMOS("4-port-pMOS-transistor", "pmos4p"),
        TRA4NPN("4-port-NPN-transistor", "npn4p"),
        TRA4PNP("4-port-PNP-transistor", "pnp4p"),
        TRA4NJFET("4-port-n-type-JFET-transistor", "njfet4p"),
        TRA4PJFET("4-port-p-type-JFET-transistor", "pjfet4p"),
        TRA4DMES("4-port-depletion-mesfet", "dmes4p"),
        TRA4EMES("4-port-enhancement-mesfet", "emes4p"),
        TRANS4("4-port-transistor", "trans4p"),
        RESIST("resistor", "res"),
        PRESIST("poly-resistor", "pres"),
        WRESIST("well-resistor", "wres"),
        ESDDEVICE("esd-device", "esdd"),
        CAPAC("capacitor", "cap"),
        ECAPAC("electrolytic-capacitor", "ecap"),
        DIODE("diode", "diode"),
        DIODEZ("zener-diode", "zdiode"),
        INDUCT("inductor", "ind"),
        METER("meter", "meter"),
        BASE("base", "base"),
        EMIT("emitter", "emit"),
        COLLECT("collector", "coll"),
        BUFFER("buffer", "buf"),
        GATEAND("AND-gate", "and"),
        GATEOR("OR-gate", "or"),
        GATEXOR("XOR-gate", "xor"),
        FLIPFLOPRSMS("flip-flop-RS-MS", "ffRSms"),
        FLIPFLOPRSP("flip-flop-RS-P", "ffRSp"),
        FLIPFLOPRSN("flip-flop-RS-N", "ffRSn"),
        FLIPFLOPJKMS("flip-flop-JK-MS", "ffJKms"),
        FLIPFLOPJKP("flip-flop-JK-P", "ffJKp"),
        FLIPFLOPJKN("flip-flop-JK-N", "ffJKn"),
        FLIPFLOPDMS("flip-flop-D-MS", "ffDms"),
        FLIPFLOPDP("flip-flop-D-P", "ffDp"),
        FLIPFLOPDN("flip-flop-D-N", "ffDn"),
        FLIPFLOPTMS("flip-flop-T-MS", "ffTms"),
        FLIPFLOPTP("flip-flop-T-P", "ffTp"),
        FLIPFLOPTN("flip-flop-T-N", "ffTn"),
        MUX("multiplexor", "mux"),
        CONPOWER("power", "pwr"),
        CONGROUND("ground", "gnd"),
        SOURCE("source", "source"),
        SUBSTRATE("substrate", "substr"),
        WELL("well", "well"),
        ART("artwork", "art"),
        ARRAY("array", "array"),
        ALIGN("align", "align"),
        CCVS("ccvs", "ccvs"),
        CCCS("cccs", "cccs"),
        VCVS("vcvs", "vcvs"),
        VCCS("vccs", "vccs"),
        TLINE("transmission-line", "transm");

        private final String name;
        private final String shortName;
        private final Name basename;

        private Function(String name, String shortName) {
            this.name = name;
            this.shortName = shortName;
            this.basename = Name.findName(TextUtils.canonicString(shortName) + "@0").getBasename();
        }

        public static List<Function> getFunctions() {
            return Arrays.asList(Function.class.getEnumConstants());
        }

        public static Function findName(String name) {
            List<Function> allFuncs = Function.getFunctions();
            for (Function fun : allFuncs) {
                if (!fun.name.equalsIgnoreCase(name)) continue;
                return fun;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getConstantName() {
            return this.name();
        }

        public String getShortName() {
            return this.shortName;
        }

        public Name getBasename() {
            return this.basename;
        }

        public boolean isCapacitor() {
            return this == CAPAC || this == ECAPAC;
        }

        public boolean isResistor() {
            return this == RESIST || this == PRESIST || this == WRESIST;
        }

        public boolean isESDDevice() {
            return this == ESDDEVICE;
        }

        public boolean isTransistor() {
            return this == TRANMOS || this == TRAPMOS || this == TRADMOS || this == TRA4NMOS || this == TRA4PMOS || this == TRA4DMOS || this == TRANPN || this == TRAPNP || this == TRANJFET || this == TRAPJFET || this == TRAEMES || this == TRADMES || this == TRA4NPN || this == TRA4PNP || this == TRA4NJFET || this == TRA4PJFET || this == TRA4EMES || this == TRA4DMES || this == TRANSREF || this == TRANS || this == TRANS4;
        }

        public boolean isFlipFlop() {
            return this == FLIPFLOPRSMS || this == FLIPFLOPRSP || this == FLIPFLOPRSN || this == FLIPFLOPJKMS || this == FLIPFLOPJKP || this == FLIPFLOPJKN || this == FLIPFLOPDMS || this == FLIPFLOPDP || this == FLIPFLOPDN || this == FLIPFLOPTMS || this == FLIPFLOPTP || this == FLIPFLOPTN;
        }

        public String toString() {
            return this.name;
        }
    }
}

