/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.ObjectQTree;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CircuitChangeJobs;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoStitch {
    private static final boolean USEQTREE = true;
    private static InteractiveRouter router = new SimpleWirer();
    private List<Route> allRoutes = new ArrayList<Route>();
    private HashSet<NodeInst> possibleInlinePins = new HashSet();
    private HashSet<NodeInst> nodeMark;

    public static void autoStitch(boolean highlighted, boolean forced) {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        ArrayList<NodeInst> nodesToStitch = null;
        ArrayList<ArcInst> arcsToStitch = null;
        RectangularShape limitBound = null;
        if (highlighted) {
            nodesToStitch = new ArrayList<NodeInst>();
            arcsToStitch = new ArrayList<ArcInst>();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            List<Geometric> highs = wnd.getHighlightedEObjs(true, true);
            limitBound = wnd.getHighlightedArea();
            for (Geometric geom : highs) {
                Geometric eObj = geom;
                if (eObj instanceof PortInst) {
                    eObj = ((PortInst)((Object)eObj)).getNodeInst();
                }
                if (eObj instanceof NodeInst) {
                    PrimitiveNode pnp;
                    NodeInst ni = (NodeInst)eObj;
                    if (!ni.isCellInstance() && ((pnp = (PrimitiveNode)ni.getProto()).getTechnology() == Generic.tech || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
                    nodesToStitch.add((NodeInst)eObj);
                    continue;
                }
                if (!(eObj instanceof ArcInst)) continue;
                arcsToStitch.add((ArcInst)eObj);
            }
            if (nodesToStitch.size() == 0 && arcsToStitch.size() == 0) {
                if (forced) {
                    System.out.println("Nothing selected to auto-route");
                }
                return;
            }
        }
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        if (limitBound != null) {
            lX = limitBound.getMinX();
            hX = limitBound.getMaxX();
            lY = limitBound.getMinY();
            hY = limitBound.getMaxY();
        }
        new AutoStitchJob(cell, nodesToStitch, arcsToStitch, lX, hX, lY, hY, forced);
    }

    public static void runAutoStitch(Cell cell, List<NodeInst> nodesToStitch, List<ArcInst> arcsToStitch, PolyMerge stayInside, Rectangle2D limitBound, boolean forced, boolean showProgress) {
        AutoStitch as = new AutoStitch();
        as.runNow(cell, nodesToStitch, arcsToStitch, stayInside, limitBound, forced, showProgress);
    }

    private AutoStitch() {
    }

    private void runNow(Cell cell, List<NodeInst> nodesToStitch, List<ArcInst> arcsToStitch, PolyMerge stayInside, Rectangle2D limitBound, boolean forced, boolean showProgress) {
        Iterator<Geometric> it;
        if (showProgress) {
            Job.getUserInterface().setProgressNote("Initializing routing");
        }
        ArcProto preferredArc = Routing.getPreferredRoutingArcProto();
        if (nodesToStitch == null) {
            nodesToStitch = new ArrayList<NodeInst>();
            it = cell.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pnp;
                NodeInst ni = (NodeInst)it.next();
                if (ni.isIconOfParent() || !ni.isCellInstance() && ((pnp = (PrimitiveNode)ni.getProto()).getTechnology() == Generic.tech || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
                nodesToStitch.add(ni);
            }
        }
        if (arcsToStitch == null) {
            arcsToStitch = new ArrayList<ArcInst>();
            it = cell.getArcs();
            while (it.hasNext()) {
                arcsToStitch.add((ArcInst)it.next());
            }
        }
        HashMap<NodeInst, Rectangle2D[]> nodeBounds = new HashMap<NodeInst, Rectangle2D[]>();
        HashMap<NodeInst, ObjectQTree> nodePortBounds = new HashMap<NodeInst, ObjectQTree>();
        Iterator<NodeInst> nIt = cell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            int total = ni.getProto().getNumPorts();
            Rectangle2D[] bbArray = new Rectangle2D[total];
            int i = 0;
            Iterator<PortProto> pIt = ni.getProto().getPorts();
            while (pIt.hasNext()) {
                PortProto pp = pIt.next();
                PortOriginal fp = new PortOriginal(ni, pp);
                AffineTransform trans = fp.getTransformToTop();
                NodeInst rNi = fp.getBottomNodeInst();
                Rectangle2D.Double bounds = new Rectangle2D.Double(rNi.getAnchorCenterX() - rNi.getXSize() / 2.0, rNi.getAnchorCenterY() - rNi.getYSize() / 2.0, rNi.getXSize(), rNi.getYSize());
                DBMath.transformRect(bounds, trans);
                bbArray[i++] = bounds;
            }
            nodeBounds.put(ni, bbArray);
            ObjectQTree oqt = new ObjectQTree(ni.getBounds());
            Iterator<PortInst> it2 = ni.getPortInsts();
            while (it2.hasNext()) {
                PortInst pi = it2.next();
                PortProto pp = pi.getPortProto();
                PortOriginal fp = new PortOriginal(ni, pp);
                AffineTransform trans = fp.getTransformToTop();
                NodeInst rNi = fp.getBottomNodeInst();
                Rectangle2D.Double bounds = new Rectangle2D.Double(rNi.getAnchorCenterX() - rNi.getXSize() / 2.0, rNi.getAnchorCenterY() - rNi.getYSize() / 2.0, rNi.getXSize(), rNi.getYSize());
                DBMath.transformRect(bounds, trans);
                oqt.add(pi, bounds);
            }
            nodePortBounds.put(ni, oqt);
        }
        this.nodeMark = new HashSet();
        for (NodeInst ni : nodesToStitch) {
            this.nodeMark.add(ni);
        }
        HashMap<ArcProto, Layer> arcLayers = new HashMap<ArcProto, Layer>();
        int totalToStitch = nodesToStitch.size() + arcsToStitch.size();
        int soFar = 0;
        if (showProgress) {
            Job.getUserInterface().setProgressNote("Routing " + totalToStitch + " objects...");
        }
        Topology top = new Topology(cell);
        for (NodeInst ni : nodesToStitch) {
            if (showProgress && ++soFar % 100 == 0) {
                Job.getUserInterface().setProgressValue(soFar * 100 / totalToStitch);
            }
            if (cell.isAllLocked()) continue;
            this.checkStitching(ni, nodeBounds, nodePortBounds, arcLayers, stayInside, top, limitBound, preferredArc);
        }
        for (ArcInst ai : arcsToStitch) {
            if (showProgress && ++soFar % 100 == 0) {
                Job.getUserInterface().setProgressValue(soFar * 100 / totalToStitch);
            }
            if (!ai.isLinked() || cell.isAllLocked() || !this.arcTooWide(ai)) continue;
            this.checkStitching(ai, nodeBounds, nodePortBounds, arcLayers, stayInside, top, limitBound, preferredArc);
        }
        totalToStitch = this.allRoutes.size();
        soFar = 0;
        if (showProgress) {
            Job.getUserInterface().setProgressValue(0L);
            Job.getUserInterface().setProgressNote("Creating " + totalToStitch + " wires...");
        }
        Collections.sort(this.allRoutes, new compRoutes());
        HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
        HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
        for (Route route : this.allRoutes) {
            if (showProgress && ++soFar % 100 == 0) {
                Job.getUserInterface().setProgressValue(soFar * 100 / totalToStitch);
            }
            RouteElement re = (RouteElement)route.get(0);
            Cell c = re.getCell();
            RouteElementPort start = route.getStart();
            RouteElementPort end = route.getEnd();
            PortInst startPi = start.getPortInst();
            PortInst endPi = end.getPortInst();
            if (startPi != null && endPi != null) {
                boolean already = false;
                Iterator<Connection> cIt = startPi.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    ArcInst existingAI = con.getArc();
                    if (existingAI.getHead() == con) {
                        if (existingAI.getTail().getPortInst() != endPi) continue;
                        already = true;
                        break;
                    }
                    if (existingAI.getHead().getPortInst() != endPi) continue;
                    already = true;
                    break;
                }
                if (already) continue;
            }
            if (stayInside != null) {
                // empty if block
            }
            Router.createRouteNoJob(route, c, false, arcsCreatedMap, nodesCreatedMap);
        }
        if (forced) {
            Router.reportRoutingResults("AUTO ROUTING", arcsCreatedMap, nodesCreatedMap);
        }
        if (showProgress) {
            Job.getUserInterface().setProgressValue(0L);
            Job.getUserInterface().setProgressNote("Cleaning up pins...");
        }
        ArrayList<CircuitChangeJobs.Reconnect> pinsToPassThrough = new ArrayList<CircuitChangeJobs.Reconnect>();
        for (NodeInst ni : this.possibleInlinePins) {
            CircuitChangeJobs.Reconnect re;
            if (!ni.isInlinePin() || (re = CircuitChangeJobs.Reconnect.erasePassThru(ni, false, true)) == null) continue;
            pinsToPassThrough.add(re);
        }
        if (pinsToPassThrough.size() > 0) {
            CircuitChangeJobs.CleanupChanges job = new CircuitChangeJobs.CleanupChanges(cell, true, Collections.<NodeInst>emptySet(), pinsToPassThrough, new HashMap<NodeInst, EPoint>(), new ArrayList<NodeInst>(), new HashSet<ArcInst>(), 0, 0, 0);
            try {
                job.doIt();
            }
            catch (JobException e) {
                // empty catch block
            }
        }
    }

    private boolean arcTooWide(ArcInst ai) {
        boolean headTooWide = true;
        NodeInst hNi = ai.getHeadPortInst().getNodeInst();
        if (hNi.isCellInstance()) {
            headTooWide = false;
        } else if (ai.getLambdaBaseWidth() <= hNi.getLambdaBaseXSize() && ai.getLambdaBaseWidth() <= hNi.getLambdaBaseYSize()) {
            headTooWide = false;
        }
        boolean tailTooWide = true;
        NodeInst tNi = ai.getTailPortInst().getNodeInst();
        if (tNi.isCellInstance()) {
            tailTooWide = false;
        } else if (ai.getLambdaBaseWidth() <= tNi.getLambdaBaseXSize() && ai.getLambdaBaseWidth() <= tNi.getLambdaBaseYSize()) {
            tailTooWide = false;
        }
        return headTooWide || tailTooWide;
    }

    private void checkStitching(Geometric geom, HashMap<NodeInst, Rectangle2D[]> nodeBounds, HashMap<NodeInst, ObjectQTree> nodePortBounds, HashMap<ArcProto, Layer> arcLayers, PolyMerge stayInside, Topology top, Rectangle2D limitBound, ArcProto preferredArc) {
        Cell cell = geom.getParent();
        NodeInst ni = null;
        if (geom instanceof NodeInst) {
            ni = (NodeInst)geom;
        }
        ArrayList<Geometric> geomsInArea = new ArrayList<Geometric>();
        Rectangle2D geomBounds = geom.getBounds();
        double epsilon = DBMath.getEpsilon();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(geomBounds.getMinX() - epsilon, geomBounds.getMinY() - epsilon, geomBounds.getWidth() + epsilon * 2.0, geomBounds.getHeight() + epsilon * 2.0);
        Iterator<RTBounds> it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            Geometric oGeom = (Geometric)it.next();
            if (oGeom == geom) continue;
            geomsInArea.add(oGeom);
        }
        for (Geometric oGeom : geomsInArea) {
            PrimitiveNode pnp;
            if (oGeom instanceof ArcInst) {
                ArcInst oAi = (ArcInst)oGeom;
                if (ni == null) {
                    if (!this.arcTooWide(oAi)) continue;
                    this.compareTwoArcs((ArcInst)geom, oAi, stayInside, top, limitBound);
                    continue;
                }
                this.compareNodeWithArc(ni, oAi, stayInside, top, limitBound);
                continue;
            }
            NodeInst oNi = (NodeInst)oGeom;
            if (!oNi.isCellInstance() && ((pnp = (PrimitiveNode)oNi.getProto()).getTechnology() == Generic.tech || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
            if (ni == null) {
                this.compareNodeWithArc(oNi, (ArcInst)geom, stayInside, top, limitBound);
                continue;
            }
            this.compareTwoNodes(ni, oNi, nodeBounds, nodePortBounds, arcLayers, stayInside, top, limitBound, preferredArc);
        }
    }

    private void compareTwoNodes(NodeInst ni, NodeInst oNi, HashMap<NodeInst, Rectangle2D[]> nodeBounds, HashMap<NodeInst, ObjectQTree> nodePortBounds, HashMap<ArcProto, Layer> arcLayers, PolyMerge stayInside, Topology top, Rectangle2D limitBound, ArcProto preferredArc) {
        block26: {
            block27: {
                Rectangle2D.Double biggerBounds;
                if (this.nodeMark.contains(oNi) && oNi.getNodeIndex() <= ni.getNodeIndex()) {
                    return;
                }
                Rectangle2D oBounds = oNi.getBounds();
                if (!ni.isCellInstance()) break block27;
                ObjectQTree oqt = nodePortBounds.get(ni);
                Set set = oqt.find(biggerBounds = new Rectangle2D.Double(oBounds.getMinX() - 1.0, oBounds.getMinY() - 1.0, oBounds.getWidth() + 2.0, oBounds.getHeight() + 2.0));
                if (set == null) break block26;
                block0: for (Object obj : set) {
                    PortInst pi = (PortInst)obj;
                    PortProto pp = pi.getPortProto();
                    AffineTransform trans = ni.rotateOut();
                    NodeInst rNi = ni;
                    PortProto rPp = pp;
                    while (rNi.isCellInstance()) {
                        AffineTransform temp = rNi.translateOut();
                        temp.preConcatenate(trans);
                        Export e = (Export)rPp;
                        rNi = e.getOriginalPort().getNodeInst();
                        rPp = e.getOriginalPort().getPortProto();
                        trans = rNi.rotateOut();
                        trans.preConcatenate(temp);
                    }
                    ArcProto[] connections = pp.getBasePort().getConnections();
                    for (int i = 0; i < connections.length; ++i) {
                        this.findSmallestLayer(connections[i], arcLayers);
                    }
                    boolean usePortPoly = false;
                    Poly[] nodePolys = this.shapeOfNode(rNi);
                    int tot = nodePolys.length;
                    if (tot == 0 || rNi.getProto() == Generic.tech.simProbeNode) {
                        usePortPoly = true;
                        tot = 1;
                    }
                    Netlist subNetlist = rNi.getParent().getUserNetlist();
                    for (int j = 0; j < tot; ++j) {
                        Layer layer = null;
                        Poly poly = null;
                        if (usePortPoly) {
                            poly = ni.getShapeOfPort(pp);
                            layer = poly.getLayer();
                        } else {
                            poly = nodePolys[j];
                            if (poly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, poly.getPort())) continue;
                            poly.transform(trans);
                            layer = poly.getLayer();
                            if (layer != null) {
                                layer = layer.getNonPseudoLayer();
                            }
                        }
                        boolean connected = false;
                        for (int pass = 0; pass < 2; ++pass) {
                            for (int i = 0; i < connections.length; ++i) {
                                ArcProto ap = connections[i];
                                if (pass != 0 ? ap == preferredArc || ap.getTechnology() != rNi.getProto().getTechnology() : ap != preferredArc) continue;
                                if (!usePortPoly) {
                                    Layer oLayer = arcLayers.get(ap);
                                    if (!layer.getTechnology().sameLayer(oLayer, layer)) continue;
                                }
                                if (connected = this.testPoly(ni, pp, ap, poly, oNi, top, nodeBounds, nodePortBounds, arcLayers, stayInside, limitBound)) break;
                            }
                            if (connected) break;
                        }
                        if (connected) continue block0;
                    }
                }
                break block26;
            }
            AffineTransform trans = ni.rotateOut();
            double oX = oNi.getAnchorCenterX();
            double oY = oNi.getAnchorCenterY();
            boolean usePortPoly = false;
            Poly[] polys = this.shapeOfNode(ni);
            int tot = polys.length;
            if (tot == 0 || ni.getProto() == Generic.tech.simProbeNode) {
                usePortPoly = true;
                tot = 1;
            }
            for (int j = 0; j < tot; ++j) {
                double dist;
                double y;
                Iterator<PortProto> pIt;
                double bestDist;
                PortProto bestPp;
                PortProto rPp = null;
                Poly polyPtr = null;
                if (usePortPoly) {
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = pIt.next();
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                            bestPp = tPp;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr = ni.getShapeOfPort(rPp);
                } else {
                    polyPtr = polys[j];
                    if (polyPtr.getPort() == null) continue;
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = pIt.next();
                        if (!top.portsConnected(ni, tPp, polyPtr.getPort())) continue;
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr.transform(trans);
                }
                Layer layer = polyPtr.getLayer();
                if (layer != null) {
                    layer = layer.getNonPseudoLayer();
                }
                boolean found = false;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    PortInst pi = con.getPortInst();
                    if (!top.portsConnected(ni, rPp, pi.getPortProto()) || con.getArc().getHeadPortInst().getNodeInst() != oNi && con.getArc().getTailPortInst().getNodeInst() != oNi) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean connected = false;
                ArcProto[] connections = rPp.getBasePort().getConnections();
                for (int pass = 0; pass < 2; ++pass) {
                    for (int i = 0; i < connections.length; ++i) {
                        ArcProto ap = connections[i];
                        if (pass != 0 ? ap == preferredArc : ap != preferredArc) continue;
                        if (ap.getTechnology() != ni.getProto().getTechnology()) break;
                        this.findSmallestLayer(ap, arcLayers);
                        if (!usePortPoly) {
                            Layer oLayer = arcLayers.get(ap);
                            if (!ap.getTechnology().sameLayer(oLayer, layer)) continue;
                        }
                        if (connected = this.testPoly(ni, rPp, ap, polyPtr, oNi, top, nodeBounds, nodePortBounds, arcLayers, stayInside, limitBound)) break;
                    }
                    if (connected) break;
                }
                if (!connected) {
                    continue;
                }
                break;
            }
        }
    }

    private void compareTwoArcs(ArcInst ai1, ArcInst ai2, PolyMerge stayInside, Topology top, Rectangle2D limitBound) {
        Network net2;
        if (ai1.getProto() != ai2.getProto()) {
            return;
        }
        Network net1 = top.getArcNetwork(ai1);
        if (net1 == (net2 = top.getArcNetwork(ai2))) {
            return;
        }
        Poly[] polys1 = ai1.getProto().getTechnology().getShapeOfArc(ai1);
        int tot1 = polys1.length;
        Poly[] polys2 = ai2.getProto().getTechnology().getShapeOfArc(ai2);
        int tot2 = polys2.length;
        for (int i1 = 0; i1 < tot1; ++i1) {
            Poly poly1 = polys1[i1];
            Layer layer1 = poly1.getLayer();
            Layer.Function fun = layer1.getFunction();
            if (!fun.isMetal() && !fun.isDiff() && !fun.isPoly()) continue;
            Rectangle2D bounds1 = poly1.getBounds2D();
            for (int i2 = 0; i2 < tot2; ++i2) {
                Rectangle2D bounds2;
                Poly poly2 = polys2[i2];
                if (layer1 != poly2.getLayer() || !bounds1.intersects(bounds2 = poly2.getBounds2D())) continue;
                Rectangle2D.Double intersection = new Rectangle2D.Double();
                Rectangle2D.intersect(bounds1, bounds2, intersection);
                double x = intersection.getCenterX();
                double y = intersection.getCenterY();
                this.connectObjects(ai1, net1, ai2, net2, ai1.getParent(), new Point2D.Double(x, y), stayInside, limitBound, top);
                return;
            }
        }
    }

    private void compareNodeWithArc(NodeInst ni, ArcInst ai, PolyMerge stayInside, Topology top, Rectangle2D limitBound) {
        if (ni.isCellInstance()) {
            return;
        }
        Network arcNet = top.getArcNetwork(ai);
        Poly[] nodePolys = this.shapeOfNode(ni);
        int nTot = nodePolys.length;
        AffineTransform trans = ni.rotateOut();
        for (Poly arcPoly : ai.getProto().getTechnology().getShapeOfArc(ai)) {
            Layer arcLayer = arcPoly.getLayer();
            Layer.Function arcLayerFun = arcLayer.getFunction();
            if (!arcLayerFun.isMetal() && !arcLayerFun.isDiff() && !arcLayerFun.isPoly()) continue;
            Rectangle2D arcBounds = arcPoly.getBounds2D();
            double aCX = arcBounds.getCenterX();
            double aCY = arcBounds.getCenterY();
            for (int j = 0; j < nTot; ++j) {
                double polyDist;
                Poly nodePoly = nodePolys[j];
                nodePoly.transform(trans);
                Layer nodeLayer = nodePoly.getLayer();
                if (nodeLayer != null) {
                    nodeLayer = nodeLayer.getNonPseudoLayer();
                }
                if (nodeLayer.getFunction() != arcLayerFun || (polyDist = arcPoly.separation(nodePoly)) >= DBMath.getEpsilon() || nodePoly.getPort() == null) continue;
                PortProto bestPp = null;
                double bestDist = 0.0;
                Iterator<PortProto> pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto tPp = pIt.next();
                    if (!top.portsConnected(ni, tPp, nodePoly.getPort())) continue;
                    Poly portPoly = ni.getShapeOfPort(tPp);
                    double portCX = portPoly.getCenterX();
                    double portCY = portPoly.getCenterY();
                    double dist = Math.abs(portCX - aCX) + Math.abs(portCY - aCY);
                    if (bestPp == null) {
                        bestDist = dist;
                    }
                    if (dist > bestDist) continue;
                    bestPp = tPp;
                    bestDist = dist;
                }
                if (bestPp == null) continue;
                PortInst pi = ni.findPortInstFromProto(bestPp);
                Poly portPoly = ni.getShapeOfPort(bestPp);
                double portCX = portPoly.getCenterX();
                double portCY = portPoly.getCenterY();
                Network nodeNet = top.getPortNetwork(pi);
                if (arcNet == nodeNet) continue;
                Point2D.Double bend1 = new Point2D.Double(portCX, aCY);
                Point2D.Double bend2 = new Point2D.Double(aCX, portCY);
                if (stayInside != null) {
                    if (!stayInside.contains(arcLayer, bend1)) {
                        bend1 = bend2;
                    }
                } else if (!arcPoly.contains(bend1)) {
                    bend1 = bend2;
                }
                this.connectObjects(ai, arcNet, pi, nodeNet, ai.getParent(), bend1, stayInside, limitBound, top);
                return;
            }
        }
    }

    private boolean connectObjects(ElectricObject eobj1, Network net1, ElectricObject eobj2, Network net2, Cell cell, Point2D ctr, PolyMerge stayInside, Rectangle2D limitBound, Topology top) {
        NodeInst ni1 = null;
        if (eobj1 instanceof NodeInst) {
            ni1 = (NodeInst)eobj1;
        } else if (eobj1 instanceof PortInst) {
            ni1 = ((PortInst)eobj1).getNodeInst();
        }
        NodeInst ni2 = null;
        if (eobj2 instanceof NodeInst) {
            ni2 = (NodeInst)eobj2;
        } else if (eobj2 instanceof PortInst) {
            ni2 = ((PortInst)eobj2).getNodeInst();
        }
        Route route = router.planRoute(cell, eobj1, eobj2, ctr, stayInside, true, true);
        if (route.size() == 0) {
            return false;
        }
        this.allRoutes.add(route);
        top.connect(net1, net2);
        if (ni1 != null && ni1.getFunction() == PrimitiveNode.Function.PIN && !ni1.hasExports() && !ni1.hasConnections()) {
            this.possibleInlinePins.add(ni1);
        }
        if (ni2 != null && ni2.getFunction() == PrimitiveNode.Function.PIN && !ni2.hasExports() && !ni2.hasConnections()) {
            this.possibleInlinePins.add(ni2);
        }
        return true;
    }

    private boolean testPoly(NodeInst ni, PortProto pp, ArcProto ap, Poly poly, NodeInst oNi, Topology top, HashMap<NodeInst, Rectangle2D[]> nodeBounds, HashMap<NodeInst, ObjectQTree> nodePortBounds, HashMap<ArcProto, Layer> arcLayers, PolyMerge stayInside, Rectangle2D limitBound) {
        block19: {
            Network net;
            block18: {
                Rectangle2D.Double biggerBounds;
                PortInst pi = ni.findPortInstFromProto(pp);
                net = top.getNodeNetwork(ni, pp);
                if (!oNi.isCellInstance()) break block18;
                Rectangle2D bounds = poly.getBounds2D();
                ObjectQTree oqt = nodePortBounds.get(oNi);
                Set set = oqt.find(biggerBounds = new Rectangle2D.Double(bounds.getMinX() - 1.0, bounds.getMinY() - 1.0, bounds.getWidth() + 2.0, bounds.getHeight() + 2.0));
                if (set == null) break block19;
                for (Object obj : set) {
                    PortInst oPi = (PortInst)obj;
                    PortProto mPp = oPi.getPortProto();
                    if (!mPp.getBasePort().connectsTo(ap)) continue;
                    Network oNet = top.getPortNetwork(oNi.findPortInstFromProto(mPp));
                    if (net != null && oNet == net) continue;
                    boolean ignore = false;
                    Iterator<Connection> piit = oPi.getConnections();
                    while (piit.hasNext()) {
                        Connection conn = piit.next();
                        ArcInst ai = conn.getArc();
                        if (ai.getHeadPortInst() == pi) {
                            ignore = true;
                        }
                        if (ai.getTailPortInst() != pi) continue;
                        ignore = true;
                    }
                    if (ignore) continue;
                    AffineTransform trans = oNi.rotateOut();
                    NodeInst rNi = oNi;
                    PortProto rPp = mPp;
                    while (rNi.isCellInstance()) {
                        AffineTransform temp = rNi.translateOut();
                        temp.preConcatenate(trans);
                        Export e = (Export)rPp;
                        rNi = e.getOriginalPort().getNodeInst();
                        rPp = e.getOriginalPort().getPortProto();
                        trans = rNi.rotateOut();
                        trans.preConcatenate(temp);
                    }
                    Poly[] polys = this.shapeOfNode(rNi);
                    int tot = polys.length;
                    if (tot == 0) {
                        Poly oPoly = oNi.getShapeOfPort(mPp);
                        if (!this.comparePoly(oNi, mPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, top, limitBound)) continue;
                        return true;
                    }
                    Netlist subNetlist = rNi.getParent().getUserNetlist();
                    for (int j = 0; j < tot; ++j) {
                        Poly oPoly = polys[j];
                        if (oPoly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, oPoly.getPort())) continue;
                        if (ni.getProto() != Generic.tech.simProbeNode) {
                            Layer oLayer = oPoly.getLayer();
                            if (oLayer != null) {
                                oLayer = oLayer.getNonPseudoLayer();
                            }
                            Layer apLayer = arcLayers.get(ap);
                            if (!oLayer.getTechnology().sameLayer(oLayer, apLayer)) continue;
                        }
                        oPoly.transform(trans);
                        if (!this.comparePoly(oNi, mPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, top, limitBound)) continue;
                        return true;
                    }
                }
                break block19;
            }
            AffineTransform trans = oNi.rotateOut();
            double ox = poly.getCenterX();
            double oy = poly.getCenterY();
            Poly[] polys = this.shapeOfNode(oNi);
            int tot = polys.length;
            if (tot == 0) {
                PortProto bestPp = null;
                double bestDist = 0.0;
                Iterator<PortProto> pIt = oNi.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto rPp = pIt.next();
                    Poly portPoly = oNi.getShapeOfPort(rPp);
                    double dist = Math.abs(portPoly.getCenterX() - ox) + Math.abs(portPoly.getCenterY() - oy);
                    if (bestPp == null) {
                        bestDist = dist;
                        bestPp = rPp;
                    }
                    if (dist > bestDist) continue;
                    bestPp = rPp;
                    bestDist = dist;
                }
                if (bestPp != null) {
                    Poly oPoly;
                    PortProto rPp = bestPp;
                    Network oNet = top.getPortNetwork(oNi.findPortInstFromProto(bestPp));
                    if ((net == null || oNet != net) && rPp.getBasePort().connectsTo(ap) && this.comparePoly(oNi, rPp, oPoly = oNi.getShapeOfPort(rPp), oNet, ni, pp, poly, net, ap, stayInside, top, limitBound)) {
                        return true;
                    }
                }
            } else {
                for (int j = 0; j < tot; ++j) {
                    PortProto rPp;
                    Layer apLayer;
                    Poly oPoly = polys[j];
                    if (oPoly.getPort() == null) continue;
                    Layer oLayer = oPoly.getLayer();
                    if (oLayer != null) {
                        oLayer = oLayer.getNonPseudoLayer();
                    }
                    if (!(apLayer = arcLayers.get(ap)).getTechnology().sameLayer(apLayer, oLayer)) continue;
                    PortInst oPi = oNi.findPortInstFromProto(oPoly.getPort());
                    Network oNet = top.getPortNetwork(oPi);
                    if (net != null && oNet == net) continue;
                    PortProto bestPp = null;
                    double bestDist = 0.0;
                    Iterator<PortProto> pIt = oNi.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto rPp2 = pIt.next();
                        if (!top.portsConnected(oNi, rPp2, oPoly.getPort())) continue;
                        Poly portPoly = oNi.getShapeOfPort(rPp2);
                        double dist = Math.abs(ox - portPoly.getCenterX()) + Math.abs(oy - portPoly.getCenterY());
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = rPp2;
                        bestDist = dist;
                    }
                    if (bestPp == null || !(rPp = bestPp).getBasePort().connectsTo(ap)) continue;
                    oPoly.transform(trans);
                    if (!this.comparePoly(oNi, rPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, top, limitBound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean comparePoly(NodeInst oNi, PortProto opp, Poly oPoly, Network oNet, NodeInst ni, PortProto pp, Poly poly, Network net, ArcProto ap, PolyMerge stayInside, Topology top, Rectangle2D limitBound) {
        Point2D.Double tPortCenter;
        double tDist;
        PortProto tPp;
        if (poly.separation(oPoly) >= DBMath.getEpsilon()) {
            return false;
        }
        Poly portPoly = ni.getShapeOfPort(pp);
        Point2D.Double portCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
        Poly oPortPoly = oNi.getShapeOfPort(opp);
        Point2D.Double oPortCenter = new Point2D.Double(oPortPoly.getCenterX(), oPortPoly.getCenterY());
        if (ni.isCellInstance() || oNi.isCellInstance()) {
            Rectangle2D polyBounds = portPoly.getBounds2D();
            Rectangle2D oPolyBounds = oPortPoly.getBounds2D();
            if ((polyBounds.getMinX() > oPolyBounds.getMaxX() || oPolyBounds.getMinX() > polyBounds.getMaxX()) && (polyBounds.getMinY() > oPolyBounds.getMaxY() || oPolyBounds.getMinY() > polyBounds.getMaxY())) {
                return false;
            }
        }
        double dist = portCenter.distance(oPortCenter);
        Iterator<PortProto> it = oNi.getProto().getPorts();
        while (it.hasNext()) {
            tPp = it.next();
            if (tPp == opp || !top.portsConnected(oNi, tPp, opp) || (tDist = portCenter.distance(tPortCenter = new Point2D.Double((portPoly = oNi.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            opp = tPp;
            oPortCenter.setLocation(tPortCenter);
        }
        it = ni.getProto().getPorts();
        while (it.hasNext()) {
            tPp = it.next();
            if (tPp == pp || !top.portsConnected(ni, tPp, pp) || (tDist = oPortCenter.distance(tPortCenter = new Point2D.Double((portPoly = ni.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            pp = tPp;
            portCenter.setLocation(tPortCenter);
        }
        if (limitBound != null && !GenMath.pointInRect(portCenter, limitBound) && !GenMath.pointInRect(oPortCenter, limitBound)) {
            return false;
        }
        double x = (((Point2D)oPortCenter).getX() + ((Point2D)portCenter).getX()) / 2.0;
        double y = (((Point2D)oPortCenter).getY() + ((Point2D)portCenter).getY()) / 2.0;
        PortInst pi = ni.findPortInstFromProto(pp);
        PortInst opi = oNi.findPortInstFromProto(opp);
        return this.connectObjects(pi, net, opi, oNet, ni.getParent(), new Point2D.Double(x, y), stayInside, limitBound, top);
    }

    private Poly[] shapeOfNode(NodeInst ni) {
        Technology tech = ni.getProto().getTechnology();
        Poly[] nodePolys = tech.getShapeOfNode(ni, true, true, null);
        if (nodePolys.length == 0) {
            return nodePolys;
        }
        if (ni.getFunction() == PrimitiveNode.Function.PIN) {
            boolean gotOne = false;
            Rectangle2D coverage = null;
            Rectangle2D polyBounds = nodePolys[0].getBounds2D();
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                ArcInst ai = con.getArc();
                if (ai.getLambdaBaseWidth() >= ni.getLambdaBaseXSize() && ai.getLambdaBaseWidth() >= ni.getLambdaBaseYSize() && ai.isHeadExtended() && ai.isTailExtended()) {
                    gotOne = true;
                    break;
                }
                Poly[] arcPolys = ai.getProto().getTechnology().getShapeOfArc(ai);
                if (arcPolys.length == 0) continue;
                Rectangle2D arcBounds = arcPolys[0].getBounds2D();
                arcBounds.intersects(polyBounds);
                if (coverage == null) {
                    coverage = arcBounds;
                    continue;
                }
                if (coverage.getMinX() == arcBounds.getMinX() && coverage.getMaxX() == arcBounds.getMaxX() && coverage.getMinY() >= arcBounds.getMaxY() && coverage.getMaxY() <= arcBounds.getMinY()) {
                    double lX = Math.min(coverage.getMinX(), arcBounds.getMinX());
                    double hX = Math.max(coverage.getMaxX(), arcBounds.getMaxX());
                    coverage.setRect(lX, coverage.getMinY(), hX - lX, coverage.getHeight());
                    continue;
                }
                if (coverage.getMinY() == arcBounds.getMinY() && coverage.getMaxY() == arcBounds.getMaxY()) {
                    if (!(coverage.getMinX() >= arcBounds.getMaxX()) || !(coverage.getMaxX() <= arcBounds.getMinX())) continue;
                    double lY = Math.min(coverage.getMinY(), arcBounds.getMinY());
                    double hY = Math.max(coverage.getMaxY(), arcBounds.getMaxY());
                    coverage.setRect(coverage.getMinX(), lY, coverage.getWidth(), hY - lY);
                    continue;
                }
                coverage.intersects(arcBounds);
            }
            if (!gotOne && !ni.hasExports()) {
                if (coverage == null) {
                    return new Poly[0];
                }
                Poly newPoly = new Poly(coverage);
                newPoly.setStyle(nodePolys[0].getStyle());
                newPoly.setLayer(nodePolys[0].getLayerOrPseudoLayer());
                newPoly.setPort(nodePolys[0].getPort());
                nodePolys[0] = newPoly;
            }
        }
        return nodePolys;
    }

    private void findSmallestLayer(ArcProto ap, HashMap<ArcProto, Layer> arcLayers) {
        if (arcLayers.get(ap) != null) {
            return;
        }
        boolean bestFound = false;
        double bestArea = 0.0;
        for (Poly poly : ap.getShapeOfDummyArc(100.0)) {
            double area = poly.getArea();
            if (bestFound && area >= bestArea) continue;
            bestArea = area;
            bestFound = true;
            arcLayers.put(ap, poly.getLayer());
        }
    }

    private static class Topology {
        private Netlist netlist;
        private Map<Network, Network> connected;

        Topology(Cell cell) {
            this.netlist = cell.acquireUserNetlist();
            if (this.netlist == null) {
                System.out.println("Sorry, a deadlock aborted auto-routing (network information unavailable).  Please try again");
            }
            this.connected = new HashMap<Network, Network>();
        }

        Network getNodeNetwork(NodeInst ni, PortProto pp) {
            Network net = this.netlist.getNetwork(ni, pp, 0);
            return this.getRealNet(net);
        }

        Network getPortNetwork(PortInst pi) {
            Network net = this.netlist.getNetwork(pi);
            return this.getRealNet(net);
        }

        Network getArcNetwork(ArcInst ai) {
            Network net = this.netlist.getNetwork(ai, 0);
            return this.getRealNet(net);
        }

        boolean portsConnected(NodeInst ni, PortProto pp1, PortProto pp2) {
            return this.netlist.portsConnected(ni, pp1, pp2);
        }

        private Network getRealNet(Network net) {
            Network nextNet;
            while ((nextNet = this.connected.get(net)) != null) {
                net = nextNet;
            }
            return net;
        }

        void connect(Network net1, Network net2) {
            Network conNet1 = this.connected.get(net1);
            Network conNet2 = this.connected.get(net2);
            if (conNet1 == null && conNet2 == null) {
                this.connected.put(net1, net2);
                return;
            }
            if (conNet1 == null) {
                this.connected.put(net1, conNet2);
                return;
            }
            if (conNet2 == null) {
                this.connected.put(net2, conNet1);
                return;
            }
            this.connected.put(net2, conNet1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class compRoutes
    implements Comparator<Route> {
        private compRoutes() {
        }

        @Override
        public int compare(Route r1, Route r2) {
            int res;
            NodeInst n2e;
            NodeInst n2s;
            NodeInst n1e;
            boolean r2ToArc;
            RouteElementPort r1s = r1.getStart();
            RouteElementPort r1e = r1.getEnd();
            RouteElementPort r2s = r2.getStart();
            RouteElementPort r2e = r2.getEnd();
            boolean r1ToArc = r1s.getPortInst() == null || r1e.getPortInst() == null;
            boolean bl = r2ToArc = r2s.getPortInst() == null || r2e.getPortInst() == null;
            if (r1ToArc && !r2ToArc) {
                return 1;
            }
            if (!r1ToArc && r2ToArc) {
                return -1;
            }
            if (r1ToArc && r2ToArc) {
                ArcProto ap1 = null;
                ArcProto ap2 = null;
                if (r1s.getNewArcs().hasNext()) {
                    ap1 = ((RouteElementArc)r1s.getNewArcs().next()).getArcProto();
                }
                if (r1e.getNewArcs().hasNext()) {
                    ap1 = ((RouteElementArc)r1e.getNewArcs().next()).getArcProto();
                }
                if (r2s.getNewArcs().hasNext()) {
                    ap2 = ((RouteElementArc)r2s.getNewArcs().next()).getArcProto();
                }
                if (r2e.getNewArcs().hasNext()) {
                    ap2 = ((RouteElementArc)r2e.getNewArcs().next()).getArcProto();
                }
                if (ap1 == null || ap2 == null) {
                    return 0;
                }
                return ap1.compareTo(ap2);
            }
            NodeInst n1s = r1s.getPortInst().getNodeInst();
            if (n1s.compareTo(n1e = r1e.getPortInst().getNodeInst()) < 0) {
                NodeInst s = n1s;
                n1s = n1e;
                n1e = s;
                RouteElementPort se = r1s;
                r1s = r1e;
                r1e = se;
            }
            if ((n2s = r2s.getPortInst().getNodeInst()).compareTo(n2e = r2e.getPortInst().getNodeInst()) < 0) {
                NodeInst s = n2s;
                n2s = n2e;
                n2e = s;
                RouteElementPort se = r2s;
                r2s = r2e;
                r2e = se;
            }
            if ((res = n1s.compareTo(n2s)) != 0) {
                return res;
            }
            res = n1e.compareTo(n2e);
            if (res != 0) {
                return res;
            }
            res = r1s.getPortInst().getPortProto().getName().compareTo(r2s.getPortInst().getPortProto().getName());
            if (res != 0) {
                return res;
            }
            res = r1e.getPortInst().getPortProto().getName().compareTo(r2e.getPortInst().getPortProto().getName());
            if (res != 0) {
                return res;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AutoStitchJob
    extends Job {
        private Cell cell;
        private List<NodeInst> nodesToStitch;
        private List<ArcInst> arcsToStitch;
        private double lX;
        private double hX;
        private double lY;
        private double hY;
        private boolean forced;

        private AutoStitchJob(Cell cell, List<NodeInst> nodesToStitch, List<ArcInst> arcsToStitch, double lX, double hX, double lY, double hY, boolean forced) {
            super("Auto-Stitch", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.nodesToStitch = nodesToStitch;
            this.arcsToStitch = arcsToStitch;
            this.lX = lX;
            this.hX = hX;
            this.lY = lY;
            this.hY = hY;
            this.forced = forced;
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Rectangle2D.Double limitBound = null;
            if (this.lX != this.hX && this.lY != this.hY) {
                limitBound = new Rectangle2D.Double(this.lX, this.lY, this.hX - this.lX, this.hY - this.lY);
            }
            AutoStitch.runAutoStitch(this.cell, this.nodesToStitch, this.arcsToStitch, null, limitBound, this.forced, false);
            return true;
        }
    }
}

