/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.constraint;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableLibrary;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.LibId;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.constraint.LayoutCell;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.drc.DRC;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout
extends Constraints {
    static final boolean DEBUG = false;
    static boolean doChangesQuietly;
    static Snapshot oldSnapshot;
    static long revisionDate;
    static String userName;
    static Set<Cell> goodDRCCells;
    static Variable goodDRCDate;
    static Variable goodDRCBit;
    private static final ArrayList<LayoutCell> cellInfos;
    private static final HashMap<ArcInst, Boolean> tempRigid;
    static final HashSet<LibId> librariesWritten;

    Layout() {
    }

    public static void changesQuiet(boolean quiet) {
        doChangesQuietly = true;
    }

    @Override
    public void startBatch(Snapshot initialSnapshot) {
        doChangesQuietly = false;
        oldSnapshot = initialSnapshot;
        tempRigid.clear();
        librariesWritten.clear();
        goodDRCCells = null;
        Layout.makeLayoutCells();
    }

    @Override
    public void endBatch(String userName) {
        Layout.userName = userName;
        revisionDate = System.currentTimeMillis();
        if (goodDRCCells != null) {
            TextDescriptor td = TextDescriptor.getCellTextDescriptor().withDisplay(false);
            goodDRCDate = Variable.newInstance(DRC.DRC_LAST_GOOD_DATE, new Long(revisionDate + 1L), td);
        }
        if (!doChangesQuietly) {
            Library lib;
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                lib = it.next();
                Iterator<Cell> cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell cell = cIt.next();
                    if (!cell.isLinked()) continue;
                    LayoutCell cellInfo = Layout.getCellInfo(cell);
                    cellInfo.compute();
                }
            }
            it = Library.getLibraries();
            while (it.hasNext()) {
                lib = it.next();
                if (librariesWritten.contains(lib.getId())) {
                    lib.clearChanged();
                    continue;
                }
                LibraryBackup libBackup = oldSnapshot.getLib(lib.getId());
                if (lib.backup() == libBackup) continue;
                lib.setChanged();
            }
            for (CellBackup cellBackup : Layout.oldSnapshot.cellBackups) {
                Library lib2;
                if (cellBackup == null) continue;
                CellId cellId = cellBackup.cellRevision.d.cellId;
                if (EDatabase.serverDatabase().getCell(cellId) != null || (lib2 = EDatabase.serverDatabase().getLib(cellId.libId)) == null) continue;
                lib2.setChanged();
            }
        }
        cellInfos.clear();
        tempRigid.clear();
        librariesWritten.clear();
        EDatabase.serverDatabase().backup();
        goodDRCCells = null;
        oldSnapshot = null;
    }

    @Override
    public void modifyNodeInst(NodeInst ni, ImmutableNodeInst oD) {
        if (doChangesQuietly) {
            return;
        }
        Layout.getCellInfo(ni.getParent()).modifyNodeInst(ni, oD);
    }

    @Override
    public void modifyArcInst(ArcInst ai, ImmutableArcInst oD) {
        if (doChangesQuietly) {
            return;
        }
        Layout.getCellInfo(ai.getParent()).modifyArcInst(ai, oD);
    }

    @Override
    public void modifyExport(Export pp, ImmutableExport oldD) {
        if (doChangesQuietly) {
            return;
        }
        PortInst oldPi = pp.getParent().getPortInst(oldD.originalNodeId, oldD.originalPortId);
        if (oldPi == pp.getOriginalPort()) {
            return;
        }
        Layout.getCellInfo(pp.getParent()).modifyExport(pp, oldPi);
    }

    @Override
    public void modifyCell(Cell cell, ImmutableCell oD) {
    }

    @Override
    public void modifyLibrary(Library lib, ImmutableLibrary oldD) {
    }

    @Override
    public void newObject(ElectricObject obj) {
        if (doChangesQuietly) {
            return;
        }
        Cell cell = obj.whichCell();
        if (obj == cell) {
            Layout.newCellInfo(cell, null);
        } else if (cell != null) {
            Layout.getCellInfo(cell).newObject(obj);
        }
    }

    @Override
    public void writeLibrary(Library lib) {
        librariesWritten.add(lib.getId());
    }

    @Override
    public void renameIds(IdMapper idMapper) {
        EDatabase database = EDatabase.serverDatabase();
        for (CellId cellId : idMapper.getNewCellIds()) {
            this.newObject(cellId.inDatabase(database));
        }
    }

    public static void setTempRigid(ArcInst ai, boolean tempRigid) {
        ai.checkChanging();
        Layout.tempRigid.put(ai, tempRigid);
    }

    public static void removeTempRigid(ArcInst ai) {
        ai.checkChanging();
        tempRigid.remove(ai);
    }

    public static void setGoodDRCCells(Set<Cell> goodDRCCells, int activeBits, boolean inMemory) {
        assert (!inMemory);
        Layout.goodDRCCells = goodDRCCells;
        TextDescriptor td = TextDescriptor.getCellTextDescriptor().withDisplay(false);
        goodDRCBit = Variable.newInstance(DRC.DRC_LAST_GOOD_BIT, new Integer(activeBits), td);
    }

    static boolean isRigid(ArcInst ai) {
        Boolean override = tempRigid.get(ai);
        return override != null ? override.booleanValue() : ai.isRigid();
    }

    private static void makeLayoutCells() {
        cellInfos.clear();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                Layout.newCellInfo(cell, oldSnapshot.getCell(cell.getId()));
            }
        }
    }

    static Poly oldPortPosition(PortInst pi) {
        NodeInst ni = pi.getNodeInst();
        PortProto pp = pi.getPortProto();
        AffineTransform subrot = Layout.makeOldRot(ni);
        if (subrot == null) {
            return null;
        }
        NodeInst bottomNi = ni;
        PortProto bottomPP = pp;
        while (bottomNi.isCellInstance()) {
            AffineTransform localtran = Layout.makeOldTrans(bottomNi);
            subrot.concatenate(localtran);
            PortInst bottomPi = Layout.getOldOriginalPort((Export)bottomPP);
            bottomNi = bottomPi.getNodeInst();
            bottomPP = bottomPi.getPortProto();
            localtran = Layout.makeOldRot(bottomNi);
            subrot.concatenate(localtran);
        }
        ImmutableNodeInst d = Layout.getOldD(bottomNi);
        assert (d != null);
        if (d != bottomNi.getD()) {
            bottomNi = NodeInst.makeDummyInstance(bottomNi.getProto());
            bottomNi.lowLevelModify(d);
        }
        PrimitiveNode np = (PrimitiveNode)bottomNi.getProto();
        Technology tech = np.getTechnology();
        Poly poly = tech.getShapeOfPort(bottomNi, (PrimitivePort)bottomPP);
        poly.transform(subrot);
        return poly;
    }

    private static AffineTransform makeOldRot(NodeInst ni) {
        ImmutableNodeInst d = Layout.getOldD(ni);
        if (d == null) {
            return null;
        }
        double cX = d.anchor.getX();
        double cY = d.anchor.getY();
        return d.orient.rotateAbout(cX, cY);
    }

    private static AffineTransform makeOldTrans(NodeInst ni) {
        ImmutableNodeInst d = Layout.getOldD(ni);
        if (d == null) {
            return null;
        }
        AffineTransform transform = new AffineTransform();
        double cX = d.anchor.getX();
        double cY = d.anchor.getY();
        transform.translate(cX, cY);
        return transform;
    }

    static PortInst getOldOriginalPort(Export e) {
        return Layout.getCellInfo(e.getParent()).getOldOriginalPort(e);
    }

    static ImmutableNodeInst getOldD(NodeInst ni) {
        return Layout.getCellInfo(ni.getParent()).getOldD(ni);
    }

    private static void newCellInfo(Cell cell, CellBackup oldBackup) {
        int cellIndex = cell.getCellIndex();
        while (cellInfos.size() <= cellIndex) {
            cellInfos.add(null);
        }
        assert (cellInfos.get(cellIndex) == null);
        cellInfos.set(cellIndex, new LayoutCell(cell, oldBackup));
    }

    static LayoutCell getCellInfo(Cell cell) {
        return cellInfos.get(cell.getCellIndex());
    }

    static {
        cellInfos = new ArrayList();
        tempRigid = new HashMap();
        librariesWritten = new HashSet();
    }
}

