/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.Analysis;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signal {
    private String signalName;
    private String signalContext;
    protected Analysis an;
    private List<Signal> bussedSignals;
    private int busCount;
    protected Rectangle2D bounds;

    protected Signal(Analysis an) {
        this.an = an;
        this.bounds = null;
        this.busCount = 0;
        if (an != null) {
            an.addSignal(this);
        }
    }

    public void finished() {
        System.out.println("Signal finish");
        for (Signal s : this.bussedSignals) {
            s.finished();
        }
        this.bussedSignals.clear();
    }

    public Analysis getAnalysis() {
        return this.an;
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
        this.an.nameSignal(this, this.getFullName());
    }

    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalContext(String signalContext) {
        this.signalContext = signalContext;
    }

    public String getSignalContext() {
        return this.signalContext;
    }

    public String getFullName() {
        if (this.signalContext != null) {
            return this.signalContext + this.an.getStimuli().getSeparatorChar() + this.signalName;
        }
        return this.signalName;
    }

    public void buildBussedSignalList() {
        this.bussedSignals = new ArrayList<Signal>();
        this.an.getBussedSignals().add(this);
    }

    public List<Signal> getBussedSignals() {
        return this.bussedSignals;
    }

    public void clearBussedSignalList() {
        for (Signal sig : this.bussedSignals) {
            --sig.busCount;
        }
        this.bussedSignals.clear();
    }

    public void addToBussedSignalList(Signal ws) {
        this.bussedSignals.add(ws);
        ++ws.busCount;
    }

    public boolean isInBus() {
        return this.busCount != 0;
    }

    public Double[] getControlPoints() {
        return this.an.getStimuli().getControlPoints(this);
    }

    public void clearControlPoints() {
        this.an.getStimuli().clearControlPoints(this);
    }

    public void addControlPoint(double time) {
        this.an.getStimuli().addControlPoint(this, time);
    }

    public void removeControlPoint(double time) {
        this.an.getStimuli().removeControlPoint(this, time);
    }

    public int getNumEvents() {
        return 0;
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        return this.bounds;
    }

    protected void calcBounds() {
    }
}

