/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.HashMap;
import java.util.Iterator;

public class Tech {
    private static Type techType;
    private static final String[] MOCMOS_LAYER_NAMES;
    private static final String[] TSMC90_LAYER_NAMES;
    private static String[] layerNms;
    private static int nbLay;
    private static ArcProto[] layers;
    private static PrimitiveNode[] vias;
    private static HashMap<Integer, PrimitiveNode> viaMap;
    private static Technology tech;
    private static double gateLength;
    private static double offsetLShapePolyContact;
    private static double offsetTShapePolyContact;
    private static double selectSpace;
    private static double selectSurroundDiffInTrans;
    private static double selectSurroundDiffAlongGateInTrans;
    private static double selectSurround;
    private static double wellWidth;
    private static double wellSurroundDiff;
    private static double gateExtendPastMOS;
    private static double p1Width;
    private static double p1ToP1Space;
    private static double p1M1Width;
    private static double gateToGateSpace;
    private static double gateToDiffContSpace;
    private static double diffContWidth;
    private static double selectSurroundDiffInActiveContact;
    public static final Variable.Key ATTR_X;
    public static final Variable.Key ATTR_S;
    public static final Variable.Key ATTR_SN;
    public static final Variable.Key ATTR_SP;
    public static ArcProto pdiff;
    public static ArcProto ndiff;
    public static ArcProto p1;
    public static ArcProto m1;
    public static ArcProto m2;
    public static ArcProto m3;
    public static ArcProto m4;
    public static ArcProto m5;
    public static ArcProto m6;
    public static ArcProto m7;
    public static ArcProto m8;
    public static ArcProto m9;
    public static ArcProto ndiff18;
    public static ArcProto pdiff18;
    public static ArcProto ndiff25;
    public static ArcProto pdiff25;
    public static ArcProto ndiff33;
    public static ArcProto pdiff33;
    public static PrimitiveNode ndpin;
    public static PrimitiveNode pdpin;
    public static PrimitiveNode p1pin;
    public static PrimitiveNode m1pin;
    public static PrimitiveNode m2pin;
    public static PrimitiveNode m3pin;
    public static PrimitiveNode m4pin;
    public static PrimitiveNode m5pin;
    public static PrimitiveNode m6pin;
    public static PrimitiveNode m7pin;
    public static PrimitiveNode m8pin;
    public static PrimitiveNode m9pin;
    public static PrimitiveNode nwm1;
    public static PrimitiveNode pwm1;
    public static PrimitiveNode nwm1Y;
    public static PrimitiveNode pwm1Y;
    public static PrimitiveNode ndm1;
    public static PrimitiveNode pdm1;
    public static PrimitiveNode p1m1;
    public static PrimitiveNode m1m2;
    public static PrimitiveNode m2m3;
    public static PrimitiveNode m3m4;
    public static PrimitiveNode m4m5;
    public static PrimitiveNode m5m6;
    public static PrimitiveNode m6m7;
    public static PrimitiveNode m7m8;
    public static PrimitiveNode m8m9;
    public static PrimitiveNode nmos;
    public static PrimitiveNode pmos;
    public static PrimitiveNode nmos18;
    public static PrimitiveNode pmos18;
    public static PrimitiveNode nmos25;
    public static PrimitiveNode pmos25;
    public static PrimitiveNode nmos33;
    public static PrimitiveNode pmos33;
    public static PrimitiveNode nvth;
    public static PrimitiveNode pvth;
    public static PrimitiveNode nvtl;
    public static PrimitiveNode pvtl;
    public static PrimitiveNode nnat;
    public static PrimitiveNode pnat;
    public static PrimitiveNode nmos18contact;
    public static PrimitiveNode pmos18contact;
    public static PrimitiveNode nmos25contact;
    public static PrimitiveNode pmos25contact;
    public static PrimitiveNode nmos33contact;
    public static PrimitiveNode pmos33contact;
    public static PrimitiveNode nwell;
    public static PrimitiveNode pwell;
    public static PrimitiveNode m1Node;
    public static PrimitiveNode m2Node;
    public static PrimitiveNode m3Node;
    public static PrimitiveNode m4Node;
    public static PrimitiveNode m5Node;
    public static PrimitiveNode m6Node;
    public static PrimitiveNode m7Node;
    public static PrimitiveNode m8Node;
    public static PrimitiveNode m9Node;
    public static PrimitiveNode p1Node;
    public static PrimitiveNode pdNode;
    public static PrimitiveNode ndNode;
    public static PrimitiveNode pselNode;
    public static PrimitiveNode nselNode;
    public static PrimitiveNode pwellNode;
    public static PrimitiveNode nwellNode;
    public static PrimitiveNode od18;
    public static PrimitiveNode od25;
    public static PrimitiveNode od33;
    public static PrimitiveNode vth;
    public static PrimitiveNode vtl;
    public static PrimitiveNode essentialBounds;
    public static PrimitiveNode facetCenter;
    public static ArcProto universalArc;

    public static double roundToGrid(double x) {
        return Tech.isTSMC90() ? x : Math.rint(x * 2.0) / 2.0;
    }

    public static MosInst newNmosInst(double x, double y, double w, double l, Cell parent) {
        return new MosInst(true, x, y, w, l, parent);
    }

    public static MosInst newPmosInst(double x, double y, double w, double l, Cell parent) {
        return new MosInst(false, x, y, w, l, parent);
    }

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Type getTechnology() {
        return techType;
    }

    public static void setTechnology(Type techNm) {
        int i;
        techType = techNm;
        boolean isTsmc90 = techType == Type.TSMC90;
        boolean isTsmc180 = techType == Type.TSMC180;
        tech = !isTsmc90 ? Technology.findTechnology(Type.MOCMOS.name()) : Technology.findTechnology(techNm.name());
        layerNms = isTsmc90 ? TSMC90_LAYER_NAMES : MOCMOS_LAYER_NAMES;
        nbLay = layerNms.length;
        layers = new ArcProto[nbLay];
        vias = new PrimitiveNode[nbLay - 1];
        for (i = 0; i < nbLay; ++i) {
            Tech.layers[i] = tech.findArcProto(layerNms[i]);
            Tech.error(layers[i] == null, "No such layer: " + layerNms[i]);
        }
        p1 = layers[0];
        m1 = layers[1];
        m2 = layers[2];
        m3 = layers[3];
        m4 = layers[4];
        m5 = layers[5];
        m6 = layers[6];
        if (techType == Type.TSMC90) {
            m7 = layers[7];
            m8 = layers[8];
            m9 = layers[9];
        }
        pdiff = tech.findArcProto("P-Active");
        ndiff = tech.findArcProto("N-Active");
        ndiff18 = tech.findArcProto("thick-OD18-N-Active");
        pdiff18 = tech.findArcProto("thick-OD18-P-Active");
        ndiff25 = tech.findArcProto("thick-OD25-N-Active");
        pdiff25 = tech.findArcProto("thick-OD25-P-Active");
        ndiff33 = tech.findArcProto("thick-OD33-N-Active");
        pdiff33 = tech.findArcProto("thick-OD33-P-Active");
        pdpin = pdiff.findOverridablePinProto();
        ndpin = ndiff.findOverridablePinProto();
        p1pin = p1.findOverridablePinProto();
        m1pin = m1.findOverridablePinProto();
        m2pin = m2.findOverridablePinProto();
        m3pin = m3.findOverridablePinProto();
        m4pin = m4.findOverridablePinProto();
        m5pin = m5.findOverridablePinProto();
        m6pin = m6.findOverridablePinProto();
        if (isTsmc90) {
            m7pin = m7.findOverridablePinProto();
            m8pin = m8.findOverridablePinProto();
            m9pin = m9.findOverridablePinProto();
        }
        for (i = 0; i < nbLay - 1; ++i) {
            Tech.vias[i] = Tech.findNode(PrimitiveNode.Function.CONTACT, new ArcProto[]{layers[i], layers[i + 1]}, tech);
            Tech.error(vias[i] == null, "No via for layer: " + layerNms[i]);
        }
        p1m1 = vias[0];
        m1m2 = vias[1];
        m2m3 = vias[2];
        m3m4 = vias[3];
        m4m5 = vias[4];
        m5m6 = vias[5];
        if (isTsmc90) {
            m6m7 = vias[6];
            m7m8 = vias[7];
            m8m9 = vias[8];
        }
        ndm1 = tech.findNodeProto("Metal-1-N-Active-Con");
        pdm1 = tech.findNodeProto("Metal-1-P-Active-Con");
        nwm1 = tech.findNodeProto("Metal-1-N-Well-Con");
        pwm1 = tech.findNodeProto("Metal-1-P-Well-Con");
        nwm1Y = tech.findNodeProto("Y-Metal-1-N-Well-Con");
        pwm1Y = tech.findNodeProto("Y-Metal-1-P-Well-Con");
        nmos = tech.findNodeProto("N-Transistor");
        pmos = tech.findNodeProto("P-Transistor");
        nmos18 = tech.findNodeProto("OD18-N-Transistor");
        pmos18 = tech.findNodeProto("OD18-P-Transistor");
        nmos25 = tech.findNodeProto("OD25-N-Transistor");
        pmos25 = tech.findNodeProto("OD25-P-Transistor");
        nmos33 = tech.findNodeProto("OD33-N-Transistor");
        pmos33 = tech.findNodeProto("OD33-P-Transistor");
        nvth = null;
        pvth = null;
        nvtl = null;
        pvtl = null;
        nnat = null;
        pnat = null;
        nmos18contact = tech.findNodeProto("thick-OD18-Metal-1-N-Active-Con");
        pmos18contact = tech.findNodeProto("thick-OD18-Metal-1-P-Active-Con");
        nmos25contact = tech.findNodeProto("thick-OD25-Metal-1-N-Active-Con");
        pmos25contact = tech.findNodeProto("thick-OD25-Metal-1-P-Active-Con");
        nmos33contact = tech.findNodeProto("thick-OD33-Metal-1-N-Active-Con");
        pmos33contact = tech.findNodeProto("thick-OD33-Metal-1-P-Active-Con");
        od18 = tech.findNodeProto("OD18-Node");
        od25 = tech.findNodeProto("OD25-Node");
        od33 = tech.findNodeProto("OD33-Node");
        vth = tech.findNodeProto("VTH-Node");
        vtl = tech.findNodeProto("VTL-Node");
        nwell = tech.findNodeProto("N-Well-Node");
        pwell = tech.findNodeProto("P-Well-Node");
        nwellNode = tech.findNodeProto("Metal-1-N-Well-Con");
        pwellNode = tech.findNodeProto("Metal-1-P-Well-Con");
        if (isTsmc90) {
            nwellNode = tech.findNodeProto("Y-Metal-1-N-Well-Con");
            pwellNode = tech.findNodeProto("Y-Metal-1-P-Well-Con");
        }
        m1Node = tech.findNodeProto("Metal-1-Node");
        m2Node = tech.findNodeProto("Metal-2-Node");
        m3Node = tech.findNodeProto("Metal-3-Node");
        m4Node = tech.findNodeProto("Metal-4-Node");
        m5Node = tech.findNodeProto("Metal-5-Node");
        m6Node = tech.findNodeProto("Metal-6-Node");
        m7Node = tech.findNodeProto("Metal-7-Node");
        m8Node = tech.findNodeProto("Metal-8-Node");
        m9Node = tech.findNodeProto("Metal-9-Node");
        p1Node = tech.findNodeProto("Polysilicon-1-Node");
        pdNode = tech.findNodeProto("P-Active-Node");
        ndNode = tech.findNodeProto("N-Active-Node");
        nselNode = tech.findNodeProto("N-Select-Node");
        pselNode = tech.findNodeProto("P-Select-Node");
        Technology generic = Technology.findTechnology("generic");
        essentialBounds = generic.findNodeProto("Essential-Bounds");
        facetCenter = generic.findNodeProto("Facet-Center");
        universalArc = generic.findArcProto("Universal");
        viaMap.put(new Integer(m1.hashCode() * m2.hashCode()), m1m2);
        viaMap.put(new Integer(m2.hashCode() * m3.hashCode()), m2m3);
        viaMap.put(new Integer(m3.hashCode() * m4.hashCode()), m3m4);
        viaMap.put(new Integer(m4.hashCode() * m5.hashCode()), m4m5);
        viaMap.put(new Integer(m5.hashCode() * m6.hashCode()), m5m6);
        if (isTsmc90) {
            viaMap.put(new Integer(m6.hashCode() * m7.hashCode()), m6m7);
            viaMap.put(new Integer(m7.hashCode() * m8.hashCode()), m7m8);
            viaMap.put(new Integer(m8.hashCode() * m9.hashCode()), m8m9);
        }
        viaMap.put(new Integer(ndiff.hashCode() * m1.hashCode()), ndm1);
        viaMap.put(new Integer(pdiff.hashCode() * m1.hashCode()), pdm1);
        viaMap.put(new Integer(p1.hashCode() * m1.hashCode()), p1m1);
        PrimitiveNode wellCon = tech.findNodeProto("Metal-1-N-Well-Con");
        wellCon.getMinWidth();
        wellWidth = wellCon.getMinWidth();
        if (isTsmc90) {
            if (wellWidth != 14.0) {
                new Error("wrong value in Tech");
            }
            wellSurroundDiff = Double.NaN;
            gateExtendPastMOS = 3.25;
            p1Width = 2.0;
            p1ToP1Space = 3.6;
            p1M1Width = Double.NaN;
            gateToGateSpace = 4.0;
            gateToDiffContSpace = 1.9999999999999996;
            diffContWidth = 5.2;
            gateLength = 2.0;
            offsetLShapePolyContact = 1.5;
            offsetTShapePolyContact = 3.5;
            selectSpace = 4.8;
            selectSurroundDiffInTrans = 1.3;
            selectSurround = 4.4;
            selectSurroundDiffInActiveContact = Double.NaN;
            selectSurroundDiffAlongGateInTrans = 3.6;
        } else if (isTsmc180) {
            if (wellWidth != 17.0) {
                new Error("wrong value in Tech");
            }
            wellSurroundDiff = 4.3;
            gateExtendPastMOS = 2.5;
            p1Width = 1.8;
            p1ToP1Space = 2.7;
            p1M1Width = 5.0;
            gateToGateSpace = 3.0;
            gateToDiffContSpace = 1.1;
            diffContWidth = 5.0;
            gateLength = 1.8;
            offsetLShapePolyContact = 1.6;
            offsetTShapePolyContact = 3.4;
            selectSpace = 4.4;
            selectSurroundDiffInTrans = 1.8;
            selectSurround = 0.0;
            selectSurroundDiffInActiveContact = 1.0;
            selectSurroundDiffAlongGateInTrans = 3.6;
        } else {
            if (wellWidth != 17.0) {
                new Error("wrong value in Tech");
            }
            wellSurroundDiff = 3.0;
            gateExtendPastMOS = 2.0;
            p1Width = 2.0;
            p1ToP1Space = 3.0;
            p1M1Width = 5.0;
            gateToGateSpace = 3.0;
            gateToDiffContSpace = 0.5;
            diffContWidth = 5.0;
            gateLength = 2.0;
            offsetLShapePolyContact = 1.5;
            offsetTShapePolyContact = 3.5;
            selectSpace = 2.0;
            selectSurroundDiffInTrans = 2.0;
            selectSurround = Double.NaN;
            selectSurroundDiffInActiveContact = 2.0;
            selectSurroundDiffAlongGateInTrans = 2.0;
        }
    }

    public static boolean isTSMC90() {
        return techType == Type.TSMC90;
    }

    public static PrimitiveNode getViaFor(ArcProto a1, ArcProto a2) {
        int code = a1.hashCode() * a2.hashCode();
        return viaMap.get(new Integer(code));
    }

    public static ArcProto closestLayer(PortProto port, ArcProto layer) {
        int h = Tech.layerHeight(layer);
        for (int dist = 0; dist < nbLay; ++dist) {
            ArcProto lay;
            int lookUp = h + dist;
            int lookDn = h - dist;
            if (lookUp < nbLay && port.connectsTo(lay = Tech.layerAtHeight(lookUp))) {
                return lay;
            }
            if (lookDn < 0 || !port.connectsTo(lay = Tech.layerAtHeight(lookDn))) continue;
            return lay;
        }
        Tech.error(true, "port can't connect to any layer?!!");
        return null;
    }

    public static ArcProto layerAtHeight(int layHeight) {
        return layers[layHeight];
    }

    public static int layerHeight(ArcProto p) {
        for (int i = 0; i < nbLay; ++i) {
            if (layers[i] != p) continue;
            return i;
        }
        Tech.error(true, "Can't find layer: " + p);
        return -1;
    }

    public static PrimitiveNode viaAbove(ArcProto lay) {
        return Tech.viaAbove(Tech.layerHeight(lay));
    }

    public static PrimitiveNode viaAbove(int layHeight) {
        return vias[layHeight];
    }

    public static PrimitiveNode viaBelow(ArcProto lay) {
        return Tech.viaBelow(Tech.layerHeight(lay));
    }

    public static PrimitiveNode viaBelow(int layHeight) {
        return vias[layHeight - 1];
    }

    public static PrimitiveNode findNode(PrimitiveNode.Function type, ArcProto[] arcs, Technology tech) {
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            boolean found = true;
            if (pn.getFunction() != type) continue;
            for (int j = 0; j < arcs.length; ++j) {
                if (pn.connectsTo(arcs[j]) != null) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return pn;
        }
        return null;
    }

    public static double getWellWidth() {
        return wellWidth;
    }

    public static double getWellSurroundDiff() {
        return wellSurroundDiff;
    }

    public static double getGateExtendPastMOS() {
        return gateExtendPastMOS;
    }

    public static double getP1Width() {
        return p1Width;
    }

    public static double getP1ToP1Space() {
        return p1ToP1Space;
    }

    public static double getGateToGateSpace() {
        return gateToGateSpace;
    }

    public static double getGateToDiffContSpace() {
        return gateToDiffContSpace;
    }

    public static double getDiffContWidth() {
        return diffContWidth;
    }

    public static double getP1M1Width() {
        return p1M1Width;
    }

    public static double getGateLength() {
        return gateLength;
    }

    public static double selectSurroundDiffInActiveContact() {
        return selectSurroundDiffInActiveContact;
    }

    public static double selectSurroundDiffAlongGateInTrans() {
        return selectSurroundDiffAlongGateInTrans;
    }

    public static double getPolyLShapeOffset() {
        return offsetLShapePolyContact;
    }

    public static double getPolyTShapeOffset() {
        return offsetTShapePolyContact;
    }

    public static double getSelectSpacingRule() {
        return selectSpace;
    }

    public static double getSelectSurroundDiffInTrans() {
        return selectSurroundDiffInTrans;
    }

    public static double getSelectSurroundOverPoly() {
        return selectSurround;
    }

    static {
        MOCMOS_LAYER_NAMES = new String[]{"Polysilicon-1", "Metal-1", "Metal-2", "Metal-3", "Metal-4", "Metal-5", "Metal-6"};
        TSMC90_LAYER_NAMES = new String[]{"Polysilicon", "Metal-1", "Metal-2", "Metal-3", "Metal-4", "Metal-5", "Metal-6", "Metal-7", "Metal-8", "Metal-9"};
        viaMap = new HashMap();
        ATTR_X = Variable.newKey("ATTR_X");
        ATTR_S = Variable.newKey("ATTR_S");
        ATTR_SN = Variable.newKey("ATTR_SN");
        ATTR_SP = Variable.newKey("ATTR_SP");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INVALID,
        MOCMOS,
        TSMC90,
        TSMC180;

    }

    public static class MosInst {
        private boolean isTsmc90 = Tech.isTSMC90();
        private NodeInst mos;
        boolean ntype;

        protected MosInst(boolean ntype, double x, double y, double w, double l, Cell parent) {
            this.ntype = ntype;
            PrimitiveNode np = ntype ? nmos : pmos;
            double angle = this.isTsmc90 ? 0.0 : 90.0;
            double xSize = this.isTsmc90 ? l : w;
            double ySize = this.isTsmc90 ? w : l;
            this.mos = LayoutLib.newNodeInst(np, x, y, xSize, ySize, angle, parent);
        }

        private String mosTypeString() {
            return this.ntype ? "n-trans" : "p-trans";
        }

        private PortInst getPort(String portNm) {
            PortInst pi = this.mos.findPortInst(portNm);
            Tech.error(pi == null, "MosInst can't find port!");
            return pi;
        }

        public PortInst leftDiff() {
            String type = this.isTsmc90 ? "" : this.mosTypeString() + "-";
            String portNm = type + "diff" + (this.isTsmc90 ? "-left" : "-top");
            return this.getPort(portNm);
        }

        public PortInst rightDiff() {
            String type = this.isTsmc90 ? "" : this.mosTypeString() + "-";
            String portNm = type + "diff" + (this.isTsmc90 ? "-right" : "-bottom");
            return this.getPort(portNm);
        }

        public PortInst topPoly() {
            String type = this.isTsmc90 ? "" : this.mosTypeString() + "-";
            String portNm = type + "poly" + (this.isTsmc90 ? "-top" : "-right");
            return this.getPort(portNm);
        }

        public PortInst botPoly() {
            String type = this.isTsmc90 ? "" : this.mosTypeString() + "-";
            String portNm = type + "poly" + (this.isTsmc90 ? "-bottom" : "-left");
            return this.getPort(portNm);
        }
    }
}

