/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Network {
    private static final String[] NULL_STRING_ARRAY;
    private Netlist netlist;
    private int netIndex;
    private String[] names = NULL_STRING_ARRAY;
    private int exportedNamesCount;
    private boolean isUsernamed;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Network(Netlist netlist, int netIndex) {
        this.netlist = netlist;
        this.netIndex = netIndex;
    }

    public void addUserName(Name nameKey, boolean exported) {
        int i;
        if (!$assertionsDisabled && nameKey.isTempname()) {
            throw new AssertionError();
        }
        String name = nameKey.toString();
        if (exported && !$assertionsDisabled && this.exportedNamesCount != this.names.length) {
            throw new AssertionError();
        }
        for (i = 0; i < this.names.length; ++i) {
            String n = this.names[i];
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(name, n);
            if (cmp == 0 && !exported) {
                return;
            }
            if (cmp < 0 && (exported || i >= this.exportedNamesCount)) break;
        }
        if (this.names.length == 0) {
            this.names = new String[]{name};
        } else {
            String[] newNames = new String[this.names.length + 1];
            System.arraycopy(this.names, 0, newNames, 0, i);
            newNames[i] = name;
            System.arraycopy(this.names, i, newNames, i + 1, this.names.length - i);
            this.names = newNames;
        }
        if (exported) {
            ++this.exportedNamesCount;
        }
        this.isUsernamed = true;
    }

    public void addTempName(String name) {
        if (this.names.length > 0) {
            return;
        }
        this.names = new String[]{name};
    }

    public Netlist getNetlist() {
        return this.netlist;
    }

    public Cell getParent() {
        return this.netlist.netCell.cell;
    }

    public int getNetIndex() {
        return this.netIndex;
    }

    public Iterator getNames() {
        return ArrayIterator.iterator(this.names);
    }

    public Iterator getExportedNames() {
        return ArrayIterator.iterator(this.names, 0, this.exportedNamesCount);
    }

    public String getName() {
        return this.names[0];
    }

    boolean hasNames() {
        return this.names.length > 0;
    }

    public boolean hasName(String nm) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(nm)) continue;
            return true;
        }
        return false;
    }

    public void fillNames(Collection exportedNames, Collection unexportedNames) {
        for (int i = 0; i < this.names.length; ++i) {
            String name = this.names[i];
            (i < this.exportedNamesCount ? exportedNames : unexportedNames).add(name);
        }
    }

    public Iterator getPorts() {
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        Iterator it = this.getParent().getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator pit = ni.getPortInsts();
            while (pit.hasNext()) {
                PortInst pi = (PortInst)pit.next();
                if (this.netlist.getNetwork(pi) != this) continue;
                ports.add(pi);
            }
        }
        return ports.iterator();
    }

    public Iterator getExports() {
        ArrayList<Export> exports = new ArrayList<Export>();
        Iterator it = this.getParent().getPorts();
        block0: while (it.hasNext()) {
            Export e = (Export)it.next();
            int busWidth = this.netlist.getBusWidth(e);
            for (int i = 0; i < busWidth; ++i) {
                if (this.netlist.getNetwork(e, i) != this) continue;
                exports.add(e);
                continue block0;
            }
        }
        return exports.iterator();
    }

    public Iterator getArcs() {
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        Iterator it = this.getParent().getArcs();
        block0: while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            int busWidth = this.netlist.getBusWidth(ai);
            for (int i = 0; i < busWidth; ++i) {
                if (this.netlist.getNetwork(ai, i) != this) continue;
                arcs.add(ai);
                continue block0;
            }
        }
        return arcs.iterator();
    }

    public boolean isExported() {
        return this.exportedNamesCount > 0;
    }

    public boolean isUsernamed() {
        return this.isUsernamed;
    }

    public String describe(boolean withQuotes) {
        Iterator it = this.getNames();
        String name = (String)it.next();
        while (it.hasNext()) {
            name = name + "/" + (String)it.next();
        }
        if (withQuotes) {
            name = "'" + name + "'";
        }
        return name;
    }

    public String toString() {
        return "network " + this.describe(true);
    }

    static {
        $assertionsDisabled = !Network.class.desiredAssertionStatus();
        NULL_STRING_ARRAY = new String[0];
    }
}

