/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.LibId;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.HashMap;

public class ImmutableVariable {
    public static final ImmutableVariable[] NULL_ARRAY;
    private static final byte ARRAY = 1;
    private static final byte SIMPLE = 0;
    private static final byte LIBRARY = 2;
    private static final byte CELL = 4;
    private static final byte EXPORT = 6;
    private static final HashMap validClasses;
    public final Variable.Key key;
    public final ImmutableTextDescriptor descriptor;
    private final Object value;
    private final byte type;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ImmutableVariable(Variable.Key key, ImmutableTextDescriptor descriptor, Object value, byte type) {
        this.key = key;
        this.descriptor = descriptor;
        this.value = value;
        this.type = type;
        this.check();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImmutableVariable newInstance(Variable.Key key, ImmutableTextDescriptor descriptor, Object value) {
        int type;
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        if (value instanceof Object[]) {
            Byte typeByte = (Byte)validClasses.get(value.getClass().getComponentType());
            if (typeByte != null) {
                value = ((Object[])value).clone();
                type = (byte)(typeByte | 1);
            } else if (value instanceof Library[]) {
                Library[] libs = (Library[])value;
                LibId[] libIds = new LibId[libs.length];
                for (int i = 0; i < libs.length; ++i) {
                    if (libs[i] == null) continue;
                    libIds[i] = libs[i].getId();
                }
                value = libIds;
                type = 3;
            } else if (value instanceof Cell[]) {
                Cell[] cells = (Cell[])value;
                CellId[] cellIds = new CellId[cells.length];
                for (int i = 0; i < cells.length; ++i) {
                    if (cells[i] == null) continue;
                    cellIds[i] = (CellId)cells[i].getId();
                }
                value = cellIds;
                type = 5;
            } else if (value instanceof Export[]) {
                Export[] exports = (Export[])value;
                ExportId[] exportIds = new ExportId[exports.length];
                for (int i = 0; i < exports.length; ++i) {
                    if (exports[i] == null) continue;
                    exportIds[i] = (ExportId)exports[i].getId();
                }
                value = exportIds;
                type = 7;
            } else {
                if (!(value instanceof Point2D[])) throw new IllegalArgumentException(value.getClass().toString());
                Point2D[] points = (Point2D[])value;
                EPoint[] epoints = new EPoint[points.length];
                for (int i = 0; i < points.length; ++i) {
                    if (points[i] == null) continue;
                    epoints[i] = EPoint.snap(points[i]);
                }
                value = epoints;
                type = 1;
            }
        } else {
            Byte typeByte = (Byte)validClasses.get(value.getClass());
            if (typeByte != null) {
                type = typeByte.byteValue();
            } else if (value instanceof Library) {
                value = ((Library)value).getId();
                type = 2;
            } else if (value instanceof Cell) {
                value = ((Cell)value).getId();
                type = 4;
            } else if (value instanceof Export) {
                value = ((Export)value).getId();
                type = 6;
            } else {
                if (!(value instanceof Point2D)) throw new IllegalArgumentException(value.getClass().toString());
                value = EPoint.snap((Point2D)value);
                type = 0;
            }
        }
        if (!descriptor.isCode() || value instanceof String || value instanceof String[]) return new ImmutableVariable(key, descriptor, value, (byte)type);
        descriptor = descriptor.withoutCode();
        return new ImmutableVariable(key, descriptor, value, (byte)type);
    }

    public ImmutableVariable withDescriptor(ImmutableTextDescriptor descriptor) {
        if (this.descriptor == descriptor) {
            return this;
        }
        if (descriptor.isCode() && !(this.value instanceof String) && !(this.value instanceof String[])) {
            descriptor = descriptor.withoutCode();
        }
        return new ImmutableVariable(this.key, descriptor, this.value, this.type);
    }

    public ImmutableVariable withValue(Object value) {
        if (this.value.equals(value)) {
            return this;
        }
        if ((this.type & 1) != 0 && value instanceof Object[] && Arrays.equals((Object[])this.value, (Object[])value) && this.value.getClass().getComponentType() == value.getClass().getComponentType()) {
            return this;
        }
        return ImmutableVariable.newInstance(this.key, this.descriptor, value);
    }

    public Object getValue() {
        return (this.type & 1) != 0 ? ((Object[])this.value).clone() : this.value;
    }

    public Object getValueInCurrentThread() {
        switch (this.type) {
            case 0: {
                return this.value;
            }
            case 2: {
                return ((LibId)this.value).inCurrentThread();
            }
            case 4: {
                return ((CellId)this.value).inCurrentThread();
            }
            case 6: {
                return ((ExportId)this.value).inCurrentThread();
            }
            case 1: {
                return ((Object[])this.value).clone();
            }
            case 3: {
                LibId[] libIds = (LibId[])this.value;
                Library[] libs = new Library[libIds.length];
                for (int i = 0; i < libIds.length; ++i) {
                    if (libIds[i] == null) continue;
                    libs[i] = libIds[i].inCurrentThread();
                }
                return libs;
            }
            case 5: {
                CellId[] cellIds = (CellId[])this.value;
                Cell[] cells = new Cell[cellIds.length];
                for (int i = 0; i < cellIds.length; ++i) {
                    if (cellIds[i] == null) continue;
                    cells[i] = (Cell)cellIds[i].inCurrentThread();
                }
                return cells;
            }
            case 7: {
                ExportId[] exportIds = (ExportId[])this.value;
                Export[] exports = new Export[exportIds.length];
                for (int i = 0; i < exportIds.length; ++i) {
                    if (exportIds[i] == null) continue;
                    exports[i] = (Export)exportIds[i].inCurrentThread();
                }
                return exports;
            }
        }
        throw new AssertionError();
    }

    public int getValueLength() {
        return (this.type & 1) != 0 ? ((Object[])this.value).length : -1;
    }

    public Object getValue(int index) {
        if ((this.type & 1) == 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return ((Object[])this.value)[index];
    }

    public Object getValueInCurrentThread(int index) {
        switch (this.type) {
            case 1: {
                return ((Object[])this.value)[index];
            }
            case 3: {
                LibId libId = ((LibId[])this.value)[index];
                return libId != null ? libId.inCurrentThread() : null;
            }
            case 5: {
                CellId cellId = ((CellId[])this.value)[index];
                return cellId != null ? cellId.inCurrentThread() : null;
            }
            case 7: {
                ExportId exportId = ((ExportId[])this.value)[index];
                return exportId != null ? exportId.inCurrentThread() : null;
            }
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void check() {
        if (!$assertionsDisabled && this.key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.descriptor == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.value == null) {
            throw new AssertionError();
        }
        if (this.value instanceof Object[]) {
            Byte typeByte = (Byte)validClasses.get(this.value.getClass().getComponentType());
            if (!$assertionsDisabled && this.type != (byte)(typeByte | 1)) {
                throw new AssertionError();
            }
        } else {
            Byte typeByte = (Byte)validClasses.get(this.value.getClass());
            if (!$assertionsDisabled && this.type != typeByte) {
                throw new AssertionError();
            }
        }
        if (this.descriptor.isCode() && !$assertionsDisabled && !(this.value instanceof String) && !(this.value instanceof String[])) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !ImmutableVariable.class.desiredAssertionStatus();
        NULL_ARRAY = new ImmutableVariable[0];
        validClasses = new HashMap();
        validClasses.put(String.class, new Byte(0));
        validClasses.put(Double.class, new Byte(0));
        validClasses.put(Float.class, new Byte(0));
        validClasses.put(Long.class, new Byte(0));
        validClasses.put(Integer.class, new Byte(0));
        validClasses.put(Short.class, new Byte(0));
        validClasses.put(Byte.class, new Byte(0));
        validClasses.put(Boolean.class, new Byte(0));
        validClasses.put(EPoint.class, new Byte(0));
        validClasses.put(Tool.class, new Byte(0));
        validClasses.put(Technology.class, new Byte(0));
        validClasses.put(PrimitiveNode.class, new Byte(0));
        validClasses.put(ArcProto.class, new Byte(0));
        validClasses.put(LibId.class, new Byte(2));
        validClasses.put(CellId.class, new Byte(4));
        validClasses.put(ExportId.class, new Byte(6));
    }
}

