/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sc;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.Listener;
import java.awt.geom.Rectangle2D;

public class SilComp
extends Listener {
    private static SilComp tool = new SilComp();
    private static Library cellLibrary;
    private static Pref cacheNumberOfRows;
    private static Pref cacheHorizRoutingArc;
    private static Pref cacheHorizRoutingWidth;
    private static Pref cacheVertRoutingArc;
    private static Pref cacheVertRoutingWidth;
    private static Pref cachePowerWireWidth;
    private static Pref cacheMainPowerWireWidth;
    private static Pref cacheMainPowerArc;
    private static Pref cachePWellHeight;
    private static Pref cachePWellOffset;
    private static Pref cacheNWellHeight;
    private static Pref cacheNWellOffset;
    private static Pref cacheViaSize;
    private static Pref cacheMinMetalSpacing;
    private static Pref cacheFeedThruSize;
    private static Pref cacheMinPortDistance;
    private static Pref cacheMinActiveDistance;

    private SilComp() {
        super("sc");
    }

    public void init() {
    }

    public static SilComp getSilCompTool() {
        return tool;
    }

    public static Library getCellLib() {
        return cellLibrary;
    }

    public static void setCellLib(Library lib) {
        cellLibrary = lib;
    }

    static double leafCellXSize(Cell cell) {
        Rectangle2D bounds = cell.getBounds();
        return bounds.getWidth();
    }

    static double leafCellYSize(Cell cell) {
        Rectangle2D bounds = cell.getBounds();
        return bounds.getHeight();
    }

    static double leafPortXPos(Export port) {
        if (port == null) {
            return 0.0;
        }
        Poly poly = port.getOriginalPort().getPoly();
        Rectangle2D bounds = ((Cell)port.getParent()).getBounds();
        return poly.getCenterX() - bounds.getMinX();
    }

    static double leafPortYPos(Export port) {
        if (port == null) {
            return 0.0;
        }
        Poly poly = port.getOriginalPort().getPoly();
        Rectangle2D bounds = ((Cell)port.getParent()).getBounds();
        return poly.getCenterY() - bounds.getMinY();
    }

    public static int getNumberOfRows() {
        return cacheNumberOfRows.getInt();
    }

    public static void setNumberOfRows(int rows) {
        cacheNumberOfRows.setInt(rows);
    }

    public static String getHorizRoutingArc() {
        return cacheHorizRoutingArc.getString();
    }

    public static void setHorizRoutingArc(String arcName) {
        cacheHorizRoutingArc.setString(arcName);
    }

    public static double getHorizArcWidth() {
        return cacheHorizRoutingWidth.getDouble();
    }

    public static void setHorizArcWidth(double wid) {
        cacheHorizRoutingWidth.setDouble(wid);
    }

    public static String getVertRoutingArc() {
        return cacheVertRoutingArc.getString();
    }

    public static void setVertRoutingArc(String arcName) {
        cacheVertRoutingArc.setString(arcName);
    }

    public static double getVertArcWidth() {
        return cacheVertRoutingWidth.getDouble();
    }

    public static void setVertArcWidth(double wid) {
        cacheVertRoutingWidth.setDouble(wid);
    }

    public static double getPowerWireWidth() {
        return cachePowerWireWidth.getDouble();
    }

    public static void setPowerWireWidth(double wid) {
        cachePowerWireWidth.setDouble(wid);
    }

    public static double getMainPowerWireWidth() {
        return cacheMainPowerWireWidth.getDouble();
    }

    public static void setMainPowerWireWidth(double wid) {
        cacheMainPowerWireWidth.setDouble(wid);
    }

    public static String getMainPowerArc() {
        return cacheMainPowerArc.getString();
    }

    public static void setMainPowerArc(String arcName) {
        cacheMainPowerArc.setString(arcName);
    }

    public static double getPWellHeight() {
        return cachePWellHeight.getDouble();
    }

    public static void setPWellHeight(double hei) {
        cachePWellHeight.setDouble(hei);
    }

    public static double getPWellOffset() {
        return cachePWellOffset.getDouble();
    }

    public static void setPWellOffset(double off) {
        cachePWellOffset.setDouble(off);
    }

    public static double getNWellHeight() {
        return cacheNWellHeight.getDouble();
    }

    public static void setNWellHeight(double hei) {
        cacheNWellHeight.setDouble(hei);
    }

    public static double getNWellOffset() {
        return cacheNWellOffset.getDouble();
    }

    public static void setNWellOffset(double off) {
        cacheNWellOffset.setDouble(off);
    }

    public static double getViaSize() {
        return cacheViaSize.getDouble();
    }

    public static void setViaSize(double off) {
        cacheViaSize.setDouble(off);
    }

    public static double getMinMetalSpacing() {
        return cacheMinMetalSpacing.getDouble();
    }

    public static void setMinMetalSpacing(double off) {
        cacheMinMetalSpacing.setDouble(off);
    }

    public static double getFeedThruSize() {
        return cacheFeedThruSize.getDouble();
    }

    public static void setFeedThruSize(double off) {
        cacheFeedThruSize.setDouble(off);
    }

    public static double getMinPortDistance() {
        return cacheMinPortDistance.getDouble();
    }

    public static void setMinPortDistance(double off) {
        cacheMinPortDistance.setDouble(off);
    }

    public static double getMinActiveDistance() {
        return cacheMinActiveDistance.getDouble();
    }

    public static void setMinActiveDistance(double off) {
        cacheMinActiveDistance.setDouble(off);
    }

    static {
        cacheNumberOfRows = Pref.makeIntPref("NumberOfRows", SilComp.tool.prefs, 4);
        cacheHorizRoutingArc = Pref.makeStringPref("HorizRoutingArc", SilComp.tool.prefs, "Metal-1");
        cacheHorizRoutingWidth = Pref.makeDoublePref("HorizArcWidth", SilComp.tool.prefs, 4.0);
        cacheVertRoutingArc = Pref.makeStringPref("VertRoutingArc", SilComp.tool.prefs, "Metal-2");
        cacheVertRoutingWidth = Pref.makeDoublePref("VertArcWidth", SilComp.tool.prefs, 4.0);
        cachePowerWireWidth = Pref.makeDoublePref("PowerWireWidth", SilComp.tool.prefs, 5.0);
        cacheMainPowerWireWidth = Pref.makeDoublePref("MainPowerWireWidth", SilComp.tool.prefs, 8.0);
        cacheMainPowerArc = Pref.makeStringPref("MainPowerArc", SilComp.tool.prefs, "Horizontal Arc");
        cachePWellHeight = Pref.makeDoublePref("PWellHeight", SilComp.tool.prefs, 41.0);
        cachePWellOffset = Pref.makeDoublePref("PWellOffset", SilComp.tool.prefs, 0.0);
        cacheNWellHeight = Pref.makeDoublePref("NWellHeight", SilComp.tool.prefs, 51.0);
        cacheNWellOffset = Pref.makeDoublePref("NWellOffset", SilComp.tool.prefs, 0.0);
        cacheViaSize = Pref.makeDoublePref("ViaSize", SilComp.tool.prefs, 4.0);
        cacheMinMetalSpacing = Pref.makeDoublePref("MinMetalSpacing", SilComp.tool.prefs, 6.0);
        cacheFeedThruSize = Pref.makeDoublePref("FeedThruSize", SilComp.tool.prefs, 16.0);
        cacheMinPortDistance = Pref.makeDoublePref("MinPortDistance", SilComp.tool.prefs, 8.0);
        cacheMinActiveDistance = Pref.makeDoublePref("MinActiveDistance", SilComp.tool.prefs, 8.0);
    }
}

