/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.CellUsage;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.Passed;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NccBottomUp {
    private static final Passed passed = new Passed();

    private CellUsage getCellUsage(Cell root) {
        CellUsage visitor = new CellUsage();
        HierarchyEnumerator.enumerateCell(root, null, null, visitor);
        return visitor;
    }

    private CellContext selectAndRemoveReferenceCellContext(List cellCtxts) {
        Iterator it = cellCtxts.iterator();
        while (it.hasNext()) {
            CellContext cc = (CellContext)it.next();
            if (!cc.cell.isSchematic()) continue;
            it.remove();
            return cc;
        }
        it = cellCtxts.iterator();
        CellContext refCell = (CellContext)it.next();
        it.remove();
        return refCell;
    }

    private boolean hasSkipAnnotation(List cellCtxts) {
        Iterator it = cellCtxts.iterator();
        while (it.hasNext()) {
            String reason;
            Cell c = ((CellContext)it.next()).cell;
            NccCellAnnotations ann = NccCellAnnotations.getAnnotations(c);
            if (ann == null || (reason = ann.getSkipReason()) == null) continue;
            System.out.println("Skip NCC of " + NccUtils.fullName(c) + " because " + reason);
            return true;
        }
        return false;
    }

    private boolean hasBlackBoxAnnotation(List cellCtxts) {
        Iterator it = cellCtxts.iterator();
        while (it.hasNext()) {
            String reason;
            Cell c = ((CellContext)it.next()).cell;
            NccCellAnnotations ann = NccCellAnnotations.getAnnotations(c);
            if (ann == null || (reason = ann.getBlackBoxReason()) == null) continue;
            System.out.println("Black box: " + NccUtils.fullName(c) + " because " + reason);
            return true;
        }
        return false;
    }

    private void purgeUnnecessaryDuplicateCells(List cellContextsInGroup) {
        HashSet<Cell> cells = new HashSet<Cell>();
        Iterator it = cellContextsInGroup.iterator();
        while (it.hasNext() && cellContextsInGroup.size() > 2) {
            Cell c = ((CellContext)it.next()).cell;
            if (cells.contains(c)) {
                it.remove();
                continue;
            }
            cells.add(c);
        }
    }

    private void printCells(List cellContextsInGroup) {
        System.out.print("Cells in group: ");
        Iterator it = cellContextsInGroup.iterator();
        while (it.hasNext()) {
            CellContext cc = (CellContext)it.next();
            Cell c = cc.cell;
            System.out.print(c.getName() + " ");
        }
        System.out.println();
    }

    private NccResult compareCellsInGroup(List cellContextsInGroup, String groupName, HierarchyInfo hierInfo, boolean hierarchical, boolean skipPassed, NccOptions options) {
        NccResult result = new NccResult(true, true, true, null);
        if (cellContextsInGroup.size() < 2) {
            return result;
        }
        if (this.hasSkipAnnotation(cellContextsInGroup)) {
            return result;
        }
        hierInfo.beginNextCellGroup(groupName);
        if (this.hasNotSubcircuitAnnotation(cellContextsInGroup)) {
            hierInfo.purgeCurrentCellGroup();
        }
        boolean blackBoxAnn = this.hasBlackBoxAnnotation(cellContextsInGroup);
        this.purgeUnnecessaryDuplicateCells(cellContextsInGroup);
        CellContext refCC = this.selectAndRemoveReferenceCellContext(cellContextsInGroup);
        Iterator it = cellContextsInGroup.iterator();
        while (it.hasNext()) {
            CellContext thisCC = (CellContext)it.next();
            if (blackBoxAnn || skipPassed && passed.getPassed(refCC.cell, thisCC.cell)) {
                boolean ok;
                if (hierInfo == null || (ok = NccUtils.buildBlackBoxes(refCC, thisCC, hierInfo, options))) continue;
                return null;
            }
            result.abandonNccGlobals();
            NccResult r = NccUtils.compareAndPrintStatus(refCC.cell, refCC.context, thisCC.cell, thisCC.context, hierInfo, options);
            result.andEquals(r);
            if (r.match()) {
                passed.setPassed(refCC.cell, thisCC.cell);
            }
            if (r.match() || !options.haltAfterFirstMismatch) continue;
            break;
        }
        if (!hierarchical) {
            hierInfo.purgeCurrentCellGroup();
        }
        return result;
    }

    private List getUsedCellsInGroup(Cell cell, CellUsage use1, CellUsage use2) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cell);
        Cell.CellGroup group = cell.getCellGroup();
        if (ann != null && ann.getGroupToJoin() != null && ann.getGroupToJoin() != group) {
            return new ArrayList();
        }
        HashSet<CellContext> cellsInGroup = new HashSet<CellContext>();
        cellsInGroup.addAll(use1.getGroupAdditions(group));
        cellsInGroup.addAll(use2.getGroupAdditions(group));
        Iterator gi = group.getCells();
        while (gi.hasNext()) {
            Cell c = (Cell)gi.next();
            if (use1.cellIsUsed(c)) {
                cellsInGroup.add(use1.getCellContext(c));
            }
            if (!use2.cellIsUsed(c)) continue;
            cellsInGroup.add(use2.getCellContext(c));
        }
        if (cell == use1.getRoot()) {
            cellsInGroup.add(use2.getCellContext(use2.getRoot()));
        }
        if (cell == use2.getRoot()) {
            cellsInGroup.add(use1.getCellContext(use1.getRoot()));
        }
        LayoutLib.error(cellsInGroup.size() == 0, "Cell not in its own group?");
        ArrayList<CellContext> cellsInGroupList = new ArrayList<CellContext>();
        cellsInGroupList.addAll(cellsInGroup);
        return cellsInGroupList;
    }

    private boolean hasNotSubcircuitAnnotation(List cellContextsInGroup) {
        Iterator it = cellContextsInGroup.iterator();
        while (it.hasNext()) {
            String notSubcktReason;
            Cell c = ((CellContext)it.next()).cell;
            NccCellAnnotations anns = NccCellAnnotations.getAnnotations(c);
            if (anns == null || (notSubcktReason = anns.getNotSubcircuitReason()) == null) continue;
            System.out.println("For this hierarchical NCC I'm not treating " + NccUtils.fullName(c) + " as a subcircuit because " + notSubcktReason);
            return true;
        }
        return false;
    }

    private boolean alreadyCompared(Set compared, List cellCtxtsInGroup) {
        int num = 0;
        int numComp = 0;
        Iterator it = cellCtxtsInGroup.iterator();
        while (it.hasNext()) {
            CellContext cc = (CellContext)it.next();
            if (compared.contains(cc)) {
                ++numComp;
            }
            ++num;
        }
        LayoutLib.error(numComp != 0 && numComp != num, "cell group partially processed");
        return numComp > 0;
    }

    private NccResult compareCellGroups(CellUsage use1, CellUsage use2, boolean hierarchical, boolean skipPassed, NccOptions options) {
        NccResult result = new NccResult(true, true, true, null);
        HashSet compared = new HashSet();
        HierarchyInfo hierInfo = new HierarchyInfo();
        Iterator it = use1.cellsInReverseTopologicalOrder();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            List cellContextsInGroup = this.getUsedCellsInGroup(cell, use1, use2);
            if (this.alreadyCompared(compared, cellContextsInGroup)) continue;
            compared.addAll(cellContextsInGroup);
            String grpNm = cell.getLibrary().getName() + ":" + cell.getName();
            result.abandonNccGlobals();
            NccResult r = this.compareCellsInGroup(cellContextsInGroup, grpNm, hierInfo, hierarchical, skipPassed, options);
            if (r == null) {
                System.out.println("Halting multiple cell NCC because of failure to build a black box");
                return result;
            }
            result.andEquals(r);
            if (result.match() || !options.haltAfterFirstMismatch) continue;
            System.out.println("Halting multiple cell NCC after finding first mismatch");
            return result;
        }
        return result;
    }

    private NccResult compareCells(Cell c1, Cell c2, boolean hierarchical, boolean skipPassed, NccOptions options) {
        CellUsage use1 = this.getCellUsage(c1);
        CellUsage use2 = this.getCellUsage(c2);
        return this.compareCellGroups(use1, use2, hierarchical, skipPassed, options);
    }

    public static NccResult compare(Cell c1, Cell c2, boolean hierarchical, boolean skipPassed, NccOptions options) {
        NccBottomUp ncch = new NccBottomUp();
        return ncch.compareCells(c1, c2, hierarchical, skipPassed, options);
    }

    public static void clearPassedHistory() {
        passed.clear();
    }
}

