/*
 * Electric(tm) VLSI Design System
 *
 * File: usr.h
 * User interface aid: header file
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

/******************** CONSTANTS ********************/

/* the meaning of NODEINST->userbits: (bit 0 to 6 (0177) used globally) */
#define	KILLN                   0200		/* if on, this nodeinst is marked for death */
#define	REWANTN                 0400		/* nodeinst re-drawing is scheduled */
#define	RELOCLN                01000		/* only local nodeinst re-drawing desired */
#define	RETDONN                02000		/* transparent nodeinst re-draw is done */
#define REODONN                04000		/* opaque nodeinst re-draw is done */
#define	SPREADN               010000		/* if on, nodeinst has been spread */
#define	WANTEXP               020000		/* if on, nodeinst wants to be (un)expanded */
#define	TEMPFLG               040000		/* temporary flag for nodeinst display */
#define	HARDSELECTN          0100000		/* set if hard to select */

/* the meaning of ARCINST->userbits: (bits 0 to 24 (0177777777) used globally) */
#define	KILLA             0200000000		/* if on, this arcinst is marked for death */
#define	REWANTA           0400000000		/* arcinst re-drawing is scheduled */
#define	RELOCLA          01000000000		/* only local arcinst re-drawing desired */
#define	RETDONA          02000000000		/* transparent arcinst re-draw is done */
#define	REODONA          04000000000		/* opaque arcinst re-draw is done */
#define	SPREADA         010000000000		/* if on, arcinst streches in spread */
#define	HARDSELECTA     020000000000		/* set if hard to select */

/* the meaning of NODEPROTO->userbits: (bits 0 to 23 (077777777) used globally) */
#define	NHASOPA           0100000000		/* set if prototype has opaque graphics */
#define	NFIRSTOPA       017600000000		/* index of first opaque layer (if any) */
#define NFIRSTOPASH               25		/* right shift of NFIRSTOPA */

/* the meaning of ARCPROTO->userbits: (bits 0 to 22 (037777777) used globally) */
#define	CANCONNECT         040000000		/* temporary for finding port connections */
#define	AHASOPA           0100000000		/* set if prototype has opaque graphics */
#define	AFIRSTOPA       017600000000		/* index of first opaque layer (if any) */
#define AFIRSTOPASH               25		/* right shift of AFIRSTOPA */

/* the meaning of PORTPROTO->userbits: (bits 0 to 31 used globally) */

/* the meaning of "us_aid->aidstate" (bits 0 to 6 (0177) used globally) */
#define	NOKEYLOCK            0200000		/* set to ignore key lockout after errors */
#define	JUSTTHEFACTS         0400000		/* set to print only informative messages */
#define	NODETAILS           01000000		/* set to make no mention of specific commands */
#define	USEDIALOGS          02000000		/* set to use dialogs where appropriate */
#define	ONESHOTMENU         04000000		/* set to have fixed menus highlight in one-shot mode */
#define	INTERACTIVE        010000000		/* set if cursor commands drag */
#define	INTEGRAL           020000000		/* set if windows must be integral pixels */
#define	ECHOBIND           040000000		/* set to echo bound commands in full */
#define	MENUON            0100000000		/* set if menu is on */
#define	SHOWXY            0200000000		/* set to display cursor rather than TECH/LAMBDA */
#define	TTYNOMORE         0400000000		/* set to skip -More- handling */
#define TERMBEEP         01000000000		/* set to enable terminal beep */

/* the meaning of "aid:user.USER_optionflags" */
#define	NOTEXTSELECT              01		/* set to disable selection of ALL text unless "special" option used */
#define	DRAWTINYFACETS            02		/* clear to "hash-out" tiny facets */
#define	CHECKDATE                 04		/* set to check facet dates */
#define	NOFACETCHANGES           010		/* set to lock facet changes */
#define	NOPRIMCHANGES            020		/* set to lock lockable primitives */
#define PORTLABELS              0700		/* bits for port labels */
#define PORTSFULL                  0		/* ports not drawn */
#define PORTSCROSS              0100		/* ports drawn as crosses */
#define PORTSOFF                0200		/* ports drawn as complete text */
#define PORTSSHORT              0300		/* ports drawn as shortened text */
#define PUTFACETCENTERINICON   01000		/* set to put facet centers in icons */
#define	NOINSTANCESELECT       02000		/* set to disable selection of instances unless "special" option used */
#define	NOMOVEAFTERDUP         04000		/* set to disable moving of objects after duplication */
#define	DUPCOPIESPORTS        010000		/* set to have duplication/array/extract copy ports */
#define	NO3DPERSPECTIVE       020000		/* set to turn off perspective in 3D view */
#define	FLIPINTERACTIVECON    040000		/* set to flip the sense of the interactive constraint */
#define	CENTEREDPRIMITIVES   0100000		/* set to place primitives by centers */

/* the O/S capabilities */
#define CANLOGINPUT               01		/* can log input for playback */
#define CANUSEFRAMES              02		/* can display multiple window frames */
#define CANSHOWPOPUP              04		/* can display popup menus */
#define CANRUNPROCESS            010		/* can run subprocesses (fork and exec) */
#define CANHAVENOWINDOWS         020		/* can exist with no edit windows */
#define CANSTATUSPERFRAME        040		/* can put separate status info in each frame */

/* the "style" parameter to "us_getcolormap()" */
#define	COLORSEXISTING             0		/* reload existing colors */
#define COLORSDEFAULT              1		/* load default colors (gray background) */
#define	COLORSBLACK                2		/* load black background colors */
#define COLORSWHITE                3		/* load white background colors */

/* editor defaults in the user interface */
#define DEFAULTBUTTONHANDLER     us_buttonhandler
#define DEFAULTCHARHANDLER       us_charhandler
#define DEFAULTCHANGEHANDLER       0
#define DEFAULTTERMHANDLER         0
#define DEFAULTREDISPHANDLER     us_redisplay

/* the meaning of "us_state" */
#define	COMMANDFAILED             01		/* set if current command has error */
#define SKIPKEYS                  02		/* set to ignore further single-key commands */
#define	GOTXY                     04		/* set if X/Y co-ordinates are known */
#define	LANGLOOP                 010		/* set if interpreting language code */
#define	HIGHLIGHTSET             020		/* set if highlighting turned on in broadcast */
#define	DIDINPUT                 040		/* set if just did input but haven't executed yet */
#define	MACROTERMINATED         0100		/* set if macro has terminated early */
#define	SNAPMODE               03600		/* snapping mode bits */
#define	SNAPMODENONE               0		/* snapping mode: none */
#define	SNAPMODECENTER          0200		/* snapping mode: center (circles, arcs) */
#define	SNAPMODEMIDPOINT        0400		/* snapping mode: midpoint (lines) */
#define	SNAPMODEENDPOINT        0600		/* snapping mode: endpoint (lines, arcs) */
#define	SNAPMODETANGENT        01000		/* snapping mode: tangent (circles, arcs) */
#define	SNAPMODEPERP           01200		/* snapping mode: perpendicular (lines, arcs, circles) */
#define	SNAPMODEQUAD           01400		/* snapping mode: quadrant (circles, arcs) */
#define	SNAPMODEINTER          01600		/* snapping mode: any intersection */
#define	NONOVERLAPPABLEDISPLAY 04000		/* set to disallow overlappable layers in display */
#define	NONPERSISTENTCURNODE  010000		/* clear to have current node be persistent */

/* cursor definitions */
#define	NORMALCURSOR               0		/* a normal arrow cursor */
#define	WANTTTYCURSOR              1		/* a "use the TTY" cursor */
#define	PENCURSOR                  2		/* a "pen" cursor */
#define	NULLCURSOR                 3		/* a null cursor */
#define	MENUCURSOR                 4		/* a menu selection cursor */
#define	HANDCURSOR                 5		/* a hand cursor (for dragging) */
#define	TECHCURSOR                 6		/* the technology edit cursor ("T") */
#define	IBEAMCURSOR                7		/* the text edit cursor ("I") */
#define	WAITCURSOR                 8		/* the hourglass cursor */
#define	LRCURSOR                   9		/* a left/right pointing cursor */
#define	UDCURSOR                  10		/* an up/down pointing cursor */

#define MESSAGESWIDTH             80		/* width of messages window */

/******************** VARIABLES ********************/

/* static display information */
extern INTSML       us_gotstatus;			/* nature of status terminal (see above) */
extern INTSML       us_longcount;			/* number of long commands */
extern INTSML     (*us_displayroutine)(POLYGON*, WINDOWPART*); /* routine for graphics display */
extern INTSML       us_cursorstate;			/* see defines above */
extern INTSML       us_normalcursor;		/* default cursor to use */
extern INTSML       us_optionschanged;		/* nonzero if options changed */
extern AIDENTRY    *us_aid;					/* the USER aid object */
extern INTBIG       us_layer_letters;		/* cached key for "USER_layer_letters" */
extern INTBIG       us_highlighted;			/* cached key for "USER_highlighted" */
extern INTBIG       us_highlightstack;		/* cached key for "USER_highlightstack" */
extern INTBIG       us_facet_descent_path;	/* cached key for "USER_descent_path" */
extern INTBIG       us_binding_keys;		/* cached key for "USER_binding_keys" */
extern INTBIG       us_binding_buttons;		/* cached key for "USER_binding_buttons" */
extern INTBIG       us_binding_menu;		/* cached key for "USER_binding_menu" */
extern INTBIG       us_current_node;		/* cached key for "USER_current_node" */
extern INTBIG       us_current_arc;			/* cached key for "USER_current_arc" */
extern INTBIG       us_placement_angle;		/* cached key for "USER_placement_angle" */
extern INTBIG       us_alignment_obj;		/* cached key for "USER_alignment_obj" */
extern INTBIG       us_alignment_edge;		/* cached key for "USER_alignment_edge" */
extern INTBIG       us_arcstyle;			/* cached key for "USER_arc_style" */
extern INTBIG       us_current_technology;	/* cached key for "USER_current_technology" */
extern INTBIG       us_current_window;		/* cached key for "USER_current_window" */
extern INTBIG       us_current_constraint;	/* cached key for "USER_current_constraint" */
extern INTBIG       us_colormap_red;		/* cached key for "USER_colormap_red" */
extern INTBIG       us_colormap_green;		/* cached key for "USER_colormap_green" */
extern INTBIG       us_colormap_blue;		/* cached key for "USER_colormap_blue" */
extern INTBIG       us_menu_position;		/* cached key for "USER_colormap_position" */
extern INTBIG       us_menu_x;				/* cached key for "USER_colormap_x" */
extern INTBIG       us_menu_y;				/* cached key for "USER_colormap_y" */
extern INTBIG       us_macrorunning;		/* cached key for "USER_macrorunning" */
extern INTBIG       us_macrobuilding;		/* cached key for "USER_macrobuilding" */
extern INTBIG       us_text_editor;			/* cached key for "USER_text_editor" */
extern INTBIG       us_optionflags;			/* cached key for "USER_optionflags" */
extern INTBIG       us_gridfloats;			/* cached key for "USER_grid_floats" */
extern INTBIG       us_gridboldspacing;		/* cached key for "USER_grid_bold_spacing" */
extern INTBIG       us_quickkeys;			/* cached key for "USER_quick_keys" */
extern INTBIG       us_interactiveangle;	/* cached key for "USER_interactive_angle" */
extern INTBIG       us_tinylambdaperpixel;	/* cached key for "USER_tiny_lambda_per_pixel" */
extern INTBIG       us_techstate;			/* cached key for "TECH_state" */
extern INTBIG       us_techlayer3dheightkey;/* cached key for "TECH_layer_3dheight" */
extern INTBIG       us_techlayer3dthicknesskey;	/* cached key for "TECH_layer_3dthickness" */
extern INTBIG       us_ignoreoptionchanges;	/* cached key for "USER_ignore_option_changes" */
extern INTBIG       us_useroptions;			/* mirror for "USER_optionflags" */
extern INTBIG       us_tinyratio;			/* mirror for "USER_tiny_lambda_per_pixel" */
extern INTBIG       us_separatechar;		/* separating character in port names */

/* internal state */
extern INTBIG       us_state;				/* miscellaneous state of user interface */
extern EDITOR      *us_editorfree;			/* top of free list of editors */

/* user interface state */
extern NODEPROTO   *us_curnodeproto;		/* current nodeproto */
extern ARCPROTO    *us_curarcproto;			/* current arcproto */
extern INTBIG       us_alignment;			/* current alignment in lambda */
extern INTBIG       us_edgealignment;		/* current edge alignment in lambda */
extern INTSML       us_dupdistset;			/* nonzero if duplication distance is valid */
extern NODEINST    *us_dupnode;				/* a node that was duplicated */
extern LIBRARY     *us_clipboardlib;		/* library with cut/copy/paste facet */
extern NODEPROTO   *us_clipboardfacet;		/* facet with cut/copy/paste objects */
extern INTBIG       us_dupx, us_dupy;		/* amount to move duplicated objects */
extern WINDOWFRAME *us_menuframe;			/* window frame on which menu resides */
extern INTSML       us_erasech, us_killch;	/* the erase and kill characters */
extern INTBIG       us_menux, us_menuy;		/* number of menu elements on the screen */
extern INTBIG       us_menupos;				/* position: 0:top 1:bottom 2:left 3:right */
extern INTBIG       us_menuxsz,us_menuysz;	/* size of menu elements */
extern INTBIG       us_menuhnx,us_menuhny;	/* highlighted nodeinst menu entry */
extern INTBIG       us_menuhax,us_menuhay;	/* highlighted arcinst menu entry */
extern INTBIG       us_menulx,us_menuhx;	/* X: low and high of menu area */
extern INTBIG       us_menuly,us_menuhy;	/* Y: low and high of menu area */
extern INTBIG       us_lastmeasurex, us_lastmeasurey;	/* last measured distance */
extern INTSML       us_validmesaure;		/* nonzero if a measure was done */
extern FILE        *us_logrecord;			/* logging record file */
extern FILE        *us_logplay;				/* logging playback file */
extern INTSML       us_logflushfreq;		/* session logging flush frequency */
extern INTBIG       us_quickkeycount;		/* number of quick keys in initial setup */
extern char       **us_quickkeylist;		/* quick keys in initial setup */

/******************** HIGHLIGHT MODULES ********************/

#define	NOHIGHLIGHT ((HIGHLIGHT *)-1)
#define	HIGHFROM                  01		/* set to display "from" object */
#define	HIGHBBOX                  04		/* set to display bounding box */
#define	HIGHLINE                 010		/* set to display a line */
#define	HIGHTEXT                 020		/* set to display text */
#define	HIGHTYPE                 037		/* the above highlight types */
#define	HIGHEXTRA                040		/* set to display extra information */
#define	HIGHSNAP                0100		/* set if snap point selected */
#define	HIGHSNAPTAN             0200		/* set if tangent snap point selected */
#define	HIGHSNAPPERP            0400		/* set if perpendicular snap point selected */
#define	HIGHNOBOX              01000		/* set to disable basic selection box */

typedef struct Ihighlight
{
	struct Ihighlight *nexthighlight;		/* next in linked list */
	INTSML            status;				/* nature of this highlighting (see above) */
	NODEPROTO        *facet;				/* the facet containing this highlight */
	GEOM             *fromgeom;				/* "from" object: geometry module */
	PORTPROTO        *fromport;				/* "from" object: port on node */
	INTSML            frompoint;			/* "from" object: polygon vertex */
	VARIABLE         *fromvar;				/* "from" object: variable with text */
	INTBIG            snapx, snapy;			/* HIGHSNAP: coordinate of snap point */
	INTBIG            stalx,staly;			/* HIGHBBOX: lower corner HIGHLINE: point 1 */
	INTBIG            stahx,stahy;			/* HIGHBBOX: upper corner HIGHLINE: point 2 */
} HIGHLIGHT;

/******************** MACRO PACKAGE MODULES ********************/

#define	NOMACROPACK ((MACROPACK *)-1)

typedef struct Imacropack
{
	char               *packname;			/* name of this macro package */
	INTSML              total;				/* number of macros in this package */
	struct  Imacropack *nextmacropack;		/* next in list of macros */
} MACROPACK;

extern MACROPACK *us_macropacktop;			/* top of list of defined macro packages */
extern MACROPACK *us_curmacropack;			/* current macro package */

/******************** USER COMMAND MODULES ********************/

#define	NOUSERCOM     ((USERCOM *)-1)
#define	NUMKEYS                  256		/* maximum keys on keyboard */
#define	NUMBUTS                   27		/* maximum buttons on tablet/mouse */

typedef struct Iusercom
{
	INTSML             active;				/* command index (-1 if none) */
	char              *comname;				/* name of this command */
	struct Ipopupmenu *menu;				/* pop-up menu to execute (if command is one) */
	char              *message;				/* message to place in menu */
	NODEPROTO         *nodeglyph;			/* nodeproto glyph to display in menu */
	ARCPROTO          *arcglyph;			/* arcproto glyph to display in menu */
	INTSML             count;				/* number of valid parameters */
	char              *word[MAXPARS];		/* parameter from user */
	struct Iusercom   *nextcom;				/* next in list */
} USERCOM;

extern USERCOM *us_usercomfree;				/* list of free user commands */
extern USERCOM *us_lastcom;					/* last command and arguments */

/******************** POP-UP MENU MODULES ********************/

#define	NOPOPUPMENUITEM ((POPUPMENUITEM *)-1)

typedef struct
{
	char    *attribute;						/* attribute name */
	char    *value;							/* value of the attribute (0 for none) */
	COMCOMP *valueparse;					/* command completion for "value" field */
	INTSML   maxlen;						/* length of value field (-1 to preserve) */
	USERCOM *response;						/* command in this menu entry */
	INTSML   changed;						/* nonzero if value is changed */
} POPUPMENUITEM;

#define	NOPOPUPMENU ((POPUPMENU *)-1)

typedef struct Ipopupmenu
{
	char              *name;				/* pop-up menu name */
	POPUPMENUITEM     *list;				/* array of pop-up menu items */
	INTSML             total;				/* number of items */
	char              *header;				/* header information for the menu */
	struct Ipopupmenu *nextpopupmenu;		/* next in linked list */
} POPUPMENU;

extern POPUPMENU *us_firstpopupmenu;		/* list of existing pop-up menus */

/******************** PULLDOWN MENUS ********************/

#define	MENUBARHEIGHT             25		/* size in pixels */

extern INTSML      us_menubarsize;			/* actual size (0 if no menu bar) */
extern INTSML      us_pulldownmenucount;	/* number of pulldown menus */
extern INTSML     *us_pulldownmenupos;		/* position of pulldown menus */
extern POPUPMENU **us_pulldowns;			/* the current pulldown menus */

/******************** BINDINGS ********************/

typedef struct
{
	NODEPROTO *nodeglyph;					/* node to be drawn in the menu */
	ARCPROTO  *arcglyph;					/* arc to be drawn in the menu */
	INTSML     backgroundcolor;				/* background color of the menu */
	INTSML     menumessagesize;				/* size of text to be drawn in the menu */
	char      *menumessage;					/* text to be drawn in the menu */
	POPUPMENU *popup;						/* popup menu that goes here */
	INTSML     inputpopup;					/* nonzero if the popup is input type */
	char      *command;						/* command to execute */
} COMMANDBINDING;

/******************** HOOKS TO DIALOGS IN OTHER TOOLS ********************/

#define NODIALOGHOOK ((DIALOGHOOK *)-1)

typedef struct IDialogHook
{
	char               *terminputkeyword;
	COMCOMP            *getlinecomp;
	void              (*routine)(void);
	struct IDialogHook *nextdialoghook;
} DIALOGHOOK;

/******************** STATUS BAR ********************/

typedef struct
{
	INTSML line;							/* line in status area where field resides */
	INTSML startper, endper;				/* percentage of status line used by field */
	char  *label;							/* field label */
} STATUSFIELD;

extern STATUSFIELD *us_statusalign;			/* current node alignment */
extern STATUSFIELD *us_statusangle;			/* current placement angle */
extern STATUSFIELD *us_statusarc;			/* current arc prototype */
extern STATUSFIELD *us_statusfacet;			/* current facet */
extern STATUSFIELD *us_statusfacetsize;		/* current facet size */
extern STATUSFIELD *us_statusgridsize;		/* current grid size */
extern STATUSFIELD *us_statuslambda;		/* current lambda */
extern STATUSFIELD *us_statusnetwork;		/* current network */
extern STATUSFIELD *us_statusnode;			/* current node prototype */
extern STATUSFIELD *us_statustechnology;	/* current technology */
extern STATUSFIELD *us_statusxpos;			/* current x position */
extern STATUSFIELD *us_statusypos;			/* current y position */
extern STATUSFIELD *us_statusproject;		/* current project */
extern STATUSFIELD *us_statusroot;			/* current root */
extern STATUSFIELD *us_statuspart;			/* current part */
extern STATUSFIELD *us_statuspackage;		/* current package */
extern STATUSFIELD *us_statusselection;		/* current selection */

/******************** EDITOR TABLE ********************/

typedef struct
{
	char    *editorname;							/* name of this editor */
	WINDOWPART *(*makeeditor)(WINDOWPART*, char*, INTSML*, INTSML*);/* create new editor in window */
	void    (*terminate)(EDITOR*);						/* terminate editor */
	INTBIG  (*totallines)(WINDOWPART*);					/* report number of lines in editor buffer */
	char   *(*getline)(WINDOWPART*, INTBIG);			/* get line from editor buffer */
	void    (*addline)(WINDOWPART*, INTBIG, char*);		/* add line to editor buffer */
	void    (*replaceline)(WINDOWPART*, INTBIG, char*);	/* replace line in editor */
	void    (*deleteline)(WINDOWPART*, INTBIG);			/* delete line in editor */
	void    (*highlightline)(WINDOWPART*, INTBIG);		/* highlight line in editor */
	void    (*suspendgraphics)(WINDOWPART*);			/* suspend display changes in editor */
	void    (*resumegraphics)(WINDOWPART*);				/* resume display changes in editor */
	void    (*writetextfile)(WINDOWPART*, char*);		/* write editer buffer to file */
	void    (*readtextfile)(WINDOWPART*, char*);		/* read file into editor */
	void    (*editorterm)(WINDOWPART*);					/* editor termination routine */
	void    (*shipchanges)(WINDOWPART*);				/* routine to force any changes out */
	INTSML  (*gotchar)(WINDOWPART*, INTSML);			/* character input routine */
	void    (*cut)(WINDOWPART*);						/* text cut routine */
	void    (*copy)(WINDOWPART*);						/* text copy routine */
	void    (*paste)(WINDOWPART*);						/* text paste routine */
	void    (*undo)(WINDOWPART*);						/* text undo routine */
	void    (*search)(WINDOWPART*, char*, INTSML);		/* text search routine */
} EDITORTABLE;

extern EDITORTABLE us_editortable[];
extern INTSML us_currenteditor;

/******************** PARSING MODULES ********************/

/* the main command table (with additional information) */
struct commandinfo
{
	char    *name;							/* name of this command */
	void   (*routine)(INTSML, char*[]);		/* routine to execute this command */
	INTSML   params;						/* number of parameters to command */
	COMCOMP *par[TEMPLATEPARS];				/* parameter types */
};

#define	MAXKEYWORD               100		/* maximum keywords on input */

extern INTSML   us_pacurchar;				/* current character on current line */
extern char    *us_pattyline;				/* current line image */
extern char    *us_paambiguous;				/* used by "us_pagetword" for "?" message */
extern INTSML   us_patruelength;			/* size of above two buffers */
extern INTSML   us_paparamcount;			/* number of parameters read in */
extern char    *us_palinestart;				/* first character position on line */
extern COMCOMP *us_paparamtype[MAXKEYWORD]; /* expected type of each parameter */
extern INTSML   us_pakeycount;				/* number of keywords allowed in parse */
extern char   **us_paparamstart;			/* character position of each parameter */
extern KEYWORD *us_pathiskey;				/* the current keyword list */

/* defined in "usercom.c" */
extern struct commandinfo us_lcommand[];

/******************** PROTOTYPES ********************/

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* prototypes for tool interface */
void us_init(INTBIG*, char*[], AIDENTRY*);
void us_done(void);
INTSML us_set(INTSML, char*[]);
INTBIG us_request(char*, va_list);
void us_examinenodeproto(NODEPROTO*);
void us_slice(void);
void us_startbatch(AIDENTRY*, INTSML);
void us_endbatch(void);
void us_startobjectchange(INTBIG, INTBIG);
void us_endobjectchange(INTBIG, INTBIG);
void us_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void us_modifynodeproto(NODEPROTO*);
void us_newobject(INTBIG, INTBIG);
void us_killobject(INTBIG, INTBIG);
void us_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void us_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void us_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void us_readlibrary(LIBRARY*);
void us_eraselibrary(LIBRARY*);
void us_writelibrary(LIBRARY*, INTSML);

/* prototypes for user commands */
void us_arc(INTSML, char*[]);
void us_array(INTSML, char*[]);
void us_bind(INTSML, char*[]);
void us_color(INTSML, char*[]);
void us_commandfile(INTSML, char*[]);
void us_constraint(INTSML, char*[]);
void us_copyfacet(INTSML, char*[]);
void us_create(INTSML, char*[]);
void us_debug(INTSML, char*[]);
void us_defarc(INTSML, char*[]);
void us_defnode(INTSML, char*[]);
void us_duplicate(INTSML, char*[]);
void us_echo(INTSML, char*[]);
void us_editfacet(INTSML, char*[]);
void us_erase(INTSML, char*[]);
void us_find(INTSML, char*[]);
void us_getproto(INTSML, char*[]);
void us_grid(INTSML, char*[]);
void us_help(INTSML, char*[]);
void us_if(INTSML, char*[]);
void us_interpret(INTSML, char*[]);
void us_iterate(INTSML, char*[]);
void us_killfacet(INTSML, char*[]);
void us_lambda(INTSML, char*[]);
void us_library(INTSML, char*[]);
void us_macbegin(INTSML, char*[]);
void us_macdone(INTSML, char*[]);
void us_macend(INTSML, char*[]);
void us_menu(INTSML, char*[]);
void us_mirror(INTSML, char*[]);
void us_move(INTSML, char*[]);
void us_node(INTSML, char*[]);
void us_offaid(INTSML, char*[]);
void us_onaid(INTSML, char*[]);
void us_outhier(INTSML, char*[]);
void us_package(INTSML, char*[]);
void us_port(INTSML, char*[]);
void us_quit(INTSML, char*[]);
void us_redraw(INTSML, char*[]);
void us_rename(INTSML, char*[]);
void us_replace(INTSML, char*[]);
void us_rotate(INTSML, char*[]);
void us_show(INTSML, char*[]);
void us_size(INTSML, char*[]);
void us_spread(INTSML, char*[]);
void us_system(INTSML, char*[]);
void us_technology(INTSML, char*[]);
void us_tellaid(INTSML, char*[]);
void us_terminal(INTSML, char*[]);
void us_text(INTSML, char*[]);
void us_undo(INTSML, char*[]);
void us_var(INTSML, char*[]);
void us_view(INTSML, char*[]);
void us_visiblelayers(INTSML, char*[]);
void us_window(INTSML, char*[]);
void us_yanknode(INTSML, char*[]);

/* prototypes for text editing */
void           us_describeeditor(char**);
WINDOWPART    *us_makeeditor(WINDOWPART*, char*, INTSML*, INTSML*);
INTBIG         us_totallines(WINDOWPART*);
char          *us_getline(WINDOWPART*, INTBIG);
void           us_addline(WINDOWPART*, INTBIG, char*);
void           us_replaceline(WINDOWPART*, INTBIG, char*);
void           us_deleteline(WINDOWPART*, INTBIG);
void           us_highlightline(WINDOWPART*, INTBIG);
void           us_suspendgraphics(WINDOWPART*);
void           us_resumegraphics(WINDOWPART*);
void           us_writetextfile(WINDOWPART*, char*);
void           us_readtextfile(WINDOWPART*, char*);
void           us_editorterm(WINDOWPART*);
void           us_shipchanges(WINDOWPART*);
INTSML         us_gotchar(WINDOWPART*, INTSML);
void           us_cuttext(WINDOWPART*);
void           us_copytext(WINDOWPART*);
void           us_pastetext(WINDOWPART*);
void           us_undotext(WINDOWPART*);
void           us_searchtext(WINDOWPART*, char*, INTSML);

/* prototypes for intratool interface */
void           us_3dbuttonhandler(WINDOWPART *w, INTSML but, INTSML x, INTSML y);
void           us_3ddefaultlayerheight(TECHNOLOGY *tech);
void           us_3denddrawing(void);
void           us_3dfillview(WINDOWPART *win);
void           us_3dpanview(WINDOWPART *win, INTBIG x, INTBIG y);
void           us_3dsetinteraction(INTBIG interaction);
void           us_3dsetupviewing(WINDOWPART*);
INTSML         us_3dshowpoly(POLYGON*, WINDOWPART*);
void           us_3dstartdrawing(WINDOWPART*);
void           us_3dzoomview(WINDOWPART *win, float z);
void           us_abortcommand(char*, ...);
void           us_abortedmsg(void);
INTSML         us_addhighlight(HIGHLIGHT*);
void           us_adjustdisplayabletext(NODEINST*);
void           us_adjustlambda(INTBIG, INTBIG);
void           us_adjustperpendicularsnappoints(HIGHLIGHT*, HIGHLIGHT*);
void           us_adjustquickkeys(VARIABLE *var);
void           us_adjusttangentsnappoints(HIGHLIGHT*, HIGHLIGHT*);
INTBIG         us_alignvalue(INTBIG, INTBIG, INTBIG*);
EDITOR        *us_alloceditor(void);
USERCOM       *us_allocusercom(void);
INTSML         us_alreadyfacetcenter(NODEPROTO *np);
INTSML         us_appendargs(USERCOM*);
void           us_arrayfromfile(char *file);
void           us_beginchanges(void);
INTSML         us_bottomrecurse(NODEINST*, PORTPROTO*, INTSML);
USERCOM       *us_buildcommand(INTSML, char*[]);
void           us_buildquickkeylist(void);
void           us_buildtexthighpoly(GEOM*, INTBIG, INTBIG, INTBIG, INTBIG, INTSML, POLYGON*);
void           us_buttonhandler(WINDOWPART*, INTSML, INTSML, INTSML);
INTSML         us_canedit(NODEPROTO*, NODEPROTO*, INTSML);
INTSML         us_charhandler(WINDOWPART*, INTSML);
void           us_chatportproto(NODEINST*, PORTPROTO*);
void           us_check_facet_date(NODEPROTO*, UINTBIG);
void           us_checkdatabase(INTSML);
void           us_cleanupfacet(NODEPROTO*);
void           us_clearhighlightcount(void);
void           us_clearwindow(WINDOWPART*);
char          *us_commandvarname(INTSML);
NODEPROTO     *us_convertfacet(NODEPROTO*, TECHNOLOGY*);
void           us_copylisttofacet(GEOM**, NODEPROTO*, NODEPROTO*, INTSML, INTSML);
void           us_copyobjects(WINDOWPART*);
NODEPROTO     *us_copyrecursively(NODEPROTO*, char*, LIBRARY*, VIEW*, INTSML, char*);
INTSML         us_copyvars(INTBIG fromaddr, INTBIG fromtype, INTBIG toaddr, INTBIG totype);
void           us_coverimplant(void);
INTSML         us_cursoroverhigh(HIGHLIGHT*, INTBIG, INTBIG, WINDOWPART*);
void           us_cutobjects(WINDOWPART*);
void           us_delfacetmessage(NODEPROTO*);
INTSML         us_delhighlight(HIGHLIGHT*);
void           us_delnodeprotocenter(NODEPROTO*);
INTSML         us_demandxy(INTBIG*, INTBIG*);
void           us_describecontents(NODEINST*);
char          *us_describefont(INTBIG);
char          *us_describemenunode(COMMANDBINDING *commandbinding);
char          *us_describeportbits(PORTPROTO*);
char          *us_describestyle(INTBIG);
char          *us_describetextdescript(INTBIG);
void           us_docommands(FILE*, INTSML, char*);
void           us_doexpand(NODEINST*, INTSML, INTSML);
void           us_dofillet(void);
void           us_dopeek(INTBIG, INTBIG, INTBIG, INTBIG, NODEPROTO*, WINDOWPART*);
void           us_doubchanges(void);
void           us_dounexpand(NODEINST*);
INTSML         us_drawarcinst(ARCINST*, INTSML, XARRAY, INTSML, WINDOWPART*);
void           us_drawdispwindowsliders(WINDOWPART *w);
INTSML         us_drawfacet(NODEINST*, INTSML, XARRAY, INTSML, WINDOWPART*);
void           us_drawmenu(INTSML, WINDOWFRAME*);
void           us_drawmenuentry(INTBIG, INTBIG, char*);
INTSML         us_drawnodeinst(NODEINST*, INTSML, XARRAY, INTSML, WINDOWPART*);
void           us_drawwindow(WINDOWPART*, INTSML);
void           us_editvariabletext(VARIABLE*, INTBIG, INTBIG, char*);
void           us_endchanges(WINDOWPART*);
void           us_ensurewindow(NODEPROTO*);
void           us_erasegeometry(NODEPROTO*);
void           us_erasenodeinst(NODEINST*);
INTSML         us_erasepassthru(NODEINST*, INTSML);
void           us_erasescreen(WINDOWFRAME*);
void           us_erasewindow(WINDOWPART*);
INTSML         us_evaluatevariable(char*, INTBIG*, INTBIG*, char**);
void           us_execute(USERCOM*, INTBIG, INTSML, INTSML);
INTSML         us_expandaddrtypearray(INTBIG*, INTBIG**, INTBIG**, INTBIG);
void           us_expandttybuffers(INTSML);
INTSML         us_facetedithandler(WINDOWPART*, INTSML);
INTBIG         us_figuregrabpoint(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void           us_figuretechopaque(TECHNOLOGY*);
INTBIG         us_figurevariableplace(INTBIG, INTSML, char*[]);
INTSML         us_fillcomcomp(USERCOM*, COMCOMP*[]);
void           us_findlowerport(NODEINST**, PORTPROTO**);
void           us_findobject(INTBIG, INTBIG, WINDOWPART*, HIGHLIGHT*, INTSML, INTSML, INTSML, INTSML, INTSML);
void           us_forceeditchanges(void);
void           us_freebindingparse(COMMANDBINDING *commandbinding);
void           us_freecomekmemory(void);
void           us_freecomtvmemory(void);
void           us_freediacommemory(void);
void           us_freeeditor(EDITOR*);
void           us_freeedtecpmemory(void);
void           us_freehighmemory(void);
void           us_freemiscmemory(void);
void           us_freenetmemory(void);
void           us_freeparsememory(void);
void           us_freewindowmemory(void);
void           us_freestatusmemory(void);
void           us_freeusercom(USERCOM*);
void           us_fullview(NODEPROTO*, INTBIG*, INTBIG*, INTBIG*, INTBIG*);
INTBIG        *us_getallhighlighted(void);
NODEPROTO     *us_getareabounds(INTBIG*, INTBIG*, INTBIG*, INTBIG*);
GEOM          *us_getclosest(INTBIG, INTBIG, NODEPROTO*);
void           us_getcolormap(TECHNOLOGY*, INTSML, INTSML);
INTSML         us_getcolormapentry(char*, INTSML);
COMCOMP       *us_getcomcompfromkeyword(char *keyword);
GEOM         **us_gethighlighted(INTSML);
void           us_gethightextcenter(HIGHLIGHT*, INTBIG*, INTBIG*, INTSML*);
void           us_getlowleft(NODEINST*, INTBIG*, INTBIG*);
VARIABLE      *us_getmacro(char*);
MACROPACK     *us_getmacropack(char*);
UINTBIG        us_getobject(INTSML, INTSML);
HIGHLIGHT     *us_getonehighlight(void);
INTSML         us_getonesnappoint(INTBIG *x, INTBIG *y);
POPUPMENU     *us_getpopupmenu(char*);
void           us_getquickkeylist(INTBIG *quickkeycount, char ***quickkeylist);
void           us_getslide(INTSML, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG*, INTBIG*);
void           us_getsnappoint(HIGHLIGHT*, INTBIG*, INTBIG*);
INTBIG         us_gettextposition(char*);
INTBIG         us_gettextsize(char*, INTBIG);
INTSML         us_gettwoobjects(GEOM**, PORTPROTO**, GEOM**, PORTPROTO**);
INTSML         us_getvar(char*, INTBIG*, INTBIG*, char**, INTSML*, INTSML*);
void           us_graphfacets(void);
void           us_gridset(WINDOWPART*, INTBIG);
INTSML         us_hasotherwindowpart(INTBIG x, INTBIG y, WINDOWPART *ow);
void           us_highlighteverywhere(GEOM*, PORTPROTO*, INTSML, INTSML, INTSML, INTSML);
void           us_highlightmenu(INTBIG, INTBIG, INTSML);
void           us_highlightwindow(WINDOWPART*, INTSML);
void           us_hsvtorgb(float, float, float, INTBIG*, INTBIG*, INTBIG*);
void           us_identifyports(NODEINST*, NODEPROTO*, INTSML);
void           us_illustratecommandset(void);
INTSML         us_initialbinding(void);
void           us_initlayerletters(void);
void           us_initpulldownmenu(POPUPMENU*);
void           us_initstatus(void);
INTSML         us_islasteval(INTSML);
char          *us_keyname(INTSML);
void           us_killcurrentwindow(INTSML);
void           us_killwindowpickanother(WINDOWPART*);
char          *us_layerletters(TECHNOLOGY*, INTSML);
void           us_layouttext(char *layer, char *font, INTBIG scale, char *msg);
INTBIG         us_makearcuserbits(ARCPROTO*);
USERCOM       *us_makecommand(char*);
char          *us_makefacetline(NODEPROTO*, INTSML);
INTSML         us_makehighlight(char*, HIGHLIGHT*);
char          *us_makehighlightstring(HIGHLIGHT*);
NODEPROTO     *us_makeiconfacet(PORTPROTO*, char*, char*, TECHNOLOGY*, LIBRARY*);
void           us_makenewportproto(NODEPROTO*, NODEINST*, PORTPROTO*, char*, INTBIG, INTBIG, INTBIG);
INTSML         us_makescreen(INTBIG*, INTBIG*, INTBIG*, INTBIG*, WINDOWPART*);
void           us_maketextpoly(char*, WINDOWPART*, INTBIG, INTBIG, GEOM*, INTBIG, POLYGON*);
void           us_manhattantravel(NODEINST*, INTSML);
void           us_manymove(GEOM**, NODEINST**, INTSML, INTBIG, INTBIG);
INTSML         us_modarcbits(INTSML, INTSML, char*, GEOM**);
void           us_modifytextdescript(HIGHLIGHT*, INTBIG);
void           us_movetext(HIGHLIGHT*, INTSML, char*[]);
NODEPROTO     *us_needfacet(void);
INTSML         us_needwindow(void);
void           us_nettravel(NODEINST*, INTBIG);
MACROPACK     *us_newmacropack(char*);
char          *us_nextparse(void);
char          *us_nextvars(void);
INTSML         us_nulldisplayroutine(POLYGON*, WINDOWPART*);
INTSML         us_pagetword(INTSML(*)(COMCOMP**, INTSML*), void(*)(char*), void(*)(void), void(*)(void), INTSML);
void           us_parsebinding(char*, COMMANDBINDING*);
INTSML         us_parsecommand(char*, char*[]);
void           us_pasteobjects(WINDOWPART*);
NODEINST      *us_pickhigherinstance(NODEPROTO *inp);
INTSML         us_pophighlight(INTSML);
POPUPMENUITEM *us_popupmenu(POPUPMENU**, INTSML*, INTSML, INTSML, INTSML, INTSML);
PORTPROTO     *us_portdetails(PORTPROTO*, INTSML, char*[], NODEINST*, INTBIG*, INTBIG*, INTSML, char*);
void           us_portsynchronize(LIBRARY*);
INTSML         us_preventloss(LIBRARY*, char*, INTSML);
void           us_printarcaidinfo(ARCINST*);
void           us_printcolorvalue(INTSML);
void           us_printmacro(VARIABLE*);
void           us_printmacros(void);
void           us_printnodeaidinfo(NODEINST*);
void           us_printtechnology(TECHNOLOGY*);
void           us_pushhighlight(void);
char          *us_putintoinfstr(char *str);
void           us_queueopaque(GEOM*, INTSML);
void           us_queueredraw(GEOM*, INTSML);
void           us_redisplay(WINDOWPART*);
void           us_redisplaynow(WINDOWPART*, INTSML);
void           us_redostatus(WINDOWFRAME*);
INTSML         us_reexportport(PORTPROTO*, NODEINST*);
void           us_regridfacet(void);
char          *us_removeampersand(char *name);
void           us_removegetfacets(void);
void           us_removeubchange(NODEPROTO*);
void           us_renameport(PORTPROTO*, char*);
NODEINST      *us_replacenodeinst(NODEINST *oldni, NODEPROTO *newnp);
void           us_rgbtohsv(INTSML, INTSML, INTSML, float*, float*, float*);
INTBIG         us_rotatedescript(GEOM*, INTBIG);
INTBIG         us_rotatedescriptI(GEOM*, INTBIG);
ARCINST       *us_runarcinst(NODEINST*, PORTPROTO*, INTBIG, INTBIG, NODEINST*, PORTPROTO*, INTBIG, INTBIG, ARCPROTO*, INTBIG);
void           us_scaletowindow(INTBIG*, INTBIG*, WINDOWPART*);
void           us_scaletraceinfo(NODEINST*, INTBIG, INTBIG, INTBIG, INTBIG);
void           us_scanforkeyequiv(POPUPMENU*);
void           us_selectsnap(HIGHLIGHT*, INTBIG, INTBIG);
void           us_setaid(INTSML, char*[], INTSML);
void           us_setalignment(WINDOWFRAME*);
void           us_setarcname(ARCINST*, char*);
void           us_setarcproto(ARCPROTO*, INTSML);
void           us_setcolorentry(INTSML, INTSML, INTSML, INTSML, INTSML, INTSML);
void           us_setcursorpos(WINDOWFRAME*, INTBIG, INTBIG);
INTBIG         us_setdescriptoffset(INTBIG, INTBIG, INTBIG);
void           us_setfacetname(WINDOWPART*);
void           us_setfacetsize(WINDOWPART*);
void           us_setfind(HIGHLIGHT*, INTSML, INTSML, INTSML, INTSML);
void           us_setgridsize(WINDOWPART*);
void           us_sethighlight(HIGHLIGHT*, INTSML);
void           us_setkeyequiv(POPUPMENU*, INTSML);
void           us_setlambda(WINDOWFRAME*);
void           us_setmenunodearcs(void);
INTSML         us_setmenusize(INTSML, INTSML, INTSML, INTSML);
void           us_setmultiplehighlight(char*, INTSML);
void           us_setnodeangle(WINDOWFRAME*);
void           us_setnodeproto(NODEPROTO*);
void           us_setnodeprotocenter(INTBIG, INTBIG, NODEPROTO*);
void           us_settechname(WINDOWFRAME*);
void           us_settrace(NODEINST*, INTBIG*, INTSML);
INTSML         us_setunexpand(NODEINST*, INTSML);
void           us_setwindowsimulation(WINDOWPART*, INTSML);
INTSML         us_setxy(INTSML, INTSML);
void           us_shadowarcproto(WINDOWFRAME*, ARCPROTO*);
void           us_shadownodeproto(WINDOWFRAME*, NODEPROTO*);
void           us_showallhighlight(void);
void           us_showcurrentarcproto(void);
void           us_showcurrentnodeproto(void);
void           us_shownetworkname(WINDOWFRAME*);
INTSML         us_showpoly(POLYGON*, WINDOWPART*);
void           us_slideleft(INTBIG);
void           us_slideup(INTBIG);
NODEPROTO    **us_sortlib(LIBRARY*, char*, INTSML);
WINDOWPART    *us_splitcurrentwindow(INTSML, INTSML);
void           us_spreadrotateconnection(NODEINST *theni);
void           us_squarescreen(WINDOWPART*, WINDOWPART*, INTSML, INTBIG*, INTBIG*, INTBIG*, INTBIG*);
INTBIG         us_stretchtonodes(ARCPROTO *typ, INTBIG wid, NODEINST *ni1, PORTPROTO *pp1, INTBIG otherx, INTBIG othery);
char          *us_stripampersand(char*);
WINDOWPART    *us_subwindow(INTBIG, INTBIG, INTBIG, INTBIG, WINDOWPART*);
void           us_switchtofacet(NODEPROTO*, INTBIG, INTBIG, INTBIG, INTBIG, NODEINST*, PORTPROTO*, INTSML, INTSML);
void           us_switchtolibrary(LIBRARY*);
void           us_tecedaddfunstring(INTBIG);
void           us_tecedentry(INTSML, char*[]);
INTSML         us_tecedgetoption(NODEINST*);
char          *us_techname(NODEPROTO *np);
char          *us_tempoptionslibraryname(void);
void           us_termpulldownmenu(POPUPMENU*);
void           us_textfacetchanges(WINDOWPART*, INTSML, char*, char*, INTBIG);
INTSML         us_topofallthings(char**);
INTSML         us_topofarcnodes(char**);
INTSML         us_topofarcs(char**);
INTSML         us_topofcellfacets(char**);
INTSML         us_topofcommands(char**);
INTSML         us_topofconstraints(char**);
INTSML         us_topofcports(char**);
INTSML         us_topofedtecarc(char**);
INTSML         us_topofedteclay(char**);
INTSML         us_topofedtecnode(char**);
INTSML         us_topofexpports(char**);
INTSML         us_topoffacets(char**);
INTSML         us_topofhighlight(char**);
INTSML         us_topoflayers(char**);
INTSML         us_topofmacros(char**);
INTSML         us_topofmbuttons(char**);
INTSML         us_topofnodes(char**);
INTSML         us_topofpopupmenu(char**);
INTSML         us_topofports(char**);
INTSML         us_topofprims(char**);
INTSML         us_topofvars(char**);
INTSML         us_topofwindows(char**);
void           us_undisplayobject(GEOM*);
void           us_undoportproto(NODEINST*, PORTPROTO*);
char          *us_uniqueportname(char*, NODEPROTO*);
void           us_unknowncommand(void);
void           us_unqueueredraw(LIBRARY *lib);
void           us_varchanges(WINDOWPART*, INTSML, char*, char*, INTBIG);
char          *us_variableattributes(VARIABLE*, INTSML);
char          *us_variabletypename(INTBIG);
INTBIG         us_variabletypevalue(char*);
WINDOWPART    *us_wantnewwindow(INTSML orientation);
void           us_wanttoread(char*);
INTBIG         us_widestarcinst(ARCPROTO*, NODEINST*, PORTPROTO*);
INTSML         us_windowcansplit(WINDOWPART*, WINDOWPART*, WINDOWPART*);
void           us_windowfit(WINDOWFRAME*, INTSML, INTSML);
void           us_yankonenode(NODEINST*);

/* terminal interface */
void           us_ttyclose(void);
void           us_ttyinit(void);
void           us_ttyprint(INTSML, char*, va_list);
INTSML         us_specialparse(char*, COMCOMP*, INTSML, char *paramstart[]);

/* the status bar */
STATUSFIELD   *ttydeclarestatusfield(INTSML line, INTSML startper, INTSML endper, char *label);
void           ttyfreestatusfield(STATUSFIELD *field);
void           ttysetstatusfield(WINDOWFRAME *frame, STATUSFIELD *field, char *message, INTSML cancrop);
INTSML         ttynumstatuslines(void);

/* popup and pulldown menus */
INTSML         nativemenuload(INTSML, char*[]);
void           nativemenurename(POPUPMENU*, INTSML);
INTSML         nativepopupmenu(POPUPMENU *menu, INTSML header, INTSML left, INTSML top);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
