/*
 * Electric(tm) VLSI Design System
 *
 * File: config.h
 * Site-dependent definitions
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#ifndef _CONFIG_H_
#define _CONFIG_H_ 1

/********************* MACHINE DETERMINATION *********************/

/* determine if it is Macintosh OS */
#if defined(THINK_C) || defined(THINK_CPLUS) || defined(__MWERKS__)
#  define MACOS 1
#endif

/* determine if it is Windows 9x/NT */
#if (defined(_WIN32) || defined(__WIN32__)) && !defined(WIN32)
#  define WIN32 1
#endif

/* determine if it is UNIX */
#if !defined(MACOS) && !defined(WIN32)
#  define ONUNIX 1
#endif

/********************* MACHINE-SPECIFIC DEFINES *********************/

#ifdef	MACOS						/***** Macintosh *****/
#  include <QDOffscreen.h>
#  define STDC_HEADERS     1
#  define DIRSEP           ':'						/* directory separator */
#  define NONFILECH        '|'						/* character that cannot be in file name */
#  define CADRCFILENAME    "cadrc"					/* CAD startup file */
#  define ELECTRICLOG      "electric.log"			/* log file during run */
#  define ELECTRICLOGSAVE  "electriclast.log"		/* log file after standard exit */
#  define OPTIONSFILE      "electricoptions.elib"	/* where options are saved */
#  define LIBDIR           ":lib:"					/* location of library files */
#  define SORTLOC          ""
#  define ESIMLOC          ""
#  define RSIMLOC          ""
#  define PRESIMLOC        ""
#  define RNLLOC           ""
#  define SPICELOC         ""
#  define FLATDRCLOC       ""
#  define SFLATDRCLOC      ""
#  define HUGEINT          0x7FFFFFFF				/* largest possible integer */
   typedef          long   INTBIG;					/* at least 32 bits, can hold address */
   typedef          short  INTSML;					/* at least 16 bits */
   typedef unsigned long  UINTBIG;					/* at least 32 bits, can hold address */
   typedef unsigned short UINTSML;					/* at least 16 bits */
#endif

#ifdef WIN32						/***** Windows *****/
#  include "windows.h"
#  define STDC_HEADERS     1
#  define DIRSEP           '\\'						/* directory separator */
#  define NONFILECH        '|'						/* character that cannot be in file name */
#  define CADRCFILENAME    "cadrc"					/* CAD startup file */
#  define ELECTRICLOG      "electric.log"			/* log file during run */
#  define ELECTRICLOGSAVE  "electriclast.log"		/* log file after standard exit */
#  define OPTIONSFILE      "electricoptions.elib"	/* where options are saved */
#  define LIBDIR           "lib\\"					/* location of library files */
#  define SORTLOC          ""
#  define ESIMLOC          ""
#  define RSIMLOC          ""
#  define PRESIMLOC        ""
#  define RNLLOC           ""
#  define SPICELOC         ""
#  define FLATDRCLOC       ""
#  define SFLATDRCLOC      ""
#  undef TECHNOLOGY
#  define HUGEINT          0x7FFFFFFF				/* largest possible integer */
   typedef LONG            INTBIG;					/* at least 32 bits, can hold address */
   typedef SHORT           INTSML;					/* at least 16 bits */
   typedef ULONG          UINTBIG;					/* at least 32 bits, can hold address */
   typedef USHORT         UINTSML;					/* at least 16 bits */
#endif

#ifdef ONUNIX						/***** UNIX *****/
#  include "defines.h"
#  include <X11/Intrinsic.h>
#  define DIRSEP           '/'						/* directory separator */
#  define NONFILECH        '?'						/* character that cannot be in file name */
#  define CADRCFILENAME    ".cadrc"					/* CAD startup file */
#  define ELECTRICLOG      ".electric.log"			/* log file during run */
#  define ELECTRICLOGSAVE  ".electriclast.log"		/* log file after standard exit */
#  define OPTIONSFILE      ".electricoptions.elib"	/* where options are saved */
#  define LIBDIR           "lib/"					/* location of library files */
#  define SORTLOC          "/usr/bin/sort"
#  define ESIMLOC          "/usr/local/bin/esim"
#  define RSIMLOC          "/usr/local/bin/rsim"
#  define PRESIMLOC        "/usr/local/bin/presim"
#  define RNLLOC           "/usr/local/bin/rnl"
#  define SPICELOC         "/usr/local/bin/spice"
#  define FLATDRCLOC       "/usr/local/bin/ffindshort"
#  define SFLATDRCLOC      "/usr/local/bin/findshort"
#  define HUGEINT          0x7FFFFFFF				/* largest possible integer */
   typedef          long   INTBIG;					/* at least 32 bits, can hold address */
   typedef          short  INTSML;					/* at least 16 bits */
   typedef unsigned long  UINTBIG;					/* at least 32 bits, can hold address */
   typedef unsigned short UINTSML;					/* at least 16 bits */
#endif

/********************* DETERMINE CONFIGURATION *********************/

/*
 * There are two different source configurations available,
 * all defined externally when compiling Electric:
 *
 * EGNU     GNU release
 * EVE      Full VLSI system
 */
#ifdef EVE
#  undef  EVE
#  define EVE 1
#else
#  define EVE 0
#endif

/* if not a full release, then it is for GNU */
#if EVE == 0
#  define EGNU 1
#else
#  define EGNU 0
#endif

/********************* SOURCE MODULE CONFIGURATION *********************/

/* The tools (User and I/O are always enabled) */
#define COMAID             ( EGNU | EVE )
#define COMPENAID          ( EGNU | EVE )
#define DRCAID             ( EGNU | EVE )
#define ERCAID             ( EGNU | EVE )
#define LOGEFFAID          ( EGNU | EVE )
#define MAPPERAID          (   0  |  0  )
#define PLAAID             ( EGNU | EVE )
#define PROJECTAID         ( EGNU | EVE )
#define ROUTAID            ( EGNU | EVE )
#define SCAID              ( EGNU | EVE )
#define SIMAID             ( EGNU | EVE )
#define VHDLAID            ( EGNU | EVE )

/* The I/O modules (Binary, Text, and printer formats are always enabled) */
#define IOCIF              ( EGNU | EVE )
#define IODEF              (   0  | EVE | FORCECADENCE)
#define IODXF              ( EGNU | EVE )
#define IOEDIF             ( EGNU | EVE )
#define IOGDS              ( EGNU | EVE )
#define IOL                ( EGNU | EVE )
#define IOLEF              (   0  | EVE | FORCECADENCE)
#define IOSDF              ( EGNU | EVE )
#define IOSKILL            (   0  | EVE | FORCECADENCE)
#define IOSUE              ( EGNU | EVE )

/* The technologies (Artwork, Generic and Schematic are always enabled) */
#define TECBICMOS          ( EGNU | EVE )
#define TECBIPOLAR         ( EGNU | EVE )
#define TECCMOS            ( EGNU | EVE )
#define TECCMOSDODN        ( EGNU | EVE )
#define TECEFIDO           ( EGNU | EVE )
#define TECFPGA            ( EGNU | EVE )
#define TECGEM             ( EGNU | EVE )
#define TECMOCMOS          ( EGNU | EVE )
#define TECMOCMOSSUB       ( EGNU | EVE )
#define TECMOCMOS2         ( EGNU | EVE )
#define TECNCMOS3          (   0  | EVE )
#define TECNMOS            ( EGNU | EVE )
#define TECPCB             ( EGNU | EVE )
#define TECRCMOS           ( EGNU | EVE )

/* The language interfaces */
#define LANGJAVA           (   0  |  0  | FORCEJAVA)
#define LANGLISP           (   0  | EVE | FORCELISP)
#define LANGTCL            (   0  | EVE | FORCETCL)

#endif  /* _CONFIG_H_ - at top */
