/* CDA pp. 135 - 138, 171 - 174, 176 - 177
 * Here we fit loglinear models in table 6.3 on p. 172
 */
#include <dap.h>

double loglin(double lambda[7], double class[3]);

void main()
{
  infile("cda171.dat", " ")
    {
      double def, vic, pen, n;
      input("def vic pen n");
      outset("cda171", "");
      skip(1);
      while (step())
        output();
    }
  {
    double lambda[7];
    int l;
 
    for (l = 0; l < 7; l++)
      lambda[l] = 0.0;
  
    title("(DV, P) vs (D, V, P)\nParameters: mu D V P DV DP VP");
    categ("cda171", "n def vic pen", &loglin, lambda, "1111?00", "");
    sort("cda171.cat", "def vic _type_ pen", "");
    table("cda171.cat.srt", "def vic", "_type_ pen n", "s6.2 30", "");
  
    title("(DV, VP) vs (DV, P)\nParameters: mu D V P DV DP VP");
    categ("cda171", "n def vic pen", &loglin, lambda, "111110?", "");
    sort("cda171.cat", "def vic _type_ pen", "");
    table("cda171.cat.srt", "def vic", "_type_ pen n", "s6.2 30", "");
  
    title("(DV, DP, VP) vs (DV, VP)\nParameters: mu D V P DV DP VP");
    categ("cda171", "n def vic pen", &loglin, lambda, "11111?1", "");
    sort("cda171.cat", "def vic _type_ pen", "");
    table("cda171.cat.srt", "def vic", "_type_ pen n", "s6.2 30", "");
  }
}

/* The parameters of the loglinear model are:
 * lambda[0] = mu
 * lambda[1] = lambda^D_0
 * lambda[2] = lambda^V_0
 * lambda[3] = lambda^P_0
 * lambda[4] = lambda^DV_00
 * lambda[5] = lambda^DP_00
 * lambda[6] = lambda^VP_00
 */
double loglin(double lambda[7], double class[3])
{
  double logp;
  int v, w;
  int l;

  for (logp = lambda[0], v = 0, l = 1; v < 3; v++)
    {
      if (class[v] == 0.0)
        logp += lambda[l];
      else
        logp += -lambda[l];
      l++;
    }
  for (v = 0; v < 3; v++)
    for (w = v + 1; w < 3; w++)
      {
        if ( !( ((int) (class[v] + class[w])) % 2 ) )
          logp += lambda[l];
        else
          logp -= lambda[l];
        l++;
      }
  return exp(logp);
}
