/* translation of file(s)
	"bpel-abstract.k"
	"bpel-unparse-petri.k"
	"bpel-unparse-xml.k"
	"bpel-unparse-cfg.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.8 (C) 1998-2003 Humboldt-University of Berlin $
 */
#define KC_UNPARSE

#include <stdio.h>
#include <string>
#include <stdlib.h>
#include "bpel-kc-k.h"
#include "bpel-kc-unpk.h"


namespace kc {
base_uview_class base_uview;
petrinet_class petrinet;
xml_class xml;
cfg_class cfg;

impl_uviews uviews[] = {
    {"base_uview",&base_uview},
    {"petrinet",&petrinet},
    {"xml",&xml},
    {"cfg",&cfg},
    {0,0}
};

} // namespace kc
namespace kc { }
using namespace kc;
/* included stuff */
#line 71 "bpel-unparse-petri.k"
/* These lines are from bpel-unparse-petri.k */
#include <iostream>
#include "petrinet.h"
#include "check-symbols.h"
#include "symbol-table.h"
#include "options.h"
#include "bpel-unparse-tools.h"

using namespace std;

// introduced in main.c
extern PetriNet *TheNet;

// introduced in bpel-syntax.y
extern SymbolTable symTab;
extern SymbolManager symMan;

/// prefix of the current scope (read by the stop pattern and used to direct
/// failures to the correct fault_in place)
string currentScope;


#line  61 "bpel-kc-unpk.cc"
#line 72 "bpel-unparse-xml.k"
/* These lines are from bpel-unparse-xml.k */
#include <iostream>
#include "bpel-unparse-tools.h"

#line  67 "bpel-kc-unpk.cc"
#line 68 "bpel-unparse-cfg.k"

#include "cfg.h"
#include "helpers.h"
#include <map>

extern CFGBlock * TheCFG;

map <std::string, CFGBlock *> cfgMap;


#line  79 "bpel-kc-unpk.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void
impl_abstract_phylum::unparse(printer_function opf, uview uv)
{
    printer_functor_function_wrapper pf(opf);
    do_unparse(pf, uv);
}

// Everything given as a pointer is expected to have an unparse-method (we
// believe it's a phylum), unless there's a specialisation for it

void
unparse(abstract_phylum kc_p, printer_functor kc_printer, uview kc_current_view)
{
    kc_p->unparse(kc_printer, kc_current_view);
}

void
unparse(void *kc_p, printer_functor kc_printer, uview kc_current_view)
{
    // MPi: 20020628 there shouldn't be any left
    assertionFailed("Unparse called for untyped pointer");
    // MPi: cast should be unnecessary, but there are still void*
    reinterpret_cast<impl_abstract_phylum*>(kc_p)->unparse(kc_printer, kc_current_view);
}

void
unparse(int kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_integer(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(double kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_real(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(kc_char_t *kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v, kc_current_view);
}

void
unparse(kc_string_t kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v.c_str(), kc_current_view);
}

#line  142 "bpel-kc-unpk.cc"
void
impl_abstract_phylum::default_unparse(printer_functor kc_printer, uview kc_current_view)
{
    register int no_sons = operator_info[prod_sel()].no_sons;
    for (int i=0; i < no_sons; i++)
    subphylum(i)->unparse(kc_printer, kc_current_view);
}

void
impl_casestring__Str::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_nocasestring_NoCaseStr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_integer__Int::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_real__Real::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_voidptr__VoidPtr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(pointer, kc_printer, kc_current_view);
}


#line  182 "bpel-kc-unpk.cc"
void
impl_tProcess_Process::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 86 "bpel-unparse-cfg.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 86 "bpel-unparse-cfg.k"
		const tPartner_list b = this->tPartner_list_1;
#line 86 "bpel-unparse-cfg.k"
		const tVariable_list c = this->tVariable_list_1;
#line 86 "bpel-unparse-cfg.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 86 "bpel-unparse-cfg.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 86 "bpel-unparse-cfg.k"
		const tCompensationHandler f = this->tCompensationHandler_1;
#line 86 "bpel-unparse-cfg.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 86 "bpel-unparse-cfg.k"
		const tStop h = this->tStop_1;
#line 86 "bpel-unparse-cfg.k"
		const activity i = this->activity_1;
#line 87 "bpel-unparse-cfg.k"


		TheCFG = new CFGProcess(this->id);
		cfgMap[intToString(this->id->value)] = TheCFG; 

#line  214 "bpel-kc-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 93 "bpel-unparse-cfg.k"

		TheCFG->nextBlock = cfgMap.find(intToString(i->id->value))->second;
		(cfgMap.find(intToString(i->id->value))->second)->prevBlock = TheCFG;

#line  221 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 98 "bpel-unparse-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 98 "bpel-unparse-xml.k"
		const tPartner_list b = this->tPartner_list_1;
#line 98 "bpel-unparse-xml.k"
		const tVariable_list c = this->tVariable_list_1;
#line 98 "bpel-unparse-xml.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 98 "bpel-unparse-xml.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 98 "bpel-unparse-xml.k"
		const tCompensationHandler f = this->tCompensationHandler_1;
#line 98 "bpel-unparse-xml.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 98 "bpel-unparse-xml.k"
		const tStop h = this->tStop_1;
#line 98 "bpel-unparse-xml.k"
		const activity i = this->activity_1;
#line 99 "bpel-unparse-xml.k"
		inup(); 
#line  248 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<process id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
#line 101 "bpel-unparse-xml.k"
		if (a->length() == 0) 
#line  254 "bpel-kc-unpk.cc"
		{
		}
#line 103 "bpel-unparse-xml.k"
		else 
#line  259 "bpel-kc-unpk.cc"
		{
#line 104 "bpel-unparse-xml.k"
		    inup(); 
#line  263 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("<partnerLinks>\n"), kc_current_view); }
		    kc::unparse(a, kc_printer, kc_current_view);
#line 104 "bpel-unparse-xml.k"
		    indown(); 
#line  268 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("</partnerLinks>\n"), kc_current_view); }
		}
#line 106 "bpel-unparse-xml.k"
		if (b->length() == 0) 
#line  273 "bpel-kc-unpk.cc"
		{
		}
#line 108 "bpel-unparse-xml.k"
		else 
#line  278 "bpel-kc-unpk.cc"
		{
#line 109 "bpel-unparse-xml.k"
		    inup(); 
#line  282 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("<partners>\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 109 "bpel-unparse-xml.k"
		    indown(); 
#line  287 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("</partners>\n"), kc_current_view); }
		}
#line 111 "bpel-unparse-xml.k"
		if (c->length() == 0) 
#line  292 "bpel-kc-unpk.cc"
		{
		}
#line 113 "bpel-unparse-xml.k"
		else 
#line  297 "bpel-kc-unpk.cc"
		{
#line 114 "bpel-unparse-xml.k"
		    inup(); 
#line  301 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("<variables>\n"), kc_current_view); }
		    kc::unparse(c, kc_printer, kc_current_view);
#line 114 "bpel-unparse-xml.k"
		    indown(); 
#line  306 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
#line 116 "bpel-unparse-xml.k"
		if (d->length() == 0) 
#line  311 "bpel-kc-unpk.cc"
		{
		}
#line 118 "bpel-unparse-xml.k"
		else 
#line  316 "bpel-kc-unpk.cc"
		{
#line 119 "bpel-unparse-xml.k"
		    inup(); 
#line  320 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("<correlationSets>\n"), kc_current_view); }
		    kc::unparse(d, kc_printer, kc_current_view);
#line 119 "bpel-unparse-xml.k"
		    indown(); 
#line  325 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("</correlationSets>\n"), kc_current_view); }
		}
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(h, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 121 "bpel-unparse-xml.k"
		indown(); 
#line  335 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</process>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 107 "bpel-unparse-petri.k"
		const tProcess This = this/**/;
#line 107 "bpel-unparse-petri.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 107 "bpel-unparse-petri.k"
		const tPartner_list b = this->tPartner_list_1;
#line 107 "bpel-unparse-petri.k"
		const tVariable_list c = this->tVariable_list_1;
#line 107 "bpel-unparse-petri.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 107 "bpel-unparse-petri.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 107 "bpel-unparse-petri.k"
		const tCompensationHandler f = this->tCompensationHandler_1;
#line 107 "bpel-unparse-petri.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 107 "bpel-unparse-petri.k"
		const tStop h = this->tStop_1;
#line 107 "bpel-unparse-petri.k"
		const activity i = this->activity_1;
#line 109 "bpel-unparse-petri.k"

		trace(TRACE_INFORMATION, "Generating Petri net...\n");
		header(This->id, true);

		string prefix = intToString(This->id->value) + ".internal.";
		currentScope = prefix;
		SymbolScope *me = symMan.getScope(this->id);





		for (set<string>::iterator in = symMan.inChannels.begin(); in != symMan.inChannels.end(); in++)
		TheNet->newPlace("in." + *in, IN);
		for (set<string>::iterator out = symMan.outChannels.begin(); out != symMan.outChannels.end(); out++)
		TheNet->newPlace("out." + *out, OUT);



		for (list<SymbolScope *>::iterator child = me->children.begin(); child != me->children.end(); child++)
		{
		    TheNet->newPlace( intToString((*child)->id->value) + ".push");
		    TheNet->newPlace( intToString((*child)->id->value) + ".!push");
		}





		for (list<string>::iterator link = symMan.links.begin(); link != symMan.links.end(); link++)
		{
		    TheNet->newPlace("link." + *link);
		    TheNet->newPlace("!link." + *link);
		}



		for (list<string>::iterator variable = symMan.variables.begin(); variable != symMan.variables.end(); variable++)
		{
		    Place *v = TheNet->newPlace("variable." + *variable);
		    v->mark();
		}



		Place *clock = TheNet->newPlace(prefix + "clock");
		clock->mark();



		Place *p1 = TheNet->newPlace(prefix + "initial");
		p1->mark();


		Place *p3  = TheNet->newPlace(prefix + "scopeCompensated");
		Place *p5  = TheNet->newPlace(prefix + "upperFH");
		Place *p6  = TheNet->newPlace(prefix + "upperTerminate");
		Place *p7  = TheNet->newPlace(prefix + "Active");
		Place *p8  = TheNet->newPlace(prefix + "!Completed");
		Place *p9  = TheNet->newPlace(prefix + "Completed");
		Place *p10 = TheNet->newPlace(prefix + "!Compensated");
		Place *p11 = TheNet->newPlace(prefix + "!Active");
		Place *p12 = TheNet->newPlace(prefix + "Compensated");
		Place *p13 = TheNet->newPlace(prefix + "!Ended");
		Place *p14 = TheNet->newPlace(prefix + "Ended");
		Place *p15 = TheNet->newPlace(prefix + "!Faulted");
		Place *p16 = TheNet->newPlace(prefix + "Faulted");
		Place *p17 = TheNet->newPlace(prefix + "!Terminated");
		Place *p18 = TheNet->newPlace(prefix + "Terminated");
		Place *p19 = TheNet->newPlace(prefix + "p19");
		Place *p20 = TheNet->newPlace(prefix + "p20");
		Place *p21 = TheNet->newPlace(prefix + "p21");
		Place *p22 = TheNet->newPlace(prefix + "p22");
		Place *p33 = TheNet->newPlace(prefix + "p33");
		Place *p34 = TheNet->newPlace(prefix + "p34");
		Place *p35 = TheNet->newPlace(prefix + "p35");
		Place *p36 = TheNet->newPlace(prefix + "p36");
		Place *p37 = TheNet->newPlace(prefix + "fault");
		Place *p38 = TheNet->newPlace(prefix + "faultSave");
		Place *p39 = TheNet->newPlace(prefix + "final");
		Place *p40 = TheNet->newPlace(prefix + "rethrow");
		Place *p41 = TheNet->newPlace(prefix + "p41");
		Place *p42 = TheNet->newPlace(prefix + "ch_out");






		Place *fh_faulted = TheNet->newPlace(prefix + "FHFaulted");
		Place *fh_not_faulted = TheNet->newPlace(prefix + "!FHFaulted");
		Place *ch_faulted = TheNet->newPlace(prefix + "CHFaulted");
		Place *ch_not_faulted = TheNet->newPlace(prefix + "!CHFaulted");








		if (parameters[P_FINISHLOOP])
		{
		    Transition *process_loop = TheNet->newTransition(prefix + "finishloop");
		    TheNet->newArc(p39, process_loop, READ);
		}



		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p1, t2);
		TheNet->newArc(t2, p7);
		TheNet->newArc(t2, p8);
		TheNet->newArc(t2, p10);
		TheNet->newArc(t2, p13);
		TheNet->newArc(t2, p15);
		TheNet->newArc(t2, p17);
		TheNet->newArc(t2, p19);
		TheNet->newArc(t2, fh_not_faulted);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p7, t4);
		TheNet->newArc(p8, t4);
		TheNet->newArc(t4, p9);
		TheNet->newArc(t4, p11);
		TheNet->newArc(p33, t4);
		TheNet->newArc(t4, p39);





		if (This->hasEH)
		{
		    Place *p23 = TheNet->newPlace(prefix + "p23");
		    Place *p24 = TheNet->newPlace(prefix + "p24");
		    Place *p25 = TheNet->newPlace(prefix + "p25");
		    Place *p26 = TheNet->newPlace(prefix + "p26");
		    Place *p27 = TheNet->newPlace(prefix + "p27");

		    TheNet->newArc(t2, p23);
		    TheNet->newArc(p25, t4);

		    Transition *t1 = TheNet->newTransition(prefix + "t1");
		    TheNet->newArc(p27, t1);
		    TheNet->newArc(t1, p34);

		    Transition *t3 = TheNet->newTransition(prefix + "t3");
		    TheNet->newArc(p20, t3);
		    TheNet->newArc(t3, p33);
		    TheNet->newArc(t3, p24);

		    Transition *t5 = TheNet->newTransition(prefix + "t5");
		    TheNet->newArc(p22, t5);
		    TheNet->newArc(t5, p26);

		    Transition *t6 = TheNet->newTransition(prefix + "t6");
		    TheNet->newArc(t6, p26);
		    TheNet->newArc(p21, t6);
		    TheNet->newArc(p33, t6);
		}
		else
		{
		    TheNet->mergePlaces(p20, p33);
		    TheNet->mergePlaces(p22, p34);
		}

#line  531 "bpel-kc-unpk.cc"
		kc::unparse(h, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 281 "bpel-unparse-petri.k"




		for (list<SymbolScope*>::iterator child = me->children.begin(); child != me->children.end(); child++)
		TheNet->newArc(t2, TheNet->findPlace( intToString((*child)->id->value) + ".!push" ));



		for (list<string>::iterator link = symMan.links.begin(); link != symMan.links.end(); link++)
		TheNet->newArc(t2, TheNet->findPlace("!link." + *link));



		TheNet->mergePlaces("1.internal.fault",     "1.internal.faultHandler.fault");
		TheNet->mergePlaces("1.internal.faultSave", "1.internal.faultHandler.faultSave");
		TheNet->mergePlaces("1.internal.rethrow",   "1.internal.faultHandler.rethrow");
		TheNet->mergePlaces("1.internal.!Ended",    "1.internal.faultHandler.!Ended");
		TheNet->mergePlaces("1.internal.Ended",     "1.internal.faultHandler.Ended");
		TheNet->mergePlaces("1.internal.p41",       "1.internal.faultHandler.ch_fh");
		TheNet->mergePlaces("1.internal.ch_out",    "1.internal.faultHandler.ch_out");
		TheNet->mergePlaces("1.internal.final",     "1.internal.faultHandler.final");



		TheNet->mergePlaces("1.internal.Completed",        "1.internal.compensationHandler.Completed");
		TheNet->mergePlaces("1.internal.!Completed",       "1.internal.compensationHandler.!Completed");
		TheNet->mergePlaces("1.internal.Compensated",      "1.internal.compensationHandler.Compensated");
		TheNet->mergePlaces("1.internal.p41",              "1.internal.compensationHandler.fh");
		TheNet->mergePlaces("1.internal.scopeCompensated", "1.internal.compensationHandler.scopeCompensated");
		TheNet->mergePlaces("1.internal.p34",              "1.internal.compensationHandler.clean");
		TheNet->mergePlaces("1.internal.p35",              "1.internal.compensationHandler.cleaned");
		TheNet->mergePlaces("1.internal.ch_out",           "1.internal.compensationHandler.ch_out");



		if (This->hasEH)
		{
		    TheNet->mergePlaces("1.internal.p23",      "1.internal.eventHandler.initial");
		    TheNet->mergePlaces("1.internal.p24",      "1.internal.eventHandler.finish");
		    TheNet->mergePlaces("1.internal.p25",      "1.internal.eventHandler.final");
		    TheNet->mergePlaces("1.internal.p26",      "1.internal.eventHandler.stop");
		    TheNet->mergePlaces("1.internal.p27",      "1.internal.eventHandler.stopped");
		}



		TheNet->mergePlaces("1.internal.Faulted",        "1.internal.stop.Faulted");
		TheNet->mergePlaces("1.internal.upperFH",        "1.internal.stop.fault_in");
		TheNet->mergePlaces("1.internal.fault",          "1.internal.stop.fault");
		TheNet->mergePlaces("1.internal.faultSave",      "1.internal.stop.faultSave");
		TheNet->mergePlaces("1.internal.Active",         "1.internal.stop.Active");
		TheNet->mergePlaces("1.internal.!Active",        "1.internal.stop.!Active");
		TheNet->mergePlaces("1.internal.final",          "1.internal.stop.final");
		TheNet->mergePlaces("1.internal.upperTerminate", "1.internal.stop.terminate");
		TheNet->mergePlaces("1.internal.!Faulted",       "1.internal.stop.!Faulted");
		TheNet->mergePlaces("1.internal.rethrow",        "1.internal.stop.rethrow");
		TheNet->mergePlaces("1.internal.Ended",          "1.internal.stop.Ended");
		TheNet->mergePlaces("1.internal.Compensated",    "1.internal.stop.Compensated");
		TheNet->mergePlaces("1.internal.!Ended",         "1.internal.stop.!Ended");
		TheNet->mergePlaces("1.internal.p21",            "1.internal.stop.stop");
		TheNet->mergePlaces("1.internal.p34",            "1.internal.stop.stopped");
		TheNet->mergePlaces("1.internal.p35",            "1.internal.stop.cleanCH");
		TheNet->mergePlaces("1.internal.p36",            "1.internal.stop.ch_cleaned");
		TheNet->mergePlaces("1.internal.FHFaulted",      "1.internal.stop.FHFaulted");
		TheNet->mergePlaces("1.internal.!FHFaulted",     "1.internal.stop.!FHFaulted");
		TheNet->mergePlaces("1.internal.CHFaulted",      "1.internal.stop.CHFaulted");
		TheNet->mergePlaces("1.internal.!CHFaulted",     "1.internal.stop.!CHFaulted");



		TheNet->mergePlaces(TheNet->findPlace("1.internal.p19"), TheNet->findPlace(i, ".initial"));
		TheNet->mergePlaces(TheNet->findPlace("1.internal.p20"), TheNet->findPlace(i, ".final"));
		TheNet->mergePlaces(TheNet->findPlace("1.internal.p21"), TheNet->findPlace(i, ".stop"));
		TheNet->mergePlaces(TheNet->findPlace("1.internal.p22"), TheNet->findPlace(i, ".stopped"));

		footer(This->id, true);
		trace(TRACE_INFORMATION, "Generating Petri net complete.\n");

#line  617 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  622 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  635 "bpel-kc-unpk.cc"
void
impl_tStop_StopInScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 510 "bpel-unparse-petri.k"

		string prefix = currentScope + "stop.";
		trace(TRACE_DEBUG, "[PNU]" + inString() + "<stopPatternInsideScope scope=\"" + currentScope + "\">\n");

		Place *p1 =  TheNet->newPlace(prefix + "ft_in");
		Place *p2 =  TheNet->newPlace(prefix + "p2");
		Place *p3 =  TheNet->newPlace(prefix + "ftSave");
		Place *p4 =  TheNet->newPlace(prefix + "ft");
		Place *p5 =  TheNet->newPlace(prefix + "Faulted");
		Place *p6 =  TheNet->newPlace(prefix + "p6");
		Place *p7 =  TheNet->newPlace(prefix + "p7");
		Place *p8 =  TheNet->newPlace(prefix + "p8");
		Place *p9 =  TheNet->newPlace(prefix + "!Faulted");
		Place *p10 = TheNet->newPlace(prefix + "fault_in");
		Place *p11 = TheNet->newPlace(prefix + "p11");
		Place *p12 = TheNet->newPlace(prefix + "fault");
		Place *p13 = TheNet->newPlace(prefix + "faultSave");
		Place *p14 = TheNet->newPlace(prefix + "Active");
		Place *p15 = TheNet->newPlace(prefix + "terminate_up");
		Place *p16 = TheNet->newPlace(prefix + "p16");
		Place *p17 = TheNet->newPlace(prefix + "stopped_s");
		Place *p18 = TheNet->newPlace(prefix + "!Active");
		Place *p19 = TheNet->newPlace(prefix + "p19");
		Place *p20 = TheNet->newPlace(prefix + "upperTerminate");
		Place *p21 = TheNet->newPlace(prefix + "terminate");
		Place *p22 = TheNet->newPlace(prefix + "Ended");
		Place *p23 = TheNet->newPlace(prefix + "rethrow");
		Place *p24 = TheNet->newPlace(prefix + "Compensated");
		Place *p25 = TheNet->newPlace(prefix + "p25");
		Place *p26 = TheNet->newPlace(prefix + "p26");
		Place *p27 = TheNet->newPlace(prefix + "upperFH");
		Place *p28 = TheNet->newPlace(prefix + "!Ended");
		Place *p29 = TheNet->newPlace(prefix + "stop");
		Place *p30 = TheNet->newPlace(prefix + "stopped");
		Place *p31 = TheNet->newPlace(prefix + "cleanCH");
		Place *p32 = TheNet->newPlace(prefix + "ch_cleaned");
		Place *fh_faulted = TheNet->newPlace(prefix + "FHFaulted");
		Place *fh_not_faulted = TheNet->newPlace(prefix + "!FHFaulted");
		Place *fh_fault_in = TheNet->newPlace(prefix + "fh_fault_in"); 
		Place *ch_faulted = TheNet->newPlace(prefix + "CHFaulted");
		Place *ch_not_faulted = TheNet->newPlace(prefix + "!CHFaulted");
		Place *ch_fault_in = TheNet->newPlace(prefix + "ch_fault_in"); 

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);
		TheNet->newArc(t1, p6);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);
		TheNet->newArc(t2, p4);
		TheNet->newArc(t2, p5);
		TheNet->newArc(p8, t2);
		TheNet->newArc(p9, t2);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(p5, t3, READ);
		TheNet->newArc(fh_fault_in, t3);
		TheNet->newArc(t3, p23);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p6, t4);
		TheNet->newArc(t4, p7);
		TheNet->newArc(t4, p29);

		Transition *t5 = TheNet->newTransition(prefix + "t5");
		TheNet->newArc(p7, t5);
		TheNet->newArc(t5, p8);
		TheNet->newArc(p30, t5);

		Transition *t6 = TheNet->newTransition(prefix + "t6");
		TheNet->newArc(t6, p6);
		TheNet->newArc(p10, t6);
		TheNet->newArc(t6, p11);

		Transition *t7 = TheNet->newTransition(prefix + "t7");
		TheNet->newArc(t7, p5);
		TheNet->newArc(p8, t7);
		TheNet->newArc(p9, t7);
		TheNet->newArc(p11, t7);
		TheNet->newArc(t7, p12);
		TheNet->newArc(t7, p13);

		Transition *t8 = TheNet->newTransition(prefix + "t8");
		TheNet->newArc(t8, p6);
		TheNet->newArc(p15, t8);
		TheNet->newArc(t8, p16);

		Transition *t9 = TheNet->newTransition(prefix + "t9");
		TheNet->newArc(p8, t9);
		TheNet->newArc(p16, t9);
		TheNet->newArc(t9, p17);
		TheNet->newArc(t9, p22);
		TheNet->newArc(p28, t9);

		Transition *t10 = TheNet->newTransition(prefix + "t10");
		TheNet->newArc(t10, p6);
		TheNet->newArc(p14, t10);
		TheNet->newArc(t10, p19);
		TheNet->newArc(t10, p18);
		TheNet->newArc(p21, t10);

		Transition *t11 = TheNet->newTransition(prefix + "t11");
		TheNet->newArc(p8, t11);
		TheNet->newArc(p19, t11);
		TheNet->newArc(t11, p20);
		TheNet->newArc(t11, p22);
		TheNet->newArc(p28, t11);

		Transition *t12 = TheNet->newTransition(prefix + "t12");
		TheNet->newArc(p18, t12, READ);
		TheNet->newArc(p21, t12);
		TheNet->newArc(t12, p20);

		Transition *t14 = TheNet->newTransition(prefix + "faultInCH");
		TheNet->newArc(ch_fault_in, t14);
		TheNet->newArc(p24, t14, READ);
		TheNet->newArc(t14, p26);
		TheNet->newArc(p28, t14);
		TheNet->newArc(t14, p31);

		Transition *t16 = TheNet->newTransition(prefix + "t16");
		TheNet->newArc(t16, p22);
		TheNet->newArc(p26, t16);
		TheNet->newArc(t16, p27);
		TheNet->newArc(p32, t16);

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</stopPatternInsideScope scope=\"" + currentScope + "\">\n");

#line  774 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  779 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  791 "bpel-kc-unpk.cc"
void
impl_tStop_StopInProcess::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 400 "bpel-unparse-petri.k"

		string prefix = "1.internal.stop.";
		trace(TRACE_DEBUG, "[PNU]" + inString() + "<stopPatternInsideProcess>\n");

		Place *p1  = TheNet->newPlace(prefix + "Faulted");
		Place *p2  = TheNet->newPlace(prefix + "p2");
		Place *p3  = TheNet->newPlace(prefix + "p3");
		Place *p4  = TheNet->newPlace(prefix + "p4");
		Place *p5  = TheNet->newPlace(prefix + "fault_in");
		Place *p6  = TheNet->newPlace(prefix + "p6");
		Place *p7  = TheNet->newPlace(prefix + "fault");
		Place *p8  = TheNet->newPlace(prefix + "faultSave");
		Place *p9  = TheNet->newPlace(prefix + "Active");
		Place *p10 = TheNet->newPlace(prefix + "!Active");
		Place *p11 = TheNet->newPlace(prefix + "p11");
		Place *p12 = TheNet->newPlace(prefix + "final");
		Place *p13 = TheNet->newPlace(prefix + "terminate");
		Place *p14 = TheNet->newPlace(prefix + "!Faulted");
		Place *p15 = TheNet->newPlace(prefix + "rethrow");
		Place *p16 = TheNet->newPlace(prefix + "Ended");
		Place *p17 = TheNet->newPlace(prefix + "Compensated");
		Place *p19 = TheNet->newPlace(prefix + "p19");
		Place *p20 = TheNet->newPlace(prefix + "!Ended");
		Place *p21 = TheNet->newPlace(prefix + "stop");
		Place *p22 = TheNet->newPlace(prefix + "stopped");
		Place *p23 = TheNet->newPlace(prefix + "cleanCH");
		Place *p24 = TheNet->newPlace(prefix + "ch_cleaned");
		Place *fh_faulted = TheNet->newPlace(prefix + "FHFaulted");
		Place *fh_not_faulted = TheNet->newPlace(prefix + "!FHFaulted");
		Place *fh_fault_in = TheNet->newPlace(prefix + "fh_fault_in");  
		Place *ch_faulted = TheNet->newPlace(prefix + "CHFaulted");
		Place *ch_not_faulted = TheNet->newPlace(prefix + "!CHFaulted");
		Place *ch_fault_in = TheNet->newPlace(prefix + "ch_fault_in");  

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1, READ);
		TheNet->newArc(fh_fault_in, t1);
		TheNet->newArc(t1, p15);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);
		TheNet->newArc(t2, p21);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(p3, t3);
		TheNet->newArc(p22, t3);

		Transition *t4 =  TheNet->newTransition(prefix + "t4");
		TheNet->newArc(t3, p4);
		TheNet->newArc(p5, t4);
		TheNet->newArc(t4, p2);
		TheNet->newArc(t4, p6);

		Transition *t5 = TheNet->newTransition(prefix + "t5");
		TheNet->newArc(p4, t5);
		TheNet->newArc(p6, t5);
		TheNet->newArc(p14, t5);
		TheNet->newArc(t5, p1);
		TheNet->newArc(t5, p7);
		TheNet->newArc(t5, p8);

		Transition *t6 = TheNet->newTransition(prefix + "t6");
		TheNet->newArc(p9, t6);
		TheNet->newArc(p13, t6);
		TheNet->newArc(t6, p2);
		TheNet->newArc(t6, p10);
		TheNet->newArc(t6, p11);

		Transition *t7 = TheNet->newTransition(prefix + "t7");
		TheNet->newArc(p4, t7);
		TheNet->newArc(p11, t7);
		TheNet->newArc(p20, t7);
		TheNet->newArc(t7, p12);
		TheNet->newArc(t7, p16);

		Transition *t8 = TheNet->newTransition(prefix + "t8");
		TheNet->newArc(p10, t8, READ);
		TheNet->newArc(p13, t8);

		Transition *t10 = TheNet->newTransition(prefix + "t10");
		TheNet->newArc(ch_fault_in, t10);
		TheNet->newArc(p17, t10, READ);
		TheNet->newArc(p20, t10);
		TheNet->newArc(t10, p19);
		TheNet->newArc(t10, p23);

		Transition *t12 = TheNet->newTransition(prefix + "t12");
		TheNet->newArc(p19, t12);
		TheNet->newArc(p24, t12);
		TheNet->newArc(t12, p16);
		TheNet->newArc(t12, p12);

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</stopPatternInsideProcess>\n");

#line  895 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  900 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  912 "bpel-kc-unpk.cc"
void
impl_activity_activityCompensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  918 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  931 "bpel-kc-unpk.cc"
void
impl_activity_activityScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  937 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  950 "bpel-kc-unpk.cc"
void
impl_activity_activityPick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((this->tPick_1->prod_sel() == sel_Pick)) {
#line 3084 "bpel-unparse-petri.k"
		const activity TheActivity = this/**/;
#line 3084 "bpel-unparse-petri.k"
		const tPick This = this->tPick_1;
#line 3084 "bpel-unparse-petri.k"
		const standardElements a = phylum_cast<const impl_tPick_Pick*>(this->tPick_1)->standardElements_1;
#line 3084 "bpel-unparse-petri.k"
		const tOnMessage_list b = phylum_cast<const impl_tPick_Pick*>(this->tPick_1)->tOnMessage_list_1;
#line 3084 "bpel-unparse-petri.k"
		const tOnAlarm_list c = phylum_cast<const impl_tPick_Pick*>(this->tPick_1)->tOnAlarm_list_1;
#line 3086 "bpel-unparse-petri.k"

		header(This->id, true);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p5 = TheNet->newPlace(prefix + "final");
		Place *p6 = TheNet->newPlace(prefix + "initial");
		Place *p7 = TheNet->newPlace(prefix + "TimeStamp");
		Place *p11 = TheNet->newPlace(prefix + "stop");
		Place *p12 = TheNet->newPlace(prefix + "stopped");


		Transition *t5 = TheNet->newTransition(prefix + "t5");
		TheNet->newArc(TheNet->findPlace("1.internal.clock"), t5, READ);
		TheNet->newArc(p6, t5);
		TheNet->newArc(t5, p7);



		Transition *t1 = NULL;
		if (This->dpe->value > 0)
		{
		    t1 = TheNet->newTransition(prefix + "t1");
		    Place *p1 = TheNet->newPlace(prefix + "negLink");
		    TheNet->newArc(p1, t1);
		}



		Transition *t7 = stop(p6, "initial", prefix);
		Transition *t8 = stop(p7, "TimeStamp", prefix);

#line  1000 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 3120 "bpel-unparse-petri.k"


		int onMessageCount = 1;
		{
#line 3123 "bpel-unparse-petri.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  1012 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 3123 "bpel-unparse-petri.k"
			    {
#line 3124 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 3124 "bpel-unparse-petri.k"
#line 3123 "bpel-unparse-petri.k"
				    const tOnMessage ThisBranch = kc_selvar_0_1;
#line 3123 "bpel-unparse-petri.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 3124 "bpel-unparse-petri.k"

				    trace(TRACE_DEBUG, "[PNU]\t\t<onMessage>\n");
				    string message = intToString(onMessageCount++);
				    string newPrefix = prefix + "onMessage" + message + ".";

				    Place *p3 = TheNet->newPlace(newPrefix + "p3");
				    Place *p10 = TheNet->newPlace(newPrefix + "p10");

				    Transition *t2 = TheNet->newTransition(newPrefix + "t2");
				    TheNet->newArc(TheNet->findPlace("in." + string(ThisBranch->channelID->name)), t2);
				    TheNet->newArc(TheNet->findPlace(TheActivity, ".internal.TimeStamp"), t2);
				    TheNet->newArc(t2, p3);

				    Transition *t3 = TheNet->newTransition(newPrefix + "t3");
				    TheNet->newArc(TheNet->findPlace("variable." + string(ThisBranch->variableID->name)), t3);
				    TheNet->newArc(t3, TheNet->findPlace("variable." + string(ThisBranch->variableID->name)));
				    TheNet->newArc(p3, t3);
				    TheNet->newArc(t3, TheNet->findPlace(innerActivity, ".initial"));



				    if (parameters[P_NOSTANDARDFAULTS] == false)
				    Transition *t4 = throwFault(p3, p10, "p3", newPrefix, This->negativeControlFlow);

				    Transition *t9  = stop(p3, "p3at" + message, prefix);
				    Transition *t10 = stop(p10, "p10at" + message, prefix);



				    TheNet->mergePlaces(TheActivity, ".stop",    innerActivity, ".stop");
				    TheNet->mergePlaces(TheActivity, ".stopped", innerActivity, ".stopped");
				    TheNet->mergePlaces(TheActivity, ".final",   innerActivity, ".final");

				    trace(TRACE_DEBUG, "[PNU]\t\t</onMessage>\n");

#line  1063 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1068 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 3123 "bpel-unparse-petri.k"

#line  1073 "bpel-kc-unpk.cc"
		    }
		}
#line 3159 "bpel-unparse-petri.k"



		int onAlarmCount = 1;
		{
#line 3163 "bpel-unparse-petri.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  1085 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 3163 "bpel-unparse-petri.k"
			    {
#line 3164 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 3164 "bpel-unparse-petri.k"
#line 3163 "bpel-unparse-petri.k"
				    const tOnAlarm onAlarmBranch = kc_selvar_0_1;
#line 3163 "bpel-unparse-petri.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 3164 "bpel-unparse-petri.k"

				    trace(TRACE_DEBUG, "[PNU]\t\t<onAlarm>\n");
				    string newPrefix = prefix + "onAlarm" + intToString(onAlarmCount++) + ".";
				    string onAlarmGuard;

				    if (onAlarmBranch->For != mkcasestring(""))
				    onAlarmGuard = "x + " + string(onAlarmBranch->For->name) + " \\<= y"; 
				    else
				    onAlarmGuard = string(onAlarmBranch->until->name) + " \\<= y"; 

				    Transition *t6 = TheNet->newTransition(newPrefix + "t6");
				    TheNet->newArc(TheNet->findPlace("1.internal.clock"), t6, READ);
				    TheNet->newArc(TheNet->findPlace(TheActivity, ".internal.TimeStamp"), t6);
				    TheNet->newArc(t6, TheNet->findPlace(innerActivity, ".initial"));



				    TheNet->mergePlaces(TheActivity, ".stop",    innerActivity, ".stop");
				    TheNet->mergePlaces(TheActivity, ".stopped", innerActivity, ".stopped");
				    TheNet->mergePlaces(TheActivity, ".final",   innerActivity, ".final");

				    trace(TRACE_DEBUG, "[PNU]\t\t</onAlarm>\n");

#line  1124 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1129 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 3163 "bpel-unparse-petri.k"

#line  1134 "bpel-kc-unpk.cc"
		    }
		}
#line 3187 "bpel-unparse-petri.k"







		int currentMessage = 1;
		{
#line 3195 "bpel-unparse-petri.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  1150 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 3195 "bpel-unparse-petri.k"
			    {
#line 3196 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 3196 "bpel-unparse-petri.k"
#line 3195 "bpel-unparse-petri.k"
				    const tOnMessage thisonmessage = kc_selvar_0_1;
#line 3195 "bpel-unparse-petri.k"
				    const activity innerActivity1 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 3196 "bpel-unparse-petri.k"

				    {
#line 3197 "bpel-unparse-petri.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  1171 "bpel-kc-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 3197 "bpel-unparse-petri.k"
						{
#line 3198 "bpel-unparse-petri.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 3198 "bpel-unparse-petri.k"
#line 3197 "bpel-unparse-petri.k"
							const tOnMessage otheronmessage = kc_selvar_1_1;
#line 3197 "bpel-unparse-petri.k"
							const activity innerActivity2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 3198 "bpel-unparse-petri.k"

							if ((innerActivity1 != innerActivity2) && (otheronmessage->dpe->value > 0))
							TheNet->newArc(TheNet->findTransition(prefix + "onMessage" + intToString(currentMessage) + ".t3"), TheNet->findPlace(innerActivity2, ".negLink"));

#line  1191 "bpel-kc-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  1196 "bpel-kc-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 3197 "bpel-unparse-petri.k"

#line  1201 "bpel-kc-unpk.cc"
					}
				    }
#line 3202 "bpel-unparse-petri.k"

				    {
#line 3203 "bpel-unparse-petri.k"
					tOnAlarm_list kc_fe_selvar_1 =  c;

#line  1210 "bpel-kc-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
					    ) {
					    tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
					    {
#line 3203 "bpel-unparse-petri.k"
						{
#line 3204 "bpel-unparse-petri.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 3204 "bpel-unparse-petri.k"
#line 3203 "bpel-unparse-petri.k"
							const tOnAlarm thisonalarm = kc_selvar_1_1;
#line 3203 "bpel-unparse-petri.k"
							const activity innerActivity2 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 3204 "bpel-unparse-petri.k"

							if (thisonalarm->dpe->value > 0)
							TheNet->newArc(TheNet->findTransition(prefix + "onMessage" + intToString(currentMessage) + ".t3"), TheNet->findPlace(innerActivity2, ".negLink"));

#line  1230 "bpel-kc-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  1235 "bpel-kc-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 3203 "bpel-unparse-petri.k"

#line  1240 "bpel-kc-unpk.cc"
					}
				    }
#line 3208 "bpel-unparse-petri.k"

				    currentMessage++;

				    if ((thisonmessage->dpe->value > 0) && (This->dpe->value > 0))
				    TheNet->newArc(t1, TheNet->findPlace(innerActivity1, ".negLink"));

#line  1250 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1255 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 3195 "bpel-unparse-petri.k"

#line  1260 "bpel-kc-unpk.cc"
		    }
		}
#line 3214 "bpel-unparse-petri.k"


		int currentAlarm = 1;
		{
#line 3217 "bpel-unparse-petri.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  1271 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 3217 "bpel-unparse-petri.k"
			    {
#line 3218 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 3218 "bpel-unparse-petri.k"
#line 3217 "bpel-unparse-petri.k"
				    const tOnAlarm thisonalarm = kc_selvar_0_1;
#line 3217 "bpel-unparse-petri.k"
				    const activity innerActivity1 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 3218 "bpel-unparse-petri.k"

				    {
#line 3219 "bpel-unparse-petri.k"
					tOnAlarm_list kc_fe_selvar_1 =  c;

#line  1292 "bpel-kc-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
					    ) {
					    tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
					    {
#line 3219 "bpel-unparse-petri.k"
						{
#line 3220 "bpel-unparse-petri.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 3220 "bpel-unparse-petri.k"
#line 3219 "bpel-unparse-petri.k"
							const tOnAlarm otheronalarm = kc_selvar_1_1;
#line 3219 "bpel-unparse-petri.k"
							const activity innerActivity2 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 3220 "bpel-unparse-petri.k"

							if ((innerActivity1 != innerActivity2) && (otheronalarm->dpe->value > 0))
							TheNet->newArc(TheNet->findTransition(prefix + "onAlarm" + intToString(currentAlarm) + ".t6"), TheNet->findPlace(innerActivity2, ".negLink"));

#line  1312 "bpel-kc-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  1317 "bpel-kc-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 3219 "bpel-unparse-petri.k"

#line  1322 "bpel-kc-unpk.cc"
					}
				    }
#line 3224 "bpel-unparse-petri.k"

				    {
#line 3225 "bpel-unparse-petri.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  1331 "bpel-kc-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 3225 "bpel-unparse-petri.k"
						{
#line 3226 "bpel-unparse-petri.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 3226 "bpel-unparse-petri.k"
#line 3225 "bpel-unparse-petri.k"
							const tOnMessage thisonmessage = kc_selvar_1_1;
#line 3225 "bpel-unparse-petri.k"
							const activity innerActivity2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 3226 "bpel-unparse-petri.k"

							if (thisonmessage->dpe->value > 0)
							TheNet->newArc(TheNet->findTransition(prefix + "onAlarm" + intToString(currentAlarm) + ".t6"), TheNet->findPlace(innerActivity2, ".negLink"));

#line  1351 "bpel-kc-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  1356 "bpel-kc-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 3225 "bpel-unparse-petri.k"

#line  1361 "bpel-kc-unpk.cc"
					}
				    }
#line 3230 "bpel-unparse-petri.k"

				    currentAlarm++;

				    if ((thisonalarm->dpe->value > 0) && (This->dpe->value > 0))
				    TheNet->newArc(t1, TheNet->findPlace(innerActivity1, ".negLink"));

#line  1371 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1376 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 3217 "bpel-unparse-petri.k"

#line  1381 "bpel-kc-unpk.cc"
		    }
		}
#line 3236 "bpel-unparse-petri.k"

		footer(This->id, true);

#line  1388 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  1394 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1408 "bpel-kc-unpk.cc"
void
impl_activity_activitySequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tSequence_1->prod_sel() == sel_Sequence)) {
#line 352 "bpel-unparse-xml.k"
		const standardElements a = phylum_cast<const impl_tSequence_Sequence*>(this->tSequence_1)->standardElements_1;
#line 352 "bpel-unparse-xml.k"
		const activity_list b = phylum_cast<const impl_tSequence_Sequence*>(this->tSequence_1)->activity_list_1;
#line 353 "bpel-unparse-xml.k"
		inup(); 
#line  1422 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<sequence id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 353 "bpel-unparse-xml.k"
		indown(); 
#line  1434 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</sequence>\n"), kc_current_view); }
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((this->tSequence_1->prod_sel() == sel_Sequence)) {
#line 3015 "bpel-unparse-petri.k"
		const activity This = this/**/;
#line 3015 "bpel-unparse-petri.k"
		const standardElements a = phylum_cast<const impl_tSequence_Sequence*>(this->tSequence_1)->standardElements_1;
#line 3015 "bpel-unparse-petri.k"
		const activity_list b = phylum_cast<const impl_tSequence_Sequence*>(this->tSequence_1)->activity_list_1;
#line 3017 "bpel-unparse-petri.k"

		header(This->id, true);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p2  = TheNet->newPlace(prefix + "initial");
		Place *p9  = TheNet->newPlace(prefix + "final");
		Place *p10 = TheNet->newPlace(prefix + "stop");
		Place *p11 = TheNet->newPlace(prefix + "stopped");



		Transition *t1 = NULL;
		if (This->dpe->value > 0)
		{
		    Place *p1  = TheNet->newPlace(prefix + "negLink");
		    t1 = TheNet->newTransition(prefix + "t1");
		    TheNet->newArc(p1, t1);
		}


#line  1470 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 3039 "bpel-unparse-petri.k"

		int activityCount = 1;
		kc::impl_activity* lastActivity;

		{
#line 3043 "bpel-unparse-petri.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  1482 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 3043 "bpel-unparse-petri.k"
			    {
				{
#line 3044 "bpel-unparse-petri.k"
#line 3043 "bpel-unparse-petri.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 3044 "bpel-unparse-petri.k"

				    if (activityCount == 1)
				    TheNet->mergePlaces(This, ".internal.initial", innerActivity, ".initial");
				    else
				    TheNet->mergePlaces(lastActivity, ".final", innerActivity, ".initial");

				    if (activityCount == b->length())
				    TheNet->mergePlaces(This, ".internal.final", innerActivity, ".final");



				    string newPrefix = intToString(innerActivity->id->value);
				    if (This->dpe->value > 0 && TheNet->findPlace(newPrefix + ".negLink") != NULL)
				    TheNet->newArc(t1, TheNet->findPlace(newPrefix + ".negLink"));


				    TheNet->mergePlaces(This, ".internal.stop", innerActivity, ".stop");
				    TheNet->mergePlaces(This, ".internal.stopped", innerActivity, ".stopped");

				    lastActivity = innerActivity;
				    activityCount++;

#line  1517 "bpel-kc-unpk.cc"
				}
			    }

#line  1521 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 3043 "bpel-unparse-petri.k"

#line  1526 "bpel-kc-unpk.cc"
		    }
		}
#line 3066 "bpel-unparse-petri.k"

		footer(This->id, true);

#line  1533 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  1539 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1553 "bpel-kc-unpk.cc"
void
impl_activity_activityWhile::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((this->tWhile_1->prod_sel() == sel_While)) {
#line 2930 "bpel-unparse-petri.k"
		const activity This = this/**/;
#line 2930 "bpel-unparse-petri.k"
		const tWhile TheWhile = this->tWhile_1;
#line 2930 "bpel-unparse-petri.k"
		const standardElements a = phylum_cast<const impl_tWhile_While*>(this->tWhile_1)->standardElements_1;
#line 2930 "bpel-unparse-petri.k"
		const activity b = phylum_cast<const impl_tWhile_While*>(this->tWhile_1)->activity_1;
#line 2932 "bpel-unparse-petri.k"

		header(This->id, true);
		string prefix = intToString(TheWhile->id->value) + ".internal.";
		string condition = string(TheWhile->condition->name);

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "running");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "p4");
		Place *p5 = TheNet->newPlace(prefix + "p5");
		Place *p6 = TheNet->newPlace(prefix + "p6");
		Place *p7 = TheNet->newPlace(prefix + "stop");
		Place *p8 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p2, t1);
		TheNet->newArc(t1, p3);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p1, t2);
		TheNet->newArc(t2, p2);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(p2, t3);
		TheNet->newArc(t3, p4);






		if (parameters[P_CYCLICWHILE] == true)
		{
		    Transition *t4 = TheNet->newTransition(prefix + "t4");
		    TheNet->newArc(t4, p1);
		    TheNet->newArc(p5, t4);
		}



		if (parameters[P_NOSTANDARDFAULTS] == false)
		Transition *t5 = throwFault(p2, p6, "running", prefix, This->negativeControlFlow);

		Transition *t6 = stop(p1, "initial", prefix);
		Transition *t7 = stop(p2, "running", prefix);
		Transition *t8 = stop(p6, "p6", prefix);
		Transition *t9 = stop(p3, "final", prefix);

#line  1618 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 2982 "bpel-unparse-petri.k"


		TheNet->mergePlaces(This, ".internal.p4",      b, ".initial");
		TheNet->mergePlaces(This, ".internal.p5",      b, ".final");
		TheNet->mergePlaces(This, ".internal.stop",    b, ".stop");
		TheNet->mergePlaces(This, ".internal.stopped", b, ".stopped");







		if (parameters[P_CYCLICWHILE] == false)
		TheNet->mergePlaces(This, ".internal.p5", This, ".internal.final");

		footer(This->id, true);

#line  1640 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  1646 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1660 "bpel-kc-unpk.cc"
void
impl_activity_activitySwitch::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((this->tSwitch_1->prod_sel() == sel_Switch) && (phylum_cast<const impl_tSwitch_Switch*>(this->tSwitch_1)->tOtherwise_1->prod_sel() == sel_Otherwise)) {
#line 2766 "bpel-unparse-petri.k"
		const activity This = this/**/;
#line 2766 "bpel-unparse-petri.k"
		const standardElements a = phylum_cast<const impl_tSwitch_Switch*>(this->tSwitch_1)->standardElements_1;
#line 2766 "bpel-unparse-petri.k"
		const tCase_list b = phylum_cast<const impl_tSwitch_Switch*>(this->tSwitch_1)->tCase_list_1;
#line 2766 "bpel-unparse-petri.k"
		const activity c = phylum_cast<const impl_tOtherwise_Otherwise*>(phylum_cast<const impl_tSwitch_Switch*>(this->tSwitch_1)->tOtherwise_1)->activity_1;
#line 2768 "bpel-unparse-petri.k"

		header(This->id, true);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p4 =  TheNet->newPlace(prefix + "final");
		Place *p5 =  TheNet->newPlace(prefix + "initial");
		Place *p6 =  TheNet->newPlace(prefix + "running");
		Place *p10 = TheNet->newPlace(prefix + "p10");
		Place *p11 = TheNet->newPlace(prefix + "stop");
		Place *p12 = TheNet->newPlace(prefix + "stopped");

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(p5, t3);
		TheNet->newArc(t3, p6);



		if (parameters[P_NOSTANDARDFAULTS] == false)
		Transition *t7 = throwFault(p6, p10, "running", prefix, This->negativeControlFlow);

		Transition *t8  = stop(p5, "initial", prefix);
		Transition *t9  = stop(p6, "running", prefix);
		Transition *t10 = stop(p10, "p10", prefix);



		Transition *t1 = NULL;
		if (This->dpe->value > 0)
		{
		    t1 = TheNet->newTransition(prefix + "t1");
		    Place *p1 = TheNet->newPlace(prefix + "negLink");
		    TheNet->newArc(p1, t1);
		}

#line  1711 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 2805 "bpel-unparse-petri.k"

		int currentCase = 1;
		Transition *last;
		{
#line 2808 "bpel-unparse-petri.k"
		    tCase_list kc_fe_selvar_1 =  b;

#line  1723 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCase_list
			) {
			tCase kc_selvar_0_1 = kc_fe_selvar_1->tCase_1;
			{
#line 2808 "bpel-unparse-petri.k"
			    {
#line 2809 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Case)) {
#line 2809 "bpel-unparse-petri.k"
#line 2808 "bpel-unparse-petri.k"
				    const tCase caseBranch = kc_selvar_0_1;
#line 2808 "bpel-unparse-petri.k"
				    const activity innerActivity = phylum_cast<const impl_tCase_Case*>(kc_selvar_0_1)->activity_1;
#line 2809 "bpel-unparse-petri.k"

				    string condition = caseBranch->condition->name;
				    string caseNumber = intToString(currentCase);

				    trace(TRACE_VERY_DEBUG, "[PNU]\tEmbedding case branch " + caseNumber + "...\n");


				    Transition *t2 = NULL;
				    Transition *t4 = NULL;

				    if (currentCase == 1)
				    {

					t2 = TheNet->newTransition(prefix + "t2.case1");
					t4 = TheNet->newTransition(prefix + "t4.case1");


					TheNet->newArc(TheNet->findPlace(This, ".internal.running"), t2);
					TheNet->newArc(TheNet->findPlace(This, ".internal.running"), t4);

					last = t4;
				    }
				    else
				    {

					t2 = TheNet->newTransition(prefix + "t2.case" + caseNumber);
					t4 = TheNet->newTransition(prefix + "t4.case" + caseNumber);


					Place *running =  TheNet->newPlace(prefix + "running.case" + caseNumber);
					TheNet->newArc(last, running);
					TheNet->newArc(running, t2);
					TheNet->newArc(running, t4);

					Transition *t11 = stop(running, "runningCase" + caseNumber, prefix);

					last = t4;
				    }


				    TheNet->newArc(t2, TheNet->findPlace(innerActivity, ".initial"));
				    TheNet->mergePlaces(This, ".internal.final",   innerActivity, ".final");
				    TheNet->mergePlaces(This, ".internal.stop",    innerActivity, ".stop");
				    TheNet->mergePlaces(This, ".internal.stopped", innerActivity, ".stopped");

				    currentCase++;

#line  1786 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1791 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCase_list_1;
#line 2808 "bpel-unparse-petri.k"

#line  1796 "bpel-kc-unpk.cc"
		    }
		}
#line 2856 "bpel-unparse-petri.k"


		trace(TRACE_VERY_DEBUG, "[PNU]\tEmbedding otherwise branch...\n");

		Transition *t2 = TheNet->newTransition(prefix + "t2.otherwise");


		Place *running = TheNet->newPlace(prefix + "running.otherwise");
		TheNet->newArc(running, t2);
		TheNet->newArc(last, running);

		Transition *tnoname = stop(running, "runningOtherwise", prefix);


		TheNet->newArc(t2, TheNet->findPlace(c, ".initial"));
		TheNet->mergePlaces(This, ".internal.final",   c, ".final");
		TheNet->mergePlaces(This, ".internal.stop",    c, ".stop");
		TheNet->mergePlaces(This, ".internal.stopped", c, ".stopped");








		currentCase = 1;
		{
#line 2883 "bpel-unparse-petri.k"
		    tCase_list kc_fe_selvar_1 =  b;

#line  1831 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCase_list
			) {
			tCase kc_selvar_0_1 = kc_fe_selvar_1->tCase_1;
			{
#line 2883 "bpel-unparse-petri.k"
			    {
#line 2884 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Case)) {
#line 2884 "bpel-unparse-petri.k"
#line 2883 "bpel-unparse-petri.k"
				    const tCase thisCaseBranch = kc_selvar_0_1;
#line 2883 "bpel-unparse-petri.k"
				    const activity innerActivity1 = phylum_cast<const impl_tCase_Case*>(kc_selvar_0_1)->activity_1;
#line 2884 "bpel-unparse-petri.k"

				    {
#line 2885 "bpel-unparse-petri.k"
					tCase_list kc_fe_selvar_1 =  b;

#line  1852 "bpel-kc-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstCase_list
					    ) {
					    tCase kc_selvar_1_1 = kc_fe_selvar_1->tCase_1;
					    {
#line 2885 "bpel-unparse-petri.k"
						{
#line 2886 "bpel-unparse-petri.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_Case)) {
#line 2886 "bpel-unparse-petri.k"
#line 2885 "bpel-unparse-petri.k"
							const tCase otherCaseBranch = kc_selvar_1_1;
#line 2885 "bpel-unparse-petri.k"
							const activity innerActivity2 = phylum_cast<const impl_tCase_Case*>(kc_selvar_1_1)->activity_1;
#line 2886 "bpel-unparse-petri.k"

							if ((innerActivity1 != innerActivity2) && (otherCaseBranch->dpe->value > 0))
							TheNet->newArc(TheNet->findTransition(prefix + "t2.case" + intToString(currentCase)), TheNet->findPlace(innerActivity2, ".negLink"));

							if (c->dpe->value > 0)
							TheNet->newArc(TheNet->findTransition(prefix + "t2.case" + intToString(currentCase)), TheNet->findPlace(c, ".negLink"));

#line  1875 "bpel-kc-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  1880 "bpel-kc-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tCase_list_1;
#line 2885 "bpel-unparse-petri.k"

#line  1885 "bpel-kc-unpk.cc"
					}
				    }
#line 2893 "bpel-unparse-petri.k"

				    if (thisCaseBranch->dpe->value > 0)
				    {
					TheNet->newArc(TheNet->findTransition(prefix + "t2.otherwise"), TheNet->findPlace(innerActivity1, ".negLink"));
				    }


				    currentCase++;

				    if ((This->dpe->value > 0) && (thisCaseBranch->dpe->value > 0))
				    TheNet->newArc(t1, TheNet->findPlace(innerActivity1, ".negLink"));

#line  1901 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1906 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCase_list_1;
#line 2883 "bpel-unparse-petri.k"

#line  1911 "bpel-kc-unpk.cc"
		    }
		}
#line 2905 "bpel-unparse-petri.k"

		footer(This->id, true);

#line  1918 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  1924 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1938 "bpel-kc-unpk.cc"
void
impl_activity_activityFlow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1944 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1957 "bpel-kc-unpk.cc"
void
impl_activity_activityTerminate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1963 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1976 "bpel-kc-unpk.cc"
void
impl_activity_activityThrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1982 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1995 "bpel-kc-unpk.cc"
void
impl_activity_activityWait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2001 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2014 "bpel-kc-unpk.cc"
void
impl_activity_activityAssign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2020 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2033 "bpel-kc-unpk.cc"
void
impl_activity_activityReply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2039 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2052 "bpel-kc-unpk.cc"
void
impl_activity_activityReceive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2058 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2071 "bpel-kc-unpk.cc"
void
impl_activity_activityInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2077 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2090 "bpel-kc-unpk.cc"
void
impl_activity_activityEmpty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2096 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  2116 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartnerLink_list iterator_ = this; iterator_->tPartnerLink_list_1 != 0; iterator_ = iterator_->tPartnerLink_list_1)
		    iterator_->tPartnerLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2134 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  2146 "bpel-kc-unpk.cc"
void
impl_tPartnerLink_PartnerLink::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 130 "bpel-unparse-xml.k"
		in(); 
#line  2156 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<partnerLink />\n"), kc_current_view); }
	    }
	    break;
	}

#line  2162 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  2181 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartner_list iterator_ = this; iterator_->tPartner_list_1 != 0; iterator_ = iterator_->tPartner_list_1)
		    iterator_->tPartner_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2199 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  2211 "bpel-kc-unpk.cc"
void
impl_tPartner_Partner::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 138 "bpel-unparse-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 139 "bpel-unparse-xml.k"
		inup(); 
#line  2223 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<partner>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 139 "bpel-unparse-xml.k"
		indown(); 
#line  2228 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</partner>\n"), kc_current_view); }
	    }
	    break;
	}

#line  2234 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2247 "bpel-kc-unpk.cc"
void
impl_tFaultHandlers_implicitFaultHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((KC_TRACE_PROVIDED((this/**/->inProcess), "bpel-unparse-petri.k", 810, this))) {
#line 810 "bpel-unparse-petri.k"
		const tFaultHandlers This = this/**/;
#line 812 "bpel-unparse-petri.k"

		string prefix = "1.internal.faultHandler.";
		trace(TRACE_DEBUG, "[PNU]" + inString() + "<implicitFaultHandlerInsideProcess>\n");

		Place *p1 =  TheNet->newPlace(prefix + "fault");
		Place *p2 =  TheNet->newPlace(prefix + "p2");
		Place *p3 =  TheNet->newPlace(prefix + "p3");
		Place *p4 =  TheNet->newPlace(prefix + "ch_fh");
		Place *p5 =  TheNet->newPlace(prefix + "ch_out");
		Place *p6 =  TheNet->newPlace(prefix + "p6");
		Place *p7 =  TheNet->newPlace(prefix + "faultSave");
		Place *p8 =  TheNet->newPlace(prefix + "p8");
		Place *p9 =  TheNet->newPlace(prefix + "final");
		Place *p10 = TheNet->newPlace(prefix + "rethrow");
		Place *p11 = TheNet->newPlace(prefix + "!Ended");
		Place *p12 = TheNet->newPlace(prefix + "Ended");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p2, t1);
		TheNet->newArc(p7, t1);
		TheNet->newArc(t1, p9);
		TheNet->newArc(p11, t1);
		TheNet->newArc(t1, p12);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(t2, p3);
		TheNet->newArc(p7, t2);
		TheNet->newArc(t2, p8);
		TheNet->newArc(p10, t2);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(p6, t3);
		TheNet->newArc(t3, p9);
		TheNet->newArc(p8, t3);
		TheNet->newArc(p11, t3);
		TheNet->newArc(t3, p12);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p10, t4);
		TheNet->newArc(p12, t4, READ);



		prefix += "compensate.";

		Place *compensate_p1 = TheNet->newPlace(prefix + "initial");
		Place *compensate_p2 = TheNet->newPlace(prefix + "running");
		Place *compensate_p3 = TheNet->newPlace(prefix + "final");
		Place *compensate_p4 = TheNet->newPlace(prefix + "stop");
		Place *compensate_p5 = TheNet->newPlace(prefix + "ch_fh");
		Place *compensate_p6 = TheNet->newPlace(prefix + "ch_out");
		Place *compensate_p7 = TheNet->newPlace(prefix + "stopped");

		Transition *compensate_t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(compensate_p1, compensate_t1);
		TheNet->newArc(compensate_t1, compensate_p2);
		TheNet->newArc(compensate_t1, compensate_p5);

		Transition *compensate_t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(compensate_p2, compensate_t2);
		TheNet->newArc(compensate_t2, compensate_p3);
		TheNet->newArc(compensate_p6, compensate_t2);

		Transition *compensate_t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(compensate_p1, compensate_t3);
		TheNet->newArc(compensate_p4, compensate_t3);
		TheNet->newArc(compensate_t3, compensate_p7);

		Transition *compensate_t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(compensate_p2, compensate_t4);
		TheNet->newArc(compensate_p4, compensate_t4);
		TheNet->newArc(compensate_t4, compensate_p7);

		Transition *compensate_t5 = TheNet->newTransition(prefix + "t5");
		TheNet->newArc(compensate_p2, compensate_t5);
		TheNet->newArc(compensate_p3, compensate_t5);
		TheNet->newArc(compensate_t5, compensate_p7);



		TheNet->mergePlaces(p1, compensate_p1);
		TheNet->mergePlaces(p2, compensate_p3);
		TheNet->mergePlaces(p3, compensate_p4);
		TheNet->mergePlaces(p4, compensate_p5);
		TheNet->mergePlaces(p5, compensate_p6);
		TheNet->mergePlaces(p6, compensate_p7);

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</implicitFaultHandlerInsideProcess>\n");

#line  2347 "bpel-kc-unpk.cc"
	    } else
		if ((KC_TRACE_PROVIDED((!this/**/->inProcess), "bpel-unparse-petri.k", 1144, this))) {
#line 1144 "bpel-unparse-petri.k"
		const tFaultHandlers This = this/**/;
#line 1146 "bpel-unparse-petri.k"

		string prefix = intToString(This->parentScopeId->value) + ".internal.faultHandler.";
		trace(TRACE_DEBUG, "[PNU]" + inString() + "<implicitFaultHandlerInsideScope scope=\"" + currentScope + "\">\n");

		Place *p1 =  TheNet->newPlace(prefix + "ft");
		Place *p1a = TheNet->newPlace(prefix + "fault");
		Place *p2 =  TheNet->newPlace(prefix + "p2");
		Place *p3 =  TheNet->newPlace(prefix + "p3");
		Place *p4 =  TheNet->newPlace(prefix + "ch_fh");
		Place *p5 =  TheNet->newPlace(prefix + "ch_out");
		Place *p6 =  TheNet->newPlace(prefix + "p6");
		Place *p7 =  TheNet->newPlace(prefix + "faultSave");
		Place *p8 =  TheNet->newPlace(prefix + "ftSave");
		Place *p9 =  TheNet->newPlace(prefix + "upperFH");
		Place *p10 = TheNet->newPlace(prefix + "trueOut");
		Place *p11 = TheNet->newPlace(prefix + "sourceFalse");
		Place *p12 = TheNet->newPlace(prefix + "p12");
		Place *p13 = TheNet->newPlace(prefix + "rethrow");
		Place *p14 = TheNet->newPlace(prefix + "stopped");
		Place *p15 = TheNet->newPlace(prefix + "falseOut");
		Place *p16 = TheNet->newPlace(prefix + "!Ended");
		Place *p17 = TheNet->newPlace(prefix + "Ended");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p2, t1);
		TheNet->newArc(p7, t1);
		TheNet->newArc(t1, p9);
		TheNet->newArc(t1, p10);
		TheNet->newArc(t1, p11);
		TheNet->newArc(p16, t1);
		TheNet->newArc(t1, p17);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(p8, t2);
		TheNet->newArc(t2, p10);
		TheNet->newArc(t2, p11);
		TheNet->newArc(t2, p14);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(t3, p3);
		TheNet->newArc(p7, t3);
		TheNet->newArc(t3, p12);
		TheNet->newArc(p13, t3);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p6, t4);
		TheNet->newArc(t4, p9);
		TheNet->newArc(t4, p11);
		TheNet->newArc(p12, t4);
		TheNet->newArc(t4, p15);
		TheNet->newArc(p16, t4);
		TheNet->newArc(t4, p17);

		Transition *t5 = TheNet->newTransition(prefix + "t5");
		TheNet->newArc(p8, t5, READ);
		TheNet->newArc(p13, t5);

		Transition *t6 = TheNet->newTransition(prefix + "t6");
		TheNet->newArc(p13, t6);
		TheNet->newArc(p17, t6, READ);



		string compensate_prefix = prefix + "compensate.";

		Place *compensate_p1 = TheNet->newPlace(compensate_prefix + "initial");
		Place *compensate_p2 = TheNet->newPlace(compensate_prefix + "running");
		Place *compensate_p3 = TheNet->newPlace(compensate_prefix + "final");
		Place *compensate_p4 = TheNet->newPlace(compensate_prefix + "stop");
		Place *compensate_p5 = TheNet->newPlace(compensate_prefix + "ch_fh");
		Place *compensate_p6 = TheNet->newPlace(compensate_prefix + "ch_out");
		Place *compensate_p7 = TheNet->newPlace(compensate_prefix + "stopped");

		Transition *compensate_t1 = TheNet->newTransition(compensate_prefix + "t1");
		TheNet->newArc(compensate_p1, compensate_t1);
		TheNet->newArc(compensate_t1, compensate_p2);
		TheNet->newArc(compensate_t1, compensate_p5);

		Transition *compensate_t2 = TheNet->newTransition(compensate_prefix + "t2");
		TheNet->newArc(compensate_p2, compensate_t2);
		TheNet->newArc(compensate_t2, compensate_p3);
		TheNet->newArc(compensate_p6, compensate_t2);

		Transition *compensate_t3 = TheNet->newTransition(compensate_prefix + "t3");
		TheNet->newArc(compensate_p1, compensate_t3);
		TheNet->newArc(compensate_p4, compensate_t3);
		TheNet->newArc(compensate_t3, compensate_p7);

		Transition *compensate_t4 = TheNet->newTransition(compensate_prefix + "t4");
		TheNet->newArc(compensate_p2, compensate_t4);
		TheNet->newArc(compensate_p4, compensate_t4);
		TheNet->newArc(compensate_t4, compensate_p7);

		Transition *compensate_t5 = TheNet->newTransition(compensate_prefix + "t5");
		TheNet->newArc(compensate_p2, compensate_t5);
		TheNet->newArc(compensate_p3, compensate_t5);
		TheNet->newArc(compensate_t5, compensate_p7);



		TheNet->mergePlaces(p1, compensate_p1);
		TheNet->mergePlaces(p2, compensate_p3);
		TheNet->mergePlaces(p3, compensate_p4);
		TheNet->mergePlaces(p4, compensate_p5);
		TheNet->mergePlaces(p5, compensate_p6);
		TheNet->mergePlaces(p6, compensate_p7);

		TheNet->mergePlaces(prefix + "ft", prefix + "fault");

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</implicitFaultHandlerInsideScope scope=\"" + currentScope + "\">\n");

#line  2465 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  2471 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  2484 "bpel-kc-unpk.cc"
void
impl_tFaultHandlers_userDefinedFaultHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 147 "bpel-unparse-xml.k"
		const tCatch_list a = this->tCatch_list_1;
#line 147 "bpel-unparse-xml.k"
		const tCatchAll b = this->tCatchAll_1;
#line 148 "bpel-unparse-xml.k"
		inup(); 
#line  2498 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<faultHandlers>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 148 "bpel-unparse-xml.k"
		indown(); 
#line  2504 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</faultHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((KC_TRACE_PROVIDED((this/**/->inProcess), "bpel-unparse-petri.k", 655, this))) {
#line 655 "bpel-unparse-petri.k"
		const tFaultHandlers This = this/**/;
#line 655 "bpel-unparse-petri.k"
		const tCatch_list a = this->tCatch_list_1;
#line 655 "bpel-unparse-petri.k"
		const tCatchAll b = this->tCatchAll_1;
#line 657 "bpel-unparse-petri.k"

		string prefix = "1.internal.faultHandler.";
		trace(TRACE_DEBUG, "[PNU]" + inString() + "<userDefinedFaultHandlerInsideProcess>\n");

		Place *p3 =  TheNet->newPlace(prefix + "final");
		Place *p4 =  TheNet->newPlace(prefix + "fault");
		Place *p7 =  TheNet->newPlace(prefix + "faultSave");
		Place *p8 =  TheNet->newPlace(prefix + "p8");
		Place *p9 =  TheNet->newPlace(prefix + "p9");
		Place *p11 = TheNet->newPlace(prefix + "p11");
		Place *p12 = TheNet->newPlace(prefix + "p12");
		Place *p13 = TheNet->newPlace(prefix + "rethrow");
		Place *p14 = TheNet->newPlace(prefix + "p14");
		Place *p15 = TheNet->newPlace(prefix + "Ended");
		Place *p16 = TheNet->newPlace(prefix + "!Ended");
		Place *p17 = TheNet->newPlace(prefix + "ch_fh");
		Place *p18 = TheNet->newPlace(prefix + "ch_out");

		Transition *t7 = TheNet->newTransition(prefix + "t7");
		TheNet->newArc(p7, t7);
		TheNet->newArc(t7, p11);
		TheNet->newArc(p13, t7);
		TheNet->newArc(t7, p14);

		Transition *t8 = TheNet->newTransition(prefix + "t8");
		TheNet->newArc(t8, p3);
		TheNet->newArc(p12, t8);
		TheNet->newArc(p14, t8);
		TheNet->newArc(t8, p15);
		TheNet->newArc(p16, t8);

		Transition *t9 = TheNet->newTransition(prefix + "t9");
		TheNet->newArc(p13, t9);
		TheNet->newArc(p15, t9, READ);



		if (!This->hasCatchAll)
		{
		    Transition *t5 = TheNet->newTransition(prefix + "t5");
		    TheNet->newArc(p4, t5);
		    TheNet->newArc(p7, t5, READ);
		    TheNet->newArc(t5, p8);

		    Transition *t6 = TheNet->newTransition(prefix + "t6");
		    TheNet->newArc(t6, p3);
		    TheNet->newArc(p7, t6);
		    TheNet->newArc(p9, t6);
		    TheNet->newArc(t6, p15);
		    TheNet->newArc(p16, t6);



		    string newPrefix = "1.internal.faultHandler.compensate.";

		    Place *compensate_p1 = TheNet->newPlace(newPrefix + "initial");
		    Place *compensate_p2 = TheNet->newPlace(newPrefix + "running");
		    Place *compensate_p3 = TheNet->newPlace(newPrefix + "final");
		    Place *compensate_p4 = TheNet->newPlace(newPrefix + "stop");
		    Place *compensate_p5 = TheNet->newPlace(newPrefix + "ch_fh");
		    Place *compensate_p6 = TheNet->newPlace(newPrefix + "ch_out");
		    Place *compensate_p7 = TheNet->newPlace(newPrefix + "stopped");

		    Transition *compensate_t1 = TheNet->newTransition(newPrefix + "t1");
		    TheNet->newArc(compensate_p1, compensate_t1);
		    TheNet->newArc(compensate_t1, compensate_p2);
		    TheNet->newArc(compensate_t1, compensate_p5);

		    Transition *compensate_t2 = TheNet->newTransition(newPrefix + "t2");
		    TheNet->newArc(compensate_p2, compensate_t2);
		    TheNet->newArc(compensate_t2, compensate_p3);
		    TheNet->newArc(compensate_p6, compensate_t2);

		    Transition *compensate_t3 = TheNet->newTransition(newPrefix + "t3");
		    TheNet->newArc(compensate_p1, compensate_t3);
		    TheNet->newArc(compensate_p4, compensate_t3);
		    TheNet->newArc(compensate_t3, compensate_p7);

		    Transition *compensate_t4 = TheNet->newTransition(newPrefix + "t4");
		    TheNet->newArc(compensate_p2, compensate_t4);
		    TheNet->newArc(compensate_p4, compensate_t4);
		    TheNet->newArc(compensate_t4, compensate_p7);

		    Transition *compensate_t5 = TheNet->newTransition(newPrefix + "t5");
		    TheNet->newArc(compensate_p2, compensate_t5);
		    TheNet->newArc(compensate_p3, compensate_t5);
		    TheNet->newArc(compensate_t5, compensate_p7);



		    TheNet->mergePlaces(p8,  compensate_p1);
		    TheNet->mergePlaces(p9,  compensate_p3);
		    TheNet->mergePlaces(p11, compensate_p4);
		    TheNet->mergePlaces(p17, compensate_p5);
		    TheNet->mergePlaces(p18, compensate_p6);
		    TheNet->mergePlaces(p12, compensate_p7);
		}

#line  2617 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 757 "bpel-unparse-petri.k"

		{
#line 758 "bpel-unparse-petri.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  2626 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 758 "bpel-unparse-petri.k"
			    {
#line 759 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 759 "bpel-unparse-petri.k"
#line 758 "bpel-unparse-petri.k"
				    const tCatch catchBranch = kc_selvar_0_1;
#line 758 "bpel-unparse-petri.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 759 "bpel-unparse-petri.k"

				    string faultToCatch = catchBranch->faultName->name;
				    Transition *t1 = TheNet->newTransition(prefix + "t1.internal." + faultToCatch);
				    Transition *t2 = TheNet->newTransition(prefix + "t2." + faultToCatch);


				    TheNet->newArc(t1, TheNet->findPlace(innerActivity, ".initial"));
				    TheNet->newArc(TheNet->findPlace(innerActivity, ".final"), t2);
				    TheNet->mergePlaces(TheNet->findPlace("1.internal.faultHandler.p11"), TheNet->findPlace(innerActivity, ".stop"));
				    TheNet->mergePlaces(TheNet->findPlace("1.internal.faultHandler.p12"), TheNet->findPlace(innerActivity, ".stopped"));

				    TheNet->newArc(p4, t1);
				    TheNet->newArc(p7, t1, READ);
				    TheNet->newArc(t2, p3);
				    TheNet->newArc(p7, t2);

#line  2658 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2663 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 758 "bpel-unparse-petri.k"

#line  2668 "bpel-kc-unpk.cc"
		    }
		}
#line 775 "bpel-unparse-petri.k"

		{
#line 776 "bpel-unparse-petri.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 778 "bpel-unparse-petri.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 778 "bpel-unparse-petri.k"
#line 777 "bpel-unparse-petri.k"
			const activity innerActivity = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 778 "bpel-unparse-petri.k"

			Transition *t3 = TheNet->newTransition(prefix + "t3.catchAll");
			Transition *t4 = TheNet->newTransition(prefix + "t4.catchAll");


			TheNet->newArc(t3, TheNet->findPlace(innerActivity, ".initial"));
			TheNet->newArc(TheNet->findPlace(innerActivity, ".final"), t4);
			TheNet->mergePlaces(TheNet->findPlace("1.internal.faultHandler.p11"), TheNet->findPlace(innerActivity, ".stop"));
			TheNet->mergePlaces(TheNet->findPlace("1.internal.faultHandler.p12"), TheNet->findPlace(innerActivity, ".stopped"));

			TheNet->newArc(p4, t3);
			TheNet->newArc(p7, t3, READ);
			TheNet->newArc(t4, p3);
			TheNet->newArc(p7, t4);

#line  2697 "bpel-kc-unpk.cc"
		    } else
		    {
#line 793 "bpel-unparse-petri.k"
#line 793 "bpel-unparse-petri.k"

#line  2703 "bpel-kc-unpk.cc"
		    }
		}
#line 795 "bpel-unparse-petri.k"

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</userDefinedFaultHandlerInsideProcess>\n");

#line  2710 "bpel-kc-unpk.cc"
	    } else
		if ((KC_TRACE_PROVIDED((!this/**/->inProcess), "bpel-unparse-petri.k", 912, this))) {
#line 912 "bpel-unparse-petri.k"
		const tFaultHandlers This = this/**/;
#line 912 "bpel-unparse-petri.k"
		const tCatch_list a = this->tCatch_list_1;
#line 912 "bpel-unparse-petri.k"
		const tCatchAll b = this->tCatchAll_1;
#line 914 "bpel-unparse-petri.k"

		string prefix = intToString(This->parentScopeId->value) + ".internal.faultHandler.";
		trace(TRACE_DEBUG, "[PNU]" + inString() + "<userDefinedFaultHandlerInsideScope scope=\"" + currentScope + "\">\n");

		Place *p3 =  TheNet->newPlace(prefix + "out");
		Place *p4 =  TheNet->newPlace(prefix + "fault");
		Place *p7 =  TheNet->newPlace(prefix + "trueOut");
		Place *p8 =  TheNet->newPlace(prefix + "sourceFalse");
		Place *p9 =  TheNet->newPlace(prefix + "faultSave");
		Place *p10 = TheNet->newPlace(prefix + "p10");
		Place *p11 = TheNet->newPlace(prefix + "p11");
		Place *p12 = TheNet->newPlace(prefix + "falseOut");
		Place *p13 = TheNet->newPlace(prefix + "p13");
		Place *p14 = TheNet->newPlace(prefix + "p14");
		Place *p15 = TheNet->newPlace(prefix + "rethrow");
		Place *p16 = TheNet->newPlace(prefix + "p16");
		Place *p17 = TheNet->newPlace(prefix + "upperFH");
		Place *p18 = TheNet->newPlace(prefix + "Ended");
		Place *p19 = TheNet->newPlace(prefix + "ftSave");
		Place *p20 = TheNet->newPlace(prefix + "ft");
		Place *p21 = TheNet->newPlace(prefix + "p21");
		Place *p22 = TheNet->newPlace(prefix + "p22");
		Place *p23 = TheNet->newPlace(prefix + "stopped");
		Place *p24 = TheNet->newPlace(prefix + "!Ended");
		Place *p25 = TheNet->newPlace(prefix + "ch_fh");
		Place *p26 = TheNet->newPlace(prefix + "ch_out");

		Transition *t7 = TheNet->newTransition(prefix + "t7");
		TheNet->newArc(p9, t7);
		TheNet->newArc(t7, p13);
		TheNet->newArc(p15, t7);
		TheNet->newArc(t7, p16);

		Transition *t8 = TheNet->newTransition(prefix + "t8");
		TheNet->newArc(t8, p8);
		TheNet->newArc(t8, p12);
		TheNet->newArc(p14, t8);
		TheNet->newArc(p16, t8);
		TheNet->newArc(t8, p17);
		TheNet->newArc(t8, p18);
		TheNet->newArc(p24, t8);

		Transition *t9 = TheNet->newTransition(prefix + "t9");
		TheNet->newArc(p15, t9);
		TheNet->newArc(p18, t9, READ);

		Transition *t10 = TheNet->newTransition(prefix + "t10");
		TheNet->newArc(p15, t10);
		TheNet->newArc(p19, t10, READ);

		Transition *t11 = TheNet->newTransition(prefix + "t11");
		TheNet->newArc(t11, p7);
		TheNet->newArc(t11, p8);
		TheNet->newArc(p19, t11);
		TheNet->newArc(p22, t11);
		TheNet->newArc(t11, p23);

		Transition *t12 = TheNet->newTransition(prefix + "t12");
		TheNet->newArc(p20, t12);
		TheNet->newArc(t12, p21);



		if (!This->hasCatchAll)
		{
		    Transition *t5 = TheNet->newTransition(prefix + "t5");
		    TheNet->newArc(p4, t5);
		    TheNet->newArc(p9, t5, READ);
		    TheNet->newArc(t5, p10);

		    Transition *t6 = TheNet->newTransition(prefix + "t6");
		    TheNet->newArc(t6, p8);
		    TheNet->newArc(p9, t6);
		    TheNet->newArc(p11, t6);
		    TheNet->newArc(t6, p12);
		    TheNet->newArc(t6, p17);
		    TheNet->newArc(t6, p18);
		    TheNet->newArc(p24, t6);



		    string newPrefix = prefix + "compensate.left.";

		    Place *compensate1_p1 = TheNet->newPlace(newPrefix + "initial");
		    Place *compensate1_p2 = TheNet->newPlace(newPrefix + "running");
		    Place *compensate1_p3 = TheNet->newPlace(newPrefix + "final");
		    Place *compensate1_p4 = TheNet->newPlace(newPrefix + "stop");
		    Place *compensate1_p5 = TheNet->newPlace(newPrefix + "ch_fh");
		    Place *compensate1_p6 = TheNet->newPlace(newPrefix + "ch_out");
		    Place *compensate1_p7 = TheNet->newPlace(newPrefix + "stopped");

		    Transition *compensate1_t1 = TheNet->newTransition(newPrefix + "t1");
		    TheNet->newArc(compensate1_p1, compensate1_t1);
		    TheNet->newArc(compensate1_t1, compensate1_p2);
		    TheNet->newArc(compensate1_t1, compensate1_p5);

		    Transition *compensate1_t2 = TheNet->newTransition(newPrefix + "t2");
		    TheNet->newArc(compensate1_p2, compensate1_t2);
		    TheNet->newArc(compensate1_t2, compensate1_p3);
		    TheNet->newArc(compensate1_p6, compensate1_t2);

		    Transition *compensate1_t3 = TheNet->newTransition(newPrefix + "t3");
		    TheNet->newArc(compensate1_p1, compensate1_t3);
		    TheNet->newArc(compensate1_p4, compensate1_t3);
		    TheNet->newArc(compensate1_t3, compensate1_p7);

		    Transition *compensate1_t4 = TheNet->newTransition(newPrefix + "t4");
		    TheNet->newArc(compensate1_p2, compensate1_t4);
		    TheNet->newArc(compensate1_p4, compensate1_t4);
		    TheNet->newArc(compensate1_t4, compensate1_p7);

		    Transition *compensate1_t5 = TheNet->newTransition(newPrefix + "t5");
		    TheNet->newArc(compensate1_p2, compensate1_t5);
		    TheNet->newArc(compensate1_p3, compensate1_t5);
		    TheNet->newArc(compensate1_t5, compensate1_p7);



		    TheNet->mergePlaces(TheNet->findPlace(prefix + "p10"), compensate1_p1);
		    TheNet->mergePlaces(TheNet->findPlace(prefix + "p11"), compensate1_p3);
		    TheNet->mergePlaces(TheNet->findPlace(prefix + "p13"), compensate1_p4);
		    TheNet->mergePlaces(TheNet->findPlace(prefix + "ch_fh"), compensate1_p5);
		    TheNet->mergePlaces(TheNet->findPlace(prefix + "ch_out"), compensate1_p6);
		    TheNet->mergePlaces(TheNet->findPlace(prefix + "p14"), compensate1_p7);
		}


		string newPrefix = prefix + "compensate.right.";

		Place *compensate2_p1 = TheNet->newPlace(newPrefix + "initial");
		Place *compensate2_p2 = TheNet->newPlace(newPrefix + "running");
		Place *compensate2_p3 = TheNet->newPlace(newPrefix + "final");
		Place *compensate2_p4 = TheNet->newPlace(newPrefix + "stop");
		Place *compensate2_p5 = TheNet->newPlace(newPrefix + "ch_fh");
		Place *compensate2_p6 = TheNet->newPlace(newPrefix + "ch_out");
		Place *compensate2_p7 = TheNet->newPlace(newPrefix + "stopped");

		Transition *compensate2_t1 = TheNet->newTransition(newPrefix + "t1");
		TheNet->newArc(compensate2_p1, compensate2_t1);
		TheNet->newArc(compensate2_t1, compensate2_p2);
		TheNet->newArc(compensate2_t1, compensate2_p5);

		Transition *compensate2_t2 = TheNet->newTransition(newPrefix + "t2");
		TheNet->newArc(compensate2_p2, compensate2_t2);
		TheNet->newArc(compensate2_t2, compensate2_p3);
		TheNet->newArc(compensate2_p6, compensate2_t2);

		Transition *compensate2_t3 = TheNet->newTransition(newPrefix + "t3");
		TheNet->newArc(compensate2_p1, compensate2_t3);
		TheNet->newArc(compensate2_p4, compensate2_t3);
		TheNet->newArc(compensate2_t3, compensate2_p7);

		Transition *compensate2_t4 = TheNet->newTransition(newPrefix + "t4");
		TheNet->newArc(compensate2_p2, compensate2_t4);
		TheNet->newArc(compensate2_p4, compensate2_t4);
		TheNet->newArc(compensate2_t4, compensate2_p7);

		Transition *compensate2_t5 = TheNet->newTransition(newPrefix + "t5");
		TheNet->newArc(compensate2_p2, compensate2_t5);
		TheNet->newArc(compensate2_p3, compensate2_t5);
		TheNet->newArc(compensate2_t5, compensate2_p7);



		TheNet->mergePlaces(TheNet->findPlace(prefix + "p21"), compensate2_p1);
		TheNet->mergePlaces(TheNet->findPlace(prefix + "p22"), compensate2_p3);
		TheNet->mergePlaces(TheNet->findPlace(prefix + "ch_fh"), compensate2_p5);
		TheNet->mergePlaces(TheNet->findPlace(prefix + "ch_out"), compensate2_p6);

#line  2889 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1085 "bpel-unparse-petri.k"

		{
#line 1086 "bpel-unparse-petri.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  2898 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 1086 "bpel-unparse-petri.k"
			    {
#line 1087 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 1087 "bpel-unparse-petri.k"
#line 1086 "bpel-unparse-petri.k"
				    const tCatch catchBranch = kc_selvar_0_1;
#line 1086 "bpel-unparse-petri.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 1087 "bpel-unparse-petri.k"

				    string faultToCatch = catchBranch->faultName->name;

				    Transition *t1 = TheNet->newTransition(prefix + "t1.internal." + faultToCatch);
				    TheNet->newArc(t1, TheNet->findPlace(innerActivity, ".initial"));
				    TheNet->newArc(p4, t1);
				    TheNet->newArc(p9, t1, READ);

				    Transition *t2 = TheNet->newTransition(prefix + "t2." + faultToCatch);
				    TheNet->newArc(TheNet->findPlace(innerActivity, ".final"), t2);
				    TheNet->newArc(t2, p3);
				    TheNet->newArc(t2, p7);
				    TheNet->newArc(t2, p8);
				    TheNet->newArc(p9, t2);



				    TheNet->mergePlaces(TheNet->findPlace(prefix + "p13"), TheNet->findPlace(innerActivity, ".stop"));
				    TheNet->mergePlaces(TheNet->findPlace(prefix + "p14"), TheNet->findPlace(innerActivity, ".stopped"));

#line  2934 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2939 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 1086 "bpel-unparse-petri.k"

#line  2944 "bpel-kc-unpk.cc"
		    }
		}
#line 1107 "bpel-unparse-petri.k"

		{
#line 1108 "bpel-unparse-petri.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 1110 "bpel-unparse-petri.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 1110 "bpel-unparse-petri.k"
#line 1109 "bpel-unparse-petri.k"
			const activity innerActivity = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 1110 "bpel-unparse-petri.k"

			Transition *t3 = TheNet->newTransition(prefix + "t3.catchAll");
			TheNet->newArc(t3, TheNet->findPlace(innerActivity, ".initial"));
			TheNet->newArc(p4, t3);
			TheNet->newArc(p9, t3, READ);

			Transition *t4 = TheNet->newTransition(prefix + "t4.catchAll");
			TheNet->newArc(TheNet->findPlace(innerActivity, ".final"), t4);
			TheNet->newArc(t4, p3);
			TheNet->newArc(t4, p7);
			TheNet->newArc(t4, p8);
			TheNet->newArc(p9, t4);



			TheNet->mergePlaces(TheNet->findPlace(prefix + "p13"), TheNet->findPlace(innerActivity, ".stop"));
			TheNet->mergePlaces(TheNet->findPlace(prefix + "p14"), TheNet->findPlace(innerActivity, ".stopped"));

#line  2976 "bpel-kc-unpk.cc"
		    } else
		    {
#line 1128 "bpel-unparse-petri.k"
#line 1128 "bpel-unparse-petri.k"

#line  2982 "bpel-kc-unpk.cc"
		    }
		}
#line 1130 "bpel-unparse-petri.k"

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</userDefinedFaultHandlerInsideScope scope=\"" + currentScope + "\">\n");

#line  2989 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  2995 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3016 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCatch_list iterator_ = this; iterator_->tCatch_list_1 != 0; iterator_ = iterator_->tCatch_list_1)
		    iterator_->tCatch_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3035 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3048 "bpel-kc-unpk.cc"
void
impl_tCatch_Catch::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 151 "bpel-unparse-xml.k"
		const activity a = this->activity_1;
#line 152 "bpel-unparse-xml.k"
		inup(); 
#line  3060 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<catch>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 152 "bpel-unparse-xml.k"
		indown(); 
#line  3065 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</catch>\n"), kc_current_view); }
	    }
	    break;
	}

#line  3071 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3084 "bpel-kc-unpk.cc"
void
impl_tCatchAll_NoCatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3090 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3102 "bpel-kc-unpk.cc"
void
impl_tCatchAll_CatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 155 "bpel-unparse-xml.k"
		const activity a = this->activity_1;
#line 156 "bpel-unparse-xml.k"
		inup(); 
#line  3114 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<catchAll>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 156 "bpel-unparse-xml.k"
		indown(); 
#line  3119 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</catchAll>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 1265 "bpel-unparse-petri.k"
		const activity innerActivity = this->activity_1;
		kc::unparse(innerActivity, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  3134 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3147 "bpel-kc-unpk.cc"
void
impl_tEventHandlers_userDefinedEventHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 164 "bpel-unparse-xml.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 164 "bpel-unparse-xml.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 165 "bpel-unparse-xml.k"
		inup(); 
#line  3161 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<eventHandlers>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 165 "bpel-unparse-xml.k"
		indown(); 
#line  3167 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</eventHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 1286 "bpel-unparse-petri.k"
		const tEventHandlers This = this/**/;
#line 1286 "bpel-unparse-petri.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 1286 "bpel-unparse-petri.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 1288 "bpel-unparse-petri.k"

		trace(TRACE_DEBUG, "[PNU]" + inString() + "<eventHandler scope=\"" + currentScope + "\">\n");

		string prefix = intToString(This->parentScopeId->value) + ".internal.eventHandler.";
		Place *p6  = TheNet->newPlace(prefix + "initial");
		Place *p8  = TheNet->newPlace(prefix + "final");
		Place *p13 = TheNet->newPlace(prefix + "finish");
		Place *p17 = TheNet->newPlace(prefix + "running");
		Place *p18 = TheNet->newPlace(prefix + "finishing");
		Place *p22 = TheNet->newPlace(prefix + "stop");
		Place *p23 = TheNet->newPlace(prefix + "stopped");

		Transition *t5 = TheNet->newTransition(prefix + "t5");
		TheNet->newArc(p6, t5);
		TheNet->newArc(t5, p17);
		TheNet->newArc(TheNet->findPlace("1.internal.clock"), t5, READ);

		Transition *t7 = TheNet->newTransition(prefix + "allFinished");
		TheNet->newArc(t7, p8);
		TheNet->newArc(p18, t7);

		Transition *t11 = TheNet->newTransition(prefix + "t11");
		TheNet->newArc(p13, t11);
		TheNet->newArc(p17, t11);
		TheNet->newArc(t11, p18);

		Transition *t16 = TheNet->newTransition(prefix + "allStopped");
		TheNet->newArc(t16, p23);

		Transition *t17 = TheNet->newTransition(prefix + "normalStop");
		TheNet->newArc(p18, t17);
		TheNet->newArc(p22, t17);

		Transition *t18 = TheNet->newTransition(prefix + "t18");
		TheNet->newArc(p6, t18);
		TheNet->newArc(p22, t18);
		TheNet->newArc(t18, p23);

		Transition *t19 = TheNet->newTransition(prefix + "stop+finish");
		TheNet->newArc(p17, t19);
		TheNet->newArc(p22, t19);

		Transition *t20 = TheNet->newTransition(prefix + "t20");
		TheNet->newArc(p8, t20);
		TheNet->newArc(p22, t20);
		TheNet->newArc(t20, p23);

#line  3229 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1337 "bpel-unparse-petri.k"

		int onMessageCount = 1;
		{
#line 1339 "bpel-unparse-petri.k"
		    tOnMessage_list kc_fe_selvar_1 =  a;

#line  3239 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 1339 "bpel-unparse-petri.k"
			    {
#line 1340 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 1340 "bpel-unparse-petri.k"
#line 1339 "bpel-unparse-petri.k"
				    const tOnMessage ThisBranch = kc_selvar_0_1;
#line 1339 "bpel-unparse-petri.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 1340 "bpel-unparse-petri.k"

				    string message = intToString(onMessageCount++);
				    string newPrefix = prefix + "onMessage" + message + ".";

				    Place *onMessage_p1  = TheNet->newPlace(newPrefix + "p1");
				    Place *onMessage_p2  = TheNet->newPlace(newPrefix + "p2");
				    Place *onMessage_p3  = TheNet->newPlace(newPrefix + "p3");
				    Place *onMessage_p4  = TheNet->newPlace(newPrefix + "p4");
				    Place *onMessage_p5  = TheNet->newPlace(newPrefix + "wait" + message );
				    Place *onMessage_p6  = TheNet->newPlace(newPrefix + "p6");
				    Place *onMessage_p7  = TheNet->newPlace(newPrefix + "finish" + message );
				    Place *onMessage_p9  = TheNet->newPlace(newPrefix + "finish+stop" + message );
				    Place *onMessage_p11 = TheNet->newPlace(newPrefix + "stop" + message );
				    Place *onMessage_p12 = TheNet->newPlace(newPrefix + "p12");

				    Transition *onMessage_t2 = TheNet->newTransition(newPrefix + "t2");
				    TheNet->newArc(TheNet->findPlace("in." + string(ThisBranch->channelID->name)), onMessage_t2);
				    TheNet->newArc(onMessage_t2, onMessage_p2);
				    TheNet->newArc(onMessage_p5, onMessage_t2);

				    Transition *onMessage_t3 = TheNet->newTransition(newPrefix + "t3");
				    TheNet->newArc(TheNet->findPlace("variable." + string(ThisBranch->variableID->name)), onMessage_t3);
				    TheNet->newArc(onMessage_t3, TheNet->findPlace("variable." + string(ThisBranch->variableID->name)));
				    TheNet->newArc(onMessage_p2, onMessage_t3);
				    TheNet->newArc(onMessage_t3, onMessage_p3);

				    Transition *onMessage_t4 = TheNet->newTransition(newPrefix + "t4");
				    TheNet->newArc(onMessage_p4, onMessage_t4);
				    TheNet->newArc(onMessage_t4, onMessage_p5);

				    Transition *onMessage_t5 = TheNet->newTransition(newPrefix + "t5");
				    TheNet->newArc(onMessage_p5, onMessage_t5);
				    TheNet->newArc(onMessage_t5, onMessage_p6);
				    TheNet->newArc(onMessage_p7, onMessage_t5);

				    Transition *onMessage_t7 = TheNet->newTransition(newPrefix + "t7");
				    TheNet->newArc(onMessage_p7, onMessage_t7);
				    TheNet->newArc(onMessage_p9, onMessage_t7);
				    TheNet->newArc(onMessage_t7, onMessage_p11);

				    Transition *onMessage_t8 = TheNet->newTransition(newPrefix + "t8");
				    TheNet->newArc(onMessage_p6, onMessage_t8);
				    TheNet->newArc(onMessage_p9, onMessage_t8);
				    TheNet->newArc(onMessage_t8, onMessage_p12);

				    Transition *onMessage_t10 = TheNet->newTransition(newPrefix + "t10");
				    TheNet->newArc(onMessage_p1, onMessage_t10);
				    TheNet->newArc(onMessage_p11, onMessage_t10);
				    TheNet->newArc(onMessage_t10, onMessage_p12);

				    Transition *onMessage_t11 = TheNet->newTransition(newPrefix + "t11");
				    TheNet->newArc(onMessage_p2, onMessage_t11);
				    TheNet->newArc(onMessage_p11, onMessage_t11);
				    TheNet->newArc(onMessage_t11, onMessage_p12);

				    Transition *onMessage_t12 = TheNet->newTransition(newPrefix + "t12");
				    TheNet->newArc(onMessage_p5, onMessage_t12);
				    TheNet->newArc(onMessage_p11, onMessage_t12);
				    TheNet->newArc(onMessage_t12, onMessage_p12);

				    if (parameters[P_NOSTANDARDFAULTS] == false)
				    Transition *t1 = throwFault(onMessage_p2, onMessage_p1, "p2", prefix, mkinteger(0));


				    TheNet->newArc(t11, onMessage_p7); 
				    TheNet->newArc(t5,  onMessage_p5); 
				    TheNet->newArc(t17, onMessage_p9); 
				    TheNet->newArc(t19, onMessage_p11); 


				    TheNet->newArc(onMessage_p6, t7); 
				    TheNet->newArc(onMessage_p12, t16);


				    TheNet->mergePlaces(onMessage_p3,  TheNet->findPlace(innerActivity, ".initial"));
				    TheNet->mergePlaces(onMessage_p11, TheNet->findPlace(innerActivity, ".stop"));
				    TheNet->mergePlaces(onMessage_p12, TheNet->findPlace(innerActivity, ".stopped"));
				    TheNet->mergePlaces(onMessage_p4,  TheNet->findPlace(innerActivity, ".final"));

#line  3334 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  3339 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 1339 "bpel-unparse-petri.k"

#line  3344 "bpel-kc-unpk.cc"
		    }
		}
#line 1419 "bpel-unparse-petri.k"


		int onAlarmCount = 1;
		{
#line 1422 "bpel-unparse-petri.k"
		    tOnAlarm_list kc_fe_selvar_1 =  b;

#line  3355 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 1422 "bpel-unparse-petri.k"
			    {
#line 1423 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 1423 "bpel-unparse-petri.k"
#line 1422 "bpel-unparse-petri.k"
				    const tOnAlarm onAlarmBranch = kc_selvar_0_1;
#line 1422 "bpel-unparse-petri.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 1423 "bpel-unparse-petri.k"

				    string onAlarmGuard;
				    string newPrefix = prefix + "onAlarm" + intToString(onAlarmCount) + ".";

				    if (onAlarmBranch->For != mkcasestring(""))
				    onAlarmGuard = "x + " + string(onAlarmBranch->For->name) + " \\<= y"; 
				    else
				    onAlarmGuard = string(onAlarmBranch->until->name) + " \\<= y"; 

				    Place *onAlarm_p1  = TheNet->newPlace(newPrefix + "p1");
				    Place *onAlarm_p2  = TheNet->newPlace(newPrefix + "p2");
				    Place *onAlarm_p3  = TheNet->newPlace(newPrefix + "wait" + intToString(onAlarmCount));
				    Place *onAlarm_p4  = TheNet->newPlace(newPrefix + "p4");
				    Place *onAlarm_p5  = TheNet->newPlace(newPrefix + "finish" + intToString(onAlarmCount));
				    Place *onAlarm_p7  = TheNet->newPlace(newPrefix + "stop+finish" + intToString(onAlarmCount));
				    Place *onAlarm_p9  = TheNet->newPlace(newPrefix + "stop" + intToString(onAlarmCount));
				    Place *onAlarm_p10 = TheNet->newPlace(newPrefix + "p10");

				    Transition *onAlarm_t1 = TheNet->newTransition(newPrefix + "t1");
				    TheNet->newArc(onAlarm_p3, onAlarm_t1);
				    TheNet->newArc(onAlarm_t1, onAlarm_p1);
				    TheNet->newArc(TheNet->findPlace("1.internal.clock"), onAlarm_t1, READ);

				    Transition *onAlarm_t2 = TheNet->newTransition(newPrefix + "t2");
				    TheNet->newArc(onAlarm_p2, onAlarm_t2);
				    TheNet->newArc(onAlarm_t2, onAlarm_p4);
				    TheNet->newArc(onAlarm_p5, onAlarm_t2);

				    Transition *onAlarm_t3 = TheNet->newTransition(newPrefix + "t3");
				    TheNet->newArc(onAlarm_p3, onAlarm_t3);
				    TheNet->newArc(onAlarm_t3, onAlarm_p4);
				    TheNet->newArc(onAlarm_p5, onAlarm_t3);

				    Transition *onAlarm_t4 = TheNet->newTransition(newPrefix + "t4");
				    TheNet->newArc(onAlarm_p5, onAlarm_t4);
				    TheNet->newArc(onAlarm_p7, onAlarm_t4);
				    TheNet->newArc(onAlarm_t4, onAlarm_p9);

				    Transition *onAlarm_t6 = TheNet->newTransition(newPrefix + "t6");
				    TheNet->newArc(onAlarm_p4, onAlarm_t6);
				    TheNet->newArc(onAlarm_p7, onAlarm_t6);
				    TheNet->newArc(onAlarm_t6, onAlarm_p10);

				    Transition *onAlarm_t8 = TheNet->newTransition(newPrefix + "t8");
				    TheNet->newArc(onAlarm_p3, onAlarm_t8);
				    TheNet->newArc(onAlarm_p9, onAlarm_t8);
				    TheNet->newArc(onAlarm_t8, onAlarm_p10);



				    TheNet->newArc(t5,  onAlarm_p3);
				    TheNet->newArc(t11, onAlarm_p5);
				    TheNet->newArc(t17, onAlarm_p7);
				    TheNet->newArc(t19, onAlarm_p9);



				    TheNet->newArc(onAlarm_p4,  t7);
				    TheNet->newArc(onAlarm_p10, t16);



				    TheNet->mergePlaces(onAlarm_p1,  TheNet->findPlace(innerActivity, ".initial"));
				    TheNet->mergePlaces(onAlarm_p9,  TheNet->findPlace(innerActivity, ".stop"));
				    TheNet->mergePlaces(onAlarm_p10, TheNet->findPlace(innerActivity, ".stopped"));
				    TheNet->mergePlaces(onAlarm_p2,  TheNet->findPlace(innerActivity, ".final"));

				    onAlarmCount++;

#line  3440 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  3445 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 1422 "bpel-unparse-petri.k"

#line  3450 "bpel-kc-unpk.cc"
		    }
		}
#line 1492 "bpel-unparse-petri.k"

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</eventHandler scope=\"" + currentScope + "\">\n");

#line  3457 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  3462 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3475 "bpel-kc-unpk.cc"
void
impl_tEventHandlers_implicitEventHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3481 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3500 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnMessage_list iterator_ = this; iterator_->tOnMessage_list_1 != 0; iterator_ = iterator_->tOnMessage_list_1)
		    iterator_->tOnMessage_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3518 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3537 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnAlarm_list iterator_ = this; iterator_->tOnAlarm_list_1 != 0; iterator_ = iterator_->tOnAlarm_list_1)
		    iterator_->tOnAlarm_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3555 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3567 "bpel-kc-unpk.cc"
void
impl_tOnMessage_OnMessage::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 168 "bpel-unparse-xml.k"
		const activity a = this->activity_1;
#line 169 "bpel-unparse-xml.k"
		inup(); 
#line  3579 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<onMessage dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 169 "bpel-unparse-xml.k"
		indown(); 
#line  3586 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</onMessage>\n"), kc_current_view); }
	    }
	    break;
	}

#line  3592 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3605 "bpel-kc-unpk.cc"
void
impl_tOnAlarm_OnAlarm::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 172 "bpel-unparse-xml.k"
		const activity a = this->activity_1;
#line 173 "bpel-unparse-xml.k"
		inup(); 
#line  3617 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<onAlarm dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 173 "bpel-unparse-xml.k"
		indown(); 
#line  3624 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</onAlarm>\n"), kc_current_view); }
	    }
	    break;
	}

#line  3630 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3643 "bpel-kc-unpk.cc"
void
impl_tCompensationHandler_processCompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 1809 "bpel-unparse-petri.k"
		const tCompensationHandler This = this/**/;
#line 1811 "bpel-unparse-petri.k"

		string prefix = intToString(This->parentScopeId->value) + ".internal.compensationHandler.";
		trace(TRACE_DEBUG, "[PNU]" + inString() + "<processCompensationHandler>\n");

		Place *p2  = TheNet->newPlace(prefix + "ch_in");
		Place *p3  = TheNet->newPlace(prefix + "Compensated");
		Place *p4  = TheNet->newPlace(prefix + "!Completed");
		Place *p5  = TheNet->newPlace(prefix + "!Compensated");
		Place *p6  = TheNet->newPlace(prefix + "Completed");
		Place *p9  = TheNet->newPlace(prefix + "compensated");
		Place *p11 = TheNet->newPlace(prefix + "comp");
		Place *p13 = TheNet->newPlace(prefix + "cleaned");
		Place *p14 = TheNet->newPlace(prefix + "fh");
		Place *p15 = TheNet->newPlace(prefix + "ch_call");
		Place *p16 = TheNet->newPlace(prefix + "fh_call");
		Place *p17 = TheNet->newPlace(prefix + "ch_out");
		Place *p18 = TheNet->newPlace(prefix + "scopeCompensated");
		Place *p24 = TheNet->newPlace(prefix + "clean");

		Transition *t6 = TheNet->newTransition(prefix + "t6");
		TheNet->newArc(p14, t6);
		TheNet->newArc(t6, p11);
		TheNet->newArc(t6, p16);

		Transition *t7 = TheNet->newTransition(prefix + "t7");
		TheNet->newArc(t7, p9);
		TheNet->newArc(p11, t7);
		TheNet->newArc(p15, t7);

		Transition *t8 = TheNet->newTransition(prefix + "t8");
		TheNet->newArc(p11, t8);
		TheNet->newArc(p16, t8);
		TheNet->newArc(t8, p17);

		Transition *t9 = TheNet->newTransition(prefix + "t9");
		TheNet->newArc(t9, p11);
		TheNet->newArc(p16, t9, READ);
		TheNet->newArc(p18, t9);

		Transition *t10 = TheNet->newTransition(prefix + "t10");
		TheNet->newArc(t10, p11);
		TheNet->newArc(p15, t10, READ);
		TheNet->newArc(p18, t10);

		Transition *t11 = TheNet->newTransition(prefix + "t11");
		TheNet->newArc(t11, p13);
		TheNet->newArc(p15, t11);
		TheNet->newArc(p24, t11);

		Transition *t12 = TheNet->newTransition(prefix + "t12");
		TheNet->newArc(t12, p13);
		TheNet->newArc(p16, t12);
		TheNet->newArc(p24, t12);

		Transition *t15 = TheNet->newTransition(prefix + "t15");
		TheNet->newArc(p9, t15);
		TheNet->newArc(t15, p13);
		TheNet->newArc(p24, t15);

		Transition *t16 = TheNet->newTransition(prefix + "t16");
		TheNet->newArc(t16, p13);
		TheNet->newArc(p17, t16);
		TheNet->newArc(p24, t16);






		SymbolScope *me = symMan.getScope(This->parentScopeId);
		for (list< SymbolScope * >::iterator child = me->children.begin(); child != me->children.end(); child++)
		{
		    Place *p19_new = TheNet->newPlace(prefix + "compScope." + intToString((*child)->id->value));
		    Place *p20 = TheNet->findPlace(intToString((*child)->id->value) + ".!push");
		    Place *p21 = TheNet->findPlace(intToString((*child)->id->value) + ".push");
		    Transition *t13 = TheNet->newTransition(prefix + "t13." + intToString((*child)->id->value));
		    TheNet->newArc(p20, t7);
		    TheNet->newArc(p20, t8);
		    TheNet->newArc(p11, t13);
		    TheNet->newArc(t13, p19_new);
		    TheNet->newArc(t13, p20);
		    TheNet->newArc(p21, t13);
		}

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</processCompensationHandler>\n");

#line  3740 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  3745 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3757 "bpel-kc-unpk.cc"
void
impl_tCompensationHandler_userDefinedCompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 181 "bpel-unparse-xml.k"
		const activity a = this->activity_1;
#line 182 "bpel-unparse-xml.k"
		inup(); 
#line  3769 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<compensationHandler>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 182 "bpel-unparse-xml.k"
		indown(); 
#line  3774 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</compensationHandler>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 1642 "bpel-unparse-petri.k"
		const tCompensationHandler This = this/**/;
#line 1642 "bpel-unparse-petri.k"
		const activity innerActivity = this->activity_1;
#line 1644 "bpel-unparse-petri.k"

		string prefix = intToString(This->parentScopeId->value) + ".internal.compensationHandler.";
		trace(TRACE_DEBUG, "[PNU]" + inString() + "<userDefinedCompensationHandler scope=\"" + currentScope + "\">\n");
		SymbolScope *me = symMan.getScope(This->parentScopeId);

		Place *p2  = TheNet->newPlace(prefix + "ch_in");
		Place *p3  = TheNet->newPlace(prefix + "Compensated");
		Place *p4  = TheNet->newPlace(prefix + "!Completed");
		Place *p5  = TheNet->newPlace(prefix + "!Compensated");
		Place *p6  = TheNet->newPlace(prefix + "Completed");
		Place *p7  = TheNet->newPlace(prefix + "p7");
		Place *p8  = TheNet->newPlace(prefix + "p8");
		Place *p9  = TheNet->newPlace(prefix + "compensated");
		Place *p11 = TheNet->newPlace(prefix + "comp");
		Place *p12 = TheNet->newPlace(prefix + "scopeCompensated");
		Place *p13 = TheNet->newPlace(prefix + "cleaned");
		Place *p14 = TheNet->newPlace(prefix + "fh");
		Place *p16 = TheNet->newPlace(prefix + "fh_call");
		Place *p17 = TheNet->newPlace(prefix + "ch_out");
		Place *p24 = TheNet->newPlace(prefix + "clean");




		if (parameters[P_NOSTANDARDFAULTS] == false)
		{
		    Place *p1  = TheNet->newPlace(prefix + "p1");

		    Transition *t1 = throwFault(p2, p1, "ch_in", prefix, mkinteger(2));
		    TheNet->newArc(p3, t1, READ);

		    Transition *t3 = TheNet->newTransition(prefix + "t3");
		    TheNet->newArc(p1, t3);
		    TheNet->newArc(t3, p13);
		    TheNet->newArc(p24, t3);
		}


		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(p4, t2, READ);
		TheNet->newArc(p5, t2, READ);
		TheNet->newArc(t2, p9);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p2, t4);
		TheNet->newArc(t4, p3);
		TheNet->newArc(p5, t4);
		TheNet->newArc(p6, t4, READ);
		TheNet->newArc(t4, p7);

		Transition *t5 = TheNet->newTransition(prefix + "t5");
		TheNet->newArc(p8, t5);
		TheNet->newArc(t5, p9);

		Transition *t6 = TheNet->newTransition(prefix + "t6");
		TheNet->newArc(t6, p11);
		TheNet->newArc(p14, t6);
		TheNet->newArc(t6, p16);

		Transition *t8 = TheNet->newTransition(prefix + "t8");
		TheNet->newArc(p11, t8);
		TheNet->newArc(p16, t8);
		TheNet->newArc(t8, p17);

		Transition *t9 = TheNet->newTransition(prefix + "t9");
		TheNet->newArc(t9, p11);
		TheNet->newArc(p12, t9);
		TheNet->newArc(p16, t9, READ);

		Transition *t12 = TheNet->newTransition(prefix + "t12");
		TheNet->newArc(t12, p13);
		TheNet->newArc(p16, t12);
		TheNet->newArc(p24, t12);

		Transition *t15 = TheNet->newTransition(prefix + "t15");
		TheNet->newArc(p9, t15);
		TheNet->newArc(t15, p13);
		TheNet->newArc(p24, t15);

		Transition *t16 = TheNet->newTransition(prefix + "t16");
		TheNet->newArc(t16, p13);
		TheNet->newArc(p17, t16);
		TheNet->newArc(p24, t16);




		if (This->compensateWithoutScope)
		{

		    Place *p10 = TheNet->newPlace(prefix + "p10");
		    Place *p12 = TheNet->newPlace(prefix + "p12");
		    Place *p15 = TheNet->newPlace(prefix + "ch_call");

		    Transition *t7 = TheNet->newTransition(prefix + "t7");
		    TheNet->newArc(p11, t7);
		    TheNet->newArc(t7, p12);
		    TheNet->newArc(p15, t7, READ);
		    for (list< SymbolScope * >::iterator child = me->children.begin(); child != me->children.end(); child++)
		    TheNet->newArc(TheNet->findPlace(intToString((*child)->id->value) + ".!push"), t7);

		    Transition *t10 = TheNet->newTransition(prefix + "t10");
		    TheNet->newArc(t10, p11);
		    TheNet->newArc(p12, t10);
		    TheNet->newArc(p15, t10, READ);

		    Transition *t11 = TheNet->newTransition(prefix + "t11");
		    TheNet->newArc(t11, p10);
		    TheNet->newArc(p15, t11);
		    TheNet->newArc(p24, t11);
		}
		if (This->compensateWithScope)
		{

		    Place *p10 = TheNet->newPlace(prefix + "p10");
		    Place *p15 = TheNet->newPlace(prefix + "ch_call");

		    Transition *t11 = TheNet->newTransition(prefix + "t11");
		    TheNet->newArc(t4, p15);
		    TheNet->newArc(p15, t5);
		    TheNet->newArc(t11, p10);
		    TheNet->newArc(p15, t11);
		    TheNet->newArc(p24, t11);
		}






		for (list< SymbolScope * >::iterator child = me->children.begin(); child != me->children.end(); child++)
		{
		    Place *p19_new = TheNet->newPlace(prefix + "compScope." + intToString((*child)->id->value));
		    Place *p20 = TheNet->findPlace(intToString((*child)->id->value) + ".!push");
		    Place *p21 = TheNet->findPlace(intToString((*child)->id->value) + ".push");
		    Transition *t13 = TheNet->newTransition(prefix + "t13." + intToString((*child)->id->value));
		    TheNet->newArc(p20, t8);
		    TheNet->newArc(p11, t13);
		    TheNet->newArc(t13, p19_new);
		    TheNet->newArc(t13, p20);
		    TheNet->newArc(p21, t13);
		}

#line  3931 "bpel-kc-unpk.cc"
		kc::unparse(innerActivity, kc_printer, kc_current_view);
#line 1789 "bpel-unparse-petri.k"


		TheNet->newArc(t4, TheNet->findPlace(innerActivity, ".initial"));
		TheNet->newArc(TheNet->findPlace(innerActivity, ".final"), t5);
		TheNet->mergePlaces(p24, TheNet->findPlace(innerActivity, ".stop"));
		TheNet->mergePlaces(p13, TheNet->findPlace(innerActivity, ".stopped"));

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</userDefinedCompensationHandler scope=\"" + currentScope + "\">\n");

#line  3943 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  3948 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3961 "bpel-kc-unpk.cc"
void
impl_tCompensationHandler_implicitCompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 1511 "bpel-unparse-petri.k"
		const tCompensationHandler This = this/**/;
#line 1513 "bpel-unparse-petri.k"

		string prefix = intToString(This->parentScopeId->value) + ".internal.compensationHandler.";
		trace(TRACE_DEBUG, "[PNU]" + inString() + "<implicitCompensationHandler scope=\"" + currentScope + "\">\n");

		Place *p2  = TheNet->newPlace(prefix + "ch_in");
		Place *p3  = TheNet->newPlace(prefix + "Compensated");
		Place *p4  = TheNet->newPlace(prefix + "!Completed");
		Place *p5  = TheNet->newPlace(prefix + "!Compensated");
		Place *p6  = TheNet->newPlace(prefix + "Completed");
		Place *p9  = TheNet->newPlace(prefix + "compensated");
		Place *p11 = TheNet->newPlace(prefix + "comp");
		Place *p13 = TheNet->newPlace(prefix + "cleaned");
		Place *p14 = TheNet->newPlace(prefix + "fh");
		Place *p15 = TheNet->newPlace(prefix + "ch_call");
		Place *p16 = TheNet->newPlace(prefix + "fh_call");
		Place *p17 = TheNet->newPlace(prefix + "ch_out");
		Place *p18 = TheNet->newPlace(prefix + "scopeCompensated");
		Place *p24 = TheNet->newPlace(prefix + "clean");




		if (parameters[P_NOSTANDARDFAULTS] == false)
		{
		    Place *p1  = TheNet->newPlace(prefix + "p1");

		    Transition *t1 = throwFault(p2, p1, "ch_in", prefix, mkinteger(2));
		    TheNet->newArc(p3, t1, READ);

		    Transition *t3 = TheNet->newTransition(prefix + "t3");
		    TheNet->newArc(p1, t3);
		    TheNet->newArc(t3, p13);
		    TheNet->newArc(p24, t3);
		}


		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(p4, t2, READ);
		TheNet->newArc(p5, t2, READ);
		TheNet->newArc(t2, p9);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p2, t4);
		TheNet->newArc(t4, p3);
		TheNet->newArc(p5, t4);
		TheNet->newArc(p6, t4, READ);
		TheNet->newArc(t4, p11);
		TheNet->newArc(t4, p15);

		Transition *t6 = TheNet->newTransition(prefix + "t6");
		TheNet->newArc(p14, t6);
		TheNet->newArc(t6, p11);
		TheNet->newArc(t6, p16);

		Transition *t7 = TheNet->newTransition(prefix + "t7");
		TheNet->newArc(t7, p9);
		TheNet->newArc(p11, t7);
		TheNet->newArc(p15, t7);

		Transition *t8 = TheNet->newTransition(prefix + "t8");
		TheNet->newArc(p11, t8);
		TheNet->newArc(p16, t8);
		TheNet->newArc(t8, p17);

		Transition *t9 = TheNet->newTransition(prefix + "t9");
		TheNet->newArc(t9, p11);
		TheNet->newArc(p16, t9, READ);
		TheNet->newArc(p18, t9);

		Transition *t10 = TheNet->newTransition(prefix + "t10");
		TheNet->newArc(t10, p11);
		TheNet->newArc(p15, t10, READ);
		TheNet->newArc(p18, t10);

		Transition *t11 = TheNet->newTransition(prefix + "t11");
		TheNet->newArc(t11, p13);
		TheNet->newArc(p15, t11);
		TheNet->newArc(p24, t11);

		Transition *t12 = TheNet->newTransition(prefix + "t12");
		TheNet->newArc(t12, p13);
		TheNet->newArc(p16, t12);
		TheNet->newArc(p24, t12);

		Transition *t15 = TheNet->newTransition(prefix + "t15");
		TheNet->newArc(p9, t15);
		TheNet->newArc(t15, p13);
		TheNet->newArc(p24, t15);

		Transition *t16 = TheNet->newTransition(prefix + "t16");
		TheNet->newArc(t16, p13);
		TheNet->newArc(p17, t16);
		TheNet->newArc(p24, t16);






		SymbolScope *me = symMan.getScope(This->parentScopeId);
		for (list< SymbolScope * >::iterator child = me->children.begin(); child != me->children.end(); child++)
		{
		    Place *p19_new = TheNet->newPlace(prefix + "compScope." + intToString((*child)->id->value));
		    Place *p20 = TheNet->findPlace(intToString((*child)->id->value) + ".!push");
		    Place *p21 = TheNet->findPlace(intToString((*child)->id->value) + ".push");
		    Transition *t13 = TheNet->newTransition(prefix + "t13." + intToString((*child)->id->value));
		    TheNet->newArc(p20, t7);
		    TheNet->newArc(p20, t8);
		    TheNet->newArc(p11, t13);
		    TheNet->newArc(t13, p19_new);
		    TheNet->newArc(t13, p20);
		    TheNet->newArc(p21, t13);
		}

		trace(TRACE_DEBUG, "[PNU]" + inString() + "</implicitCompensationHandler scope=\"" + currentScope + "\">\n");

#line  4089 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  4094 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  4113 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tVariable_list iterator_ = this; iterator_->tVariable_list_1 != 0; iterator_ = iterator_->tVariable_list_1)
		    iterator_->tVariable_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  4131 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  4143 "bpel-kc-unpk.cc"
void
impl_tVariable_Variable::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 191 "bpel-unparse-xml.k"
		in(); 
#line  4153 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<variable />\n"), kc_current_view); }
	    }
	    break;
	}

#line  4159 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  4178 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelationSet_list iterator_ = this; iterator_->tCorrelationSet_list_1 != 0; iterator_ = iterator_->tCorrelationSet_list_1)
		    iterator_->tCorrelationSet_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  4196 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  4208 "bpel-kc-unpk.cc"
void
impl_tCorrelationSet_CorrelationSet::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 200 "bpel-unparse-xml.k"
		in(); 
#line  4218 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<correlationSet />\n"), kc_current_view); }
	    }
	    break;
	}

#line  4224 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  4243 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelation_list iterator_ = this; iterator_->tCorrelation_list_1 != 0; iterator_ = iterator_->tCorrelation_list_1)
		    iterator_->tCorrelation_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  4261 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  4273 "bpel-kc-unpk.cc"
void
impl_tCorrelation_Correlation::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 209 "bpel-unparse-xml.k"
		in(); 
#line  4283 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<correlation />\n"), kc_current_view); }
	    }
	    break;
	}

#line  4289 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  4301 "bpel-kc-unpk.cc"
void
impl_tEmpty_Empty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 144 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 145 "bpel-unparse-cfg.k"

		cfgMap[intToString(this->id->value)] = new CFGEmpty(this->id); 

#line  4315 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 217 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 218 "bpel-unparse-xml.k"
		inup(); 
#line  4326 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<empty id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 218 "bpel-unparse-xml.k"
		indown(); 
#line  4335 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</empty>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 1926 "bpel-unparse-petri.k"
		const tEmpty This = this/**/;
#line 1926 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 1928 "bpel-unparse-petri.k"

		string prefix = intToString(This->id->value) + ".internal.";
		header(This->id);

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "final");
		Place *p3 = TheNet->newPlace(prefix + "stop");
		Place *p4 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);



		Transition *t2 = stop(p1, "initial", prefix);
		Transition *t3 = stop(p2, "final", prefix);

#line  4366 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1947 "bpel-unparse-petri.k"

		footer(This->id);

#line  4372 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  4377 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4390 "bpel-kc-unpk.cc"
void
impl_tInvoke_Invoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 155 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 155 "bpel-unparse-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 156 "bpel-unparse-cfg.k"

		cfgMap[intToString(this->id->value)] = new CFGInvoke(this->id); 

#line  4406 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 225 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 225 "bpel-unparse-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 226 "bpel-unparse-xml.k"
		inup(); 
#line  4419 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<invoke id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 226 "bpel-unparse-xml.k"
		indown(); 
#line  4431 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</invoke>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((KC_TRACE_PROVIDED((this/**/->outputVariable == mkcasestring("")), "bpel-unparse-petri.k", 1967, this))) {
#line 1967 "bpel-unparse-petri.k"
		const tInvoke This = this/**/;
#line 1967 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 1967 "bpel-unparse-petri.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 1969 "bpel-unparse-petri.k"

		string prefix = intToString(This->id->value) + ".internal.";
		header(This->id);

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "running");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "p4");
		Place *p5 = TheNet->newPlace(prefix + "stop");
		Place *p6 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1); TheNet->findPlace("variable." + string(This->variableIDin->name));
		TheNet->newArc(TheNet->findPlace("variable." + string(This->variableIDin->name)), t1, READ);
		TheNet->newArc(TheNet->findPlace("out." + string(This->channelID->name)), t1);
		TheNet->newArc(t1, p2);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);



		if (parameters[P_NOSTANDARDFAULTS] == false)
		Transition *t3 = throwFault(p2, p4, "running", prefix, This->negativeControlFlow);

		Transition *t4 = stop(p1, "initial", prefix);
		Transition *t5 = stop(p2, "running", prefix);
		Transition *t6 = stop(p4, "p4", prefix);
		Transition *t7 = stop(p3, "final", prefix);

#line  4477 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2001 "bpel-unparse-petri.k"

		footer(This->id);

#line  4483 "bpel-kc-unpk.cc"
	    } else
		if ((KC_TRACE_PROVIDED((this/**/->outputVariable != mkcasestring("")), "bpel-unparse-petri.k", 2017, this))) {
#line 2017 "bpel-unparse-petri.k"
		const tInvoke This = this/**/;
#line 2017 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2017 "bpel-unparse-petri.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 2019 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "running1");
		Place *p3 = TheNet->newPlace(prefix + "p3");
		Place *p4 = TheNet->newPlace(prefix + "running2");
		Place *p5 = TheNet->newPlace(prefix + "final");
		Place *p6 = TheNet->newPlace(prefix + "p6");
		Place *p7 = TheNet->newPlace(prefix + "stop");
		Place *p8 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(TheNet->findPlace("variable." + string(This->variableIDin->name)), t1, READ);
		TheNet->newArc(t1, p2);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(t2, TheNet->findPlace("out." + string(This->channelID->name)));
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(TheNet->findPlace("in." + string(This->channelID->name)), t3);
		TheNet->newArc(p3, t3);
		TheNet->newArc(t3, p4);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p4, t4);
		TheNet->newArc(t4, p5);
		TheNet->newArc(TheNet->findPlace("variable." + string(This->variableIDout->name)), t4);
		TheNet->newArc(t4, TheNet->findPlace("variable." + string(This->variableIDout->name)));



		if (parameters[P_NOSTANDARDFAULTS] == false)
		{
		    Transition *t5 = throwFault(p4, p6, "running2", prefix, This->negativeControlFlow);
		    Transition *t6 = throwFault(p2, p6, "running1", prefix, This->negativeControlFlow);
		}

		Transition *t7  = stop(p1, "initial", prefix);
		Transition *t8  = stop(p2, "running1", prefix);
		Transition *t9  = stop(p3, "p3", prefix);
		Transition *t10 = stop(p4, "running2", prefix);
		Transition *t11 = stop(p6, "p6", prefix);
		Transition *t12 = stop(p5, "final", prefix);

#line  4542 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2069 "bpel-unparse-petri.k"

		footer(This->id);

#line  4548 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  4554 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4568 "bpel-kc-unpk.cc"
void
impl_tReceive_Receive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 167 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 167 "bpel-unparse-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 168 "bpel-unparse-cfg.k"

		cfgMap[intToString(this->id->value)] = new CFGReceive(this->id); 

#line  4584 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 234 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 234 "bpel-unparse-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 235 "bpel-unparse-xml.k"
		inup(); 
#line  4597 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<receive id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 235 "bpel-unparse-xml.k"
		indown(); 
#line  4607 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</receive>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 2088 "bpel-unparse-petri.k"
		const tReceive This = this/**/;
#line 2088 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2088 "bpel-unparse-petri.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 2090 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "running");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "p4");
		Place *p5 = TheNet->newPlace(prefix + "stop");
		Place *p6 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(TheNet->findPlace("in." + string(This->channelID->name)), t1);
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);
		TheNet->newArc(TheNet->findPlace("variable." + string(This->variableID->name)), t2);
		TheNet->newArc(t2, TheNet->findPlace("variable." + string(This->variableID->name)));



		if (parameters[P_NOSTANDARDFAULTS] == false)
		Transition *t3 = throwFault(p2, p4, "running", prefix, This->negativeControlFlow);

		Transition *t4 = stop(p1, "initial", prefix);
		Transition *t5 = stop(p2, "running", prefix);
		Transition *t6 = stop(p4, "p4", prefix);
		Transition *t7 = stop(p3, "final", prefix);

#line  4654 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2123 "bpel-unparse-petri.k"

		footer(This->id);

#line  4660 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  4665 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4678 "bpel-kc-unpk.cc"
void
impl_tReply_Reply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 179 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 179 "bpel-unparse-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 180 "bpel-unparse-cfg.k"

		cfgMap[intToString(this->id->value)] = new CFGReply(this->id); 

#line  4694 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 243 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 243 "bpel-unparse-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 244 "bpel-unparse-xml.k"
		inup(); 
#line  4707 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<reply id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 244 "bpel-unparse-xml.k"
		indown(); 
#line  4717 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</reply>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 2142 "bpel-unparse-petri.k"
		const tReply This = this/**/;
#line 2142 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2142 "bpel-unparse-petri.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 2144 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "running");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "p4");
		Place *p5 = TheNet->newPlace(prefix + "stop");
		Place *p6 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(TheNet->findPlace("variable." + string(This->variableID->name)), t1, READ);
		TheNet->newArc(t1, p2);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(t2, TheNet->findPlace("out." + string(This->channelID->name)));
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);



		if (parameters[P_NOSTANDARDFAULTS] == false)
		Transition *t3 = throwFault(p2, p4, "running", prefix, This->negativeControlFlow);

		Transition *t3 = stop(p1, "initial", prefix);
		Transition *t5 = stop(p2, "running", prefix);
		Transition *t6 = stop(p4, "p4", prefix);
		Transition *t7 = stop(p3, "final", prefix);

#line  4763 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2176 "bpel-unparse-petri.k"

		footer(This->id);

#line  4769 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  4774 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4787 "bpel-kc-unpk.cc"
void
impl_tAssign_Assign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 191 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 191 "bpel-unparse-cfg.k"
		const tCopy_list b = this->tCopy_list_1;
#line 192 "bpel-unparse-cfg.k"

		CFGAssign * assign = new CFGAssign(this->id);
		cfgMap[intToString(this->id->value)] = assign;
		CFGBlock * last = NULL;
		int i = 1;
		std::string prefix = intToString(this->id->value);

		{
#line 199 "bpel-unparse-cfg.k"
		    tCopy_list kc_fe_selvar_1 =  b;

#line  4811 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCopy_list
			) {
			tCopy kc_selvar_0_1 = kc_fe_selvar_1->tCopy_1;
			{
#line 199 "bpel-unparse-cfg.k"
			    {
				{
#line 200 "bpel-unparse-cfg.k"
#line 199 "bpel-unparse-cfg.k"
				    const tCopy copy = kc_selvar_0_1;
#line 200 "bpel-unparse-cfg.k"

				    CFGCopy * copyBlock = new CFGCopy(prefix + "_" + intToString(i++));
				    copyBlock->prevBlock = last;
				    if (last != NULL)
				    {
					last->nextBlock = copyBlock;
				    }
				    assign->copyList.push_back(copyBlock);
				    last = copyBlock;

#line  4834 "bpel-kc-unpk.cc"
				}
			    }

#line  4838 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCopy_list_1;
#line 199 "bpel-unparse-cfg.k"

#line  4843 "bpel-kc-unpk.cc"
		    }
		}
#line 209 "bpel-unparse-cfg.k"


#line  4849 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 252 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 252 "bpel-unparse-xml.k"
		const tCopy_list b = this->tCopy_list_1;
#line 253 "bpel-unparse-xml.k"
		inup(); 
#line  4862 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<assign id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 253 "bpel-unparse-xml.k"
		indown(); 
#line  4872 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</assign>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 2200 "bpel-unparse-petri.k"
		const tAssign This = this/**/;
#line 2200 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2200 "bpel-unparse-petri.k"
		const tCopy_list b = this->tCopy_list_1;
#line 2202 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p5 = TheNet->newPlace(prefix + "stop");
		Place *p6 = TheNet->newPlace(prefix + "stopped");

		Transition *t4 = stop(p1, "initial", prefix);
		Transition *t7 = stop(p3, "final", prefix);

#line  4899 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2215 "bpel-unparse-petri.k"

		int copyCount = 1;
		Place *lastPlace = TheNet->findPlace(prefix + "initial");

		{
#line 2219 "bpel-unparse-petri.k"
		    tCopy_list kc_fe_selvar_1 =  b;

#line  4910 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCopy_list
			) {
			tCopy kc_selvar_0_1 = kc_fe_selvar_1->tCopy_1;
			{
#line 2219 "bpel-unparse-petri.k"
			    {
#line 2220 "bpel-unparse-petri.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Copy)) {
#line 2220 "bpel-unparse-petri.k"
#line 2219 "bpel-unparse-petri.k"
				    const tFrom from = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tFrom_1;
#line 2219 "bpel-unparse-petri.k"
				    const tTo to = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tTo_1;
#line 2220 "bpel-unparse-petri.k"

				    string newPrefix = prefix + "copy." + intToString(copyCount) + ".";

				    if (from->variable != mkcasestring(""))
				    {
					Place *p2 = TheNet->newPlace(newPrefix + "running");
					Place *p4 = TheNet->newPlace(newPrefix + "p4");
					Place *p8 = TheNet->newPlace(newPrefix + "final");

					Transition *t1 = TheNet->newTransition(newPrefix + "t1");
					TheNet->newArc(lastPlace, t1);
					TheNet->newArc(TheNet->findPlace("variable." + string(from->variableID->name)), t1, READ);
					TheNet->newArc(t1, p2);

					Transition *t2 = TheNet->newTransition(newPrefix + "t2");
					TheNet->newArc(p2, t2);
					TheNet->newArc(t2, p8);
					TheNet->newArc(TheNet->findPlace("variable." + string(to->variableID->name)), t2);
					TheNet->newArc(t2, TheNet->findPlace("variable." + string(to->variableID->name)));



					if (parameters[P_NOSTANDARDFAULTS] == false)
					Transition *t3 = throwFault(p2, p4, "running", newPrefix, This->negativeControlFlow);

					Transition *t6 = stop(p4, "p4at" + intToString(copyCount), prefix);


					lastPlace = p8;
				    }
				    else 
				    {
					Place *p4 = TheNet->newPlace(newPrefix + "p4");
					Place *p8 = TheNet->newPlace(newPrefix + "final");

					Transition *t2 = TheNet->newTransition(newPrefix + "t2");
					TheNet->newArc(lastPlace, t2);
					TheNet->newArc(TheNet->findPlace("variable." + string(to->variableID->name)), t2);
					TheNet->newArc(t2, TheNet->findPlace("variable." + string(to->variableID->name)));
					TheNet->newArc(t2, p8);



					if (parameters[P_NOSTANDARDFAULTS] == false)
					Transition *t3 = throwFault(lastPlace, p4, "initial", newPrefix, This->negativeControlFlow);

					Transition *t6 = stop(p4, "p4at" + intToString(copyCount), prefix);


					lastPlace = p8;
				    }
				    copyCount++;

#line  4979 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4984 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCopy_list_1;
#line 2219 "bpel-unparse-petri.k"

#line  4989 "bpel-kc-unpk.cc"
		    }
		}
#line 2273 "bpel-unparse-petri.k"

		TheNet->mergePlaces(TheNet->findPlace(prefix + "final"), lastPlace);

		footer(This->id);

#line  4998 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  5003 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  5023 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCopy_list iterator_ = this; iterator_->tCopy_list_1 != 0; iterator_ = iterator_->tCopy_list_1)
		    iterator_->tCopy_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  5041 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  5053 "bpel-kc-unpk.cc"
void
impl_tCopy_Copy::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 256 "bpel-unparse-xml.k"
		const tFrom a = this->tFrom_1;
#line 256 "bpel-unparse-xml.k"
		const tTo b = this->tTo_1;
#line 257 "bpel-unparse-xml.k"
		inup(); 
#line  5067 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<copy>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 257 "bpel-unparse-xml.k"
		indown(); 
#line  5073 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</copy>\n"), kc_current_view); }
	    }
	    break;
	}

#line  5079 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5092 "bpel-kc-unpk.cc"
void
impl_tFrom_From::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 261 "bpel-unparse-xml.k"
		in(); 
#line  5102 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<from />\n"), kc_current_view); }
	    }
	    break;
	}

#line  5108 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  5120 "bpel-kc-unpk.cc"
void
impl_tTo_To::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 265 "bpel-unparse-xml.k"
		in(); 
#line  5130 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<to />\n"), kc_current_view); }
	    }
	    break;
	}

#line  5136 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  5148 "bpel-kc-unpk.cc"
void
impl_tWait_Wait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 220 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 221 "bpel-unparse-cfg.k"

		cfgMap[intToString(this->id->value)] = new CFGWait(this->id); 

#line  5162 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 273 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 274 "bpel-unparse-xml.k"
		inup(); 
#line  5173 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<wait id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 274 "bpel-unparse-xml.k"
		indown(); 
#line  5182 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</wait>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((KC_TRACE_PROVIDED((this/**/->until != mkcasestring("")), "bpel-unparse-petri.k", 2294, this))) {
#line 2294 "bpel-unparse-petri.k"
		const tWait This = this/**/;
#line 2294 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2296 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "final");
		Place *p3 = TheNet->newPlace(prefix + "stop");
		Place *p4 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);
		TheNet->newArc(TheNet->findPlace("1.internal.clock"), t1, READ);



		Transition *t2 = stop(p1, "initial", prefix);
		Transition *t3 = stop(p2, "final", prefix);

#line  5214 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2316 "bpel-unparse-petri.k"

		footer(This->id);

#line  5220 "bpel-kc-unpk.cc"
	    } else
		if ((KC_TRACE_PROVIDED((this/**/->For != mkcasestring("")), "bpel-unparse-petri.k", 2330, this))) {
#line 2330 "bpel-unparse-petri.k"
		const tWait This = this/**/;
#line 2330 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2332 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "TimeStamp");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "stop");
		Place *p5 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);
		TheNet->newArc(TheNet->findPlace("1.internal.clock"), t1, READ);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);
		TheNet->newArc(TheNet->findPlace("1.internal.clock"), t2, READ);



		Transition *t3 = stop(p1, "initial", prefix);
		Transition *t4 = stop(p2, "TimeStamp", prefix);
		Transition *t5 = stop(p3, "final", prefix);

#line  5254 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2359 "bpel-unparse-petri.k"

		footer(This->id);

#line  5260 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  5266 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5280 "bpel-kc-unpk.cc"
void
impl_tThrow_Throw::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 232 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 233 "bpel-unparse-cfg.k"

		cfgMap[intToString(this->id->value)] = new CFGThrow(this->id); 

#line  5294 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 282 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 283 "bpel-unparse-xml.k"
		inup(); 
#line  5305 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<throw id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 283 "bpel-unparse-xml.k"
		indown(); 
#line  5314 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</throw>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 2377 "bpel-unparse-petri.k"
		const tThrow This = this/**/;
#line 2377 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2379 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "p2");
		Place *p3 = TheNet->newPlace(prefix + "stop");
		Place *p4 = TheNet->newPlace(prefix + "stopped");



		Transition *t1 = throwFault(p1, p2, "initial", prefix, This->negativeControlFlow);
		Transition *t2 = stop(p1, "initial", prefix);
		Transition *t3 = stop(p2, "p2", prefix);

#line  5342 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2395 "bpel-unparse-petri.k"

		footer(This->id);

#line  5348 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  5353 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5366 "bpel-kc-unpk.cc"
void
impl_tCompensate_Compensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 244 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 245 "bpel-unparse-cfg.k"

		cfgMap[intToString(this->id->value)] = new CFGCompensate(this->id); 

#line  5380 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 291 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 292 "bpel-unparse-xml.k"
		inup(); 
#line  5391 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<compensate id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 292 "bpel-unparse-xml.k"
		indown(); 
#line  5400 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</compensate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((KC_TRACE_PROVIDED((!this/**/->inFaultHandler && this/**/->scope == mkcasestring("")), "bpel-unparse-petri.k", 2423, this))) {
#line 2423 "bpel-unparse-petri.k"
		const tCompensate This = this/**/;
#line 2423 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2425 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "running");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "stop");
		Place *p5 = TheNet->newPlace(prefix + "comp");
		Place *p6 = TheNet->newPlace(prefix + "done");
		Place *p7 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);
		TheNet->newArc(t1, p5);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);
		TheNet->newArc(p6, t2);



		Transition *t3 = stop(p1, "initial", prefix);
		Transition *t4 = stop(p2, "running", prefix);
		Transition *t5 = stop(p3, "final", prefix);



		TheNet->mergePlaces(p4, TheNet->findPlace(currentScope + "internal.compensationHandler.p10"));
		TheNet->mergePlaces(p6, TheNet->findPlace(currentScope + "internal.compensationHandler.p12"));

#line  5446 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2459 "bpel-unparse-petri.k"

		footer(This->id);

#line  5452 "bpel-kc-unpk.cc"
	    } else
		if ((KC_TRACE_PROVIDED((this/**/->inFaultHandler && this/**/->scope == mkcasestring("")), "bpel-unparse-petri.k", 2475, this))) {
#line 2475 "bpel-unparse-petri.k"
		const tCompensate This = this/**/;
#line 2475 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2477 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "running");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "stop");
		Place *p5 = TheNet->newPlace(prefix + "ch_fh");
		Place *p6 = TheNet->newPlace(prefix + "ch_out");
		Place *p7 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);
		TheNet->newArc(t1, p5);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);
		TheNet->newArc(p6, t2);



		Transition *t3 = stop(p1, "initial", prefix);
		Transition *t4 = stop(p2, "running", prefix);
		Transition *t5 = stop(p3, "final", prefix);



		TheNet->mergePlaces(p5, TheNet->findPlace(currentScope + "faultHandler.ch_fh"));
		TheNet->mergePlaces(p6, TheNet->findPlace(currentScope + "faultHandler.ch_out"));

#line  5493 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2511 "bpel-unparse-petri.k"

		footer(This->id);

#line  5499 "bpel-kc-unpk.cc"
	    } else
		if ((KC_TRACE_PROVIDED((!this/**/->inFaultHandler && this/**/->scope != mkcasestring("")), "bpel-unparse-petri.k", 2527, this))) {
#line 2527 "bpel-unparse-petri.k"
		const tCompensate This = this/**/;
#line 2527 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2529 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "running");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "stop");
		Place *p5 = TheNet->newPlace(prefix + "compScope");
		Place *p6 = TheNet->newPlace(prefix + "scopeCompensated");
		Place *p7 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);
		TheNet->newArc(t1, p5);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);
		TheNet->newArc(p6, t2);



		Transition *t3 = stop(p1, "initial", prefix);
		Transition *t4 = stop(p2, "running", prefix);
		Transition *t5 = stop(p3, "final", prefix);



		TheNet->mergePlaces(p4, TheNet->findPlace(currentScope + "internal.compensationHandler.p10"));

#line  5539 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2562 "bpel-unparse-petri.k"

		footer(This->id);

#line  5545 "bpel-kc-unpk.cc"
	    } else
		if ((KC_TRACE_PROVIDED((this/**/->inFaultHandler && this/**/->scope != mkcasestring("")), "bpel-unparse-petri.k", 2578, this))) {
#line 2578 "bpel-unparse-petri.k"
		const tCompensate This = this/**/;
#line 2578 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2580 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "running");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "stop");
		Place *p5 = TheNet->newPlace(prefix + "ch_in");
		Place *p6 = TheNet->newPlace(prefix + "compensated");
		Place *p7 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);
		TheNet->newArc(t1, p5);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p3);
		TheNet->newArc(p6, t2);



		Transition *t3 = stop(p1, "initial", prefix);
		Transition *t4 = stop(p2, "running", prefix);
		Transition *t5 = stop(p3, "final", prefix);



		TheNet->mergePlaces(p5, TheNet->findPlace(currentScope + "faultHandler.ch_fh"));
		TheNet->mergePlaces(p6, TheNet->findPlace(currentScope + "faultHandler.ch_out"));

#line  5586 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2614 "bpel-unparse-petri.k"

		footer(This->id);

#line  5592 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  5598 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5612 "bpel-kc-unpk.cc"
void
impl_tTerminate_Terminate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 256 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 257 "bpel-unparse-cfg.k"

		cfgMap[intToString(this->id->value)] = new CFGTerminate(this->id); 

#line  5626 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 300 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 301 "bpel-unparse-xml.k"
		inup(); 
#line  5637 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<terminate id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 301 "bpel-unparse-xml.k"
		indown(); 
#line  5646 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</terminate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 2633 "bpel-unparse-petri.k"
		const tTerminate This = this/**/;
#line 2633 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2635 "bpel-unparse-petri.k"

		header(This->id);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p1 = TheNet->newPlace(prefix + "initial");
		Place *p2 = TheNet->newPlace(prefix + "final");
		Place *p3 = TheNet->newPlace(prefix + "stop");
		Place *p4 = TheNet->newPlace(prefix + "!Terminated");
		Place *p5 = TheNet->newPlace(prefix + "Terminated");
		Place *p6 = TheNet->newPlace(prefix + "terminate");
		Place *p7 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(p1, t1);
		TheNet->newArc(t1, p2);
		TheNet->newArc(p5, t1, READ);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p1, t2);
		TheNet->newArc(t2, p2);
		TheNet->newArc(t2, p5);
		TheNet->newArc(p4, t2);
		TheNet->newArc(t2, p6);



		Transition *t3 = stop(p1, "initial", prefix);
		Transition *t4 = stop(p2, "final", prefix);



		TheNet->mergePlaces(TheNet->findPlace("1.internal.!Terminated"), p4);
		TheNet->mergePlaces(TheNet->findPlace("1.internal.Terminated"), p5);
		TheNet->mergePlaces(TheNet->findPlace(currentScope + "upperTerminate"), p6);

#line  5694 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 2671 "bpel-unparse-petri.k"

		footer(This->id);

#line  5700 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  5705 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5718 "bpel-kc-unpk.cc"
void
impl_tFlow_Flow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 268 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 268 "bpel-unparse-cfg.k"
		const tLink_list b = this->tLink_list_1;
#line 268 "bpel-unparse-cfg.k"
		const activity_list c = this->activity_list_1;
#line 269 "bpel-unparse-cfg.k"

		CFGFlow * flow = new CFGFlow(this->id);
		cfgMap[intToString(this->id->value)] = flow;

#line  5737 "bpel-kc-unpk.cc"
		kc::unparse(c, kc_printer, kc_current_view);
#line 274 "bpel-unparse-cfg.k"

		{
#line 275 "bpel-unparse-cfg.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  5745 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 275 "bpel-unparse-cfg.k"
			    {
				{
#line 276 "bpel-unparse-cfg.k"
#line 275 "bpel-unparse-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 276 "bpel-unparse-cfg.k"

				    std::string label = intToString(innerActivity->id->value);
				    CFGBlock * activity = cfgMap.find(label)->second;
				    activity->prevBlock = flow;
				    flow->activityList.push_back(activity);

#line  5764 "bpel-kc-unpk.cc"
				}
			    }

#line  5768 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 275 "bpel-unparse-cfg.k"

#line  5773 "bpel-kc-unpk.cc"
		    }
		}
#line 281 "bpel-unparse-cfg.k"


#line  5779 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tLink_list_1->prod_sel() == sel_NiltLink_list)) {
#line 309 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 309 "bpel-unparse-xml.k"
		const activity_list c = this->activity_list_1;
#line 310 "bpel-unparse-xml.k"
		inup(); 
#line  5792 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 310 "bpel-unparse-xml.k"
		indown(); 
#line  5804 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    } else
	    {
#line 313 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 313 "bpel-unparse-xml.k"
		const tLink_list b = this->tLink_list_1;
#line 313 "bpel-unparse-xml.k"
		const activity_list c = this->activity_list_1;
#line 314 "bpel-unparse-xml.k"
		inup(); 
#line  5816 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 314 "bpel-unparse-xml.k"
		inup(); 
#line  5827 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<links>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 314 "bpel-unparse-xml.k"
		indown(); 
#line  5832 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</links>\n"), kc_current_view); }
		kc::unparse(c, kc_printer, kc_current_view);
#line 314 "bpel-unparse-xml.k"
		indown(); 
#line  5837 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 2690 "bpel-unparse-petri.k"
		const tFlow This = this/**/;
#line 2690 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 2690 "bpel-unparse-petri.k"
		const tLink_list b = this->tLink_list_1;
#line 2690 "bpel-unparse-petri.k"
		const activity_list c = this->activity_list_1;
#line 2692 "bpel-unparse-petri.k"

		header(This->id, true);
		string prefix = intToString(This->id->value) + ".internal.";

		Place *p7  = TheNet->newPlace(prefix + "initial");
		Place *p8  = TheNet->newPlace(prefix + "final");
		Place *p9  = TheNet->newPlace(prefix + "running");
		Place *p15 = TheNet->newPlace(prefix + "stop");
		Place *p16 = TheNet->newPlace(prefix + "stopped");

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p7, t2);
		TheNet->newArc(t2, p9);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(t3, p8);
		TheNet->newArc(p9, t3);

		Transition *t5 = TheNet->newTransition(prefix + "t5");
		TheNet->newArc(p9, t5);
		TheNet->newArc(p15, t5);

		Transition *t6 = TheNet->newTransition(prefix + "innerStopped");
		TheNet->newArc(t6, p16);



		Transition *t4 = stop(p7, "initial", prefix);
		Transition *t7 = stop(p8, "final", prefix);



		Transition *t1 = NULL;
		if (This->dpe->value > 0)
		{
		    Place *p1  = TheNet->newPlace(prefix + "negLink");
		    t1 = TheNet->newTransition(prefix + "t1");
		    TheNet->newArc(p1, t1);
		}

#line  5894 "bpel-kc-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 2734 "bpel-unparse-petri.k"

		{
#line 2735 "bpel-unparse-petri.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  5903 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 2735 "bpel-unparse-petri.k"
			    {
				{
#line 2736 "bpel-unparse-petri.k"
#line 2735 "bpel-unparse-petri.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 2736 "bpel-unparse-petri.k"

				    string newPrefix = intToString(innerActivity->id->value);

				    if (This->dpe->value > 0 && TheNet->findPlace(newPrefix + ".negLink") != NULL)
				    {
					TheNet->newArc(t1, TheNet->findPlace(newPrefix + ".negLink"));
				    }
				    TheNet->newArc(t2, TheNet->findPlace(innerActivity, ".initial"));
				    TheNet->newArc(t5, TheNet->findPlace(innerActivity, ".stop"));
				    TheNet->newArc(TheNet->findPlace(innerActivity, ".stopped"), t6);
				    TheNet->newArc(TheNet->findPlace(innerActivity, ".final"), t3);

#line  5928 "bpel-kc-unpk.cc"
				}
			    }

#line  5932 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 2735 "bpel-unparse-petri.k"

#line  5937 "bpel-kc-unpk.cc"
		    }
		}
#line 2748 "bpel-unparse-petri.k"
		footer(This->id, true);

#line  5943 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  5948 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_activity_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  5968 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (activity_list iterator_ = this; iterator_->activity_list_1 != 0; iterator_ = iterator_->activity_list_1)
		    iterator_->activity_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_activity_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  5986 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  6005 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tLink_list iterator_ = this; iterator_->tLink_list_1 != 0; iterator_ = iterator_->tLink_list_1)
		    iterator_->tLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  6023 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  6035 "bpel-kc-unpk.cc"
void
impl_tLink_Link::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 318 "bpel-unparse-xml.k"
		in(); 
#line  6045 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<link />\n"), kc_current_view); }
	    }
	    break;
	}

#line  6051 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  6063 "bpel-kc-unpk.cc"
void
impl_tSwitch_Switch::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    if ((this->tOtherwise_1->prod_sel() == sel_Otherwise)) {
#line 291 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 291 "bpel-unparse-cfg.k"
		const tCase_list b = this->tCase_list_1;
#line 291 "bpel-unparse-cfg.k"
		const activity c = phylum_cast<const impl_tOtherwise_Otherwise*>(this->tOtherwise_1)->activity_1;
#line 292 "bpel-unparse-cfg.k"

		CFGSwitch * cfgSwitch = new CFGSwitch(this->id);
		cfgMap[intToString(this->id->value)] = cfgSwitch;

#line  6082 "bpel-kc-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 298 "bpel-unparse-cfg.k"

		{
#line 299 "bpel-unparse-cfg.k"
		    tCase_list kc_fe_selvar_1 =  b;

#line  6091 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCase_list
			) {
			tCase kc_selvar_0_1 = kc_fe_selvar_1->tCase_1;
			{
#line 299 "bpel-unparse-cfg.k"
			    {
#line 300 "bpel-unparse-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Case)) {
#line 300 "bpel-unparse-cfg.k"
#line 299 "bpel-unparse-cfg.k"
				    const tCase caseBranch = kc_selvar_0_1;
#line 299 "bpel-unparse-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tCase_Case*>(kc_selvar_0_1)->activity_1;
#line 300 "bpel-unparse-cfg.k"

				    std::string label = intToString(innerActivity->id->value);
				    CFGBlock * activity = cfgMap.find(label)->second;
				    activity->prevBlock = cfgSwitch;
				    cfgSwitch->caseList.push_back(activity);

#line  6113 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  6118 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCase_list_1;
#line 299 "bpel-unparse-cfg.k"

#line  6123 "bpel-kc-unpk.cc"
		    }
		}
#line 306 "bpel-unparse-cfg.k"
		std::string label = intToString(c->id->value);
		CFGBlock * otherwise = cfgMap.find(label)->second;
		otherwise->prevBlock = cfgSwitch;
		cfgSwitch->otherwise = otherwise;

#line  6132 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 326 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 326 "bpel-unparse-xml.k"
		const tCase_list b = this->tCase_list_1;
#line 326 "bpel-unparse-xml.k"
		const tOtherwise c = this->tOtherwise_1;
#line 327 "bpel-unparse-xml.k"
		inup(); 
#line  6148 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<switch id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 327 "bpel-unparse-xml.k"
		indown(); 
#line  6161 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</switch>\n"), kc_current_view); }
	    }
	    break;
	}

#line  6167 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCase_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  6188 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCase_list iterator_ = this; iterator_->tCase_list_1 != 0; iterator_ = iterator_->tCase_list_1)
		    iterator_->tCase_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCase_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  6207 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  6220 "bpel-kc-unpk.cc"
void
impl_tCase_Case::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 330 "bpel-unparse-xml.k"
		const activity a = this->activity_1;
#line 331 "bpel-unparse-xml.k"
		inup(); 
#line  6232 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<case dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 331 "bpel-unparse-xml.k"
		indown(); 
#line  6239 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</case>\n"), kc_current_view); }
	    }
	    break;
	}

#line  6245 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6258 "bpel-kc-unpk.cc"
void
impl_tOtherwise_Otherwise::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 334 "bpel-unparse-xml.k"
		const activity a = this->activity_1;
#line 335 "bpel-unparse-xml.k"
		inup(); 
#line  6270 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<otherwise dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 335 "bpel-unparse-xml.k"
		indown(); 
#line  6277 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</otherwise>\n"), kc_current_view); }
	    }
	    break;
	}

#line  6283 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6296 "bpel-kc-unpk.cc"
void
impl_tWhile_While::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 319 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 319 "bpel-unparse-cfg.k"
		const activity b = this->activity_1;
#line 320 "bpel-unparse-cfg.k"

		CFGWhile * cfgWhile = new CFGWhile(this->id);
		cfgMap[intToString(this->id->value)] = cfgWhile;

#line  6313 "bpel-kc-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 325 "bpel-unparse-cfg.k"

		std::string label = intToString(b->id->value);
		CFGBlock * activity = cfgMap.find(label)->second;
		activity->prevBlock = cfgWhile;
		cfgWhile->loopActivity = activity;

#line  6322 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 343 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 343 "bpel-unparse-xml.k"
		const activity b = this->activity_1;
#line 344 "bpel-unparse-xml.k"
		inup(); 
#line  6335 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<while id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 344 "bpel-unparse-xml.k"
		indown(); 
#line  6345 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</while>\n"), kc_current_view); }
	    }
	    break;
	}

#line  6351 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6364 "bpel-kc-unpk.cc"
void
impl_tSequence_Sequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 339 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 339 "bpel-unparse-cfg.k"
		const activity_list b = this->activity_list_1;
#line 340 "bpel-unparse-cfg.k"

		CFGSequence * sequence = new CFGSequence(this->id);
		cfgMap[intToString(this->id->value)] = sequence;
		CFGBlock * last = NULL;

#line  6382 "bpel-kc-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 346 "bpel-unparse-cfg.k"

		{
#line 347 "bpel-unparse-cfg.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6390 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 347 "bpel-unparse-cfg.k"
			    {
				{
#line 348 "bpel-unparse-cfg.k"
#line 347 "bpel-unparse-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 348 "bpel-unparse-cfg.k"

				    std::string label = intToString(innerActivity->id->value);
				    CFGBlock * current = cfgMap.find(label)->second;
				    current->prevBlock = last;
				    if (last != NULL)
				    {
					last->nextBlock = current;
				    }
				    sequence->activityList.push_back(current);
				    last = current;

#line  6414 "bpel-kc-unpk.cc"
				}
			    }

#line  6418 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 347 "bpel-unparse-cfg.k"

#line  6423 "bpel-kc-unpk.cc"
		    }
		}
#line 358 "bpel-unparse-cfg.k"


#line  6429 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  6434 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6447 "bpel-kc-unpk.cc"
void
impl_tPick_Pick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 368 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 368 "bpel-unparse-cfg.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 368 "bpel-unparse-cfg.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 369 "bpel-unparse-cfg.k"

		CFGPick * cfgPick = new CFGPick(this->id);
		cfgMap[intToString(this->id->value)] = cfgPick;

#line  6466 "bpel-kc-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 375 "bpel-unparse-cfg.k"

		{
#line 376 "bpel-unparse-cfg.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  6475 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 376 "bpel-unparse-cfg.k"
			    {
#line 377 "bpel-unparse-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 377 "bpel-unparse-cfg.k"
#line 376 "bpel-unparse-cfg.k"
				    const tOnMessage message = kc_selvar_0_1;
#line 376 "bpel-unparse-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 377 "bpel-unparse-cfg.k"

				    std::string label = intToString(innerActivity->id->value);
				    CFGBlock * activity = cfgMap.find(label)->second;
				    activity->prevBlock = cfgPick;
				    cfgPick->messageList.push_back(activity);

#line  6497 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  6502 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 376 "bpel-unparse-cfg.k"

#line  6507 "bpel-kc-unpk.cc"
		    }
		}
#line 383 "bpel-unparse-cfg.k"
		{
#line 383 "bpel-unparse-cfg.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  6515 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 383 "bpel-unparse-cfg.k"
			    {
#line 384 "bpel-unparse-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 384 "bpel-unparse-cfg.k"
#line 383 "bpel-unparse-cfg.k"
				    const tOnAlarm alarm = kc_selvar_0_1;
#line 383 "bpel-unparse-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 384 "bpel-unparse-cfg.k"

				    std::string label = intToString(innerActivity->id->value);
				    CFGBlock * activity = cfgMap.find(label)->second;
				    activity->prevBlock = cfgPick;
				    cfgPick->alarmList.push_back(activity);

#line  6537 "bpel-kc-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  6542 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 383 "bpel-unparse-cfg.k"

#line  6547 "bpel-kc-unpk.cc"
		    }
		}
#line 390 "bpel-unparse-cfg.k"

#line  6552 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 361 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 361 "bpel-unparse-xml.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 361 "bpel-unparse-xml.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 362 "bpel-unparse-xml.k"
		inup(); 
#line  6567 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<pick id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 362 "bpel-unparse-xml.k"
		indown(); 
#line  6580 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</pick>\n"), kc_current_view); }
	    }
	    break;
	}

#line  6586 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6599 "bpel-kc-unpk.cc"
void
impl_tScope_Scope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 399 "bpel-unparse-cfg.k"
		const standardElements a = this->standardElements_1;
#line 399 "bpel-unparse-cfg.k"
		const tVariable_list b = this->tVariable_list_1;
#line 399 "bpel-unparse-cfg.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 399 "bpel-unparse-cfg.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 399 "bpel-unparse-cfg.k"
		const tEventHandlers e = this->tEventHandlers_1;
#line 399 "bpel-unparse-cfg.k"
		const tStop f = this->tStop_1;
#line 399 "bpel-unparse-cfg.k"
		const activity g = this->activity_1;
#line 400 "bpel-unparse-cfg.k"

		CFGScope * scope = new CFGScope(this->id);
		cfgMap[intToString(this->id->value)] = scope; 

#line  6626 "bpel-kc-unpk.cc"
		kc::unparse(g, kc_printer, kc_current_view);
#line 405 "bpel-unparse-cfg.k"

		scope->innerActivity = cfgMap.find(intToString(g->id->value))->second;


#line  6633 "bpel-kc-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 370 "bpel-unparse-xml.k"
		const standardElements a = this->standardElements_1;
#line 370 "bpel-unparse-xml.k"
		const tVariable_list b = this->tVariable_list_1;
#line 370 "bpel-unparse-xml.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 370 "bpel-unparse-xml.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 370 "bpel-unparse-xml.k"
		const tEventHandlers e = this->tEventHandlers_1;
#line 370 "bpel-unparse-xml.k"
		const tStop f = this->tStop_1;
#line 370 "bpel-unparse-xml.k"
		const activity g = this->activity_1;
#line 371 "bpel-unparse-xml.k"
		inup(); 
#line  6656 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<scope id=\""), kc_current_view); }
		kc::unparse(this->id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 375 "bpel-unparse-xml.k"
		if (b->length() == 0) 
#line  6667 "bpel-kc-unpk.cc"
		{
		}
#line 377 "bpel-unparse-xml.k"
		else 
#line  6672 "bpel-kc-unpk.cc"
		{
#line 378 "bpel-unparse-xml.k"
		    inup(); 
#line  6676 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("<variables id=\""), kc_current_view); }
		    kc::unparse(this->id, kc_printer, kc_current_view);
		    { kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		    kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		    { kc_printer(kc_t("\">\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 378 "bpel-unparse-xml.k"
		    indown(); 
#line  6685 "bpel-kc-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 382 "bpel-unparse-xml.k"
		indown(); 
#line  6695 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("</scope>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    {
#line 3256 "bpel-unparse-petri.k"
		const tScope This = this/**/;
#line 3256 "bpel-unparse-petri.k"
		const standardElements a = this->standardElements_1;
#line 3256 "bpel-unparse-petri.k"
		const tVariable_list b = this->tVariable_list_1;
#line 3256 "bpel-unparse-petri.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 3256 "bpel-unparse-petri.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 3256 "bpel-unparse-petri.k"
		const tEventHandlers e = this->tEventHandlers_1;
#line 3256 "bpel-unparse-petri.k"
		const tStop f = this->tStop_1;
#line 3256 "bpel-unparse-petri.k"
		const activity g = this->activity_1;
#line 3258 "bpel-unparse-petri.k"

		header(This->id, true);
		string prefix = intToString(This->id->value) + ".internal.";
		currentScope = prefix;
		SymbolScope *me = symMan.getScope(this->id);



		for (list< SymbolScope * >::iterator child = me->children.begin(); child != me->children.end(); child++)
		{
		    Place *push_child    = TheNet->newPlace( intToString((*child)->id->value) + ".push");
		    Place *notPush_child = TheNet->newPlace( intToString((*child)->id->value) + ".!push");
		}



		if (This->dpe->value > 0)
		{
		    Place *p1  = TheNet->newPlace(prefix + "negLink");
		}
		Place *p2  = TheNet->newPlace(prefix + "initial");
		Place *p3  = TheNet->newPlace(prefix + "ch_in");
		Place *p4  = TheNet->newPlace(prefix + "scopeCompensated");
		Place *p6  = TheNet->newPlace(prefix + "p6");
		Place *p7  = TheNet->newPlace(prefix + "upperTerminate");
		Place *p8  = TheNet->newPlace(prefix + "!Terminated");
		Place *p9  = TheNet->newPlace(prefix + "Terminated");
		Place *p10 = TheNet->newPlace(prefix + "Active");
		Place *p11 = TheNet->newPlace(prefix + "!Completed");
		Place *p12 = TheNet->newPlace(prefix + "Completed");
		Place *p13 = TheNet->newPlace(prefix + "!Compensated");
		Place *p14 = TheNet->newPlace(prefix + "!Active");
		Place *p15 = TheNet->newPlace(prefix + "Compensated");
		Place *p16 = TheNet->newPlace(prefix + "!Ended");
		Place *p17 = TheNet->newPlace(prefix + "Ended");
		Place *p18 = TheNet->newPlace(prefix + "!Faulted");
		Place *p19 = TheNet->newPlace(prefix + "Faulted");
		Place *p20 = TheNet->newPlace(prefix + "stop");
		Place *p21 = TheNet->newPlace(prefix + "p21");
		Place *p22 = TheNet->newPlace(prefix + "p22");
		Place *p23 = TheNet->newPlace(prefix + "p23");
		Place *p24 = TheNet->newPlace(prefix + "p24");
		Place *p35 = TheNet->newPlace(prefix + "p35");
		Place *p36 = TheNet->newPlace(prefix + "p36");
		Place *p37 = TheNet->newPlace(prefix + "p37");
		Place *p38 = TheNet->newPlace(prefix + "p38");
		Place *p39 = TheNet->newPlace(prefix + "p39");
		Place *p40 = TheNet->newPlace(prefix + "p40");
		Place *p41 = TheNet->newPlace(prefix + "p41");
		Place *p42 = TheNet->newPlace(prefix + "p42");
		Place *p43 = TheNet->newPlace(prefix + "p43");
		Place *p44 = TheNet->newPlace(prefix + "p44");
		Place *p45 = TheNet->newPlace(prefix + "stopped");
		Place *p46 = TheNet->newPlace(prefix + "p46");
		Place *p47 = TheNet->newPlace(prefix + "p47");
		Place *p48 = TheNet->newPlace(prefix + "p48");
		Place *p49 = TheNet->newPlace(prefix + "p49");
		Place *p50 = TheNet->newPlace(prefix + "p50");
		Place *p51 = TheNet->newPlace(prefix + "final");
		Place *p52 = TheNet->newPlace(prefix + "p52");
		Place *p53 = TheNet->newPlace(prefix + "p53");
		Place *p54 = TheNet->newPlace(prefix + "p54");
		Place *p56 = TheNet->newPlace(prefix + "compensated");






		Place *fh_faulted = TheNet->newPlace(prefix + "FHFaulted");
		Place *fh_not_faulted = TheNet->newPlace(prefix + "!FHFaulted");
		Place *ch_faulted = TheNet->newPlace(prefix + "CHFaulted");
		Place *ch_not_faulted = TheNet->newPlace(prefix + "!CHFaulted");



		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p2, t2);
		TheNet->newArc(t2, p10);
		TheNet->newArc(t2, p11);
		TheNet->newArc(t2, p13);
		TheNet->newArc(t2, p16);
		TheNet->newArc(t2, p18);
		TheNet->newArc(t2, p21);
		TheNet->newArc(t2, fh_not_faulted);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p10, t4);
		TheNet->newArc(p11, t4);
		TheNet->newArc(t4, p12);
		TheNet->newArc(t4, p14);
		TheNet->newArc(TheNet->findPlace(intToString(This->id->value) + ".!push"), t4);
		TheNet->newArc(t4, TheNet->findPlace(intToString(This->id->value) + ".push"));
		TheNet->newArc(p35, t4);
		TheNet->newArc(t4, p51);

		Transition *t7 = TheNet->newTransition(prefix + "t7");
		TheNet->newArc(p8, t7, READ);
		TheNet->newArc(p10, t7);
		TheNet->newArc(t7, p14);
		TheNet->newArc(p20, t7);
		TheNet->newArc(t7, p36);

		Transition *t8 = TheNet->newTransition(prefix + "t8");
		TheNet->newArc(p9, t8, READ);
		TheNet->newArc(p10, t8);
		TheNet->newArc(t8, p14);
		TheNet->newArc(p20, t8);
		TheNet->newArc(t8, p37);

		Transition *t16 = TheNet->newTransition(prefix + "t16");
		TheNet->newArc(p53, t16);



		Transition *t9  = stop(p2, "initial", prefix);
		Transition *t10 = stop(p17, "Ended", prefix);
		TheNet->newArc(t10, p17); 
		Transition *t11 = stop(p51, "final", prefix);





		if (This->hasEH)
		{
		    Place *p25 = TheNet->newPlace(prefix + "p25");
		    Place *p26 = TheNet->newPlace(prefix + "p26");
		    Place *p27 = TheNet->newPlace(prefix + "p27");
		    Place *p28 = TheNet->newPlace(prefix + "p28");
		    Place *p29 = TheNet->newPlace(prefix + "p29");

		    TheNet->newArc(t2, p25);
		    TheNet->newArc(p27, t4);

		    Transition *t1 = TheNet->newTransition(prefix + "t1");
		    TheNet->newArc(p29, t1);
		    TheNet->newArc(t1, p38);

		    Transition *t3 = TheNet->newTransition(prefix + "t3");
		    TheNet->newArc(p22, t3);
		    TheNet->newArc(t3, p26);
		    TheNet->newArc(t3, p35);

		    Transition *t5 = TheNet->newTransition(prefix + "t5");
		    TheNet->newArc(p24, t5);
		    TheNet->newArc(t5, p28);

		    Transition *t6 = TheNet->newTransition(prefix + "t6");
		    TheNet->newArc(p23, t6);
		    TheNet->newArc(t6, p28);
		    TheNet->newArc(p35, t6);
		}
		else
		{
		    TheNet->mergePlaces(p22, p35);
		    TheNet->mergePlaces(p24, p38);
		}


		Transition *t12 = TheNet->newTransition(prefix + "passFaultUp");
		TheNet->newArc(p48, t12);
		TheNet->newArc(TheNet->findPlace(intToString(This->parentScopeId->value) + ".internal.Active"), t12);
		TheNet->newArc(t12, TheNet->findPlace(intToString(This->parentScopeId->value) + ".internal.!Active")); 
		TheNet->newArc(t12, TheNet->findPlace(intToString(This->parentScopeId->value) + ".internal.stop.fault_in"));

		Transition *t13 = TheNet->newTransition(prefix + "ignoreFault");
		TheNet->newArc(p48, t13);
		TheNet->newArc(TheNet->findPlace(intToString(This->parentScopeId->value) + ".internal.!Active"), t13, READ);



		TheNet->mergePlaces(TheNet->findPlace(intToString(This->parentScopeId->value) +
			".internal.compensationHandler.compScope." + intToString(This->id->value)), p3); 
		TheNet->mergePlaces(TheNet->findPlace(intToString(This->parentScopeId->value) + ".internal.scopeCompensated"), p56);
		TheNet->mergePlaces(TheNet->findPlace(intToString(This->parentScopeId->value) + ".internal.upperTerminate"), p46);

#line  6897 "bpel-kc-unpk.cc"
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 3441 "bpel-unparse-petri.k"




		for (list<SymbolScope*>::iterator child = me->children.begin(); child != me->children.end(); child++)
		TheNet->newArc(t2, TheNet->findPlace( intToString((*child)->id->value) + ".!push" ));

		string prefix2 = intToString(This->id->value) + ".internal.";



		TheNet->mergePlaces(prefix + "p43",     prefix2 + "faultHandler.fault");
		TheNet->mergePlaces(prefix + "p44",     prefix2 + "faultHandler.faultSave");
		TheNet->mergePlaces(prefix + "p47",     prefix2 + "faultHandler.rethrow");
		TheNet->mergePlaces(prefix + "p41",     prefix2 + "faultHandler.ft");
		TheNet->mergePlaces(prefix + "p42",     prefix2 + "faultHandler.ftSave");
		TheNet->mergePlaces(prefix + "!Ended",  prefix2 + "faultHandler.!Ended");
		TheNet->mergePlaces(prefix + "Ended",   prefix2 + "faultHandler.Ended");
		TheNet->mergePlaces(prefix + "p49",     prefix2 + "faultHandler.ch_fh");
		TheNet->mergePlaces(prefix + "p50",     prefix2 + "faultHandler.ch_out");
		TheNet->mergePlaces(prefix + "final",   prefix2 + "faultHandler.out");
		TheNet->mergePlaces(prefix + "p52",     prefix2 + "faultHandler.trueOut");
		TheNet->mergePlaces(prefix + "p53",     prefix2 + "faultHandler.sourceFalse");
		TheNet->mergePlaces(prefix + "p54",     prefix2 + "faultHandler.falseOut");
		TheNet->mergePlaces(prefix + "p48",     prefix2 + "faultHandler.upperFH");
		TheNet->mergePlaces(prefix + "stopped", prefix2 + "faultHandler.stopped");



		TheNet->mergePlaces(prefix + "ch_in",            prefix2 + "compensationHandler.ch_in");
		TheNet->mergePlaces(prefix + "Completed",        prefix2 + "compensationHandler.Completed");
		TheNet->mergePlaces(prefix + "!Completed",       prefix2 + "compensationHandler.!Completed");
		TheNet->mergePlaces(prefix + "Compensated",      prefix2 + "compensationHandler.Compensated");
		TheNet->mergePlaces(prefix + "!Compensated",     prefix2 + "compensationHandler.!Compensated");
		TheNet->mergePlaces(prefix + "p49",              prefix2 + "compensationHandler.fh");
		TheNet->mergePlaces(prefix + "scopeCompensated", prefix2 + "compensationHandler.scopeCompensated");
		TheNet->mergePlaces(prefix + "p39",              prefix2 + "compensationHandler.clean");
		TheNet->mergePlaces(prefix + "p40",              prefix2 + "compensationHandler.cleaned");
		TheNet->mergePlaces(prefix + "p50",              prefix2 + "compensationHandler.ch_out");
		TheNet->mergePlaces(prefix + "compensated",      prefix2 + "compensationHandler.compensated");



		if (This->hasEH)
		{
		    TheNet->mergePlaces(prefix + "p25", prefix2 + "eventHandler.initial");
		    TheNet->mergePlaces(prefix + "p26", prefix2 + "eventHandler.finish");
		    TheNet->mergePlaces(prefix + "p27", prefix2 + "eventHandler.final");
		    TheNet->mergePlaces(prefix + "p28", prefix2 + "eventHandler.stop");
		    TheNet->mergePlaces(prefix + "p29", prefix2 + "eventHandler.stopped");
		}



		TheNet->mergePlaces(prefix + "p36",            prefix + "stop.ft_in");
		TheNet->mergePlaces(prefix + "Faulted",        prefix + "stop.Faulted");
		TheNet->mergePlaces(prefix + "p6",             prefix + "stop.fault_in");
		TheNet->mergePlaces(prefix + "Active",         prefix + "stop.Active");
		TheNet->mergePlaces(prefix + "p37",            prefix + "stop.terminate_up");
		TheNet->mergePlaces(prefix + "!Active",        prefix + "stop.!Active");
		TheNet->mergePlaces(prefix + "upperTerminate", prefix + "stop.terminate");
		TheNet->mergePlaces(prefix + "!Faulted",       prefix + "stop.!Faulted");
		TheNet->mergePlaces(prefix + "Ended",          prefix + "stop.Ended");
		TheNet->mergePlaces(prefix + "Compensated",    prefix + "stop.Compensated");
		TheNet->mergePlaces(prefix + "!Ended",         prefix + "stop.!Ended");
		TheNet->mergePlaces(prefix + "p23",            prefix + "stop.stop");
		TheNet->mergePlaces(prefix + "p38",            prefix + "stop.stopped");
		TheNet->mergePlaces(prefix + "p39",            prefix + "stop.cleanCH");
		TheNet->mergePlaces(prefix + "p40",            prefix + "stop.ch_cleaned");
		TheNet->mergePlaces(prefix + "p41",            prefix + "stop.ft");
		TheNet->mergePlaces(prefix + "p42",            prefix + "stop.ftSave");
		TheNet->mergePlaces(prefix + "p43",            prefix + "stop.fault");
		TheNet->mergePlaces(prefix + "p44",            prefix + "stop.faultSave");
		TheNet->mergePlaces(prefix + "stopped",        prefix + "stop.stopped_s");
		TheNet->mergePlaces(prefix + "p46",            prefix + "stop.upperTerminate");
		TheNet->mergePlaces(prefix + "p47",            prefix + "stop.rethrow");
		TheNet->mergePlaces(prefix + "p48",            prefix + "stop.upperFH");

		TheNet->mergePlaces(prefix + "FHFaulted",      prefix + "stop.FHFaulted");
		TheNet->mergePlaces(prefix + "!FHFaulted",     prefix + "stop.!FHFaulted");
		TheNet->mergePlaces(prefix + "CHFaulted",      prefix + "stop.CHFaulted");
		TheNet->mergePlaces(prefix + "!CHFaulted",     prefix + "stop.!CHFaulted");




		if (This->dpe->value > 0)
		{
		    TheNet->mergePlaces(TheNet->findPlace(prefix + "negLink"), TheNet->findPlace(g, ".negLink"));
		}
		TheNet->mergePlaces(TheNet->findPlace(prefix + "p21"), TheNet->findPlace(g, ".initial"));
		TheNet->mergePlaces(TheNet->findPlace(prefix + "p22"), TheNet->findPlace(g, ".final"));
		TheNet->mergePlaces(TheNet->findPlace(prefix + "p23"), TheNet->findPlace(g, ".stop"));
		TheNet->mergePlaces(TheNet->findPlace(prefix + "p24"), TheNet->findPlace(g, ".stopped"));



		TheNet->mergePlaces(TheNet->findPlace("1.internal.!Terminated"), p8);
		TheNet->mergePlaces(TheNet->findPlace("1.internal.Terminated"), p9);



		for (list<string>::iterator link = ((ScopeScope *)me)->innerLinks.begin(); link != ((ScopeScope *)me)->innerLinks.end(); link++)
		{
		    Place *p61 = TheNet->newPlace(prefix + "p61.link." + *link);
		    Place *p62 = TheNet->findPlace("link." + *link);
		    Place *p63 = TheNet->findPlace("!link." + *link);
		    Transition *t14 = TheNet->newTransition(prefix + "t14.link." + *link);
		    Transition *t15 = TheNet->newTransition(prefix + "t15.link." + *link);
		    TheNet->newArc(p61, t14);
		    TheNet->newArc(t14, p62);
		    TheNet->newArc(p63, t14);
		    TheNet->newArc(p61, t15);
		    TheNet->newArc(t16, p61);
		    TheNet->newArc(p62, t15, READ);
		}

		currentScope = intToString(This->parentScopeId->value) + ".internal.";
		footer(This->id, true);

#line  7025 "bpel-kc-unpk.cc"
	    }
	    break;
	}

#line  7030 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7043 "bpel-kc-unpk.cc"
void
impl_standardElements_StandardElements::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case petrinet_enum: {
	    petrinet_class& kc_current_view=static_cast<petrinet_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 3572 "bpel-unparse-petri.k"
		const standardElements This = this/**/;
#line 3574 "bpel-unparse-petri.k"

		string prefix = intToString(This->parentId->value) + ".";
		string newPrefix = intToString(This->parentId->value) + ".internal";

		Place *p2 = TheNet->newPlace(prefix + "initial");
		Place *p3 = TheNet->newPlace(prefix + "final");
		Place *p4 = TheNet->newPlace(prefix + "stop");
		Place *p5 = TheNet->newPlace(prefix + "stopped");




		if (This->dpe->value > 0)
		{
		    Place *p1 = TheNet->newPlace(prefix + "negLink");
		    TheNet->mergePlaces(p1, TheNet->findPlace(newPrefix + ".negLink"));
		}



		TheNet->mergePlaces(p2, TheNet->findPlace(newPrefix + ".initial"));
		TheNet->mergePlaces(p3, TheNet->findPlace(newPrefix + ".final"));
		TheNet->mergePlaces(p4, TheNet->findPlace(newPrefix + ".stop"));
		TheNet->mergePlaces(p5, TheNet->findPlace(newPrefix + ".stopped"));

#line  7079 "bpel-kc-unpk.cc"
	    } else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 3610 "bpel-unparse-petri.k"
		const standardElements This = this/**/;
#line 3610 "bpel-unparse-petri.k"
		const tSource_list a = this->tSource_list_1;
#line 3612 "bpel-unparse-petri.k"

		trace(TRACE_DEBUG, "[PNU]" + inString() + "Fig. 22\n");
		string prefix = intToString(This->parentId->value) + ".";
		string newPrefix = intToString(This->parentId->value) + ".internal";

		Place *p2 = TheNet->newPlace(prefix + "initial");
		Place *p3 = TheNet->newPlace(prefix + "p3");
		Place *p4 = TheNet->newPlace(prefix + "p4");
		Place *p5 = TheNet->newPlace(prefix + "final");
		Place *p6 = TheNet->newPlace(prefix + "stop");
		Place *p7 = TheNet->newPlace(prefix + "stopped");

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p4, t2);
		TheNet->newArc(t2, p5);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(p4, t3);
		TheNet->newArc(t3, p5);



		Transition *t4 = stop(p5, "final", prefix);





		Transition *t1 = NULL;
		if (This->dpe->value > 0)
		{
		    Place *p1 = TheNet->newPlace(prefix + "negLink");
		    t1 = TheNet->newTransition(prefix + "t1");
		    TheNet->newArc(p1, t1);

		    Place *p3 = TheNet->findPlace(newPrefix + ".negLink");
		    if (p3 != NULL)
		    {
			TheNet->newArc(t1, p3);
			TheNet->mergePlaces(p3, TheNet->findPlace(newPrefix + ".negLink"));
		    }
		}




		{
#line 3658 "bpel-unparse-petri.k"
		    tSource_list kc_fe_selvar_1 =  a;

#line  7137 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 3658 "bpel-unparse-petri.k"
			    {
				{
#line 3659 "bpel-unparse-petri.k"
#line 3658 "bpel-unparse-petri.k"
				    const tSource link = kc_selvar_0_1;
#line 3659 "bpel-unparse-petri.k"

				    Place *p8 = TheNet->findPlace("!link." + string(link->linkID->name));
				    Place *p10 = TheNet->findPlace("link." + string(link->linkID->name));

				    TheNet->newArc(p8, t2);
				    TheNet->newArc(t2, p10);
				    TheNet->newArc(p10, t3, READ);

				    if (This->dpe->value > 0)
				    {
					TheNet->newArc(t1, p10);
					TheNet->newArc(p8, t1);
				    }

#line  7164 "bpel-kc-unpk.cc"
				}
			    }

#line  7168 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 3658 "bpel-unparse-petri.k"

#line  7173 "bpel-kc-unpk.cc"
		    }
		}
#line 3673 "bpel-unparse-petri.k"



		TheNet->mergePlaces(p2, TheNet->findPlace(newPrefix + ".initial"));
		TheNet->mergePlaces(p4, TheNet->findPlace(newPrefix + ".final"));
		TheNet->mergePlaces(p6, TheNet->findPlace(newPrefix + ".stop"));
		TheNet->mergePlaces(p7, TheNet->findPlace(newPrefix + ".stopped"));

#line  7185 "bpel-kc-unpk.cc"
	    } else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJoinFailure == mkcasestring("no")), "bpel-unparse-petri.k", 3693, this))) {
#line 3693 "bpel-unparse-petri.k"
		const standardElements This = this/**/;
#line 3693 "bpel-unparse-petri.k"
		const tTarget_list a = this->tTarget_list_1;
#line 3695 "bpel-unparse-petri.k"

		trace(TRACE_DEBUG, "[PNU]" + inString() + "Fig. 23\n");
		string prefix = intToString(This->parentId->value) + ".";
		string newPrefix = intToString(This->parentId->value) + ".internal";

		Place *p6  = TheNet->newPlace(prefix + "p6");
		Place *p7  = TheNet->newPlace(prefix + "final");
		Place *p8  = TheNet->newPlace(prefix + "initial");
		Place *p9  = TheNet->newPlace(prefix + "stop");
		Place *p10 = TheNet->newPlace(prefix + "stopped");
		Place *p11 = TheNet->newPlace(prefix + "p11");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(t1, p6);
		TheNet->newArc(p8, t1);



		Transition *t2 = throwFault(p8, p11, "initial", prefix, This->negativeControlFlow);

		Transition *t3 = stop(p8, "initial", prefix);
		Transition *t4 = stop(p11, "p11", prefix);



		{
#line 3720 "bpel-unparse-petri.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  7222 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 3720 "bpel-unparse-petri.k"
			    {
				{
#line 3721 "bpel-unparse-petri.k"
#line 3720 "bpel-unparse-petri.k"
				    const tTarget link = kc_selvar_0_1;
#line 3721 "bpel-unparse-petri.k"

				    Place *p1 = TheNet->findPlace("!link." + string(link->linkID->name));
				    Place *p3 = TheNet->findPlace("link." + string(link->linkID->name));
				    TheNet->newArc(t1, p1);
				    TheNet->newArc(p3, t1);
				    TheNet->newArc(t2, p1);
				    TheNet->newArc(p3, t2);

#line  7243 "bpel-kc-unpk.cc"
				}
			    }

#line  7247 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 3720 "bpel-unparse-petri.k"

#line  7252 "bpel-kc-unpk.cc"
		    }
		}
#line 3729 "bpel-unparse-petri.k"




		Place *p5 = TheNet->findPlace(newPrefix + ".negLink");
		if (p5 != NULL)
		{
		    Place *p5a = TheNet->newPlace(prefix + "negLink");
		    TheNet->newArc(t2, p5a);
		    TheNet->mergePlaces(p5a, p5);
		}



		TheNet->mergePlaces(p6,  TheNet->findPlace(newPrefix + ".initial"));
		TheNet->mergePlaces(p7,  TheNet->findPlace(newPrefix + ".final"));
		TheNet->mergePlaces(p9,  TheNet->findPlace(newPrefix + ".stop"));
		TheNet->mergePlaces(p10, TheNet->findPlace(newPrefix + ".stopped"));

#line  7275 "bpel-kc-unpk.cc"
	    } else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJoinFailure == mkcasestring("yes")), "bpel-unparse-petri.k", 3760, this))) {
#line 3760 "bpel-unparse-petri.k"
		const standardElements This = this/**/;
#line 3760 "bpel-unparse-petri.k"
		const tTarget_list a = this->tTarget_list_1;
#line 3762 "bpel-unparse-petri.k"

		trace(TRACE_DEBUG, "[PNU]" + inString() + "Fig. 24\n");
		string prefix = intToString(This->parentId->value) + ".";
		string newPrefix = intToString(This->parentId->value) + ".internal";

		Place *p6  = TheNet->newPlace(prefix + "p6");
		Place *p7  = TheNet->newPlace(prefix + "final");
		Place *p8  = TheNet->newPlace(prefix + "initial");
		Place *p9  = TheNet->newPlace(prefix + "stop");
		Place *p10 = TheNet->newPlace(prefix + "stopped");

		Transition *t1 = TheNet->newTransition(prefix + "t1");
		TheNet->newArc(t1, p6);
		TheNet->newArc(p8, t1);

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(p8, t2);
		TheNet->newArc(t2, p7);



		Transition *t3 = stop(p8, "initial", prefix);



		{
#line 3787 "bpel-unparse-petri.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  7312 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 3787 "bpel-unparse-petri.k"
			    {
				{
#line 3788 "bpel-unparse-petri.k"
#line 3787 "bpel-unparse-petri.k"
				    const tTarget link = kc_selvar_0_1;
#line 3788 "bpel-unparse-petri.k"

				    Place *p1 = TheNet->findPlace("!link." + string(link->linkID->name));
				    Place *p3 = TheNet->findPlace("link." + string(link->linkID->name));
				    TheNet->newArc(t1, p1);
				    TheNet->newArc(p3, t1);
				    TheNet->newArc(t2, p1);
				    TheNet->newArc(p3, t2);

#line  7333 "bpel-kc-unpk.cc"
				}
			    }

#line  7337 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 3787 "bpel-unparse-petri.k"

#line  7342 "bpel-kc-unpk.cc"
		    }
		}
#line 3796 "bpel-unparse-petri.k"




		Place *p5 = TheNet->findPlace(newPrefix + ".negLink");
		if (p5 != NULL)
		{
		    Place *p5a = TheNet->newPlace(prefix + "negLink");
		    TheNet->newArc(t2, p5);
		    TheNet->mergePlaces(p5a, p5);
		}



		TheNet->mergePlaces(p6, TheNet->findPlace(newPrefix + ".initial"));
		TheNet->mergePlaces(p7, TheNet->findPlace(newPrefix + ".final"));
		TheNet->mergePlaces(p9, TheNet->findPlace(newPrefix + ".stop"));
		TheNet->mergePlaces(p10, TheNet->findPlace(newPrefix + ".stopped"));

#line  7365 "bpel-kc-unpk.cc"
	    } else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJoinFailure == mkcasestring("yes")), "bpel-unparse-petri.k", 3827, this))) {
#line 3827 "bpel-unparse-petri.k"
		const standardElements This = this/**/;
#line 3827 "bpel-unparse-petri.k"
		const tTarget_list a = this->tTarget_list_1;
#line 3827 "bpel-unparse-petri.k"
		const tSource_list b = this->tSource_list_1;
#line 3829 "bpel-unparse-petri.k"

		trace(TRACE_DEBUG, "[PNU]" + inString() + "Fig. 25\n");
		string prefix = intToString(This->parentId->value) + ".";
		string newPrefix = intToString(This->parentId->value) + ".internal";

		Place *p11 = TheNet->newPlace(prefix + "p11");
		Place *p12 = TheNet->newPlace(prefix + "p12");
		Place *p13 = TheNet->newPlace(prefix + "final");
		Place *p14 = TheNet->newPlace(prefix + "stop");
		Place *p15 = TheNet->newPlace(prefix + "stopped");
		Place *p16 = TheNet->newPlace(prefix + "initial");

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(t2, p11);
		TheNet->newArc(p16, t2);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(p12, t3);
		TheNet->newArc(t3, p13);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p12, t4);
		TheNet->newArc(t4, p13);

		Transition *t5 = TheNet->newTransition(prefix + "t5");
		TheNet->newArc(t5, p13);
		TheNet->newArc(p16, t5);



		Transition *t6 = stop(p16, "initial", prefix);
		Transition *t7 = stop(p13, "final", prefix);




		Transition *t1 = NULL;
		if (This->dpe->value > 0)
		{
		    Place *p9  = TheNet->newPlace(prefix + "negLink");

		    t1 = TheNet->newTransition(prefix + "t1");
		    TheNet->newArc(p9, t1);

		    Place *p10 = TheNet->findPlace(newPrefix + ".negLink");
		    if (p10 != NULL)
		    TheNet->newArc(t1, p10);
		}



		{
#line 3880 "bpel-unparse-petri.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  7430 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 3880 "bpel-unparse-petri.k"
			    {
				{
#line 3881 "bpel-unparse-petri.k"
#line 3880 "bpel-unparse-petri.k"
				    const tTarget link = kc_selvar_0_1;
#line 3881 "bpel-unparse-petri.k"

				    Place *p1 = TheNet->findPlace("!link." + string(link->linkID->name));
				    Place *p3 = TheNet->findPlace("link." + string(link->linkID->name));
				    TheNet->newArc(t2, p1);
				    TheNet->newArc(p3, t2);
				    TheNet->newArc(t5, p1);
				    TheNet->newArc(p3, t5);

#line  7451 "bpel-kc-unpk.cc"
				}
			    }

#line  7455 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 3880 "bpel-unparse-petri.k"

#line  7460 "bpel-kc-unpk.cc"
		    }
		}
#line 3889 "bpel-unparse-petri.k"




		{
#line 3893 "bpel-unparse-petri.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  7472 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 3893 "bpel-unparse-petri.k"
			    {
				{
#line 3894 "bpel-unparse-petri.k"
#line 3893 "bpel-unparse-petri.k"
				    const tSource link = kc_selvar_0_1;
#line 3894 "bpel-unparse-petri.k"

				    Place *p5 = TheNet->findPlace("!link." + string(link->linkID->name));
				    Place *p7 = TheNet->findPlace("link." + string(link->linkID->name));

				    TheNet->newArc(p5, t3);
				    TheNet->newArc(t3, p7);
				    TheNet->newArc(p5, t5);
				    TheNet->newArc(t5, p7);
				    TheNet->newArc(p7, t4, READ);
				    if (This->dpe->value > 0)
				    {
					TheNet->newArc(p5, t1);
					TheNet->newArc(t1, p7);
				    }

#line  7500 "bpel-kc-unpk.cc"
				}
			    }

#line  7504 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 3893 "bpel-unparse-petri.k"

#line  7509 "bpel-kc-unpk.cc"
		    }
		}
#line 3909 "bpel-unparse-petri.k"




		Place *p10 = TheNet->findPlace(newPrefix + ".negLink");
		if (p10 != NULL)
		{
		    TheNet->newArc(t5, p10);
		    if (This->dpe->value > 0)
		    TheNet->mergePlaces(p10, TheNet->findPlace(newPrefix + ".negLink"));
		}



		TheNet->mergePlaces(p11, TheNet->findPlace(newPrefix + ".initial"));
		TheNet->mergePlaces(p12, TheNet->findPlace(newPrefix + ".final"));
		TheNet->mergePlaces(p14, TheNet->findPlace(newPrefix + ".stop"));
		TheNet->mergePlaces(p15, TheNet->findPlace(newPrefix + ".stopped"));

#line  7532 "bpel-kc-unpk.cc"
	    } else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJoinFailure == mkcasestring("no")), "bpel-unparse-petri.k", 3941, this))) {
#line 3941 "bpel-unparse-petri.k"
		const standardElements This = this/**/;
#line 3941 "bpel-unparse-petri.k"
		const tTarget_list a = this->tTarget_list_1;
#line 3941 "bpel-unparse-petri.k"
		const tSource_list b = this->tSource_list_1;
#line 3943 "bpel-unparse-petri.k"

		trace(TRACE_DEBUG, "[PNU]" + inString() + "Fig. 26\n");
		string prefix = intToString(This->parentId->value) + ".";
		string newPrefix = intToString(This->parentId->value) + ".internal";

		Place *p11 = TheNet->newPlace(prefix + "p11");
		Place *p12 = TheNet->newPlace(prefix + "p12");
		Place *p13 = TheNet->newPlace(prefix + "final");
		Place *p14 = TheNet->newPlace(prefix + "stop");
		Place *p15 = TheNet->newPlace(prefix + "stopped");
		Place *p16 = TheNet->newPlace(prefix + "initial");
		Place *p17 = TheNet->newPlace(prefix + "p17");

		Transition *t2 = TheNet->newTransition(prefix + "t2");
		TheNet->newArc(t2, p11);
		TheNet->newArc(p16, t2);

		Transition *t3 = TheNet->newTransition(prefix + "t3");
		TheNet->newArc(p12, t3);
		TheNet->newArc(t3, p13);

		Transition *t4 = TheNet->newTransition(prefix + "t4");
		TheNet->newArc(p12, t4);
		TheNet->newArc(t4, p13);



		Transition *t5 = throwFault(p16, p17, "initial", prefix, This->negativeControlFlow);

		Transition *t6 = stop(p16, "initial", prefix);
		Transition *t7 = stop(p17, "p17", prefix);
		Transition *t8 = stop(p13, "final", prefix);




		Transition *t1 = NULL;
		if (This->dpe->value > 0)
		{
		    Place *p9  = TheNet->newPlace(prefix + "negLink");

		    t1 = TheNet->newTransition(prefix + "t1");
		    TheNet->newArc(p9, t1);

		    Place *p10 = TheNet->findPlace(newPrefix + ".negLink");
		    if (p10 != NULL)
		    TheNet->newArc(t1, p10);
		}



		{
#line 3994 "bpel-unparse-petri.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  7597 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 3994 "bpel-unparse-petri.k"
			    {
				{
#line 3995 "bpel-unparse-petri.k"
#line 3994 "bpel-unparse-petri.k"
				    const tTarget link = kc_selvar_0_1;
#line 3995 "bpel-unparse-petri.k"

				    Place *p1 = TheNet->findPlace("!link." + string(link->linkID->name));
				    Place *p3 = TheNet->findPlace("link." + string(link->linkID->name));
				    TheNet->newArc(t2, p1);
				    TheNet->newArc(p3, t2);
				    TheNet->newArc(t5, p1);
				    TheNet->newArc(p3, t5);

#line  7618 "bpel-kc-unpk.cc"
				}
			    }

#line  7622 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 3994 "bpel-unparse-petri.k"

#line  7627 "bpel-kc-unpk.cc"
		    }
		}
#line 4003 "bpel-unparse-petri.k"




		{
#line 4007 "bpel-unparse-petri.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  7639 "bpel-kc-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 4007 "bpel-unparse-petri.k"
			    {
				{
#line 4008 "bpel-unparse-petri.k"
#line 4007 "bpel-unparse-petri.k"
				    const tSource link = kc_selvar_0_1;
#line 4008 "bpel-unparse-petri.k"

				    Place *p5 = TheNet->findPlace("!link." + string(link->linkID->name));
				    Place *p7 = TheNet->findPlace("link." + string(link->linkID->name));

				    TheNet->newArc(p5, t3);
				    TheNet->newArc(t3, p7);
				    TheNet->newArc(p7, t4, READ);

				    if (This->dpe->value > 0)
				    {
					TheNet->newArc(p5, t1);
					TheNet->newArc(t1, p7);
				    }

#line  7666 "bpel-kc-unpk.cc"
				}
			    }

#line  7670 "bpel-kc-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 4007 "bpel-unparse-petri.k"

#line  7675 "bpel-kc-unpk.cc"
		    }
		}
#line 4022 "bpel-unparse-petri.k"




		Place *p10 = TheNet->findPlace(newPrefix + ".negLink");
		if (p10 != NULL)
		{
		    TheNet->newArc(t5, p10);
		    if (This->dpe->value > 0)
		    TheNet->mergePlaces(p10, TheNet->findPlace(newPrefix + ".negLink"));
		}



		TheNet->mergePlaces(p11, TheNet->findPlace(newPrefix + ".initial"));
		TheNet->mergePlaces(p12, TheNet->findPlace(newPrefix + ".final"));
		TheNet->mergePlaces(p14, TheNet->findPlace(newPrefix + ".stop"));
		TheNet->mergePlaces(p15, TheNet->findPlace(newPrefix + ".stopped"));

#line  7698 "bpel-kc-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}

#line  7704 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  7725 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tTarget_list iterator_ = this; iterator_->tTarget_list_1 != 0; iterator_ = iterator_->tTarget_list_1)
		    iterator_->tTarget_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  7744 "bpel-kc-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  7757 "bpel-kc-unpk.cc"
void
impl_tTarget_Target::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 391 "bpel-unparse-xml.k"
		in(); 
#line  7767 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<target ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  7775 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tSource_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  7794 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tSource_list iterator_ = this; iterator_->tSource_list_1 != 0; iterator_ = iterator_->tSource_list_1)
		    iterator_->tSource_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tSource_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  7812 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  7824 "bpel-kc-unpk.cc"
void
impl_tSource_Source::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 395 "bpel-unparse-xml.k"
		in(); 
#line  7834 "bpel-kc-unpk.cc"
			{ kc_printer(kc_t("<source dpe=\""), kc_current_view); }
		kc::unparse(this->dpe, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" ncf=\""), kc_current_view); }
		kc::unparse(this->negativeControlFlow, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  7844 "bpel-kc-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


} // namespace kc
